/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.ArrayList;
import util.DJ;

public class Control {
    private static final long L_ZERO = 0L;
    private static final double D_ZERO = 0.0;
    private static final double SYSTEM_TIME = 0.001;
    private static final double INTERPOLATE_TIME = 0.01;
    private static final double PSN_FACTOR = 1.0E-6;
    private double system_clock;
    private double system_time;
    private double interpolate_time;
    private double interpolate_count;
    private double display_count;
    private double psn_factor;
    public static final float DAC_FACTOR = 0.0048828125f;
    private static final double INVERTER = 1.0;
    private static final double FRC_CONST = 1.0;
    private static final double INERTIA = 1.0;
    private static final double FRICTION = 2.0;
    private long dac_buffer;
    private long fbc_buffer;
    private double inverter;
    private double frc_const;
    private double inertia;
    private double friction;
    private static final double SAMPLING_TIME = 0.001;
    private double sampling_time;
    private double sampling_count;
    private double spd_step;
    private double spd_ramp;
    private static final double SIMULATION_TIME = 0.001;
    private double simulation_time;
    private double simulation_count;
    private double frc_sim;
    private double spd_sim;
    private double psn_sim;
    private double frc_sim_1;
    private double frc_sim_2;
    private double psn_sim_1;
    private double psn_sim_2;
    private double frc_rng;
    private double spd_rng;
    private double psn_rng;
    private double spd_var;
    private static final long FB_SCALE = 1L;
    private static final long TIM_REF = 1000L;
    private static final long ACC_REF = 2L;
    private static final long SPD_REF = 1000L;
    private static final long PSN_REF = 100000L;
    private long tim_ref;
    private long acc_ref;
    private long spd_ref;
    private long psn_ref;
    private long acc_cmd;
    private long spd_cmd;
    private long psn_cmd;
    private static final long PSN_PRM = 0L;
    private long psn_prm;
    private long psn_err;
    private long spd_mnp;
    private static final long FIL_PRM = 0L;
    private static final long INT_PRM = 1048L;
    private static final long DIF_PRM = 0L;
    private static final long SPD_PRM = 1024L;
    private long fil_prm;
    private long int_prm;
    private long dif_prm;
    private long spd_prm;
    private long spd_err;
    private long spd_err_old;
    private long spd_cmp;
    private long int_cmp;
    private long dif_cmp;
    private long frc_mnp;
    private long frc_old;
    private long FBC_PORT;
    private long psn_fed;
    private long spd_fed;
    private long acc_fed;
    private long frc_fed;
    private long psn_old;
    private long spd_old;
    public long DAC_PORT;
    public static final long DAC_MIN = -2048L;
    public static final long DAC_MAX = 2047L;
    public static final double DELTA_FORCE = 5.0E-5;
    private double massBase = 1.0;
    private boolean speedControlFlag = true;
    private boolean feedbackFlag = true;

    public Control() {
        this.initControl();
    }

    public final void initControl() {
        this.tim_ref = 1000L;
        this.acc_ref = 2L;
        this.spd_ref = 1000L;
        this.psn_ref = 100000L;
        this.fil_prm = 0L;
        this.int_prm = 1048L;
        this.dif_prm = 0L;
        this.spd_prm = 1024L;
        this.psn_prm = 0L;
        this.system_time = 0.001;
        this.interpolate_time = 0.01;
        this.sampling_time = 0.001;
        this.psn_factor = 1.0E-6;
        this.inverter = 1.0;
        this.frc_const = 1.0;
        this.inertia = 1.0;
        this.friction = 2.0;
        this.simulation_time = 0.001;
        this.resetControl();
    }

    public void resetControl() {
        this.system_clock = 0.0;
        this.sampling_count = 0.0;
        this.spd_step = 0.0;
        this.spd_ramp = 0.0;
        this.simulation_count = 0.0;
        this.dac_buffer = 0L;
        this.fbc_buffer = 0L;
        this.frc_sim = 0.0;
        this.spd_sim = 0.0;
        this.psn_sim = 0.0;
        this.frc_sim_1 = 0.0;
        this.frc_sim_2 = 0.0;
        this.psn_sim_1 = 0.0;
        this.psn_sim_2 = 0.0;
        this.frc_rng = 0.0;
        this.spd_rng = 0.0;
        this.psn_rng = 0.0;
        this.spd_var = 0.0;
        this.acc_cmd = 0L;
        this.spd_cmd = 0L;
        this.psn_cmd = 0L;
        this.psn_err = 0L;
        this.spd_mnp = 0L;
        this.spd_err = 0L;
        this.spd_err_old = 0L;
        this.spd_cmp = 0L;
        this.int_cmp = 0L;
        this.dif_cmp = 0L;
        this.frc_mnp = 0L;
        this.frc_old = 0L;
        this.psn_fed = 0L;
        this.spd_fed = 0L;
        this.acc_fed = 0L;
        this.frc_fed = 0L;
        this.psn_old = 0L;
        this.spd_old = 0L;
    }

    public void stopSpeedControl() {
        this.speedControlFlag = false;
    }

    public void startSpeedControl() {
        this.speedControlFlag = true;
    }

    public void stopFeedback() {
        this.feedbackFlag = false;
    }

    public void startFeedback() {
        this.feedbackFlag = true;
    }

    public double getForce() {
        return this.frc_mnp;
    }

    public double getAcceleration() {
        return this.spd_var;
    }

    public double getSpeed() {
        return this.spd_rng;
    }

    public double getPosition() {
        return this.psn_rng;
    }

    public double getSpeedFeedback() {
        return this.spd_fed;
    }

    public void setForce(double force) {
        this.frc_mnp = (long)(force * 1.0);
    }

    public void setSpeed(double speed) {
        this.spd_ref = (long)(speed * 1000.0);
    }

    public void setParameter(int spd_prm, int int_prm, double inertia, double friction) {
        this.spd_prm = spd_prm;
        this.int_prm = int_prm;
        this.inertia = inertia;
        this.friction = friction;
    }

    public void setMassBase(double mussBase) {
        this.massBase = mussBase;
    }

    public void disturber(int TryalCount) {
        if (TryalCount >= 10000) {
            if (TryalCount < 20000) {
                this.inertia -= 5.0E-5;
            } else if (TryalCount < 40000) {
                this.inertia += 5.0E-5;
            } else if (TryalCount < 50000) {
                this.inertia -= 5.0E-5;
            }
        }
    }

    public void massChanger() {
        double var = (1.0 - Math.cos(Math.PI * 6 * this.psn_rng)) * 0.1;
        this.inertia = this.massBase * (1.1 - var);
    }

    public void massChanger(double changeRate) {
        double var = (1.0 - Math.cos(Math.PI * 6 * this.psn_rng)) * 0.1;
        this.inertia = this.massBase * (1.0 + (0.1 - var) * changeRate);
    }

    public double getMass() {
        return this.inertia;
    }

    public double speed_step(double time) {
        double sref = (double)this.spd_ref * this.psn_factor / this.sampling_time;
        double gain = (double)this.spd_prm * 0.0048828125 * this.inverter * this.frc_const / this.psn_factor * this.sampling_time / 1000.0;
        this.spd_step = gain * sref / (this.friction + gain) * (1.0 - Math.exp(-(this.friction + gain) / this.inertia * time));
        return this.spd_step;
    }

    public double speed_sCurve(double time) {
        return (-0.2 * time + 0.3) * time * time;
    }

    public double getS_Curve(double clock) {
        double sCurve = (-2.0 * clock + 3.0) * clock * clock;
        return sCurve;
    }

    public double spd_ramp(double time) {
        double aref = (double)this.acc_ref * this.psn_factor / this.sampling_time / this.sampling_time;
        double gain = (double)this.spd_prm * 0.0048828125 * this.inverter * this.frc_const / this.psn_factor * this.sampling_time / 1000.0;
        this.spd_ramp = gain * aref / (this.friction + gain) * (this.system_clock - this.inertia / (this.friction + gain) * (1.0 - Math.exp(-(this.friction + gain) / this.inertia * this.system_clock)));
        return this.spd_ramp;
    }

    public double[][] getSampleData(int pointNum) {
        double[][] sampleData = new double[2][pointNum];
        int adjuster = 1000 / pointNum;
        int i = 0;
        while (i < pointNum * adjuster) {
            this.execute();
            if (i % adjuster == 0) {
                int j = i / adjuster;
                sampleData[0][j] = this.getSpeed();
                sampleData[1][j] = this.getForce();
            }
            ++i;
        }
        DJ.print(" Speed", sampleData[0]);
        DJ.print(" Force", sampleData[1]);
        return sampleData;
    }

    public ArrayList getDataSet(int pGainNum, int iGainNum, int pointNum) {
        ArrayList<double[][]> dataSet = new ArrayList<double[][]>();
        long gpd = 102L;
        long gp = 1024L - gpd * 6L;
        long gid = 1048L;
        long gi = 0L;
        DJ.print("\u30fb\u5fdc\u7b54\u30c7\u30fc\u30bf\uff08\u901f\u5ea6\uff09\u3068\u5165\u529b\u30c7\u30fc\u30bf\uff08\u529b\u306e\u64cd\u4f5c\u91cf\uff09");
        int m = 0;
        while (m < pGainNum) {
            gp += gpd * (long)m;
            int n = 0;
            while (n < iGainNum) {
                gi = gid * (long)n;
                this.resetControl();
                this.spd_prm = gp;
                this.int_prm = gi;
                DJ._print("[" + m + "," + n + "]:" + " spd_prm=" + this.spd_prm + ", int_prm=" + this.int_prm);
                double[][] sampleData = this.getSampleData(pointNum);
                dataSet.add(sampleData);
                ++n;
            }
            ++m;
        }
        return dataSet;
    }

    public void execute() {
        this.system_clock += this.system_time;
        if (this.system_clock >= 10000.0) {
            this.system_clock = 0.0;
        }
        this.simulation_count += this.system_time;
        if (this.simulation_count >= this.simulation_time) {
            this.simulation_count = 0.0;
            this.simulate();
        }
        this.sampling_count += this.system_time;
        if (this.sampling_count >= this.sampling_time) {
            this.sampling_count = 0.0;
            this.FBC_PORT = this.fbc_buffer;
            if (this.feedbackFlag) {
                this.feedback();
            }
            if (this.speedControlFlag) {
                this.speed_control();
            }
            this.output_dac();
            this.dac_buffer = this.DAC_PORT;
        }
        this.interpolate_count += this.system_time;
        if (this.interpolate_count >= this.interpolate_time) {
            this.interpolate_count = 0.0;
        }
    }

    public double speed_equation(double spd) {
        double dac_out = (double)this.dac_buffer * 0.0048828125;
        double current = this.inverter * dac_out;
        this.frc_sim = this.frc_const * current;
        double spd_dif = (this.frc_sim - this.friction * spd) / this.inertia;
        return spd_dif;
    }

    public void simulate() {
        double k1 = this.simulation_time * this.speed_equation(this.spd_rng);
        double k2 = this.simulation_time * this.speed_equation(this.spd_rng + k1 / 2.0);
        double k3 = this.simulation_time * this.speed_equation(this.spd_rng + k2 / 2.0);
        double k4 = this.simulation_time * this.speed_equation(this.spd_rng + k3);
        this.spd_var = (k1 + k2 * 2.0 + k3 * 2.0 + k4) / 6.0;
        this.spd_rng += this.spd_var;
        k1 = this.simulation_time * this.spd_rng;
        k2 = this.simulation_time * (this.spd_rng + k1 / 2.0);
        k3 = this.simulation_time * (this.spd_rng + k2 / 2.0);
        k4 = this.simulation_time * (this.spd_rng + k3);
        this.psn_rng += (k1 + k2 * 2.0 + k3 * 2.0 + k4) / 6.0;
        this.fbc_buffer = (long)(this.psn_rng / this.psn_factor / 1.0);
    }

    public void feedback() {
        this.psn_fed = this.FBC_PORT * 1L;
        this.spd_fed = this.psn_fed - this.psn_old;
        this.psn_old = this.psn_fed;
        this.acc_fed = this.spd_fed - this.spd_old;
        this.spd_old = this.spd_fed;
    }

    public void speed_control() {
        this.spd_err_old = this.spd_err;
        this.spd_err = this.spd_ref - this.spd_fed;
        this.spd_cmp = this.fil_prm * (this.spd_cmp - this.spd_err) / 1000L + this.spd_err;
        this.int_cmp += this.int_prm * this.spd_cmp;
        this.dif_cmp = this.dif_prm * (this.spd_err - this.spd_err_old) / 1000L;
        this.frc_mnp = (this.spd_cmp + this.int_cmp / 1000000L + this.dif_cmp) * this.spd_prm / 1000L;
    }

    public void output_dac() {
        long data = this.frc_mnp;
        if (data > 2047L) {
            data = 2047L;
        } else if (data < -2048L) {
            data = -2048L;
        }
        this.DAC_PORT = data;
    }

    public void interpolate() {
        long psn_dst = this.psn_ref - this.psn_cmd;
        if (psn_dst > 0L) {
            long psn_stp = this.spd_cmd * this.spd_cmd / this.acc_ref / 2L;
            if (psn_dst > psn_stp) {
                if (this.spd_cmd < this.spd_ref) {
                    this.acc_cmd = this.acc_ref;
                    this.spd_cmd += this.acc_cmd;
                    if (this.spd_cmd > this.spd_ref) {
                        this.spd_cmd = this.spd_ref;
                        this.acc_cmd = 0L;
                    }
                }
            } else if (psn_dst <= psn_stp && this.spd_cmd > this.acc_ref) {
                this.acc_cmd = -this.acc_ref;
                this.spd_cmd += this.acc_cmd;
                if (this.spd_cmd < this.acc_ref) {
                    this.spd_cmd = this.acc_ref;
                    this.acc_cmd = 0L;
                }
            }
            this.psn_cmd += this.spd_cmd;
            if (this.psn_cmd > this.psn_ref) {
                this.psn_cmd = this.psn_ref;
                this.spd_cmd = 0L;
                this.acc_cmd = 0L;
            }
        } else if (psn_dst < 0L) {
            long psn_stp = this.spd_cmd * this.spd_cmd / this.acc_ref / 2L;
            if (psn_dst < -psn_stp) {
                if (this.spd_cmd > -this.spd_ref) {
                    this.acc_cmd = -this.acc_ref;
                    this.spd_cmd += this.acc_cmd;
                    if (this.spd_cmd < -this.spd_ref) {
                        this.spd_cmd = -this.spd_ref;
                        this.acc_cmd = 0L;
                    }
                }
            } else if (psn_dst >= -psn_stp && this.spd_cmd < -this.acc_ref) {
                this.acc_cmd = this.acc_ref;
                this.spd_cmd += this.acc_cmd;
                if (this.spd_cmd > -this.acc_ref) {
                    this.spd_cmd = -this.acc_ref;
                    this.acc_cmd = 0L;
                }
            }
            this.psn_cmd += this.spd_cmd;
            if (this.psn_cmd < this.psn_ref) {
                this.psn_cmd = this.psn_ref;
                this.spd_cmd = 0L;
                this.acc_cmd = 0L;
            }
        } else {
            this.psn_cmd = this.psn_ref;
            this.spd_cmd = 0L;
            this.acc_cmd = 0L;
        }
    }

    public void position_control() {
    }
}

