/*
 * Decompiled with CFR 0.152.
 */
package layer;

import layer.Layer;

public class ControlLayer
extends Layer {
    public ControlLayer(int inputNodeNum, int outputNodeNum) {
        super(inputNodeNum, outputNodeNum);
    }

    public void clear() {
        int i = 0;
        while (i < this.inNodeNum) {
            this.x[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.outNodeNum) {
            this.u[i] = 0.0;
            this.y[i] = 0.0;
            this.c[i] = 0.0;
            this.e[i] = 0.0;
            ++i;
        }
    }

    public void backward(double[] c, double[] s) {
        this.calcuGradient(c, s);
    }

    private void calcuGradient(double[] c) {
        this.activator.derivative(this.u, this.y, this.dYdU);
        int j = 0;
        while (j < this.inNodeNum) {
            this.dEdX[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < this.outNodeNum) {
            this.e[i] = this.y[i] - c[i];
            this.dEdU[i] = this.e[i];
            this.dEdB[i] = this.dEdU[i];
            this.dEdB_sum[i] = this.dEdB_sum[i] + this.dEdB[i];
            int j2 = 0;
            while (j2 < this.inNodeNum) {
                this.dEdW[i][j2] = this.dEdU[i] * this.x[j2];
                this.dEdW_sum[i][j2] = this.dEdW_sum[i][j2] + this.dEdW[i][j2];
                this.dEdX[j2] = this.dEdX[j2] + this.w[i][j2] * this.dEdU[i];
                ++j2;
            }
            ++i;
        }
    }

    private void calcuGradient(double[] c, double[] s) {
        this.activator.derivative(this.u, this.y, this.dYdU);
        int j = 0;
        while (j < this.inNodeNum) {
            this.dEdX[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < this.outNodeNum) {
            this.e[i] = s[i] - c[i];
            this.dEdU[i] = this.e[i] * this.dYdU[i];
            this.dEdB[i] = this.dEdU[i];
            this.dEdB_sum[i] = this.dEdB_sum[i] + this.dEdB[i];
            int j2 = 0;
            while (j2 < this.inNodeNum) {
                this.dEdW[i][j2] = this.dEdU[i] * this.x[j2];
                this.dEdW_sum[i][j2] = this.dEdW_sum[i][j2] + this.dEdW[i][j2];
                this.dEdX[j2] = this.dEdX[j2] + this.w[i][j2] * this.dEdU[i];
                ++j2;
            }
            ++i;
        }
    }
}

