/*
 * Decompiled with CFR 0.152.
 */
package quan;

import java.util.Random;
import quan.QuBit;
import util.DJ;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuBasis {
    public static final int BASIS_0 = 0;
    public static final int BASIS_1 = 1;
    public static final int BASIS_2 = 2;
    public static final int BASIS_3 = 3;
    private CompMat basisMat;
    private int[] qbCounter;
    private QuBit[] selectedQuBits;
    private int classicBit;
    private int[] clBitArray;
    private final long randomSeed = 314L;
    private final Random random = new Random(314L);

    public QuBasis(int numOfQuBit) {
        int order = QuBasis.numOfProbAmp(numOfQuBit);
        this.basisMat = new CompMat(order);
    }

    public QuBasis(CompMat basisMat) {
        this.basisMat = basisMat;
    }

    public QuBasis(long theta) {
        this.basisMat = new QuBasis((double)theta * Math.PI / 180.0).getBasisMat();
    }

    public QuBasis(double theta) {
        this.basisMat = QuBasis.rotate(theta, 0.0, 0.0);
    }

    public QuBasis(double theta, double lamda, double phi) {
        this.basisMat = QuBasis.rotate(theta, lamda, phi);
    }

    public static QuBasis makeQuBasis(int order) {
        CompMat basisMat = new CompMat(order, order);
        QuBasis quBasis = new QuBasis(basisMat);
        return quBasis;
    }

    public int getOrder() {
        return this.basisMat.rowNumber();
    }

    public CompMat getBasisMat() {
        return this.basisMat;
    }

    public CompVec getBasisVec(int basisIndex) {
        int row = this.basisMat.rowNumber();
        CompVec basisVec = new CompVec(row);
        int i = 0;
        while (i < row) {
            basisVec.setComp(i, this.basisMat.getComp(i, basisIndex));
            ++i;
        }
        return basisVec;
    }

    public CompVec copyBasisVec(int basisIndex) {
        int row = this.basisMat.rowNumber();
        CompVec basisVec = new CompVec(row);
        int i = 0;
        while (i < row) {
            basisVec.setComp(i, this.basisMat.copyComp(i, basisIndex));
            ++i;
        }
        return basisVec;
    }

    public QuBit getBasisQuBit(int basisIndex) {
        int row = this.basisMat.rowNumber();
        QuBit basisQuBit = new QuBit(QuBit.calcNumOfQuBit(row));
        int i = 0;
        while (i < row) {
            basisQuBit.setProbAmp(i, this.basisMat.copyComp(i, basisIndex));
            ++i;
        }
        return basisQuBit;
    }

    public void setElement(int row, int col, Complex element) {
        this.basisMat.setComp(row, col, element);
    }

    public void setBasisMat(CompMat basisMat) {
        this.basisMat = basisMat;
    }

    public static int numOfProbAmp(int numQuBit) {
        int numProbAmp = 1;
        int i = 1;
        while (i <= numQuBit) {
            numProbAmp *= 2;
            ++i;
        }
        return numProbAmp;
    }

    public static double[][] makeRealIdentity(int order) {
        double[][] ientity = new double[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                ientity[i][j] = 0.0;
                ++j;
            }
            ientity[i][i] = 1.0;
            ++i;
        }
        return ientity;
    }

    public static Complex[][] standardBasisComplex(int order) {
        Complex[][] stdBasis = new Complex[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                stdBasis[i][j] = new Complex(0.0, 0.0);
                ++j;
            }
            stdBasis[i][i] = new Complex(1.0, 0.0);
            ++i;
        }
        return stdBasis;
    }

    public static CompMat standardBasis(int order) {
        CompMat basis = new CompMat(order, order);
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                basis.setComp(i, j, 0.0, 0.0);
                ++j;
            }
            basis.setComp(i, i, 1.0, 0.0);
            ++i;
        }
        return basis;
    }

    public QuBasis conjugate() {
        int row = this.basisMat.rowNumber();
        QuBasis conjugate = QuBasis.makeQuBasis(row);
        CompMat _conjugate = conjugate.basisMat;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < row) {
                _conjugate.setComp(j, i, this.basisMat.getComp(i, j).conjugate());
                ++j;
            }
            ++i;
        }
        return conjugate;
    }

    public static Complex[][] rotate2(double theta, double lamda, double phi) {
        Complex[][] rotor = Complex.complexMatrix(2, 2);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinTheta <= p && sinTheta >= m) {
            sinTheta = 0.0;
        }
        if (cosTheta <= p && cosTheta >= m) {
            cosTheta = 0.0;
        }
        rotor[0][0].setReal(cosTheta);
        rotor[0][1].setReal(-sinTheta);
        rotor[0][1].mul(Complex.euler(lamda));
        rotor[1][0].setReal(sinTheta);
        rotor[1][0].mul(Complex.euler(phi));
        rotor[1][1].setReal(cosTheta);
        rotor[1][1].mul(Complex.euler(lamda + phi));
        return rotor;
    }

    public static CompMat rotate(double theta, double lamda, double phi) {
        CompMat rotorMat = new CompMat(2, 2);
        Complex[][] rotor = rotorMat.getMatrix();
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinTheta <= p && sinTheta >= m) {
            sinTheta = 0.0;
        }
        if (cosTheta <= p && cosTheta >= m) {
            cosTheta = 0.0;
        }
        rotor[0][0].setReal(cosTheta);
        rotor[0][1].setReal(-sinTheta);
        rotor[0][1].mul(Complex.euler(lamda));
        rotor[1][0].setReal(sinTheta);
        rotor[1][0].mul(Complex.euler(phi));
        rotor[1][1].setReal(cosTheta);
        rotor[1][1].mul(Complex.euler(lamda + phi));
        return rotorMat;
    }

    public static QuBasis gramSchmidt(Complex[][] referenceVectors) {
        int row = referenceVectors.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** QuBasis.gramSchmidt(Complex[][] referenceVectors)\n row length (=" + row + ") is less than one.");
            return null;
        }
        int col = referenceVectors[0].length;
        if (row != col) {
            DJ.print("***** ERROR ***** QuBasis.gramSchmidt(Complex[][] referenceVectors)\n row and col length is not same.\n row length is " + row + ", \n" + " col length is " + col + ".");
            return null;
        }
        QuBasis orthonormalBasis = QuBasis.makeQuBasis(row);
        Complex[][] u = orthonormalBasis.basisMat.getMatrix();
        int j = 0;
        while (j < col) {
            u[0][j] = referenceVectors[0][j].copyComplex();
            ++j;
        }
        Complex norm = Complex.norm(u[0]);
        int j2 = 0;
        while (j2 < col) {
            u[0][j2].div(norm);
            ++j2;
        }
        int i = 1;
        while (i < row) {
            Complex[] _u = new Complex[row];
            int j3 = 0;
            while (j3 < col) {
                _u[j3] = referenceVectors[i][j3].copyComplex();
                ++j3;
            }
            int k = 0;
            while (k < i) {
                Complex innPro = Complex.innerProduct(u[k], referenceVectors[i]);
                int j4 = 0;
                while (j4 < col) {
                    u[i][j4] = u[k][j4].product(innPro);
                    _u[j4].sub(u[i][j4]);
                    ++j4;
                }
                ++k;
            }
            norm = Complex.norm(_u);
            j3 = 0;
            while (j3 < col) {
                u[i][j3] = _u[j3];
                u[i][j3].div(norm);
                ++j3;
            }
            ++i;
        }
        return orthonormalBasis;
    }

    public void checkOrthonormal(String label) {
        Complex innPro;
        Complex[][] orthonormalArrays = this.basisMat.copyMatrix();
        DJ.printF(label, orthonormalArrays);
        DJ._print("\u884c\u5217\u5f0f|" + label + "|\u304c\u30bc\u30ed\u3067\u306a\u3051\u308c\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb");
        Complex determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|" + label + "|", determinant);
        DJ.printF("  |" + label + "|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = orthonormalArrays.length;
        int i = 0;
        while (i < length) {
            DJ.print(i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] uArray = orthonormalArrays[i];
            innPro = Complex.innerProduct(uArray);
            DJ.printF_("  innPro(" + label + "[" + i + "])", innPro);
            Complex norm = Complex.norm(uArray);
            DJ.printF("  norm(" + label + "[" + i + "])", norm);
            ++i;
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        int i2 = 0;
        while (i2 < length) {
            Complex[] uArray_i = orthonormalArrays[i2];
            int k = i2 + 1;
            while (k < length) {
                DJ.print_(i2 + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                Complex[] uArray_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(uArray_i, uArray_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
                ++k;
            }
            ++i2;
        }
    }

    public static void checkOrthonormal(Complex[][] referenceVectors) {
        Complex[] u_k;
        Complex norm;
        Complex innPro;
        DJ.printF("v", referenceVectors);
        DJ.print("\u884c\u5217\u5f0f|v|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        Complex determinant = Complex.determinant(referenceVectors);
        DJ.print_("|v|", determinant);
        DJ.printF("  |v|", determinant);
        DJ._print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e\u5404\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = referenceVectors.length;
        int i = 0;
        while (i < length) {
            DJ.print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e" + i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] v = referenceVectors[i];
            innPro = Complex.innerProduct(v);
            DJ.print_("innPro(v[" + i + "])", innPro);
            DJ.printF("  innPro(v[" + i + "])", innPro);
            norm = Complex.norm(v);
            DJ.print_("norm(v[" + i + "])", norm);
            DJ.printF("  norm(v[" + i + "])", norm);
            ++i;
        }
        DJ._print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        int i2 = 0;
        while (i2 < length) {
            Complex[] u_i = referenceVectors[i2];
            int k = i2 + 1;
            while (k < length) {
                DJ.print_("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e" + i2 + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                u_k = referenceVectors[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
                ++k;
            }
            ++i2;
        }
        QuBasis orthonormalVec = QuBasis.gramSchmidt(referenceVectors);
        DJ.printF("u", orthonormalVec);
        Complex[][] orthonormalArrays = orthonormalVec.getBasisMat().getMatrix();
        DJ.print("\u884c\u5217\u5f0f|u|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|u|", determinant);
        DJ.printF("  |u|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        length = referenceVectors.length;
        int i3 = 0;
        while (i3 < length) {
            DJ.print("\u5c0e\u51fa\u57fa\u5e95\u306e" + i3 + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] u = orthonormalArrays[i3];
            innPro = Complex.innerProduct(u);
            DJ.print_("innPro(u[" + i3 + "])", innPro);
            DJ.printF("  innPro(u[" + i3 + "])", innPro);
            norm = Complex.norm(u);
            DJ.print_("norm(u[" + i3 + "])", norm);
            DJ.printF("  norm(u[" + i3 + "])", norm);
            ++i3;
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        i3 = 0;
        while (i3 < length) {
            Complex[] u_i = orthonormalArrays[i3];
            int k = i3 + 1;
            while (k < length) {
                DJ.print_("\u5c0e\u51fa\u57fa\u5e95\u306e" + i3 + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                u_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
                ++k;
            }
            ++i3;
        }
    }

    public void checkOrthonormal() {
        Complex innPro;
        Complex[][] referenceVectors = this.basisMat.getMatrix();
        DJ.print("v", referenceVectors);
        DJ.printF("v", referenceVectors);
        DJ.print("\u884c\u5217\u5f0f|v|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        Complex determinant = Complex.determinant(referenceVectors);
        DJ.print_("|v|", determinant);
        DJ.printF("  |v|", determinant);
        QuBasis orthonormalVec = QuBasis.gramSchmidt(referenceVectors);
        DJ._print("u", orthonormalVec);
        DJ.printF("u", orthonormalVec);
        Complex[][] orthonormalArrays = orthonormalVec.getBasisMat().getMatrix();
        DJ.print("\u884c\u5217\u5f0f|u|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|u|", determinant);
        DJ.printF("  |u|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = referenceVectors.length;
        int i = 0;
        while (i < length) {
            DJ.print(i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] u = orthonormalArrays[i];
            innPro = Complex.innerProduct(u);
            DJ.print_("innPro(u[" + i + "])", innPro);
            DJ.printF("  innPro(u[" + i + "])", innPro);
            Complex norm = Complex.norm(u);
            DJ.print_("norm(u[" + i + "])", norm);
            DJ.printF("  norm(u[" + i + "])", norm);
            ++i;
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        int i2 = 0;
        while (i2 < length) {
            Complex[] u_i = orthonormalArrays[i2];
            int k = i2 + 1;
            while (k < length) {
                DJ.print_(i2 + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                Complex[] u_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
                ++k;
            }
            ++i2;
        }
    }

    public int[] getQBCounter() {
        return this.qbCounter;
    }

    public QuBit[] getSelectedQuBits() {
        return this.selectedQuBits;
    }

    public int[] getClassicBit() {
        return this.clBitArray;
    }

    public int[] countQuBasis(QuBit targetQuBit, int trialNumber) {
        int numOfBasis = this.basisMat.colNumber();
        this.qbCounter = new int[numOfBasis];
        this.selectedQuBits = new QuBit[trialNumber];
        this.clBitArray = new int[trialNumber];
        int i = 0;
        while (i < trialNumber) {
            this.selectedQuBits[i] = this.measurement(targetQuBit);
            this.clBitArray[i] = this.classicBit;
            ++i;
        }
        return this.qbCounter;
    }

    public QuBit measurement(QuBit targetQuBit) {
        int numOfProbAmp = targetQuBit.getProbAmpLength();
        QuBit paQuBit = this.basisChang(targetQuBit);
        double paAccum = 0.0;
        int resultQubitNum = QuBit.calcNumOfQuBit(this.basisMat.rowNumber());
        QuBit resultQubit = new QuBit(resultQubitNum);
        boolean errorCheck = false;
        double randomNum = this.random.nextDouble();
        if (this.qbCounter == null) {
            this.qbCounter = new int[numOfProbAmp];
        }
        int i = 0;
        while (i < numOfProbAmp) {
            if (randomNum <= (paAccum += paQuBit.getProbAmp(i).square())) {
                int k = 0;
                while (k < numOfProbAmp) {
                    resultQubit.setProbAmp(k, this.basisMat.copyComp(k, i));
                    ++k;
                }
                int n = i;
                this.qbCounter[n] = this.qbCounter[n] + 1;
                this.classicBit = i;
                errorCheck = true;
                break;
            }
            ++i;
        }
        if (!errorCheck) {
            DJ.print("***** ERROR ***** QuBasis.innerProduct(QuBit operand)\n basisMat row number is less than one.");
            return null;
        }
        return resultQubit;
    }

    public QuBit basisChang(QuBit operand) {
        int row = this.basisMat.rowNumber();
        if (row < 1) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n basisMat row number is less than one.");
            return null;
        }
        int col = this.basisMat.colNumber();
        if (col % 2 != 0) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n basisMat column number is (" + col + ") is not even number.");
            return null;
        }
        int probAmpLength = operand.getProbAmpLength();
        if (row != probAmpLength) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n Element numbers are not same.\n basisMat row number is " + row + ", \n" + " ProbAmp length is " + probAmpLength + ".");
            return null;
        }
        CompMat _basisMat = this.basisMat.conjugate();
        int numOfQuBit = QuBit.calcNumOfQuBit(row);
        QuBit resultQB = new QuBit(numOfQuBit);
        CompVec _product = resultQB.getProbAmp();
        int i = 0;
        while (i < col) {
            int k = 0;
            while (k < row) {
                Complex conj = _basisMat.getComp(i, k);
                conj.mul(operand.getProbAmp(k));
                _product.getComp(i).add(conj);
                ++k;
            }
            ++i;
        }
        return resultQB;
    }

    public CompMat basisChang(CompMat quBitMat) {
        int row = this.basisMat.rowNumber();
        if (row < 1) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n basisMat row number is less than one.");
            return null;
        }
        int col = this.basisMat.colNumber();
        if (col != row) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n basisMat column number is (" + col + ") not equal to row number.");
            return null;
        }
        int numOfQuBit = quBitMat.rowNumber();
        if (!QuBit.checkPowerOfTwo(numOfQuBit)) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n number of QuBits is not power of two.");
            return null;
        }
        int order = quBitMat.colNumber();
        if (order != row) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n order of QuBits (" + order + ") is not equal to QuBasis(" + row + ")");
            return null;
        }
        CompMat _basisMat = this.basisMat.conjugate();
        CompMat resultQBMat = new CompMat(col, numOfQuBit);
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < numOfQuBit) {
                int k = 0;
                while (k < order) {
                    Complex conj = _basisMat.copyComp(i, k);
                    conj.mul(quBitMat.getComp(k, j));
                    Complex val = resultQBMat.getComp(i, j);
                    val.add(conj);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return resultQBMat;
    }

    public QuBasis interactQuBasis(QuBasis operandBasis) {
        int row0 = this.basisMat.rowNumber();
        int col0 = this.basisMat.colNumber();
        CompMat operandMat = operandBasis.basisMat;
        int row1 = operandMat.rowNumber();
        int col1 = operandMat.colNumber();
        int row = row0 * row1;
        int numOfQuBit = QuBit.calcNumOfQuBit(row);
        QuBasis interactedBasis = new QuBasis(numOfQuBit);
        int i0 = 0;
        while (i0 < row0) {
            int j0 = 0;
            while (j0 < col0) {
                int i1 = 0;
                while (i1 < row1) {
                    int j1 = 0;
                    while (j1 < col1) {
                        int i = i0 * row1 + i1;
                        int j = j0 * col1 + j1;
                        Complex element = this.basisMat.copyComp(i0, j0);
                        element.mul(operandMat.getComp(i1, j1));
                        interactedBasis.setElement(i, j, element);
                        ++j1;
                    }
                    ++i1;
                }
                ++j0;
            }
            ++i0;
        }
        return interactedBasis;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        int i = 0;
        while (i < size) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }

    public String toString() {
        int row = this.basisMat.rowNumber();
        int col = this.basisMat.colNumber();
        int[] maxWide = new int[col];
        int j = 0;
        while (j < col) {
            maxWide[j] = 5;
            ++j;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        int i = 0;
        while (i < row) {
            int j2 = 0;
            while (j2 < col) {
                String text = this.basisMat.getComp(i, j2).toString();
                if (this.basisMat.getReal(i, j2) >= 0.0) {
                    buf[i][j2] = " " + text;
                    wides[i][j2] = text.length() + 1;
                } else {
                    buf[i][j2] = text;
                    wides[i][j2] = text.length();
                }
                if (wides[i][j2] > maxWide[j2]) {
                    maxWide[j2] = wides[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        String filler = "\u2502";
        int gap = filler.length();
        int spaces = maxWide[0];
        int j3 = 1;
        while (j3 < col) {
            spaces = spaces + gap + 1 + maxWide[j3];
            ++j3;
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        int i2 = 0;
        while (i2 < row) {
            sb.append("\u2502");
            int j4 = 0;
            while (j4 < col) {
                sb.append(buf[i2][j4]);
                sb.append(this.getSpace(maxWide[j4] - wides[i2][j4])).append(filler);
                ++j4;
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
            ++i2;
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public String toFormat() {
        int row = this.basisMat.rowNumber();
        int col = this.basisMat.colNumber();
        int[] maxWide = new int[col];
        int j = 0;
        while (j < col) {
            maxWide[j] = 5;
            ++j;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        int i = 0;
        while (i < row) {
            int j2 = 0;
            while (j2 < col) {
                String text = this.basisMat.getComp(i, j2).toFormat();
                if (this.basisMat.getReal(i, j2) >= 0.0) {
                    buf[i][j2] = " " + text;
                    wides[i][j2] = text.length() + 1;
                } else {
                    buf[i][j2] = text;
                    wides[i][j2] = text.length();
                }
                if (wides[i][j2] > maxWide[j2]) {
                    maxWide[j2] = wides[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "\u2502";
        int gap = filler.length();
        int spaces = maxWide[0];
        int j3 = 1;
        while (j3 < col) {
            spaces = spaces + gap + 1 + maxWide[j3];
            ++j3;
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        int i2 = 0;
        while (i2 < row) {
            sb.append("\u2502");
            int j4 = 0;
            while (j4 < col) {
                sb.append(buf[i2][j4]);
                sb.append(this.getSpace(maxWide[j4] - wides[i2][j4])).append(filler);
                ++j4;
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
            ++i2;
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public String toString(String label) {
        String str = this.toString();
        return String.valueOf(label) + "\n" + str;
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return String.valueOf(label) + ":" + str;
    }
}

