/*
 * Decompiled with CFR 0.152.
 */
package quan;

import quan.QuBit;
import util.DJ;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuGate {
    public static final String I_GATE = "I_GATE";
    public static final String X_GATE = "X_GATE";
    public static final String Y_GATE = "Y_GATE";
    public static final String Z_GATE = "Z_GATE";
    public static final String H_GATE = "H_GATE";
    public static final String RX_GATE = "RX_GATE";
    public static final String RY_GATE = "RY_GATE";
    public static final String RZ_GATE = "RZ_GATE";
    public static final String RK_GATE = "RK_GATE";
    public static final String CX_GATE = "CX_GATE";
    public static final String C2X_GATE = "C2X_GATE";
    public static final String W_GATE = "W_GATE";
    public static final String SWAP_GATE = "SWAP_GATE";
    public static final String N_TYPE = "NONCHALANT";
    public static final String C_TYPE = "CONTROL";
    public static final String X_TYPE = "X_GATE";
    public static final Complex BASE_N = new Complex();
    public static final Complex BASE_P0 = new Complex(1.0, 0.0);
    public static final Complex BASE_M0 = new Complex(-1.0, 0.0);
    public static final Complex BASE_P1 = new Complex(0.0, 1.0);
    public static final Complex BASE_M1 = new Complex(0.0, -1.0);
    public static final int NOP = 0;
    public static final int CONTROL = 1;
    public static final int TARGET = 2;
    private CompMat gateMat;

    public QuGate() {
        this.gateMat = new CompMat(2);
    }

    public QuGate(int NumOfQuBit) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(NumOfQuBit);
        this.gateMat = new CompMat(numOfProbAmp);
    }

    public QuGate(int row, int col) {
        if (!QuBit.checkPowerOfTwo(row)) {
            DJ.print("***** ERROR ***** QuGate.QuGate(int row, int col)\n row(=" + row + ") is not power of 2.");
            return;
        }
        if (!QuBit.checkPowerOfTwo(col)) {
            DJ.print("***** ERROR ***** QuGate.QuGate(int row, int col)\n col(=" + col + ") is not power of 2.");
            return;
        }
        this.gateMat = new CompMat(row, col);
    }

    public QuGate(int NumOfQuBit, Complex element) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(NumOfQuBit);
        this.gateMat = new CompMat(numOfProbAmp, element);
    }

    public QuGate(CompVec element) {
        int length = element.length();
        double sq = Math.sqrt(length);
        long _dim = Math.round(sq);
        int numOfProbAmp = (int)_dim;
        if (_dim > Integer.MAX_VALUE) {
            DJ.print("***** ERROR ***** QuGate.QuGate(CompVec element)\n Length of element (=" + element + ") is too big.");
            return;
        }
        if (!QuBit.checkPowerOfTwo(numOfProbAmp)) {
            DJ.print("***** ERROR ***** QuGate.QuGate(CompVec element)\n Length of element (=" + element + ") is not power of two.");
            return;
        }
        this.gateMat = new CompMat(numOfProbAmp);
        int i = 0;
        while (i < numOfProbAmp) {
            int index = i * numOfProbAmp;
            int j = 0;
            while (j < numOfProbAmp) {
                this.gateMat.setComp(i, j, element.copyComp(index + j));
                ++j;
            }
            ++i;
        }
    }

    public QuGate(String gateLabel) {
        if (gateLabel == null) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel)\n Argument String (gateLabel) is null.");
            return;
        }
        Complex zero = new Complex();
        Complex one = new Complex(1.0, 0.0);
        switch (gateLabel) {
            case "I_GATE": {
                Complex[] compArrayI = new Complex[]{one, zero, zero, one};
                this.gateMat = new CompMat(compArrayI);
                break;
            }
            case "X_GATE": {
                Complex[] compArrayX = new Complex[]{zero, one, one, zero};
                this.gateMat = new CompMat(compArrayX);
                break;
            }
            case "Y_GATE": {
                Complex iOne = new Complex(0.0, 1.0);
                Complex _iOne = new Complex(0.0, -1.0);
                Complex[] compArrayY = new Complex[]{zero, _iOne, iOne, zero};
                this.gateMat = new CompMat(compArrayY);
                break;
            }
            case "Z_GATE": {
                Complex _one = new Complex(-1.0, 0.0);
                Complex[] compArrayZ = new Complex[]{one, zero, zero, _one};
                this.gateMat = new CompMat(compArrayZ);
                break;
            }
            case "H_GATE": {
                Complex oneRt2 = new Complex(1.0 / Math.sqrt(2.0), 0.0);
                Complex _oneRt2 = new Complex(-oneRt2.getReal(), 0.0);
                Complex[] compArrayH = new Complex[]{oneRt2, oneRt2, oneRt2, _oneRt2};
                this.gateMat = new CompMat(compArrayH);
                break;
            }
            default: {
                Complex[] compArrayNull = new Complex[]{zero, zero, zero, zero};
                this.gateMat = new CompMat(compArrayNull);
            }
        }
    }

    public QuGate(String gateLabel, double parameter) {
        if (gateLabel == null) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, double parameter)\n Argument String (gateLabel) is null.");
            return;
        }
        double halfTheta = parameter / 2.0;
        double sinTheat = Math.sin(halfTheta);
        double cosTheat = Math.cos(halfTheta);
        Complex zero = new Complex();
        Complex one = new Complex(1.0, 0.0);
        Complex cos = new Complex(cosTheat, 0.0);
        Complex isin = new Complex(0.0, sinTheat);
        Complex _isin = new Complex(0.0, -sinTheat);
        switch (gateLabel) {
            case "RX_GATE": {
                Complex[] compArrayRX = new Complex[]{cos, _isin, _isin, cos};
                this.gateMat = new CompMat(compArrayRX);
                break;
            }
            case "RY_GATE": {
                Complex sin = new Complex(sinTheat, 0.0);
                Complex _sin = new Complex(-sinTheat, 0.0);
                Complex[] compArrayRY = new Complex[]{cos, _sin, sin, cos};
                this.gateMat = new CompMat(compArrayRY);
                break;
            }
            case "RZ_GATE": {
                isin.add(cos);
                _isin.add(cos);
                Complex[] compArrayRZ = new Complex[]{_isin, zero, zero, isin};
                this.gateMat = new CompMat(compArrayRZ);
                break;
            }
            case "RK_GATE": {
                double angle = Math.PI / Math.pow(2.0, parameter);
                cosTheat = Math.cos(angle);
                sinTheat = Math.sin(angle);
                Complex pk = new Complex(cosTheat, sinTheat);
                Complex[] compArrayRK = new Complex[]{one, zero, zero, pk};
                this.gateMat = new CompMat(compArrayRK);
                break;
            }
            default: {
                Complex[] compArrayNull = new Complex[]{zero, zero, zero, zero};
                this.gateMat = new CompMat(compArrayNull);
            }
        }
    }

    public QuGate(String gateLabel, int parameter) {
        switch (gateLabel) {
            case "W_GATE": {
                this.gateMat = this.createWGate(parameter);
                break;
            }
            case "RK_GATE": {
                Complex zero = new Complex();
                Complex one = new Complex(1.0, 0.0);
                double angle = Math.PI / Math.pow(2.0, parameter);
                double cosTheat = Math.cos(angle);
                double sinTheat = Math.sin(angle);
                Complex pk = new Complex(cosTheat, sinTheat);
                Complex[] compArrayRK = new Complex[]{one, zero, zero, pk};
                this.gateMat = new CompMat(compArrayRK);
                break;
            }
            default: {
                DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, int numOfQuBit)\n There are no such a gate(" + gateLabel + ").");
            }
        }
    }

    public final CompMat createWGate(int numOfQuBit) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        CompMat wCompMat = new CompMat(numOfProbAmp, numOfProbAmp);
        int k = 0;
        while (k < numOfProbAmp) {
            int j = 0;
            while (j < numOfProbAmp) {
                wCompMat.setComp(k, j, this.getWkj(numOfProbAmp, k, j));
                ++j;
            }
            ++k;
        }
        return wCompMat;
    }

    public Complex getWkj(int numOfProbAmp, int k, int j) {
        double kj = Math.PI * 2 * (double)k * (double)j / (double)numOfProbAmp;
        double real = Math.cos(kj);
        double imag = Math.sin(kj);
        Complex wkj = new Complex(real, imag);
        wkj.div(Math.sqrt(numOfProbAmp));
        return wkj;
    }

    static void funcA() {
        QuGate.funcB();
    }

    static void funcB() {
        QuGate.funcA();
    }

    public QuGate(String gateLabel, int numOfQuBit, int[] targets, int[] controls) {
        if (gateLabel == null) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, int numOfBit, int[] targets, int[] controls)\n Gate Label String (gateLabel) is null.");
            return;
        }
        if (numOfQuBit <= 0) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, int numOfBit, int[] targets, int[] controls)\n Number of quBit (qbTypeArray =" + numOfQuBit + ") is Less than eaqual to zero.");
            return;
        }
        switch (gateLabel) {
            case "CX_GATE": {
                this.gateMat = this.createCXGate(numOfQuBit, targets, controls);
                break;
            }
            case "SWAP_GATE": {
                this.gateMat = this.createSwapGate(numOfQuBit, targets, controls);
                break;
            }
            default: {
                Complex[] compArrayNull = new Complex[]{BASE_P0, BASE_M0, BASE_N, BASE_P1, BASE_M1};
                this.gateMat = new CompMat(compArrayNull);
            }
        }
    }

    public final CompMat createCXGate(int numOfQuBit, int[] targets, int[] controls) {
        DJ.print_("$ numOfQuBit = ", numOfQuBit);
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        DJ.print(",  $ numOfProbAmp = ", numOfProbAmp);
        CompMat cxCompMat = new CompMat(numOfProbAmp);
        int[][] binaly = this.makeBinalyArray(numOfQuBit);
        int numOfTarget = targets.length;
        DJ.print_("$ numOfTarget = ", numOfTarget);
        DJ.print(",  $ targetIndes = ", targets);
        int targetId0 = targets[0];
        int numOfControl = controls.length;
        DJ.print_("$ numOfControl = ", numOfControl);
        if (numOfControl < 1) {
            DJ.print("$ controlIndes = null");
        } else {
            DJ.print(",  $ controlIndes = ", controls);
        }
        int maxTag = (int)Math.pow(2.0, numOfQuBit - numOfTarget);
        int[] tag0 = new int[maxTag];
        int[] tag1 = new int[maxTag];
        int count0 = 0;
        int count1 = 0;
        if (numOfControl <= 0) {
            int i = 0;
            while (i < numOfProbAmp) {
                if (binaly[i][targetId0] == 0) {
                    tag0[count0++] = i;
                } else if (binaly[i][targetId0] == 1) {
                    tag1[count1++] = i;
                }
                ++i;
            }
        } else {
            int controlIndex = controls[0];
            DJ.print("$ controlIndex = ", controlIndex);
            int i = 0;
            while (i < numOfProbAmp) {
                if (this.checkControl(i, controls, binaly)) {
                    if (binaly[i][targetId0] == 0) {
                        tag0[count0++] = i;
                    } else if (binaly[i][targetId0] == 1) {
                        tag1[count1++] = i;
                    }
                }
                ++i;
            }
        }
        int k = 0;
        while (k < count0) {
            cxCompMat.setComp(tag0[k], tag0[k], 0.0, 0.0);
            cxCompMat.setComp(tag0[k], tag1[k], 1.0, 0.0);
            cxCompMat.setComp(tag1[k], tag1[k], 0.0, 0.0);
            cxCompMat.setComp(tag1[k], tag0[k], 1.0, 0.0);
            ++k;
        }
        return cxCompMat;
    }

    public final CompMat createSwapGate(int numOfQuBit, int[] targets, int[] controls) {
        DJ.print_("$ numOfQuBit = ", numOfQuBit);
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        DJ.print(",  $ numOfProbAmp = ", numOfProbAmp);
        CompMat swapCompMat = new CompMat(numOfProbAmp);
        int[][] binaly = this.makeBinalyArray(numOfQuBit);
        int numOfTarget = targets.length;
        DJ.print_("$ numOfTarget = ", numOfTarget);
        DJ.print(",  $ targetIndes = ", targets);
        int targetId0 = targets[0];
        int targetId1 = targets[1];
        int numOfControl = controls.length;
        DJ.print_("$ numOfControl = ", numOfControl);
        if (numOfControl < 1) {
            DJ.print("$ controlIndes = null");
        } else {
            DJ.print(",  $ controlIndes = ", controls);
        }
        int maxTag = (int)Math.pow(2.0, numOfQuBit - numOfTarget);
        int[] tag0 = new int[maxTag];
        int[] tag1 = new int[maxTag];
        int count0 = 0;
        int count1 = 0;
        if (numOfControl <= 0) {
            int i = 0;
            while (i < numOfProbAmp) {
                if (binaly[i][targetId0] == 0 && binaly[i][targetId1] == 1) {
                    tag0[count0++] = i;
                } else if (binaly[i][targetId0] == 1 && binaly[i][targetId1] == 0) {
                    tag1[count1++] = i;
                }
                ++i;
            }
        } else {
            int controlIndex = controls[0];
            DJ.print("$ controlIndex = ", controlIndex);
            int i = 0;
            while (i < numOfProbAmp) {
                if (this.checkControl(i, controls, binaly)) {
                    if (binaly[i][targetId0] == 0 && binaly[i][targetId1] == 1) {
                        tag0[count0++] = i;
                    } else if (binaly[i][targetId0] == 1 && binaly[i][targetId1] == 0) {
                        tag1[count1++] = i;
                    }
                }
                ++i;
            }
        }
        int k = 0;
        while (k < count0) {
            swapCompMat.setComp(tag0[k], tag0[k], 0.0, 0.0);
            swapCompMat.setComp(tag0[k], tag1[k], 1.0, 0.0);
            swapCompMat.setComp(tag1[k], tag1[k], 0.0, 0.0);
            swapCompMat.setComp(tag1[k], tag0[k], 1.0, 0.0);
            ++k;
        }
        return swapCompMat;
    }

    private int[][] makeBinalyArray(int numOfQuBit) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        int[][] binalyMarker = new int[numOfProbAmp][numOfQuBit];
        int i = 0;
        while (i < numOfProbAmp) {
            int k = i;
            int j = 0;
            while (j < numOfQuBit) {
                binalyMarker[i][numOfQuBit - 1 - j] = k % 2;
                k /= 2;
                ++j;
            }
            ++i;
        }
        return binalyMarker;
    }

    private boolean checkControl(int index, int[] controls, int[][] binaly) {
        boolean flag = true;
        int numOfControl = controls.length;
        if (numOfControl > 0) {
            int i = 0;
            while (i < numOfControl) {
                if (binaly[index][controls[i]] == 0) {
                    flag = false;
                    break;
                }
                ++i;
            }
        }
        return flag;
    }

    public QuGate(String gateLabel, int numOfBit, int target, int[] controls) {
        if (gateLabel == null) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, int numOfBit, int target, int[] controls)\n Gate Label String (gateLabel) is null.");
            return;
        }
        if (numOfBit <= 0) {
            DJ.print("***** ERROR ***** QuGate.QuGate(String gateLabel, int numOfBit, int target, int[] controls)\n Number of quBit (qbTypeArray =" + numOfBit + ") is Less than eaqual to zero.");
            return;
        }
        switch (gateLabel) {
            case "CX_GATE": {
                int[] qbTypeArray = QuGate.getQuBitTypeArray(numOfBit, target, controls);
                int[] gateMarker = QuGate.getGateMarker(qbTypeArray);
                this.gateMat = this.createCXGate(gateMarker, controls);
                break;
            }
            default: {
                Complex[] compArrayNull = new Complex[]{BASE_P0, BASE_M0, BASE_N, BASE_P1, BASE_M1};
                this.gateMat = new CompMat(compArrayNull);
            }
        }
    }

    public static int[] getQuBitTypeArray(int numOfQuBit, int target, int[] controls) {
        int qbTypeLength = numOfQuBit * 2;
        int[] qbTypeArray = new int[qbTypeLength];
        int cntNumber = controls.length;
        int i = 0;
        while (i < qbTypeLength) {
            qbTypeArray[i] = i * 2 + 1;
            qbTypeArray[i + 1] = qbTypeArray[i] + 2;
            i += 2;
        }
        i = 0;
        while (i < cntNumber) {
            int cnt2 = controls[i] * 2;
            qbTypeArray[cnt2] = 0;
            qbTypeArray[cnt2 + 1] = 1;
            ++i;
        }
        int target2 = target * 2;
        qbTypeArray[target2] = 1;
        qbTypeArray[target2 + 1] = 2;
        return qbTypeArray;
    }

    public static int[] getGateMarker(int[] quBitTypeArray) {
        int bitTypeLength = quBitTypeArray.length;
        if (bitTypeLength % 2 != 0) {
            DJ.print("***** ERROR ***** QuGate.getGateMarker(int[] quBitTypeArray)\n QuBit-Type-Array length (" + bitTypeLength + ") is not even.");
            return null;
        }
        int numOfQuBit = bitTypeLength / 2;
        int gateOrder = QuBit.calcNumOfProbAmp(numOfQuBit);
        int[] gateMarker = new int[gateOrder];
        gateMarker[0] = quBitTypeArray[bitTypeLength - 2];
        gateMarker[1] = quBitTypeArray[bitTypeLength - 1];
        int mkLength = 1;
        int i = numOfQuBit - 2;
        while (i >= 0) {
            mkLength *= 2;
            int k = 0;
            while (k < mkLength) {
                int _pa1 = quBitTypeArray[i * 2 + 1];
                gateMarker[mkLength + k] = _pa1 *= gateMarker[k];
                int _pa0 = quBitTypeArray[i * 2];
                gateMarker[k] = _pa0 *= gateMarker[k];
                ++k;
            }
            --i;
        }
        return gateMarker;
    }

    public final CompMat createCXGate(int[] gateMaker, int[] controls) {
        int order = gateMaker.length;
        CompMat cXGateMat = new CompMat(order);
        int numOfControl = controls.length;
        int numOfQuBit = QuBit.calcNumOfQuBit(order);
        double power = numOfQuBit - 1 - numOfControl;
        int seek = (int)Math.pow(2.0, power);
        if (seek <= 0) {
            seek = 1;
        }
        int[][] pairs = new int[seek][2];
        int index = 0;
        int k = 0;
        while (k < order) {
            if (gateMaker[k] != 0) {
                pairs[index][0] = k;
                int i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == gateMaker[k] * 2) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            }
            if (index >= seek) break;
            ++k;
        }
        k = 0;
        while (k < seek) {
            cXGateMat.setComp(pairs[k][0], pairs[k][0], 0.0, 0.0);
            cXGateMat.setComp(pairs[k][0], pairs[k][1], 1.0, 0.0);
            cXGateMat.setComp(pairs[k][1], pairs[k][0], 1.0, 0.0);
            cXGateMat.setComp(pairs[k][1], pairs[k][1], 0.0, 0.0);
            ++k;
        }
        return cXGateMat;
    }

    public QuGate(QuGate targetGate, int numOfBit, int target, int[] controls) {
        if (numOfBit < 1) {
            DJ.print("***** ERROR ***** QuGate.QuGate(QuGate targetGate, int numOfBit, int target, int[] controls)\n Number of quBit (qbTypeArray =" + numOfBit + ") is Less than one.");
            return;
        }
        int[] qbTypeArray = QuGate.getQuBitTypeArray(numOfBit, target, controls);
        int[] gateMarker = QuGate.getGateMarker(qbTypeArray);
        this.gateMat = this.createMultiGate(targetGate, gateMarker, controls);
    }

    public final CompMat createMultiGate(QuGate targetGate, int[] gateMaker, int[] controls) {
        int order = gateMaker.length;
        CompMat cXGateMat = new CompMat(order);
        int numOfControl = controls.length;
        int numOfQuBit = QuBit.calcNumOfQuBit(order);
        double power = numOfQuBit - 1 - numOfControl;
        int seek = (int)Math.pow(2.0, power);
        if (seek <= 0) {
            seek = 1;
        }
        int[][] pairs = new int[seek][2];
        int index = 0;
        int k = 0;
        while (k < order) {
            if (gateMaker[k] != 0) {
                pairs[index][0] = k;
                int i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == gateMaker[k] * 2) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            }
            if (index >= seek) break;
            ++k;
        }
        k = 0;
        while (k < seek) {
            cXGateMat.setComp(pairs[k][0], pairs[k][0], targetGate.copyElement(0, 0));
            cXGateMat.setComp(pairs[k][0], pairs[k][1], targetGate.copyElement(0, 1));
            cXGateMat.setComp(pairs[k][1], pairs[k][0], targetGate.copyElement(1, 0));
            cXGateMat.setComp(pairs[k][1], pairs[k][1], targetGate.copyElement(1, 1));
            ++k;
        }
        return cXGateMat;
    }

    public static QuGate makeCUkQuGate(int numOfBit, int target, int[] controls, int parameter) {
        if (numOfBit <= 1) {
            DJ.print("***** ERROR ***** QuGate.makeCUQuGate(int numOfBit, int target, int[] controls, int parameter)\n Number of quBit (" + numOfBit + ") is less than eaqual to one.");
            return null;
        }
        QuGate cUkGate = new QuGate(numOfBit);
        int[] qbTypeArray = QuGate.getQuBitTypeArray(numOfBit, target, controls);
        DJ.print("# qbTypeArray", qbTypeArray);
        int[] gateMarker = QuGate.getGateMarker(qbTypeArray);
        DJ.print("# gateMarker", gateMarker);
        cUkGate.gateMat = cUkGate.createCUkQuGate(gateMarker, controls, parameter);
        DJ.print("# cUkGate.gateMat", cUkGate.gateMat);
        return cUkGate;
    }

    public final CompMat createCUkQuGate(int[] gateMaker, int[] controls, int parameter) {
        int order = gateMaker.length;
        CompMat cUkGateMat = new CompMat(order);
        int numOfControl = controls.length;
        int numOfQuBit = QuBit.calcNumOfQuBit(order);
        double power = numOfQuBit - 1 - numOfControl;
        int seek = (int)Math.pow(2.0, power);
        if (seek <= 0) {
            seek = 1;
        }
        int[][] pairs = new int[seek][2];
        int index = 0;
        int k = 0;
        while (k < order) {
            if (gateMaker[k] != 0) {
                pairs[index][0] = k;
                int i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == gateMaker[k] * 2) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            }
            if (index >= seek) break;
            ++k;
        }
        double halfTheta = Math.PI / Math.pow(2.0, parameter);
        double sinTheat = Math.sin(halfTheta);
        double cosTheat = Math.cos(halfTheta);
        int k2 = 0;
        while (k2 < seek) {
            cUkGateMat.setComp(pairs[k2][0], pairs[k2][0], 1.0, 0.0);
            cUkGateMat.setComp(pairs[k2][0], pairs[k2][1], 0.0, 0.0);
            cUkGateMat.setComp(pairs[k2][1], pairs[k2][0], 0.0, 0.0);
            cUkGateMat.setComp(pairs[k2][1], pairs[k2][1], cosTheat, sinTheat);
            ++k2;
        }
        return cUkGateMat;
    }

    public static QuGate makeCRkQuGate(int numOfBit, int target, int[] controls, int parameter) {
        if (numOfBit <= 1) {
            DJ.print("***** ERROR ***** QuGate.makeCRkQuGate(int numOfBit, int target, int[] controls, int parameter)\n Number of quBit (" + numOfBit + ") is less than eaqual to one.");
            return null;
        }
        QuGate cRk = new QuGate(numOfBit);
        int[] qbTypeArray = QuGate.getQuBitTypeArray(numOfBit, target, controls);
        DJ.print("# qbTypeArray", qbTypeArray);
        int[] gateMarker = QuGate.getGateMarker(qbTypeArray);
        DJ.print("# gateMarker", gateMarker);
        cRk.gateMat = cRk.createCRkQuGate(gateMarker, controls, parameter);
        return cRk;
    }

    public final CompMat createCRkQuGate(int[] gateMaker, int[] controls, int parameter) {
        int order = gateMaker.length;
        DJ.print("$ order = ", order);
        CompMat cRkGateMat = new CompMat(order);
        int numOfControl = controls.length;
        int numOfQuBit = QuBit.calcNumOfQuBit(order);
        double power = numOfQuBit - 1 - numOfControl;
        int seek = (int)Math.pow(2.0, power);
        if (seek <= 0) {
            seek = 1;
        }
        int[][] pairs = new int[seek][2];
        int index = 0;
        int k = 0;
        while (k < order) {
            if (gateMaker[k] != 0) {
                pairs[index][0] = k;
                int i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == gateMaker[k] * 2) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            }
            if (index >= seek) break;
            ++k;
        }
        double halfTheta = Math.PI / Math.pow(2.0, parameter);
        double sinTheat = Math.sin(halfTheta);
        double cosTheat = Math.cos(halfTheta);
        int k2 = 0;
        while (k2 < seek) {
            cRkGateMat.setComp(pairs[k2][0], pairs[k2][0], 1.0, 0.0);
            cRkGateMat.setComp(pairs[k2][0], pairs[k2][1], 0.0, 0.0);
            cRkGateMat.setComp(pairs[k2][1], pairs[k2][0], 0.0, 0.0);
            cRkGateMat.setComp(pairs[k2][1], pairs[k2][1], cosTheat, sinTheat);
            ++k2;
        }
        return cRkGateMat;
    }

    public static QuGate makeSwapQuGate(int numOfQuBit, int[] targets) {
        if (numOfQuBit < 2) {
            DJ.print("***** ERROR ***** QuGate.makeSwapQuGate(int numOfQuBit, int[] targets)\n Number of quBit (" + numOfQuBit + ") is less than two.");
            return null;
        }
        int numOfTarget = targets.length;
        if (numOfTarget < 2) {
            DJ.print("***** ERROR ***** QuGate.makeSwapQuGate(int numOfQuBit, int[] targets)\n Number of target (" + numOfTarget + ") is less than two.");
            return null;
        }
        int target = targets[1];
        DJ.print_("#: numOfQuBits = " + numOfQuBit + ", control = " + target);
        int[] controlArray = new int[]{targets[0]};
        DJ.print(", target", controlArray);
        QuGate cxGate = new QuGate(CX_GATE, numOfQuBit, target, controlArray);
        DJ.printF("#; cxGate", cxGate);
        target = targets[0];
        DJ.print_("#: numOfQuBits = " + numOfQuBit + ", target0 = " + target);
        controlArray[0] = targets[1];
        DJ.print(", target1", controlArray);
        QuGate xcGate = new QuGate(CX_GATE, numOfQuBit, target, controlArray);
        DJ.printF("#; xcGate", xcGate);
        QuGate swapGate = cxGate.product(xcGate);
        DJ.printF("#; Transient swapGate", swapGate);
        swapGate = swapGate.product(cxGate);
        DJ.printF("#; swapGate", swapGate);
        return swapGate;
    }

    public static QuGate makeCSwapQuGate(int numOfQuBit, int[] targets, int[] controls) {
        QuGate cSwapGate = new QuGate(numOfQuBit);
        int[] qbTypeArray = QuGate.getSwapBitArray(numOfQuBit, targets, controls);
        DJ.print("# qbTypeArray", qbTypeArray);
        int[] gateMarker = QuGate.getSwapGateMarker(qbTypeArray);
        DJ.print("# gateMarker", gateMarker);
        cSwapGate.gateMat = QuGate.createSwapGate(gateMarker, controls);
        return cSwapGate;
    }

    public static int[] getSwapBitArray(int numOfQuBit, int[] target, int[] controls) {
        int qbTypeLength = numOfQuBit * 2;
        int[] qbTypeArray = new int[qbTypeLength];
        int i = 0;
        while (i < qbTypeLength) {
            qbTypeArray[i] = 1;
            qbTypeArray[i + 1] = 0;
            i += 2;
        }
        int cntNumber = controls.length;
        if (cntNumber > 0) {
            int i2 = 0;
            while (i2 < cntNumber) {
                int cnt2 = controls[i2] * 2;
                qbTypeArray[cnt2] = 0;
                qbTypeArray[cnt2 + 1] = 1;
                ++i2;
            }
        }
        int target0 = target[0] * 2;
        qbTypeArray[target0] = 3;
        qbTypeArray[target0 + 1] = 5;
        int target1 = target[1] * 2;
        qbTypeArray[target1] = 7;
        qbTypeArray[target1 + 1] = 11;
        return qbTypeArray;
    }

    public static int[] getSwapGateMarker(int[] quBitTypeArray) {
        int bitTypeLength = quBitTypeArray.length;
        if (bitTypeLength % 2 != 0) {
            DJ.print("***** ERROR ***** QuGate.getGateMarker(int[] quBitTypeArray)\n QuBit-Type-Array length (" + bitTypeLength + ") is not even.");
            return null;
        }
        int numOfQuBit = bitTypeLength / 2;
        int gateOrder = QuBit.calcNumOfProbAmp(numOfQuBit);
        int[] gateMarker = new int[gateOrder];
        gateMarker[0] = quBitTypeArray[bitTypeLength - 2];
        gateMarker[1] = quBitTypeArray[bitTypeLength - 1];
        int mkLength = 1;
        int i = numOfQuBit - 2;
        while (i >= 0) {
            mkLength *= 2;
            int k = 0;
            while (k < mkLength) {
                int _pa1 = quBitTypeArray[i * 2 + 1];
                gateMarker[mkLength + k] = _pa1 *= gateMarker[k];
                int _pa0 = quBitTypeArray[i * 2];
                gateMarker[k] = _pa0 *= gateMarker[k];
                ++k;
            }
            --i;
        }
        return gateMarker;
    }

    public static CompMat createSwapGate(int[] gateMaker, int[] controls) {
        int order = gateMaker.length;
        DJ.print("$ order = ", order);
        CompMat cSwapGateMat = new CompMat(order);
        int seek = 1;
        int[][] pairs = new int[1][2];
        int index = 0;
        int k = 0;
        while (k < order) {
            if (gateMaker[k] == 33) {
                pairs[index][0] = k;
                i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == 35) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            } else if (gateMaker[k] == 35) {
                pairs[index][0] = k;
                i = k + 1;
                while (i < order) {
                    if (gateMaker[i] == 33) {
                        pairs[index][1] = i;
                        ++index;
                        break;
                    }
                    ++i;
                }
            }
            if (index >= seek) break;
            ++k;
        }
        k = 0;
        while (k < seek) {
            cSwapGateMat.setComp(pairs[k][0], pairs[k][0], 0.0, 0.0);
            cSwapGateMat.setComp(pairs[k][0], pairs[k][1], 1.0, 0.0);
            cSwapGateMat.setComp(pairs[k][1], pairs[k][0], 1.0, 0.0);
            cSwapGateMat.setComp(pairs[k][1], pairs[k][1], 0.0, 0.0);
            ++k;
        }
        return cSwapGateMat;
    }

    public int getOrder() {
        return this.gateMat.rowNumber();
    }

    public int rowNumber() {
        return this.gateMat.rowNumber();
    }

    public int colNumber() {
        return this.gateMat.colNumber();
    }

    public CompMat getGateMat() {
        return this.gateMat;
    }

    public void setGateMat(CompMat gateMat) {
        this.gateMat = gateMat;
    }

    public Complex getElement(int row, int col) {
        return this.gateMat.getComp(row, col);
    }

    public void setElement(int row, int col, Complex element) {
        this.gateMat.setComp(row, col, element);
    }

    public CompMat copyGateMat() {
        CompMat _gateMat = this.gateMat.copyCompMat();
        return _gateMat;
    }

    public Complex copyElement(int row, int col) {
        return this.gateMat.copyComp(row, col);
    }

    public void copyElement(int row, int col, Complex element) {
        this.gateMat.setComp(row, col, element);
    }

    public Complex[][] getElement() {
        return this.gateMat.getMatrix();
    }

    public Complex[][] copyElement() {
        return this.gateMat.copyMatrix();
    }

    public QuGate conjugate() {
        int order = this.gateMat.rowNumber();
        int numOfQuBit = QuBit.calcNumOfQuBit(order);
        QuGate conjuQuGate = new QuGate(numOfQuBit);
        CompMat conjuMat = conjuQuGate.gateMat;
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                conjuMat.setComp(j, i, this.gateMat.getComp(i, j).conjugate());
                ++j;
            }
            ++i;
        }
        return conjuQuGate;
    }

    public QuBit apply(QuBit operand) {
        Complex[] _qbVec;
        Complex[][] _gateMat = this.gateMat.getMatrix();
        if (_gateMat[0].length != (_qbVec = operand.getProbAmpArray()).length) {
            DJ.print("***** ERROR ***** QuGate.apply(QuBit operand)\n gate size (" + _gateMat[0].length + ") is not equal to QuBit size (" + _qbVec.length + ").");
            return null;
        }
        Complex[] result = Complex.product(_gateMat, _qbVec);
        QuBit resultQB = new QuBit(result);
        return resultQB;
    }

    public QuGate product(QuGate operand) {
        int row = this.gateMat.rowNumber();
        int col = this.gateMat.colNumber();
        int operandRow = operand.rowNumber();
        int operandCol = operand.colNumber();
        if (row != operandRow) {
            DJ.print("***** ERROR ***** QuGate.innerProduct(QuGate operand)\n Element numbers are not same. target row number is " + row + ", " + " operand row number is " + operandRow + ".");
            return null;
        }
        QuGate productedGate = new QuGate(col, operandCol);
        CompMat productedMat = productedGate.gateMat;
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < operandCol) {
                int k = 0;
                while (k < row) {
                    Complex element = this.gateMat.copyComp(i, k);
                    element.mul(operand.getElement(k, j));
                    productedMat.getComp(i, j).add(element);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return productedGate;
    }

    public QuGate innerProduct(QuGate operand) {
        int row = this.gateMat.rowNumber();
        int col = this.gateMat.colNumber();
        int operandRow = operand.rowNumber();
        int operandCol = operand.colNumber();
        if (row != operandRow) {
            DJ.print("***** ERROR ***** QuGate.innerProduct(QuGate operand)\n Element numbers are not same. target row number is " + row + ", " + " operand row number is " + operandRow + ".");
            return null;
        }
        CompMat _conjugate = this.gateMat.conjugate();
        QuGate productedGate = new QuGate(col, operandCol);
        CompMat productedMat = productedGate.gateMat;
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < operandCol) {
                int k = 0;
                while (k < row) {
                    Complex conj = _conjugate.copyComp(i, k);
                    conj.mul(operand.getElement(k, j));
                    productedMat.getComp(i, j).add(conj);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return productedGate;
    }

    public QuGate interactQuGate(QuGate operandGate) {
        int row0 = this.gateMat.rowNumber();
        int col0 = this.gateMat.colNumber();
        CompMat operandMat = operandGate.gateMat;
        int row1 = operandMat.rowNumber();
        int col1 = operandMat.colNumber();
        QuGate interactedGate = new QuGate(row0 * row1, col0 * col1);
        int i0 = 0;
        while (i0 < row0) {
            int j0 = 0;
            while (j0 < col0) {
                int i1 = 0;
                while (i1 < row1) {
                    int j1 = 0;
                    while (j1 < col1) {
                        int i = i0 * row1 + i1;
                        int j = j0 * col1 + j1;
                        Complex element = this.gateMat.copyComp(i0, j0);
                        element.mul(operandMat.getComp(i1, j1));
                        interactedGate.setElement(i, j, element);
                        ++j1;
                    }
                    ++i1;
                }
                ++j0;
            }
            ++i0;
        }
        return interactedGate;
    }

    public static QuBit deutschGate(int functionType, QuBit inputQuBit) {
        CompVec inputProbAmpVec = inputQuBit.copyProbAmpVec();
        QuBit quBit0 = new QuBit("std0QuBit");
        quBit0.product(inputProbAmpVec.getComp(0));
        int inCB0 = 0;
        int qbVal = QuGate.deutschFunction(functionType, inCB0);
        QuBit quBit1 = qbVal == 0 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        QuBit outputQuBit = quBit0.interactQuBit(quBit1);
        quBit0 = new QuBit("std0QuBit");
        quBit0.product(inputProbAmpVec.getComp(1));
        quBit1 = qbVal == 1 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        quBit0 = new QuBit("std1QuBit");
        quBit0.product(inputProbAmpVec.getComp(2));
        if (functionType > 1) {
            qbVal = 1 - qbVal;
        }
        quBit1 = qbVal == 0 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        quBit0 = new QuBit("std1QuBit");
        quBit0.product(inputProbAmpVec.getComp(3));
        quBit1 = qbVal == 1 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        return outputQuBit;
    }

    public static QuBit deutschGate_0(int functionType, QuBit inputQuBit) {
        CompVec inputProbAmpVec = inputQuBit.copyProbAmpVec();
        QuBit quBit0 = new QuBit("std0QuBit");
        quBit0.product(inputProbAmpVec.getComp(0));
        int inQB0 = 0;
        int qbVal = QuGate.deutschFunction(functionType, inQB0);
        DJ.print_("  $0 \u95a2\u6570\u51fa\u529bqbVal(" + functionType + ") = ", qbVal);
        QuBit quBit1 = qbVal == 0 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        QuBit outputQuBit = quBit0.interactQuBit(quBit1);
        quBit0 = new QuBit("std0QuBit");
        quBit0.product(inputProbAmpVec.getComp(1));
        DJ.print_(", ", qbVal);
        quBit1 = qbVal == 1 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        quBit0 = new QuBit("std1QuBit");
        quBit0.product(inputProbAmpVec.getComp(2));
        if (functionType > 1) {
            qbVal = 1 - qbVal;
        }
        DJ.print_(", ", qbVal);
        quBit1 = qbVal == 0 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        quBit0 = new QuBit("std1QuBit");
        quBit0.product(inputProbAmpVec.getComp(3));
        DJ.print(", ", qbVal);
        quBit1 = qbVal == 1 ? new QuBit("std0QuBit") : new QuBit("std1QuBit");
        outputQuBit.sum(quBit0.interactQuBit(quBit1));
        return outputQuBit;
    }

    public static int deutschFunction(int functionType, int input) {
        if (input != 0 && input != 1) {
            DJ.print("***** ERROR ***** QuGate.deutschOracle(int functionType, int input)\n Input value is not 0 nor 1. input value is " + input + ".");
            throw new IllegalArgumentException("\u5f15\u6570 input \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        return switch (functionType) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> input;
            default -> 1 - input;
        };
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        int i = 0;
        while (i < size) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }

    public String toString() {
        int index;
        int row = this.gateMat.rowNumber();
        int col = this.gateMat.colNumber();
        StringBuilder sb = new StringBuilder("\n[");
        int i = 0;
        while (i < row) {
            sb.append("[");
            int j = 0;
            while (j < col) {
                sb.append(this.gateMat.getComp(i, j).toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat() {
        int row = this.gateMat.rowNumber();
        int col = this.gateMat.colNumber();
        int[] maxWide = new int[col];
        int j = 0;
        while (j < col) {
            maxWide[j] = 5;
            ++j;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        int i = 0;
        while (i < row) {
            int j2 = 0;
            while (j2 < col) {
                String text = this.gateMat.getComp(i, j2).toFormat();
                if (this.gateMat.getReal(i, j2) >= 0.0) {
                    buf[i][j2] = " " + text;
                    wides[i][j2] = text.length() + 1;
                } else {
                    buf[i][j2] = text;
                    wides[i][j2] = text.length();
                }
                if (wides[i][j2] > maxWide[j2]) {
                    maxWide[j2] = wides[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "  ";
        int gap = filler.length();
        int spaces = maxWide[0];
        int j3 = 1;
        while (j3 < col) {
            spaces = spaces + gap + maxWide[j3];
            ++j3;
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        int i2 = 0;
        while (i2 < row) {
            sb.append("\u2502");
            int j4 = 0;
            while (j4 < col) {
                sb.append(buf[i2][j4]);
                sb.append(this.getSpace(maxWide[j4] - wides[i2][j4])).append(filler);
                ++j4;
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
            ++i2;
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public String toString(String label) {
        int index;
        int row = this.gateMat.rowNumber();
        int col = this.gateMat.colNumber();
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":\n[");
        int i = 0;
        while (i < row) {
            sb.append("[");
            int j = 0;
            while (j < col) {
                sb.append(this.gateMat.getComp(i, j).toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return String.valueOf(label) + ":" + str;
    }
}

