/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import layer.LinearLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class AndLogic
extends Task {
    int epoch = 20;
    int interval = 1;
    double initialCoef = 0.01;
    double eta = 0.1;
    int dataNum = 64;
    int inNodeNum = 2;
    int outNodeNum = 1;
    private LinearLayer outputLayer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[4][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(3, this.patternData0, "AndLogic");
        this.graphShift = 3;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.andLogic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andLogic() {
        DJ._print("AndLogic.andLogic() ==================");
        DJ.print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" initialCoef=", this.initialCoef);
        DJ.print_(", eta=", this.eta);
        DJ.print_(", epoch=", this.epoch);
        DJ.print_(", interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1a", this.dataNum);
        DJ._print_(" \u5165\u529b\u306e\u500b\u6570\uff1a", this.inNodeNum);
        DJ.print(", \u51fa\u529b\u306e\u500b\u6570\uff1a", this.outNodeNum);
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6b63\u89e3\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        int[][] inputData = new int[this.dataNum][2];
        int[] correctData = new int[this.dataNum];
        Random randum = DJ.getRandom();
        int i = 0;
        while (i < this.dataNum) {
            boolean b0 = randum.nextBoolean();
            boolean b1 = randum.nextBoolean();
            boolean bAnd = b0 & b1;
            inputData[i][0] = DJ.boolToInt(b0);
            inputData[i][1] = DJ.boolToInt(b1);
            correctData[i] = DJ.boolToInt(bAnd);
            ++i;
        }
        ArrayList<Integer> indexList = DJ.permutationRandom(this.dataNum);
        DJ.print("inputData", inputData);
        DJ.print("correctData", correctData);
        this.patternData0 = new double[4][this.dataNum];
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        DJ.print(" outLayer  = new Layer(inNodeNum, outNodeNum)");
        this.outputLayer = new LinearLayer(this.inNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.ReLU", 0);
        double[] x = this.outputLayer.getX();
        double[] y = this.outputLayer.getY();
        double[] e = this.outputLayer.getE();
        double[] c = this.outputLayer.getC();
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        double squareError = 0.0;
        double meanError = 0.0;
        DJ._print("\u30fb\u5b9f\u884c\u958b\u59cb\u6642\u523b\uff1a", TimeStamp.getTimeFormated());
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i2 = 0;
        while (i2 <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i2 % this.interval == this.interval - 1 | i2 == this.epoch;
            Collections.shuffle(indexList);
            int j = 0;
            while (j < this.dataNum) {
                int index = indexList.get(j);
                int k = 0;
                while (k < 2) {
                    x[k] = inputData[index][k];
                    ++k;
                }
                this.outputLayer.forward();
                c[0] = correctData[index];
                this.outputLayer.backward(c);
                this.outputLayer.update();
                if (this.intervalFlag) {
                    squareError = e[0] * e[0] / 2.0;
                    meanError += squareError;
                    this.patternData0[0][j] = x[0];
                    this.patternData0[1][j] = x[1];
                    this.patternData0[2][j] = y[0];
                    this.patternData0[3][j] = c[0];
                }
                ++j;
            }
            double aveError = meanError / (double)this.dataNum;
            meanError = 0.0;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ._print_(" i=" + i2);
                DJ.print_(", squareError = ", squareError);
                DJ.print(", aveError = ", aveError);
                this.graphData[0] = squareError;
                this.graphData[1] = aveError;
                this.updateViewer(i2);
                DJ.print_(" lapTime = ", this.lapTime);
                DJ.print("[msec]");
                AndLogic andLogic = this;
                synchronized (andLogic) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + ex.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i2;
            }
            ++i2;
        }
        DJ._print(" End of all epoch ---------------");
        DJ._print("\u30fb\u5404\u5c64\u306e\u5909\u6570\u306e\u6700\u7d42\u5024");
        DJ.print(" Last epoch = ", this.epoch);
        DJ._print("\u3000\u51fa\u529b\u5c64\u306e\u30d0\u30a4\u30a2\u30b9\u3068\u91cd\u307f");
        DJ.print("outputLayer.b", this.outputLayer.getB());
        DJ.print("outputLayer.w", this.outputLayer.getW());
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }
}

