/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Collections;
import layer.LinearLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class FormFit
extends Task {
    int epoch = 3000;
    int interval = 50;
    double initialCoef = 0.05;
    double eta = 0.1;
    int x0GridNum = 21;
    int x1GridNum = 21;
    int dataNum = this.x0GridNum * this.x1GridNum;
    int inNodeNum = 2;
    int midNodeNum = 8;
    int outNodeNum = 1;
    private LinearLayer middleLayer;
    private LinearLayer outputLayer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[3][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(2, this.patternData0, "FormFit");
        this.graphShift = 2;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.formFit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formFit() {
        DJ._print("CurveFit.curveFit() ==================");
        DJ.print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" initialCoef=", this.initialCoef);
        DJ.print_(", eta=", this.eta);
        DJ.print_(", epoch=", this.epoch);
        DJ.print_(", interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1a", this.dataNum);
        DJ._print("\u3000\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(", \u5165\u529b\u5c64\u306e\u30ce\u30fc\u30c9\u6570\uff1a", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u306e\u30ce\u30fc\u30c9\u6570\uff1a", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u306e\u30ce\u30fc\u30c9\u6570\uff1a", this.outNodeNum);
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        double[][] inputData = new double[2][this.dataNum];
        double[] polyData = new double[this.dataNum];
        double[] x0 = new double[this.x0GridNum];
        double[] x1 = new double[this.x1GridNum];
        int i = 0;
        while (i < this.x0GridNum) {
            x0[i] = -1.0 + 2.0 / (double)(this.x0GridNum - 1) * (double)i;
            ++i;
        }
        int j = 0;
        while (j < this.x1GridNum) {
            x1[j] = -1.0 + 2.0 / (double)(this.x1GridNum - 1) * (double)j;
            ++j;
        }
        i = 0;
        while (i < this.x0GridNum) {
            int j2 = 0;
            while (j2 < this.x1GridNum) {
                double y;
                int k = i * (this.x0GridNum - 1) + j2;
                inputData[0][k] = x0[i] + 0.005 * (double)j2;
                inputData[1][k] = x1[j2];
                polyData[k] = y = 1.8 * x0[i] * x0[i] * x0[i] + 0.2 * x0[i] * x0[i] - 1.0 * x0[i] - 0.5 * x1[j2] * x1[j2] - 0.2 * x1[j2] - 0.1;
                ++j2;
            }
            ++i;
        }
        ArrayList<Integer> indexList = DJ.permutationRandom(this.dataNum);
        DJ.printList("indexList=\n", indexList);
        DJ.print("inputData[0]", inputData[0]);
        DJ.print("inputData[1]", inputData[1]);
        DJ.print("polyData", polyData);
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer = new LinearLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        double[] midX = this.middleLayer.getX();
        double[] midY = this.middleLayer.getY();
        this.outputLayer = new LinearLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 0);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        this.middleLayer.setdEdY(outdEdX);
        this.outputLayer.setX(midY);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        double squareError = 0.0;
        double meanError = 0.0;
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i2 = 0;
        while (i2 <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i2 % this.interval == this.interval - 1 | i2 == this.epoch;
            Collections.shuffle(indexList);
            int j3 = 0;
            while (j3 < this.dataNum) {
                int index = indexList.get(j3);
                midX[0] = inputData[0][index];
                midX[1] = inputData[1][index];
                this.middleLayer.forward();
                this.outputLayer.forward();
                outC[0] = polyData[index];
                this.outputLayer.backward(outC);
                this.middleLayer.backward();
                this.middleLayer.update();
                this.outputLayer.update();
                if (this.intervalFlag) {
                    squareError = outE[0] * outE[0] / 2.0;
                    meanError += squareError;
                    this.patternData0[0][index] = midX[0];
                    this.patternData0[1][index] = outY[0];
                    this.patternData0[2][index] = outC[0];
                }
                ++j3;
            }
            double aveError = meanError / (double)this.dataNum;
            meanError = 0.0;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i2);
                DJ.print_(", squareError = ", squareError);
                DJ.print(", aveError = ", aveError);
                this.graphData[0] = squareError;
                this.graphData[1] = aveError;
                this.updateViewer(i2);
                DJ.print_(" lapTime = ", this.lapTime);
                DJ.print("[msec]");
                FormFit formFit = this;
                synchronized (formFit) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i2;
            }
            ++i2;
        }
        DJ._print(" End of all epoch ---------------");
        DJ._print("\u30fb\u5b66\u7fd2\u7d50\u679c");
        DJ.print(" Last epoch = ", this.epoch);
        DJ._print("\u3000\u95a2\u6570\u306e\u5165\u529b\u3001\u63a8\u5b9a\u5024\u3001\u6b63\u89e3\u5024\u3001\u8aa4\u5dee\uff05");
        DJ.print("id, input, estimated, correct data");
        int j4 = 0;
        while (j4 < this.dataNum) {
            DJ.print_(String.valueOf(j4) + ": ");
            DJ.print_(", ", this.patternData0[0][j4]);
            DJ.print_(", ", this.patternData0[1][j4]);
            DJ.print_(", ", this.patternData0[2][j4]);
            double err = (this.patternData0[1][j4] - this.patternData0[2][j4]) / this.patternData0[2][j4] * 100.0;
            DJ.print(", ", err);
            ++j4;
        }
        DJ._print("\u3000\u6700\u7d42\u8aa4\u5dee");
        if (this.graphViewer != null) {
            DJ.print(String.valueOf(this.dataName[0]) + " = ", this.graphData[0]);
            DJ.print(String.valueOf(this.dataName[1]) + " = ", this.graphData[1]);
        }
        DJ._print("\u3000\u4e2d\u9593\u5c64\u306e\u30d0\u30a4\u30a2\u30b9\u3068\u91cd\u307f");
        DJ.print("middleLayer.b", this.middleLayer.getB());
        DJ.print("middleLayer.w", this.middleLayer.getW());
        DJ._print("\u3000\u51fa\u529b\u5c64\u306e\u30d0\u30a4\u30a2\u30b9\u3068\u91cd\u307f");
        DJ.print("outputLayer.b", this.outputLayer.getB());
        DJ.print("outputLayer.w", this.outputLayer.getW());
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }
}

