/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Collections;
import layer.LinearLayer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;
import view.GraphViewer;
import view.GraphViewerLauncher;
import view.PatternViewer;
import view.PatternViewerLauncher;

public class ImageRecognizer
extends Task {
    private boolean trialFlag;
    double[] inData;
    double[] teachData;
    int epoch = 300;
    int batchNum = 15;
    int interval = 5;
    double initialCoef = 0.05;
    double eta = 0.01;
    double dropOutRate = 0.3;
    int inImageHight;
    int inImageWidth = this.inImageHight = 8;
    int inNodeNum = this.inImageHight * this.inImageWidth;
    int midNodeNum = 64;
    private final int outNodeNum = 10;
    private LinearLayer middleLayer0;
    private LinearLayer middleLayer1;
    private LinearLayer outputLayer;
    int trialCount = 0;
    int correctCount = 0;
    double correctLevel = 0.5;
    double correctRatio;
    boolean patternViewerFlag;
    PatternViewerLauncher patternViewerLauncher;
    PatternViewer patternViewer;
    double[][][] patternData0;
    double[][] patternData1;
    int graphShift = 1;
    GraphViewerLauncher graphViewerLauncher;
    GraphViewer graphViewer;
    double[] graphData;
    String[] dataName;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[1][10][2];
        this.patternData1 = new double[this.inImageHight][this.inImageWidth];
        this.patternViewerLauncher = DJ.pattern(5, this.patternData0, "ImageRecognizer0", 1, this.patternData1, "ImageRecognizer1");
        this.graphData = new double[4];
        this.dataName = new String[4];
        this.dataName[0] = "LearnError";
        this.dataName[1] = "LearnEntropy";
        this.dataName[2] = "TrialError";
        this.dataName[3] = "TrialEntropy";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.imageRecognizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageRecognizer() {
        DJ._print("ImageRecognizer.imageRecognizer() ==========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u30c9\u30ed\u30c3\u30d7\u30fb\u30a2\u30a6\u30c8\u7387:dropOutRate=", this.dropOutRate);
        DJ.print(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ._print("\u3000\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", 10);
        DJ._print("\u30fb\u5165\u529b\u753b\u50cf\u3092\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u8fbc");
        DJ.print(" DaiJa/resorce/input_image.txt, \u30b3\u30f3\u30de\u533a\u5207\u308a, 1797[\u679a]\u00d764[\u753b\u7d20]");
        double[][] inputImage = LogEditor.loadData("input_image.txt");
        int inputImageNum = inputImage.length;
        int imageElementNum = inputImage[0].length;
        DJ.print(" \u5165\u529b\u753b\u50cf\u306e\u679a\u6570inputImage.getLength(DIM_1ST)=" + inputImageNum);
        DJ.print(" \u5165\u529b\u753b\u50cf\u306e\u753b\u7d20\u6570inputImage.getLength(DIM_2ND)=" + imageElementNum);
        double average = DJ.average(inputImage);
        double stdDev = DJ.stdDev(inputImage);
        DJ.print(" \u5165\u529b\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u5e73\u5747average = inputImage.average(): average=", average);
        DJ.print(" \u6a19\u6e96\u504f\u5deestdDev = inputImage.stdDev(): stdDev=", stdDev);
        DJ._print("\u30fb\u5165\u529b\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u6b63\u898f\u5316, \u5e73\u5747=0, \u6a19\u6e96\u504f\u5dee=1");
        double[][] inputImageStd = DJ.normalize(inputImage);
        double averageNomal = DJ.average(inputImageStd);
        double stdDevNomal = DJ.stdDev(inputImageStd);
        DJ.print_(" \u6b63\u898f\u5316\u3055\u308c\u305f\u5165\u529b\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u5e73\u5747=", averageNomal);
        DJ.print(", \u6a19\u6e96\u504f\u5dee=", stdDevNomal);
        DJ._print("\u30fb\u6b63\u89e3\u6587\u5b57\u5217\u3092\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u8fbc");
        DJ.print(" \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0/resorce/target_text.txt, \u6574\u6570\u4e00\u6841, \u30b3\u30f3\u30de\u533a\u5207\u308a, 1797[\u6587\u5b57]");
        int[][] targetText = LogEditor.loadIntData("target_text.txt");
        int targetNum = targetText[0].length;
        DJ.print(" \u6b63\u89e3\u6587\u5b57\u5217\u306e\u9577\u3055:targetNum=", targetNum);
        DJ._print("\u30fb\u6b63\u89e3\u30c7\u30fc\u30bf\u3092one-hot\u8868\u73fe\u3067\u751f\u6210, 10[\u884c]\u00d71797[\u5217]");
        double[][] correctData = new double[targetNum][10];
        int i = 0;
        while (i < targetNum) {
            int j = 0;
            while (j < 10) {
                correctData[i][j] = 0.0;
                ++j;
            }
            int k = targetText[0][i];
            correctData[i][k] = 1.0;
            ++i;
        }
        DJ._print("\u30fb\u30e9\u30f3\u30c0\u30e0\u306a\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u751f\u6210, 1797[\u500b]");
        DJ.print(" \u30e9\u30f3\u30c0\u30e0\u30fb\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6570:inputImageNum=", inputImageNum);
        ArrayList<Integer> randomIndexList = DJ.permutationRandom(inputImageNum);
        int randomListNum = randomIndexList.size();
        DJ.print(" \u30e9\u30f3\u30c0\u30e0\u30fb\u30ea\u30b9\u30c8\u9577:ranListNum=", randomListNum);
        DJ.print(" \u30e9\u30f3\u30c0\u30e0\u306a\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30922:1\u3067\u5b66\u7fd2\u7528\u3068\u8a66\u884c\u7528\u306b\u5272\u308a\u632f\u308a");
        ArrayList<Integer> learnIndexList = new ArrayList<Integer>();
        ArrayList<Integer> trialIndexList = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < randomListNum) {
            if (i2 % 3 != 0) {
                learnIndexList.add(randomIndexList.get(i2));
            } else {
                trialIndexList.add(randomIndexList.get(i2));
            }
            ++i2;
        }
        int learnNum = learnIndexList.size();
        int trialNum = trialIndexList.size();
        DJ.print_(" \u5b66\u7fd2\u7528\u30c7\u30fc\u30bf\u6570:learnNum=", learnNum);
        DJ.print(", \u8a66\u884c\u7528\u30c7\u30fc\u30bf\u6570:trialNum=", trialNum);
        this.inData = new double[this.inNodeNum];
        this.teachData = new double[10];
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new LinearLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.middleLayer1 = new LinearLayer(this.midNodeNum, this.midNodeNum);
        this.middleLayer1.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        double[] mid1Y = this.middleLayer1.getY();
        double[] mid1dEdX = this.middleLayer1.getdEdX();
        this.outputLayer = new LinearLayer(this.midNodeNum, 10);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.SoftMax", 1);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outdEdX = this.outputLayer.getdEdX();
        this.middleLayer0.setdEdY(mid1dEdX);
        this.middleLayer1.setdEdY(outdEdX);
        this.middleLayer1.setX(mid0Y);
        this.outputLayer.setX(mid1Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i3 = 0;
        while (i3 <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i3 % this.interval == this.interval - 1 | i3 == this.epoch;
            if (this.intervalFlag) {
                this.trialCount = 0;
                this.correctCount = 0;
            }
            Collections.shuffle(learnIndexList);
            Collections.shuffle(trialIndexList);
            double learnErrorSum = 0.0;
            double learnEntropySum = 0.0;
            double trialErrorSum = 0.0;
            double trialEntropySum = 0.0;
            this.patternData0 = new double[trialNum][10][2];
            int j = 0;
            while (j < learnNum) {
                this.trialFlag = false;
                int learnIndex = (Integer)learnIndexList.get(j);
                this.inData = inputImageStd[learnIndex];
                System.arraycopy(this.inData, 0, mid0X, 0, this.inNodeNum);
                this.middleLayer0.forward();
                this.middleLayer1.forward();
                this.outputLayer.forward();
                this.teachData = correctData[learnIndex];
                System.arraycopy(this.teachData, 0, outC, 0, 10);
                this.outputLayer.backward(outC);
                this.middleLayer1.backward();
                this.middleLayer0.backward();
                if (j % this.batchNum == 0) {
                    this.middleLayer0.update();
                    this.middleLayer1.update();
                    this.outputLayer.update();
                }
                learnErrorSum += DJ.getSquareError(outY, this.teachData);
                learnEntropySum += DJ.getEntropyError(outY, this.teachData);
                if (j < trialNum) {
                    this.trialFlag = true;
                    int trialIndex = (Integer)trialIndexList.get(j);
                    this.inData = inputImageStd[trialIndex];
                    System.arraycopy(this.inData, 0, mid0X, 0, this.inNodeNum);
                    this.middleLayer0.forward();
                    this.middleLayer1.forward();
                    this.outputLayer.forward();
                    this.teachData = correctData[trialIndex];
                    trialErrorSum += DJ.getSquareError(outY, this.teachData);
                    trialEntropySum += DJ.getEntropyError(outY, this.teachData);
                    if (this.intervalFlag) {
                        int k = 0;
                        while (k < 10) {
                            this.patternData0[j][k][0] = outY[k];
                            this.patternData0[j][k][1] = this.teachData[k];
                            ++k;
                        }
                        ++this.trialCount;
                        int correctNumber = targetText[0][trialIndex];
                        double output = outY[correctNumber];
                        if (output >= this.correctLevel) {
                            ++this.correctCount;
                        }
                    }
                    this.trialFlag = false;
                }
                ++j;
            }
            double learnErrorVal = Math.sqrt(learnErrorSum / (double)learnNum);
            double learnEntropyVal = learnEntropySum / (double)learnNum;
            double trialErrorVal = Math.sqrt(trialErrorSum / (double)trialNum);
            double trialEntropyVal = trialEntropySum / (double)trialNum;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i3);
                this.correctRatio = (double)this.correctCount / (double)this.trialCount * 100.0;
                DJ.print_(", \u6b63\u7b54\u6bd4\u7387=", String.valueOf(this.correctRatio) + "[%]");
                if (this.patternViewer == null) {
                    this.patternViewer = this.patternViewerLauncher.getPatternViewer();
                }
                if (this.patternViewer != null) {
                    this.patternData1 = DJ.reshape(this.inData, this.inImageHight, this.inImageWidth);
                    this.patternViewer.setVisible(true);
                    this.patternViewer.updatePattern(this.patternData0, this.patternData1);
                }
                if (this.graphViewer == null) {
                    this.graphViewer = this.graphViewerLauncher.getGraphViewer();
                    if (this.graphViewer != null) {
                        this.graphViewer.shiftGraphAxis(1);
                    }
                }
                if (this.graphViewer != null) {
                    this.graphData[0] = learnErrorVal;
                    this.graphData[1] = learnEntropyVal;
                    this.graphData[2] = trialErrorVal;
                    this.graphData[3] = trialEntropyVal;
                    this.graphViewer.updateGraph(i3, this.graphData);
                }
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                ImageRecognizer imageRecognizer = this;
                synchronized (imageRecognizer) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i3;
            }
            ++i3;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print(" \u62bd\u51fa\u30b5\u30f3\u30d7\u30eb\u306b\u3088\u308b\u5b66\u7fd2\u52b9\u679c\u306e\u691c\u8a3c ----------------------------");
        this.trialFlag = true;
        int j = 0;
        while (j < 10) {
            DJ._print("\u62bd\u51fa\u30b5\u30f3\u30d7\u30eb:" + j);
            int trialIndex = (Integer)trialIndexList.get(j);
            int correctDigit = targetText[0][trialIndex];
            DJ.print("\u6b63\u89e3\u6587\u5b57:correctDigit=", correctDigit);
            this.inData = inputImageStd[trialIndex];
            System.arraycopy(this.inData, 0, mid0X, 0, this.inNodeNum);
            this.middleLayer0.forward();
            this.middleLayer1.forward();
            this.outputLayer.forward();
            DJ.print("\u8a66\u884c\u51fa\u529b:outLayer.y=", DJ.reshape(outY, 10, 1));
            ++j;
        }
        this.trialFlag = false;
        DJ._print("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        int k = 0;
        while (k < this.graphData.length) {
            DJ.print("  " + this.dataName[k] + "=" + this.graphData[k]);
            ++k;
        }
        DJ._print_("\u30fb\u8a66\u884c\u56de\u6570=", this.trialCount);
        DJ.print_(", \u6b63\u7b54\u56de\u6570=", this.correctCount);
        DJ.print("\u30fb\u6700\u7d42\u6b63\u7b54\u6bd4\u7387=", String.valueOf(this.correctRatio) + "[%]");
        DJ.print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }
}

