/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;
import view.SomViewer;
import view.SomViewerLauncher;

public class SomPlayer
extends Task {
    int epoch = 1;
    int interval = 1;
    public double learningRate = 0.1;
    public double learningRadius = 10.0;
    public double lastRadius = 1.0;
    public String factorFileName = "FactorFile";
    public int numOfTrial = 0;
    public int dimOfCodeX = 20;
    public int dimOfCodeY = 20;
    public int uMapXSize = 400;
    public int uMapYSize = 400;
    public int numOfContour = 10;
    public int baseContour = 10;
    public double borderContour = 0.2;
    public int evaluationType = 0;
    public double quantumCoeff = 1.0;
    public double disorderCoef = 1.0;
    public int learningType;
    public long initialType;
    public int shuffleMethod;
    private String titleLine = "#SOM Data : ";
    private String trialTitleLine = "#SOM Trial Data : ";
    private String[] factorNames;
    private int dimOfFactor;
    private int numOfFactor;
    private double[][] factorVectors;
    private String[] factorLabels;
    private double[][] trialVectors;
    private String[] trialLabels;
    private int numOfCodeVector;
    private double[][] codeVectorArray;
    private int dimOfUX;
    private int dimOfUY;
    private double[][] uMatrix;
    private String[][] labelMap;
    private double quantumError;
    double[][] wN;
    double[][] wD;
    private Random randamGenerator;
    private SomViewerLauncher somViewerLauncher;
    private SomViewer somViewer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.somViewerLauncher = DJ.launchSomViewer(0, "SelfOrganizingMap");
        this.somPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void somPlayer() {
        DJ._print("SomPlayer.somPlayer() ==================");
        this.somViewer = this.somViewerLauncher.getSomViewer();
        if (this.somViewer == null) {
            DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " SomViewer is null.");
            return;
        }
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                SomPlayer somPlayer = this;
                synchronized (somPlayer) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print(" ***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print(" ##### Abort action requested #####");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print(" ############################################################");
        DJ.print(" ##");
        DJ.print(" ##      \u30fb\u5b66\u7fd2\u6e08\u307f\u306eSOM\u30b3\u30fc\u30c9\u3092\u8aad\u8fbc\u3080\u306b\u306f\u3001             ");
        DJ.print(" ##      \u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u300cRun/Pause\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001 ");
        DJ.print(" ##      \u8868\u793a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u30fb\u30c0\u30a4\u30a2\u30ed\u30b0\u3067                ");
        DJ.print(" ##      SOM\u30b3\u30fc\u30c9\u30fb\u30d5\u30a1\u30a4\u30eb(SomCode_xxxxx.dat)\u3092\u9078\u629e\u3057 ");
        DJ.print(" ##      \u300c\u958b\u304f\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002          ");
        DJ.print(" ##");
        DJ.print(" ############################################################");
        DJ._print(" ##### SOM\u30b3\u30fc\u30c9\u306e\u8aad\u307f\u8fbc\u307f #####");
        String somFileName = "SomCode";
        DJ.print(" SOM\u30b3\u30fc\u30c9\u30fb\u30d5\u30a1\u30a4\u30eb\u540d\uff1a", somFileName);
        if (!this.loadSom(somFileName)) {
            DJ.print("***** ERROR ***** SomPlayer.somPlayer() Failed to load SOM Code file.");
            return;
        }
        this.dimOfUX = this.dimOfCodeX * 2;
        this.dimOfUY = this.dimOfCodeY * 2;
        this.uMatrix = new double[this.dimOfUX][this.dimOfUY];
        this.calculateUMatrix();
        this.somViewer.setComment(this.titleLine);
        this.somViewer.setProperty(this.numOfTrial, this.evaluationType, this.numOfContour, this.baseContour, this.borderContour, this.uMapXSize, this.uMapYSize);
        this.somViewer.setParameter(this.dimOfFactor, this.dimOfCodeX, this.dimOfCodeY, this.factorNames, this.numOfFactor, this.factorVectors, this.factorLabels);
        this.somViewer.setMap(this.codeVectorArray, this.uMatrix, this.labelMap);
        int iCount = this.epoch * this.numOfFactor;
        this.somViewer.updateMap(iCount);
        this.somViewer.setVisible(true);
        DJ._print(" ############################################################");
        DJ.print(" ##");
        DJ.print(" ##      \u30fb\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u3092\u8aad\u8fbc\u3080\u306b\u306f\u3001             ");
        DJ.print(" ##      \u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u300cRun/Pause\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3001 ");
        DJ.print(" ##      \u8868\u793a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u30fb\u30c0\u30a4\u30a2\u30ed\u30b0\u3067                ");
        DJ.print(" ##      \u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u30fb\u30d5\u30a1\u30a4\u30eb(Factor_xxxx.csv)\u3092\u9078\u629e\u3057\u3001");
        DJ.print(" ##      \u300c\u958b\u304f\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002          ");
        DJ.print(" ##");
        DJ.print(" ############################################################");
        this.pauseFlag = true;
        SomPlayer somPlayer = this;
        synchronized (somPlayer) {
            try {
                if (this.pauseFlag) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
            }
        }
        DJ._print(" ##### \u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u306e\u8aad\u307f\u8fbc\u307f #####");
        String trialFileName = "Factor";
        DJ.print(" \u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u30fb\u30d5\u30a1\u30a4\u30eb\u540d\uff1a", trialFileName);
        if (!this.loadTrialFactor(trialFileName)) {
            DJ.print("***** ERROR ***** SomPlayer.somPlayer() Failed to load Trial Factor Vector file.");
            return;
        }
        this.appendLabelMap();
        this.somViewer.updateMap(iCount);
        this.somViewer.setVisible(true);
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }

    double[] getRandomShuffledCode(double[] min, double[] max) {
        double[] aCodeVector = new double[this.dimOfFactor];
        int i = 0;
        while (i < this.dimOfFactor) {
            aCodeVector[i] = (max[i] - min[i]) * this.randamGenerator.nextDouble() + min[i];
            ++i;
        }
        return aCodeVector;
    }

    private boolean loadTrialFactor(String fileName) {
        ArrayList<String> stringList = LogEditor.loadText(fileName);
        if (stringList == null) {
            DJ.print("***** ERROR ***** SomPlayer.loadTrialFactor() Failed to load Trial Factor-Vector file.");
            return false;
        }
        int numOfLines = stringList.size();
        if (numOfLines < 3) {
            DJ.print("***** ERROR ***** SomPlayer.loadTrialFactor() Num of lines in Factor-Vector file less than 3.");
            return false;
        }
        DJ.print(" \uff08\uff11\uff09String comment:\u8a66\u884c\u7528\u56e0\u5b50\u30c7\u30fc\u30bf\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u30bf\u30a4\u30c8\u30eb\u3068\u30b3\u30e1\u30f3\u30c8");
        this.trialTitleLine = stringList.get(0);
        DJ.print("Title and comment of Trial Factor Files : ", this.trialTitleLine);
        DJ.print(" \uff08\uff12\uff09String[] factorName:\u56e0\u5b50\u540d\u914d\u5217");
        String dataNameLine = stringList.get(1);
        StringTokenizer dataNameToken = new StringTokenizer(dataNameLine, ",");
        ArrayList<String> factorNameList = new ArrayList<String>();
        while (dataNameToken.hasMoreTokens()) {
            factorNameList.add(dataNameToken.nextToken());
        }
        DJ.printList("Name of Factors : ", factorNameList);
        if (factorNameList.size() != this.dimOfFactor) {
            DJ.print("***** ERROR ***** SomPlayer.loadTrialFactor() Dimension of factorNameList != dimOfFactor.");
            return false;
        }
        DJ.print(" \uff08\uff13\uff09double[][] trialVectors:\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217");
        DJ.print(" \uff08\uff14\uff09String[] trialLabels:\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u30fb\u30e9\u30d9\u30eb\u914d\u5217");
        this.numOfTrial = numOfLines - 2;
        if (this.numOfTrial < 1) {
            DJ.print("***** ERROR ***** SomPlayer.loadTrialFactor() Number of Trial Facter Vector is less than 1.");
            return false;
        }
        this.trialVectors = new double[this.numOfTrial][this.dimOfFactor];
        this.trialLabels = new String[this.numOfTrial];
        int rowNum = numOfLines - 2;
        int j = 0;
        while (j < rowNum) {
            String label;
            String dataLine = stringList.get(j + 2);
            StringTokenizer dataToken = new StringTokenizer(dataLine, ",");
            int i = 0;
            while (i < this.dimOfFactor) {
                double value;
                this.trialVectors[j][i] = dataToken.hasMoreTokens() ? (value = Double.parseDouble(dataToken.nextToken().trim())) : 0.0;
                ++i;
            }
            this.trialLabels[j] = dataToken.hasMoreTokens() ? (label = dataToken.nextToken()) : "";
            ++j;
        }
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u6570\uff1anumOfTrial=", this.numOfTrial);
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217\uff1atrialVectors", this.trialVectors);
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u306e\u30e9\u30d9\u30eb\uff1atrialLabels=", DJ.stringArrayToString(this.trialLabels));
        return true;
    }

    private boolean loadSom(String fileName) {
        int i;
        ArrayList<String> stringList = LogEditor.loadText(fileName);
        if (stringList == null) {
            DJ.print("***** ERROR ***** SomPlayer.loadSom() Failed to load SOM Code file.");
            return false;
        }
        int id = 0;
        DJ.print(" \uff08\uff11\uff09String titleLine:\u30bf\u30a4\u30c8\u30eb,\u56e0\u5b50\u7a2e\u5225,\u56e0\u5b50\u6570,\u56e0\u5b50\u30d9\u30af\u30bf\u6570");
        this.titleLine = stringList.get(id);
        DJ.print("Title of SOM Files", this.titleLine);
        DJ.print(" \uff08\uff12\uff09Property // \u30d7\u30ed\u30d1\u30c6\u30a3");
        stringList.get(++id);
        String tag = stringList.get(++id);
        this.numOfTrial = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.numOfTrial);
        tag = stringList.get(++id);
        this.evaluationType = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.evaluationType);
        tag = stringList.get(++id);
        this.numOfContour = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.numOfContour);
        tag = stringList.get(++id);
        this.baseContour = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.baseContour);
        tag = stringList.get(++id);
        this.borderContour = Double.valueOf(stringList.get(++id));
        DJ.print(tag, this.borderContour);
        tag = stringList.get(++id);
        this.uMapXSize = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.uMapXSize);
        tag = stringList.get(++id);
        this.uMapYSize = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.uMapYSize);
        DJ.print(" \uff08\uff13\uff09String[] factorName; // \u56e0\u5b50\u540d");
        stringList.get(++id);
        tag = stringList.get(++id);
        this.dimOfFactor = Integer.valueOf(stringList.get(++id));
        DJ.print(tag, this.dimOfFactor);
        DJ.print(" \uff08\uff14\uff09String[] factorNames;");
        stringList.get(++id);
        tag = stringList.get(++id);
        String favtorNameLine = stringList.get(++id);
        StringTokenizer factorNameToken = new StringTokenizer(favtorNameLine, ",");
        ArrayList<String> factorNameList = new ArrayList<String>();
        while (factorNameToken.hasMoreTokens()) {
            factorNameList.add(factorNameToken.nextToken());
        }
        this.dimOfFactor = factorNameList.size();
        if (this.dimOfFactor < 1) {
            DJ.print("***** ERROR ***** SomPlayer.loadSom() Dimension of factorNameList < 1.");
        }
        this.factorNames = new String[this.dimOfFactor];
        int i2 = 0;
        while (i2 < this.dimOfFactor) {
            this.factorNames[i2] = (String)factorNameList.get(i2);
            ++i2;
        }
        DJ.print(tag, DJ.stringArrayToString(this.factorNames));
        DJ.print(" \uff08\uff15\uff09double[][] factorVectors; // \u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217[\u500b\u6570][\u6b21\u5143]");
        tag = stringList.get(++id);
        this.numOfFactor = Integer.valueOf(stringList.get(++id));
        this.factorVectors = new double[this.numOfFactor][this.dimOfFactor];
        int j = 0;
        while (j < this.numOfFactor) {
            String factorLine = stringList.get(++id);
            StringTokenizer factorToken = new StringTokenizer(factorLine, ",");
            int i3 = 0;
            while (i3 < this.dimOfFactor) {
                if (factorToken.hasMoreTokens()) {
                    this.factorVectors[j][i3] = Double.parseDouble(factorToken.nextToken().trim());
                }
                ++i3;
            }
            ++j;
        }
        DJ.print(tag.replace("=", ""), this.factorVectors);
        DJ.print(" \uff08\uff16\uff09String[] factorLabels; // \u56e0\u5b50\u30e9\u30d9\u30eb\u914d\u5217[\u500b\u6570]");
        stringList.get(++id);
        tag = stringList.get(++id);
        int numOfFactorLabels = Integer.valueOf(stringList.get(++id));
        DJ.print(String.valueOf(tag) + " ", numOfFactorLabels);
        String factorLabelLine = stringList.get(++id);
        StringTokenizer factorLabelToken = new StringTokenizer(factorLabelLine, ",");
        ArrayList<String> factorLabelList = new ArrayList<String>();
        while (factorLabelToken.hasMoreTokens()) {
            factorLabelList.add(factorLabelToken.nextToken());
        }
        if (factorLabelList.size() != numOfFactorLabels) {
            DJ.print("***** ERROR ***** SomPlayer.loadSom() Size of factorLabelList != numOfFactorLabels.");
            return false;
        }
        if (factorLabelList.size() != this.numOfFactor) {
            DJ.print("***** ERROR ***** SomPlayer.loadSom() Size of factorLabelList != numOfFactor.");
            return false;
        }
        this.factorLabels = new String[this.numOfFactor];
        int i4 = 0;
        while (i4 < this.numOfFactor) {
            this.factorLabels[i4] = (String)factorLabelList.get(i4);
            ++i4;
        }
        DJ.print(tag, DJ.stringArrayToString(this.factorLabels));
        DJ.print(" \uff08\uff17\uff09\u3001\uff08\uff18\uff09int numOfCodeVectore; // \u53c2\u7167\u30d9\u30af\u30bf\u306e\u500b\u6570");
        stringList.get(++id);
        tag = stringList.get(++id);
        this.numOfCodeVector = Integer.valueOf(stringList.get(++id));
        DJ.print(String.valueOf(tag) + " ", this.numOfCodeVector);
        DJ.print(" \uff08\uff19\uff09double[][] codeVectorArray; // \u53c2\u7167\u30d9\u30af\u30bf\u914d\u5217[\u500b\u6570][\u6b21\u5143]");
        tag = stringList.get(++id);
        this.codeVectorArray = new double[this.numOfCodeVector][this.dimOfFactor];
        int j2 = 0;
        while (j2 < this.numOfCodeVector) {
            String codeLine = stringList.get(++id);
            StringTokenizer codeToken = new StringTokenizer(codeLine, ",");
            i = 0;
            while (i < this.dimOfFactor) {
                if (codeToken.hasMoreTokens()) {
                    this.codeVectorArray[j2][i] = Double.parseDouble(codeToken.nextToken().trim());
                }
                ++i;
            }
            ++j2;
        }
        DJ.print(tag.replace("=", ""), this.codeVectorArray);
        DJ.print(" \uff0810\uff09\u3001\uff0811\uff09int labelMap.length; // \u30e9\u30d9\u30eb\u30fb\u30de\u30c3\u30d7\u306e\u884c\u6570");
        stringList.get(++id);
        tag = stringList.get(++id);
        this.dimOfCodeX = Integer.valueOf(stringList.get(++id));
        DJ.print(String.valueOf(tag) + " : ", this.dimOfCodeX);
        DJ.print(" \uff0812\uff09\u3001\uff0813\uff09int labelMap[0].length; // \u30e9\u30d9\u30eb\u30fb\u30de\u30c3\u30d7\u306e\u5217\u6570");
        tag = stringList.get(++id);
        this.dimOfCodeY = Integer.valueOf(stringList.get(++id));
        DJ.print(String.valueOf(tag) + " : ", this.dimOfCodeY);
        DJ.print(" labelMap[" + this.dimOfCodeX + "][" + this.dimOfCodeY + "] = ");
        DJ.print(" \uff0814\uff09\u3001\uff0815\uff09String[][] labelMap; // \u30e9\u30d9\u30eb\u30fb\u30de\u30c3\u30d7\uff08\u30e9\u30d9\u30eb\u884c\u5217\uff09");
        tag = stringList.get(++id);
        if (this.numOfCodeVector != this.dimOfCodeX * this.dimOfCodeY) {
            DJ._print("***** WARNING ***** SomPlayer.loadSom() Number of labels is diferent from number of CodeVectors.");
            DJ.print_(" Number of labels", this.numOfCodeVector);
            DJ.print(" Number of CodeVectors", this.dimOfCodeX * this.dimOfCodeY);
        }
        this.labelMap = new String[this.dimOfCodeX][this.dimOfCodeY];
        j2 = 0;
        while (j2 < this.dimOfCodeX) {
            String labelLine = stringList.get(++id);
            StringTokenizer labelToken = new StringTokenizer(labelLine, ",");
            i = 0;
            while (i < this.dimOfCodeY) {
                if (labelToken.hasMoreTokens()) {
                    this.labelMap[j2][i] = labelToken.nextToken().trim();
                }
                ++i;
            }
            ++j2;
        }
        DJ.print(tag);
        j2 = 0;
        while (j2 < this.dimOfCodeX) {
            DJ.print(" " + j2 + " ", DJ.stringArrayToString(this.labelMap[j2]));
            ++j2;
        }
        return true;
    }

    public int findWinner(double[] factorVector) {
        double leastNorm = Double.MAX_VALUE;
        int bestMatchIndex = -1;
        int i = 0;
        while (i < this.numOfCodeVector) {
            double aNorm = 0.0;
            int j = 0;
            while (j < this.dimOfFactor) {
                double delta = this.codeVectorArray[i][j] - factorVector[j];
                if ((aNorm += delta * delta) > leastNorm) break;
                ++j;
            }
            if (aNorm < leastNorm) {
                leastNorm = aNorm;
                bestMatchIndex = i;
            }
            ++i;
        }
        this.quantumError += Math.sqrt(leastNorm);
        return bestMatchIndex;
    }

    private void calculateUMatrix() {
        int i;
        int j = 0;
        while (j < this.dimOfCodeY) {
            i = 0;
            while (i < this.dimOfCodeX) {
                double delta;
                int k;
                int id = this.dimOfCodeX * j + i;
                if (i < this.dimOfCodeX - 1) {
                    double dx = 0.0;
                    k = 0;
                    while (k < this.dimOfFactor) {
                        delta = this.codeVectorArray[id][k] - this.codeVectorArray[id + 1][k];
                        dx += delta * delta;
                        ++k;
                    }
                    this.uMatrix[2 * i + 1][2 * j] = Math.sqrt(dx);
                }
                if (j < this.dimOfCodeY - 1) {
                    double dy = 0.0;
                    k = 0;
                    while (k < this.dimOfFactor) {
                        delta = this.codeVectorArray[id][k] - this.codeVectorArray[id + this.dimOfCodeX][k];
                        dy += delta * delta;
                        ++k;
                    }
                    this.uMatrix[2 * i][2 * j + 1] = Math.sqrt(dy);
                }
                if (j < this.dimOfCodeY - 1 && i < this.dimOfCodeX - 1) {
                    double dz;
                    double dz1 = 0.0;
                    double dz2 = 0.0;
                    int k2 = 0;
                    while (k2 < this.dimOfFactor) {
                        double delta2 = this.codeVectorArray[id][k2] - this.codeVectorArray[id + this.dimOfCodeX + 1][k2];
                        dz1 += delta2 * delta2;
                        delta2 = this.codeVectorArray[id + this.dimOfCodeX][k2] - this.codeVectorArray[id + 1][k2];
                        dz2 += delta2 * delta2;
                        ++k2;
                    }
                    this.uMatrix[2 * i + 1][2 * j + 1] = dz = (Math.sqrt(dz1 / 2.0) + Math.sqrt(dz2 / 2.0)) / 2.0;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < this.dimOfUY) {
            i = 0;
            while (i < this.dimOfUX) {
                if (i > 0 && j > 0) {
                    medtable = new double[]{this.uMatrix[i - 1][j], this.uMatrix[i + 1][j], this.uMatrix[i][j - 1], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = (medtable[1] + medtable[2]) / 2.0;
                } else if (j == 0 && i > 0) {
                    medtable = new double[]{this.uMatrix[i - 1][j], this.uMatrix[i + 1][j], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = medtable[1];
                } else if (i == 0 && j > 0) {
                    medtable = new double[]{this.uMatrix[i + 1][j], this.uMatrix[i][j - 1], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = medtable[1];
                } else if (i == 0 && j == 0) {
                    this.uMatrix[i][j] = (this.uMatrix[i + 1][j] + this.uMatrix[i][j + 1]) / 2.0;
                }
                i += 2;
            }
            j += 2;
        }
    }

    public void makeLabelMap() {
        int i = 0;
        while (i < this.dimOfCodeX) {
            int j = 0;
            while (j < this.dimOfCodeY) {
                this.labelMap[i][j] = "";
                ++j;
            }
            ++i;
        }
        int id = 0;
        while (id < this.numOfFactor) {
            int j;
            int bestMatchIndex = this.findWinner(this.factorVectors[id]);
            int i2 = bestMatchIndex % this.dimOfCodeX;
            this.labelMap[i2][j] = this.labelMap[i2][j = bestMatchIndex / this.dimOfCodeY].equals("") ? this.factorLabels[id] : String.valueOf(this.labelMap[i2][j]) + this.factorLabels[id];
            ++id;
        }
    }

    public void appendLabelMap() {
        if (this.numOfTrial < 1) {
            DJ._print("***** WARNING ***** SomPlayer.appendLabelMap() Number of labels is less than 1.");
            return;
        }
        int id = 0;
        while (id < this.numOfTrial) {
            int j;
            int bestMatchIndex = this.findWinner(this.trialVectors[id]);
            int i = bestMatchIndex % this.dimOfCodeX;
            this.labelMap[i][j] = this.labelMap[i][j = bestMatchIndex / this.dimOfCodeY].equals("") ? "\u25ce" + this.trialLabels[id] : String.valueOf(this.labelMap[i][j]) + ":" + "\u25ce" + this.trialLabels[id];
            ++id;
        }
    }
}

