/*
 * Decompiled with CFR 0.152.
 */
package task;

import util.DJ;
import util.LogEditor;
import view.GraphViewer;
import view.GraphViewerLauncher;
import view.PatternViewer;
import view.PatternViewerLauncher;

public abstract class Task
implements Runnable {
    protected static final int SLEEP_TIME = 1;
    protected boolean pauseFlag = false;
    protected boolean abortFlag = false;
    public boolean stepMode = false;
    protected boolean patternViewerFlag;
    protected PatternViewerLauncher patternViewerLauncher;
    protected PatternViewer patternViewer;
    protected double[][] patternData0;
    protected double[][] patternData1;
    protected int graphShift = 0;
    protected GraphViewerLauncher graphViewerLauncher;
    protected GraphViewer graphViewer;
    protected double[] graphData;
    protected String[] dataName;
    protected boolean intervalFlag = false;
    protected long beginTime = 0L;
    protected long finishTime = 0L;
    protected long startTime = 0L;
    protected long endTime = 0L;
    protected double lapTime = 0.0;
    protected double totalTime = 0.0;

    public void startTask() {
        Thread taskThread = this.createThread(this);
        this.startThread(taskThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTask() {
        if (this.pauseFlag) {
            this.pauseFlag = false;
            Task task = this;
            synchronized (task) {
                this.notify();
            }
        } else {
            this.pauseFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTask() {
        if (this.pauseFlag) {
            this.pauseFlag = false;
            Task task = this;
            synchronized (task) {
                this.notify();
            }
        }
        this.abortFlag = true;
    }

    public Thread createThread(Task task) {
        Thread taskThread = new Thread(task);
        taskThread.setPriority(5);
        return taskThread;
    }

    public boolean startThread(Thread thread) {
        if (thread == null) {
            LogEditor.print("LogFrame.startThread():There are no taskThread.");
            LogEditor.print("***** ERROR ***** 'taskThread' is not started.");
            return false;
        }
        thread.start();
        return true;
    }

    @Override
    public void run() {
        DJ._print("Task is started!");
        DJ.print("===============================================================");
        this.runTask();
    }

    public void runTask() {
        DJ._print("Task is started!");
        DJ.print("===============================================================");
        DJ._print("Task is running.");
        DJ._print("End of Task.");
        DJ.print("===============================================================");
    }

    public void stepTask() {
        if (this.stepMode) {
            this.stepMode = false;
            DJ._print("### Task step mode OFF. ###");
        } else {
            this.stepMode = true;
            DJ._print("### Task step mode ON. ###");
        }
    }

    protected void updateViewer(int i) {
        this.updatePattern();
        this.updateGraph(i);
    }

    protected void updateGraph(int i) {
        if (this.graphViewerLauncher == null) {
            DJ._print("GraphViewerLauncher is null.");
        } else {
            if (this.graphViewer == null) {
                this.graphViewer = this.graphViewerLauncher.getGraphViewer();
                if (this.graphViewer != null) {
                    this.graphViewer.shiftGraphAxis(this.graphShift);
                }
            }
            if (this.graphViewer != null) {
                this.graphViewer.updateGraph(i, this.graphData);
            }
        }
    }

    protected void updatePattern() {
        if (this.patternViewer == null) {
            this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        }
        if (this.patternViewer != null) {
            this.patternViewer.setVisible(this.patternViewerFlag);
            if (this.patternData1 == null) {
                this.patternViewer.updatePattern(this.patternData0);
            } else {
                this.patternViewer.updatePattern(this.patternData0, this.patternData1);
            }
        }
    }

    public void showGraph() {
        if (this.graphViewer == null) {
            this.updateGraph(0);
        }
        if (this.graphViewer != null) {
            if (this.graphViewer.isShowing()) {
                this.graphViewer.setVisible(false);
            } else {
                this.graphViewer.setVisible(true);
            }
        } else {
            DJ._print("GraphViewer is null.");
        }
    }

    public void showPattern() {
        if (this.patternViewer != null) {
            if (this.patternViewer.isShowing()) {
                this.patternViewer.setVisible(false);
            } else {
                this.patternViewer.setVisible(true);
            }
        } else {
            DJ._print("PatternViewer is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepMode() {
        this.pauseFlag = true;
        Task task = this;
        synchronized (task) {
            try {
                if (this.pauseFlag) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
            }
        }
    }
}

