/*
 * Decompiled with CFR 0.152.
 */
package task.control;

import data.Control;
import java.util.ArrayList;
import java.util.Collections;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class ReverseTuner
extends Task {
    static final int TWO_LAYER = 2;
    static final int THREE_LAYER = 3;
    int layerNum = 3;
    int epoch = 1000;
    int batchNum = 20;
    int interval = 20;
    double initialCoef = 0.8;
    double eta = 0.3;
    int dataNum = 1000;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 32;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer middleLayer1;
    private ControlLayer outputLayer;
    double squareError;
    double meanError;
    double aveError;
    static final int ST0 = 0;
    static final int ST1 = 1;
    static final int ST2 = 2;
    static final int ST3 = 3;
    static final int ST4 = 4;
    static final int ST5 = 5;
    static final int STE = 10;
    int state = 0;
    int routeNum = 42;
    int sampleNum = this.dataNum * this.routeNum;
    double accLmt = 0.005;
    double spdLmt = 0.01;
    double dfCef = 1.25E-4;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[10][this.sampleNum];
        this.patternData1 = new double[10][this.sampleNum];
        int patternNum = 1;
        while (patternNum < 10) {
            int k = 0;
            while (k < this.sampleNum) {
                this.patternData0[patternNum][k] = 10.0;
                this.patternData1[patternNum][k] = 10.0;
                ++k;
            }
            ++patternNum;
        }
        this.patternViewerLauncher = DJ.pattern(2, this.patternData0, "ReverseTuner:a-v", 2, this.patternData1, "ReverseTuner:v-p");
        this.graphShift = 2;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.reverseTuner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseTuner() {
        int latency;
        double clock;
        DJ._print("DaiJa_V5, reverseTuner() ==========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \uff11\u79d2\u9593\u306e\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u30c7\u30fc\u30bf\u53ce\u96c6\u7528\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u30c7\u30fc\u30bf\u53ce\u96c6\u7d4c\u8def\u6570:routeNum=", this.routeNum);
        DJ.print(" \u53ce\u96c6\u30c7\u30fc\u30bf\u6570:sampleNum=", this.sampleNum);
        DJ.print_(" \u52a0\u901f\u5ea6\u5236\u9650\u5024:accLmt=", this.accLmt);
        DJ.print_(", \u901f\u5ea6\u5236\u9650\u5024:spdLmt=", this.spdLmt);
        DJ.print(", \u529b\u64cd\u4f5c\u91cf\u5897\u6e1b\u5b9a\u6570:dfCef=", this.dfCef);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff08\u8ca0\u8377\uff09\u3092\u8a2d\u5b9a");
        Control control = new Control();
        control.setParameter(0, 0, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        DJ._print("\u3000\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6b63\u89e3\u30c7\u30fc\u30bf\u3092\u5b9a\u7fa9\u3059\u308b");
        double[][] inputData = new double[this.inNodeNum][this.sampleNum];
        double[] correctData = new double[this.sampleNum];
        DJ._print("\u3000\u5b66\u7fd2\u7528\u30c7\u30fc\u30bf\u3092\u5b9a\u7fa9\u3059\u308b");
        double[] forceData = new double[this.sampleNum];
        double[] accelData = new double[this.sampleNum];
        double[] speedData = new double[this.sampleNum];
        double[] positionData = new double[this.sampleNum];
        double inc = 1.0 / (double)this.dataNum;
        double force = 0.0;
        double oldAccel = 0.0;
        double oldSpeed = 0.0;
        double oldPosition = 0.0;
        double df = this.dfCef;
        double f = this.dfCef;
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\u3092\u99c6\u52d5\u3057\u3001\u5b66\u7fd2\u7528\u306e\u30c7\u30fc\u30bf\u3092\u53ce\u96c6\u3059\u308b");
        DJ.print_("\u72b6\u614b\u9077\u79fb\uff1astatus=", this.state);
        int j22 = 0;
        while (j22 < this.routeNum) {
            clock = 0.0;
            int k = 0;
            while (k < this.dataNum) {
                int id = j22 * this.dataNum + k;
                switch (this.state) {
                    case 0: {
                        if (oldSpeed > this.spdLmt) {
                            f = -df;
                            df *= 1.2;
                            this.accLmt *= 1.2;
                            this.spdLmt *= 1.6;
                            this.state = 1;
                            DJ.print_(" ,", this.state);
                        }
                        if (j22 <= 5) break;
                        this.state = 2;
                        break;
                    }
                    case 1: {
                        if (oldSpeed < -this.spdLmt) {
                            f = df;
                            df *= 1.2;
                            this.accLmt *= 1.2;
                            this.spdLmt *= 1.6;
                            this.state = 0;
                            DJ.print_(" ,", this.state);
                        }
                        if (j22 <= 5) break;
                        this.state = 3;
                        break;
                    }
                    case 2: {
                        if (!(oldSpeed > this.spdLmt)) break;
                        f = -df;
                        df *= 1.12;
                        this.spdLmt += 0.03;
                        this.state = 3;
                        DJ.print_(" ,", this.state);
                        break;
                    }
                    case 3: {
                        if (!(oldSpeed < -this.spdLmt)) break;
                        f = df;
                        df *= 1.12;
                        this.spdLmt += 0.03;
                        this.state = 2;
                        DJ.print_(" ,", this.state);
                        break;
                    }
                    default: {
                        DJ.print_(" ,", this.state);
                        return;
                    }
                }
                forceData[id] = (force += f) / 0.0048828125;
                control.setForce(forceData[id]);
                control.execute();
                accelData[id] = control.getAcceleration() * 1000.0;
                oldAccel = accelData[id];
                speedData[id] = control.getSpeed();
                oldSpeed = speedData[id];
                positionData[id] = control.getPosition();
                oldPosition = positionData[id];
                inputData[0][id] = accelData[id];
                inputData[1][id] = speedData[id];
                correctData[id] = forceData[id];
                this.patternData0[0][id] = accelData[id];
                this.patternData0[5][id] = speedData[id];
                this.patternData1[0][id] = speedData[id];
                this.patternData1[6][id] = j22 < this.routeNum / 2 ? positionData[id] : 10.0;
                this.patternData1[9][id] = j22 < this.routeNum / 2 ? 10.0 : positionData[id];
                clock += inc;
                ++k;
            }
            ++j22;
        }
        DJ._print("\u6700\u7d42\u72b6\u614b:Last status=", this.state);
        this.updatePattern();
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf");
        DJ._print(" ############################################################");
        DJ.print(" ##");
        DJ.print(" ##      \u30fb\u5236\u5fa1\u5bfe\u8c61\u306e\u9006\u95a2\u6570\u306e\u5b66\u7fd2\u3092\u958b\u59cb\u3059\u308b\u306b\u306f\u3001             ");
        DJ.print(" ##      \u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u300cRun/Pause\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        DJ.print(" ##");
        DJ.print(" ############################################################");
        this.pauseFlag = true;
        ReverseTuner j22 = this;
        synchronized (j22) {
            try {
                if (this.pauseFlag) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
            }
        }
        DJ._print(" ##### \u5236\u5fa1\u5bfe\u8c61\u306e\u9006\u95a2\u6570\u306e\u5b66\u7fd2\u3092\u958b\u59cb #####");
        DJ.print(" \u9806\u5e8f\u3092\u30e9\u30f3\u30c0\u30e0\u306b\u30b7\u30e3\u30c3\u30d5\u30eb\u3057\u305f\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u30ea\u30b9\u30c8");
        ArrayList<Integer> indexList = DJ.permutationRandom(this.sampleNum);
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        if (this.layerNum == 3) {
            this.middleLayer0.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        } else {
            this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        }
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.middleLayer1 = new ControlLayer(this.midNodeNum, this.midNodeNum);
        if (this.layerNum == 3) {
            this.middleLayer1.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        } else {
            this.middleLayer1.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        }
        double[] mid1Y = this.middleLayer1.getY();
        double[] mid1dEdX = this.middleLayer1.getdEdX();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 1);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        double[] outS = new double[outC.length];
        if (this.layerNum == 3) {
            this.middleLayer0.setdEdY(mid1dEdX);
            this.middleLayer1.setdEdY(outdEdX);
            this.middleLayer1.setX(mid0Y);
            this.outputLayer.setX(mid1Y);
        } else {
            this.middleLayer0.setdEdY(outdEdX);
            this.outputLayer.setX(mid0Y);
        }
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            Collections.shuffle(indexList);
            this.squareError = 0.0;
            this.meanError = 0.0;
            clock = 0.0;
            int j = 0;
            while (j < this.sampleNum) {
                int index = indexList.get(j);
                mid0X[0] = inputData[0][index];
                mid0X[1] = inputData[1][index];
                this.middleLayer0.forward();
                if (this.layerNum == 3) {
                    this.middleLayer1.forward();
                }
                this.outputLayer.forward();
                outS[0] = outY[0];
                outC[0] = correctData[index];
                this.outputLayer.backward(outC, outS);
                if (this.layerNum == 3) {
                    this.middleLayer1.backward();
                }
                this.middleLayer0.backward();
                if (j % this.batchNum == 0) {
                    this.middleLayer0.update();
                    if (this.layerNum == 3) {
                        this.middleLayer1.update();
                    }
                    this.outputLayer.update();
                }
                if (this.intervalFlag) {
                    this.squareError = outE[0] * outE[0] / 2.0;
                    this.meanError += this.squareError;
                    this.patternData0[0][j] = clock;
                    this.patternData0[1][j] = outC[0] * 0.002;
                    this.patternData0[2][j] = outS[0] * 0.002;
                    this.patternData0[3][j] = 10.0;
                    this.patternData0[4][j] = 10.0;
                    this.patternData0[5][j] = 10.0;
                    this.patternData0[6][j] = 10.0;
                    this.patternData0[7][j] = 10.0;
                    this.patternData0[8][j] = 10.0;
                    this.patternData0[9][j] = 10.0;
                    this.patternData1[0][j] = clock;
                    this.patternData1[1][j] = 10.0;
                    this.patternData1[2][j] = 10.0;
                    this.patternData1[3][j] = 10.0;
                    this.patternData1[4][j] = accelData[j];
                    this.patternData1[5][j] = 10.0;
                    this.patternData1[6][j] = 10.0;
                    this.patternData1[7][j] = 10.0;
                    this.patternData1[8][j] = speedData[j];
                    this.patternData1[9][j] = 10.0;
                    if ((clock += inc) > 1.0) {
                        clock = 0.0;
                    }
                }
                ++j;
            }
            this.aveError = this.meanError / (double)this.sampleNum;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i);
                DJ.print_(", squareError = ", this.squareError);
                DJ.print(", aveError = ", this.aveError);
                this.graphData[0] = this.squareError;
                this.graphData[1] = this.aveError;
                this.updateViewer(i);
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                ReverseTuner reverseTuner = this;
                synchronized (reverseTuner) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print("\u30fb\u30a8\u30dd\u30c3\u30af\u5b9f\u884c\u56de\u6570");
        DJ.print(" Last epoch = ", this.epoch);
        DJ.print_("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        int k22 = 0;
        while (k22 < this.graphData.length) {
            DJ.print_("  " + this.dataName[k22] + "=" + this.graphData[k22]);
            ++k22;
        }
        DJ.print("");
        DJ._print(" ############################################################");
        DJ.print(" ##");
        DJ.print(" ##      \u30fb\u5b66\u7fd2\u7d50\u679c\u3092\u691c\u8a3c\u3059\u308b\u306b\u306f\u3001             ");
        DJ.print(" ##      \u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u300cRun/Pause\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        DJ.print(" ##");
        DJ.print(" ############################################################");
        this.pauseFlag = true;
        ReverseTuner k22 = this;
        synchronized (k22) {
            try {
                if (this.pauseFlag) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
            }
        }
        DJ._print("\u30fb\u691c\u8a3c\uff1a\u5b66\u7fd2\u3057\u305f\u9006\u95a2\u6570\u3067\u5236\u5fa1\u5bfe\u8c61\u3092\u99c6\u52d5\u3057\u3001\u5fdc\u7b54\u901f\u5ea6\u3092\u6bd4\u8f03\u3059\u308b");
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u691c\u8a3c\uff1a\u5b66\u7fd2\u3057\u305f\u9006\u95a2\u6570\u3067\u5236\u5fa1\u5bfe\u8c61\u3092\u99c6\u52d5\u3057\u3001\u5fdc\u7b54\u901f\u5ea6\u3092\u6bd4\u8f03\u3059\u308b");
        control.setParameter(0, 0, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        int k = 0;
        while (k < 10) {
            int j = 0;
            while (j < this.sampleNum) {
                this.patternData0[k][j] = 10.0;
                this.patternData1[k][j] = 10.0;
                ++j;
            }
            ++k;
        }
        int extra = 500;
        double[] accelCmd = new double[this.dataNum + extra];
        double[] speedCmd = new double[this.dataNum + extra];
        double[] positionCmd = new double[this.dataNum + extra];
        accelCmd[0] = 0.0;
        speedCmd[0] = 0.0;
        positionCmd[0] = 0.0;
        this.patternData0[0][0] = clock = 0.0;
        this.patternData1[0][0] = clock;
        double spd = 0.0;
        double psn = 0.0;
        int j = latency = 0;
        while (j < this.dataNum + extra) {
            accelCmd[j] = (clock += inc) < 0.5 ? (1.0 - Math.cos(Math.PI * 4 * clock)) * 0.1 : (-1.0 + Math.cos(Math.PI * 4 * clock)) * 0.1;
            speedCmd[j] = spd += accelCmd[j] / (double)this.dataNum;
            positionCmd[j] = psn += speedCmd[j] / (double)this.dataNum;
            ++j;
        }
        clock = 0.0;
        j = latency;
        while (j < this.dataNum + extra) {
            clock += inc;
            mid0X[0] = accelCmd[j - latency] * 0.1;
            mid0X[1] = speedCmd[j - latency] * 0.1;
            this.middleLayer0.forward();
            if (this.layerNum == 3) {
                this.middleLayer1.forward();
            }
            this.outputLayer.forward();
            force = outY[0] / 0.0048828125;
            control.setForce(force * 1.0);
            control.execute();
            this.patternData0[0][j] = clock;
            this.patternData0[1][j] = 10.0;
            this.patternData0[2][j] = outY[0] * 0.2;
            this.patternData0[3][j] = 10.0;
            this.patternData0[4][j] = control.getAcceleration() * 200.0;
            this.patternData0[5][j] = control.getSpeed() * 0.2;
            this.patternData0[6][j] = control.getPosition() * 0.8;
            this.patternData0[7][j] = accelCmd[j] * 4.0;
            this.patternData0[8][j] = speedCmd[j] * 4.0;
            this.patternData0[9][j] = positionCmd[j] * 16.0;
            this.patternData1[0][j] = clock;
            this.patternData1[1][j] = 10.0;
            this.patternData1[2][j] = outY[0] * 0.1;
            this.patternData1[3][j] = 10.0;
            this.patternData1[4][j] = control.getAcceleration() * 100.0;
            this.patternData1[5][j] = control.getSpeed() * 0.1;
            this.patternData1[6][j] = 10.0;
            this.patternData1[7][j] = accelCmd[j] * 2.0;
            this.patternData1[8][j] = speedCmd[j] * 2.0;
            this.patternData1[9][j] = 10.0;
            ++j;
        }
        this.updatePattern();
        DJ._print_("\u30fb\u691c\u8a3c\u7d50\u679c  ");
        DJ.print("\u53ce\u96c6\u30c7\u30fc\u30bf\u6570: sampleNum=", this.sampleNum);
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### ReverseTuner \u7d42\u4e86 #####");
    }
}

