/*
 * Decompiled with CFR 0.152.
 */
package task.control;

import data.Control;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class ServoControl
extends Task {
    int epoch = 1;
    int interval = 1;
    double initialCoef = 0.1;
    double eta = 0.1;
    int dataNum = 1000;
    int speedGain = 2048;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 8;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Open-loop Control", 6, this.patternData1, "Clos-loop Control");
        this.servoControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servoControl() {
        DJ._print("ServoControl.servoControl() ==========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u3092\u8a2d\u5b9a");
        Control control = new Control();
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                ServoControl servoControl = this;
                synchronized (servoControl) {
                    try {
                        this.wait(100L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u5b9f\u884c\u6e96\u5099");
        double[][] trialData = new double[4][this.dataNum];
        DJ._print("\uff08\uff11\uff09\u30aa\u30fc\u30d7\u30f3\u30eb\u30fc\u30d7\u5236\u5fa1\u306e\u5fdc\u7b54\u901f\u5ea6");
        int gain = this.speedGain / 10;
        control.setParameter(gain, 0, this.inertia, this.friction);
        control.stopFeedback();
        control.resetControl();
        int j = 0;
        while (j < this.dataNum) {
            double clock = 0.0 + 1.0 / (double)this.dataNum * (double)j;
            control.execute();
            trialData[0][j] = control.getForce();
            trialData[1][j] = control.getAcceleration();
            trialData[2][j] = control.getSpeed();
            trialData[3][j] = control.getPosition();
            this.patternData0[0][j] = clock;
            this.patternData0[1][j] = trialData[0][j];
            this.patternData0[2][j] = trialData[1][j] * 100.0;
            this.patternData0[3][j] = trialData[2][j] * 1.0;
            this.patternData0[4][j] = trialData[3][j] * 1.0;
            ++j;
        }
        DJ._print("\uff082\uff09\u30af\u30ed\u30fc\u30ba\u30eb\u30fc\u30d7\uff08PID\uff09\u5236\u5fa1\u306e\u5fdc\u7b54\u901f\u5ea6");
        control.startSpeedControl();
        control.startFeedback();
        control.setParameter(this.speedGain, this.integralGain, this.inertia, this.friction);
        control.resetControl();
        j = 0;
        while (j < this.dataNum) {
            double clock = 0.0 + 1.0 / (double)this.dataNum * (double)j;
            control.execute();
            trialData[0][j] = control.getForce();
            trialData[1][j] = control.getAcceleration();
            trialData[2][j] = control.getSpeed();
            trialData[3][j] = control.getPosition();
            this.patternData1[0][j] = clock;
            this.patternData1[1][j] = trialData[0][j];
            this.patternData1[2][j] = trialData[1][j] * 100.0;
            this.patternData1[3][j] = trialData[2][j] * 1.0;
            this.patternData1[4][j] = trialData[3][j] * 1.0;
            ++j;
        }
        this.updatePattern();
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
    }
}

