/*
 * Decompiled with CFR 0.152.
 */
package task.control;

import data.Control;
import layer.ControlLayer;
import task.Task;
import task.control.TargetEmulator;
import util.DJ;
import util.TimeStamp;

public class TargetController
extends Task {
    int epoch = 20000;
    int batchNum = 1;
    int interval = 200;
    double initialCoef = 0.8;
    double eta = 0.3;
    int dataNum = 1000;
    Control control;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 7;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;
    double squareError;
    double meanError;
    double aveError;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[10][this.dataNum];
        this.patternData1 = new double[10][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "TargetController:Learning", 6, this.patternData1, "TargetController:Trial");
        this.graphShift = 8;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.targetController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetController() {
        DJ._print("DaiJa_V3, TargetController.targetController() ================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u3092\u8a2d\u5b9a");
        this.control = new Control();
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\u304b\u3089\u5165\u529b\uff08\u529b\u64cd\u4f5c\u91cf\uff09\u3068\u51fa\u529b\uff08\u5fdc\u7b54\u901f\u5ea6\uff09\u3092\u53ce\u96c6\u3059\u308b");
        DJ._print("\u3000\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        double[] inputData = new double[this.dataNum];
        double[] correctData = new double[this.dataNum];
        double inc = 1.0 / (double)this.dataNum;
        double clock = -inc;
        int j = 0;
        while (j < this.dataNum) {
            inputData[j] = clock += inc;
            correctData[j] = this.control.getS_Curve(clock);
            this.patternData0[0][j] = clock;
            this.patternData1[0][j] = clock;
            ++j;
        }
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\uff08\u4eee\u60f3\u5236\u5fa1\u5bfe\u8c61\uff09\u3092\u8a2d\u5b9a");
        TargetEmulator emulator = new TargetEmulator();
        emulator.runTask();
        emulator.initEmulator();
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 1);
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 1);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        double[] outS = new double[outC.length];
        this.middleLayer0.setdEdY(outdEdX);
        this.outputLayer.setX(mid0Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.squareError = 0.0;
            this.meanError = 0.0;
            this.control.setParameter(0, 0, this.inertia, this.friction);
            this.control.stopSpeedControl();
            this.control.resetControl();
            emulator.initEmulator();
            int j2 = 0;
            while (j2 < this.dataNum) {
                int index = j2;
                mid0X[0] = inputData[index];
                mid0X[1] = correctData[index];
                this.middleLayer0.forward();
                this.outputLayer.forward();
                this.control.setForce(outY[0] / 0.0048828125);
                this.control.execute();
                double force = outY[0] / 0.0048828125;
                double acceleration = emulator.setForce(force);
                double speed = emulator.getSpeed();
                outS[0] = speed * 10.0;
                double position = emulator.getPosition();
                outC[0] = correctData[index] * 1.0;
                this.outputLayer.backward(outC, outS);
                this.middleLayer0.backward();
                if (j2 % this.batchNum == 0) {
                    this.middleLayer0.update();
                    this.outputLayer.update();
                }
                if (this.intervalFlag) {
                    this.squareError = outE[0] * outE[0] / 2.0;
                    this.meanError += this.squareError;
                    this.patternData0[1][j2] = outY[0] * 0.0048828125 * 20.0;
                    this.patternData0[2][j2] = outS[0];
                    this.patternData0[3][j2] = correctData[j2];
                    this.patternData0[4][j2] = -10.0;
                    this.patternData0[5][j2] = speed * 10.0 + 0.01;
                    this.patternData0[6][j2] = position * 10.0;
                    this.patternData0[7][j2] = -10.0;
                    this.patternData0[8][j2] = this.control.getSpeed();
                    this.patternData0[9][j2] = this.control.getPosition();
                    this.patternData1[1][j2] = this.patternData0[1][j2];
                    this.patternData1[2][j2] = -10.0;
                    this.patternData1[3][j2] = -10.0;
                    this.patternData1[4][j2] = this.patternData0[3][j2];
                    this.patternData1[5][j2] = this.patternData0[2][j2];
                    this.patternData1[6][j2] = this.patternData0[4][j2];
                    this.patternData1[7][j2] = -10.0;
                    this.patternData1[8][j2] = this.control.getSpeed();
                    this.patternData1[9][j2] = this.control.getPosition();
                }
                ++j2;
            }
            this.aveError = this.meanError / (double)this.dataNum;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i);
                DJ.print_(", squareError = ", this.squareError);
                DJ.print(", aveError = ", this.aveError);
                this.graphData[0] = this.squareError;
                this.graphData[1] = this.aveError;
                this.updateViewer(i);
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                TargetController targetController = this;
                synchronized (targetController) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print("\u30fb\u30a8\u30dd\u30c3\u30af\u5b9f\u884c\u56de\u6570");
        DJ.print(" Last epoch = ", this.epoch);
        DJ.print_("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        int k = 0;
        while (k < this.graphData.length) {
            DJ.print_("  " + this.dataName[k] + "=" + this.graphData[k]);
            ++k;
        }
        DJ.print("");
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf\u6570: ", this.dataNum);
        DJ.print("\u529b\u64cd\u4f5c\u91cf\u306e\u63a8\u5b9a\u5024: f~", this.patternData0[1]);
        DJ.print("\u5fdc\u7b54\u901f\u5ea6: v", this.patternData0[2]);
        DJ._print("\u30fb\u5b66\u7fd2\u3057\u305f\u9006\u95a2\u6570\u3067\u5236\u5fa1\u5bfe\u8c61\u3092\u99c6\u52d5\u3057\u3001\u5fdc\u7b54\u3092\u5f97\u308b");
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        int j3 = 0;
        while (j3 < this.dataNum) {
            mid0X[0] = inputData[j3];
            mid0X[1] = correctData[j3];
            this.middleLayer0.forward();
            this.outputLayer.forward();
            this.control.setForce(outY[0] / 0.0048828125);
            this.control.execute();
            this.patternData1[1][j3] = outY[0] * 0.0048828125 * 20.0;
            this.patternData1[2][j3] = -10.0;
            this.patternData1[3][j3] = -10.0;
            this.patternData1[4][j3] = -10.0;
            this.patternData1[5][j3] = correctData[j3];
            this.patternData1[6][j3] = -10.0;
            this.patternData1[7][j3] = -10.0;
            this.patternData1[8][j3] = this.control.getSpeed() * 1.0;
            this.patternData1[9][j3] = this.control.getPosition() * 1.0;
            ++j3;
        }
        this.updatePattern();
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### TargetController \u7d42\u4e86 #####");
    }
}

