/*
 * Decompiled with CFR 0.152.
 */
package task.control;

import data.Control;
import java.util.ArrayList;
import java.util.StringTokenizer;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;

public class TargetEmulator
extends Task {
    int epoch = 1;
    int interval = 1;
    double initialCoef = 0.2;
    double eta = 0.2;
    int dataNum = 1000;
    Control control;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 8;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;
    private double[] mid0X;
    private double[] mid0U;
    private double[] mid0Y;
    private double[] outX;
    private double[] outU;
    private double[] outY;
    private double force;
    private double acceleration;
    private double speed;
    private double position;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[10][this.dataNum];
        this.patternData1 = new double[10][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "TargetEmulator:Learnning  Result", 6, this.patternData1, "TargetEmulator:Trial Result");
        this.targetEmulator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetEmulator() {
        DJ._print("DaiJa_V3, TargetEmulator.targetEmulator() ====================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff08\u8ca0\u8377\uff09\u3092\u8a2d\u5b9a");
        this.control = new Control();
        double[] clockData = new double[this.dataNum];
        double inc = 1.0 / (double)this.dataNum;
        double clock = -inc;
        int j = 0;
        while (j < this.dataNum) {
            clockData[j] = clock += inc;
            this.patternData0[0][j] = clock;
            this.patternData1[0][j] = clock;
            ++j;
        }
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        this.mid0X = this.middleLayer0.getX();
        this.mid0Y = this.middleLayer0.getY();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 0);
        this.outY = this.outputLayer.getY();
        double[] outdEdX = this.outputLayer.getdEdX();
        this.middleLayer0.setdEdY(outdEdX);
        this.outputLayer.setX(this.mid0Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                TargetEmulator targetEmulator = this;
                synchronized (targetEmulator) {
                    try {
                        this.wait(100L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\u3092\u5b66\u7fd2\u3057\u305fNN\u306e\u7cbe\u5ea6\u3092\u691c\u8a0e\u3059\u308b");
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        DJ._print("\uff11\uff0e\u5236\u5fa1\u5bfe\u8c61\u306b\u529b\u64cd\u4f5c\u91cf\u3092\u4e0e\u305f\u5834\u5408\u306e\u5fdc\u7b54\u901f\u5ea6");
        double[][] trialData = new double[4][this.dataNum];
        this.force = 0.0;
        int j2 = 0;
        while (j2 < this.dataNum) {
            clock = clockData[j2];
            int cycle = this.dataNum / 5;
            this.force = j2 < cycle ? (this.force += 2.5) : (j2 < cycle * 2 ? (this.force -= 3.0) : (j2 < cycle * 3 ? (this.force += 1.5) : (j2 < cycle * 4 ? (this.force -= 2.0) : (this.force += 0.75))));
            trialData[0][j2] = this.force;
            this.control.setForce(trialData[0][j2]);
            this.control.execute();
            trialData[1][j2] = this.control.getAcceleration();
            trialData[2][j2] = this.control.getSpeed();
            trialData[3][j2] = this.control.getPosition();
            ++j2;
        }
        DJ._print("\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u4fc2\u6570\uff08\u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\uff09\u306e\u8aad\u307f\u8fbc\u307f");
        String fileName = "DaiJa-V4_Emulator.dat";
        ArrayList<double[][]> coeffList = TargetEmulator.loadCoef(fileName);
        double[][] coef = coeffList.get(0);
        this.middleLayer0.setW(coef);
        DJ.print("middleLayer0.w", coef);
        coef = coeffList.get(1);
        this.middleLayer0.setB(coef[0]);
        DJ.print("middleLayer0.b", coef[0]);
        coef = coeffList.get(2);
        this.outputLayer.setW(coef);
        DJ.print("outputLayer.w", coef);
        coef = coeffList.get(3);
        this.outputLayer.setB(coef[0]);
        DJ.print("outputLayer.b", coef[0]);
        DJ._print("\uff12\uff0e\u5b66\u7fd2\u3055\u308c\u3066\u3044\u308bNN\u306b\u529b\u64cd\u4f5c\u91cf\u3092\u4e0e\u305f\u5834\u5408\u306e\u5fdc\u7b54\u901f\u5ea6");
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        this.initEmulator();
        int j3 = 0;
        while (j3 < this.dataNum) {
            this.acceleration = this.setForce(trialData[0][j3]);
            this.speed = this.getSpeed();
            this.position = this.getPosition();
            this.patternData0[1][j3] = trialData[0][j3] * 0.001;
            this.patternData0[2][j3] = -10.0;
            this.patternData0[3][j3] = -10.0;
            this.patternData0[4][j3] = trialData[1][j3] * 100.0;
            this.patternData0[5][j3] = trialData[2][j3];
            this.patternData0[6][j3] = trialData[3][j3] * 2.0;
            this.patternData0[7][j3] = this.acceleration * 1.0;
            this.patternData0[8][j3] = this.speed * 10.0;
            this.patternData0[9][j3] = this.position * 20.0;
            ++j3;
        }
        DJ._print("\uff13\uff0e\u5b66\u7fd2\u3055\u308c\u3066\u3044\u308bNN\u306b\uff33\u5b57\u72b6\u306e\u529b\u64cd\u4f5c\u91cf\u3092\u4e0e\u305f\u5834\u5408\u306e\u5fdc\u7b54");
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        this.middleLayer0.clear();
        this.outputLayer.clear();
        this.acceleration = 0.0;
        this.speed = 0.0;
        this.position = 0.0;
        j3 = 0;
        while (j3 < this.dataNum) {
            clock = clockData[j3];
            this.force = (-2.0 * clock + 3.0) * clock * clock;
            this.force *= 500.0;
            trialData[0][j3] = this.force;
            this.control.setForce(trialData[0][j3]);
            this.control.execute();
            trialData[1][j3] = this.control.getAcceleration();
            trialData[2][j3] = this.control.getSpeed();
            trialData[3][j3] = this.control.getPosition();
            this.mid0X[0] = this.force * 0.002;
            this.mid0X[1] = trialData[2][j3];
            this.middleLayer0.forward();
            this.outputLayer.forward();
            this.acceleration = this.outY[0];
            this.speed += this.acceleration / (double)this.dataNum;
            this.position += this.speed / (double)this.dataNum;
            this.patternData1[1][j3] = trialData[0][j3] * 0.001;
            this.patternData1[2][j3] = -10.0;
            this.patternData1[3][j3] = -10.0;
            this.patternData1[4][j3] = trialData[1][j3] * 100.0;
            this.patternData1[5][j3] = trialData[2][j3];
            this.patternData1[6][j3] = trialData[3][j3] * 2.0;
            this.patternData1[7][j3] = this.acceleration * 1.0;
            this.patternData1[8][j3] = this.speed * 10.0;
            this.patternData1[9][j3] = this.position * 20.0;
            ++j3;
        }
        this.updatePattern();
        this.initEmulator();
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### TargetEmulator \u6e96\u5099\u5b8c\u4e86\uff1a\u5f85\u6a5f\u4e2d #####");
    }

    public void initEmulator() {
        this.mid0X = this.middleLayer0.getX();
        this.middleLayer0.clear();
        this.outputLayer.clear();
        this.force = 0.0;
        this.acceleration = 0.0;
        this.speed = 0.0;
        this.position = 0.0;
    }

    public double setForce(double force_) {
        double acceleration_ = this.outY[0];
        double speed_ = this.speed + acceleration_ / (double)this.dataNum;
        this.mid0X[0] = force_ * 0.002;
        this.mid0X[1] = speed_ * 10.0;
        this.middleLayer0.forward();
        this.outputLayer.forward();
        this.acceleration = this.outY[0];
        this.speed += this.acceleration / (double)this.dataNum;
        this.position += this.speed / (double)this.dataNum;
        return this.acceleration;
    }

    public double setForce(double force_, double speed_) {
        this.mid0X[0] = force_ * 0.002;
        this.mid0X[1] = speed_;
        this.middleLayer0.forward();
        this.outputLayer.forward();
        this.acceleration = this.outY[0];
        this.speed += this.acceleration / (double)this.dataNum;
        this.position += this.speed / (double)this.dataNum;
        return this.acceleration;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getPosition() {
        return this.position;
    }

    public static ArrayList<double[][]> loadCoef(String fileName) {
        ArrayList<String> stringList = LogEditor.getText(fileName);
        DJ.print("File title:", stringList.get(1));
        int dataSize = Integer.parseInt(stringList.get(2));
        int lineNum = 2;
        ArrayList<double[][]> coeffList = new ArrayList<double[][]>(dataSize);
        int k = 0;
        while (k < dataSize) {
            int nodeNum = Integer.parseInt(stringList.get(++lineNum));
            double[][] coef = new double[nodeNum][];
            int i = 0;
            while (i < nodeNum) {
                coef[i] = TargetEmulator.loadLine(stringList.get(++lineNum));
                ++i;
            }
            coeffList.add(coef);
            ++k;
        }
        return coeffList;
    }

    private static double[] loadLine(String lineString) {
        ArrayList<Double> doubleList = new ArrayList<Double>();
        StringTokenizer lineToken = new StringTokenizer(lineString, ",");
        while (lineToken.hasMoreTokens()) {
            String nextStr = lineToken.nextToken().trim();
            if ("".equals(nextStr)) {
                DJ._print_("***** WARNING ***** TargetEmulator.loadLine():");
                DJ.print(" Next token in a lineString is void.");
                continue;
            }
            double d = Double.parseDouble(nextStr);
            doubleList.add(d);
        }
        int listSize = doubleList.size();
        double[] doubleArray = new double[listSize];
        int i = 0;
        while (i < listSize) {
            doubleArray[i] = (Double)doubleList.get(i);
            ++i;
        }
        return doubleArray;
    }
}

