/*
 * Decompiled with CFR 0.152.
 */
package task.control;

import data.Control;
import java.util.ArrayList;
import java.util.Collections;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;

public class TargetLearner
extends Task {
    int epoch = 1000;
    int batchNum = 1;
    int interval = 10;
    double initialCoef = 0.5;
    double eta = 0.2;
    int dataNum = 1000;
    Control control;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 8;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;
    double squareError;
    double meanError;
    double aveError;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[10][this.dataNum];
        this.patternData1 = new double[10][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "TargetLearn:Learning", 6, this.patternData1, "TargetLearn:Trial");
        this.graphShift = 8;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.targetLearner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetLearner() {
        DJ._print("DaiJa_V3, TargetLearn.targetLearner() ========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff08\u8ca0\u8377\uff09\u3092\u8a2d\u5b9a");
        this.control = new Control();
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        double[] inputData = new double[this.dataNum];
        double[] correctData = new double[this.dataNum];
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf\u3092\u3092\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u8fbc");
        DJ.print(" DaiJa/resorce/V3_SampleData.dat, 5[\u7a2e\u985e]\u00d71000[\u70b9]");
        double[][] sampleData = LogEditor.loadData("DaiJa-V4_SampleData.dat");
        DJ.print_(", \u884c\u6570\uff1a" + sampleData.length + "\uff08\u6642\u70b9,\u64cd\u4f5c\u91cf,\u5fdc\u7b54\uff09");
        DJ.print(", \u5217\u6570\uff1a", String.valueOf(sampleData[0].length) + "\uff08\u30c7\u30fc\u30bf\u6570\uff09");
        DJ.print_(" \u30af\u30ed\u30c3\u30af: ");
        DJ.print("clock", sampleData[0]);
        DJ.print_(" \u529b\u64cd\u4f5c\u91cf: ");
        DJ.print("fm", sampleData[1]);
        DJ.print_(" \u5fdc\u7b54\u52a0\u901f\u5ea6: ");
        DJ.print("a", sampleData[2]);
        DJ.print_(" \u5fdc\u7b54\u901f\u5ea6: ");
        DJ.print("v", sampleData[3]);
        DJ.print_(" \u5fdc\u7b54\u4f4d\u7f6e: ");
        DJ.print("p", sampleData[4]);
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        double inc = 1.0 / (double)this.dataNum;
        double clock = -inc;
        int j = 0;
        while (j < this.dataNum) {
            inputData[j] = sampleData[0][j];
            correctData[j] = sampleData[2][j] * 100.0;
            this.patternData0[0][j] = sampleData[0][j];
            this.patternData1[0][j] = sampleData[0][j];
            ++j;
        }
        ArrayList<Integer> indexList = DJ.permutationRandom(this.dataNum);
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 0);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        this.middleLayer0.setdEdY(outdEdX);
        this.outputLayer.setX(mid0Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            Collections.shuffle(indexList);
            this.squareError = 0.0;
            this.meanError = 0.0;
            double[] acceleration = new double[this.dataNum];
            double[] speed = new double[this.dataNum];
            double[] position = new double[this.dataNum];
            this.control.resetControl();
            int j2 = 0;
            while (j2 < this.dataNum) {
                int index = indexList.get(j2);
                mid0X[0] = sampleData[1][index] * 0.002;
                mid0X[1] = sampleData[3][index];
                this.middleLayer0.forward();
                this.outputLayer.forward();
                outC[0] = correctData[index];
                this.outputLayer.backward(outC);
                this.middleLayer0.backward();
                if (j2 % this.batchNum == 0) {
                    this.middleLayer0.update();
                    this.outputLayer.update();
                }
                acceleration[index] = outY[0];
                if (this.intervalFlag) {
                    this.squareError = outE[0] * outE[0] / 2.0;
                    this.meanError += this.squareError;
                    this.patternData0[1][index] = sampleData[1][index] * 0.001;
                    this.patternData0[3][index] = sampleData[2][index] * 100.0;
                    this.patternData0[4][index] = sampleData[3][index];
                    this.patternData0[5][index] = sampleData[4][index] * 2.0;
                    this.patternData0[6][index] = -10.0;
                    this.patternData0[7][index] = -10.0;
                }
                ++j2;
            }
            this.aveError = this.meanError / (double)this.dataNum;
            j2 = 0;
            while (j2 < this.dataNum) {
                if (j2 > 0) {
                    speed[j2] = speed[j2 - 1] + acceleration[j2] / (double)this.dataNum;
                }
                this.patternData0[2][j2] = acceleration[j2];
                this.patternData0[8][j2] = speed[j2] * 10.0;
                if (j2 > 0) {
                    position[j2] = position[j2 - 1] + speed[j2] / (double)this.dataNum;
                }
                this.patternData0[9][j2] = position[j2] * 20.0;
                ++j2;
            }
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i);
                DJ.print_(", squareError = ", this.squareError);
                DJ.print(", aveError = ", this.aveError);
                this.graphData[0] = this.squareError;
                this.graphData[1] = this.aveError;
                this.updateViewer(i);
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                TargetLearner targetLearner = this;
                synchronized (targetLearner) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            ++i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print("\u30fb\u30a8\u30dd\u30c3\u30af\u5b9f\u884c\u56de\u6570");
        DJ.print(" Last epoch = ", this.epoch);
        DJ.print_("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        int k = 0;
        while (k < this.graphData.length) {
            DJ.print_("  " + this.dataName[k] + "=" + this.graphData[k]);
            ++k;
        }
        DJ.print("");
        DJ._print("\u30fb\u5b66\u7fd2\u3057\u305f\u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3059\u308b");
        String[] element = new String[]{"TargetLearner:" + TimeStamp.getTimeFormated()};
        double[][] mid0W = this.middleLayer0.getW();
        double[][] mid0B = new double[][]{this.middleLayer0.getB()};
        double[][] outW = this.outputLayer.getW();
        double[][] outB = new double[][]{this.outputLayer.getB()};
        ArrayList<double[][]> coeffList = new ArrayList<double[][]>();
        coeffList.add(mid0W);
        coeffList.add(mid0B);
        coeffList.add(outW);
        coeffList.add(outB);
        TargetLearner.saveData(element, coeffList, "DaiJa-V4_Emulator.dat");
        DJ._print("\u30fb\u4e2d\u9593\uff10\u5c64\u306e\u91cd\u307f: ", mid0W);
        DJ.print("\u30fb\u4e2d\u9593\uff10\u5c64\u306e\u30d0\u30a4\u30a2\u30b9: ", mid0B);
        DJ.print("\u30fb\u51fa\u529b\u5c64\u306e\u91cd\u307f: ", outW);
        DJ.print("\u30fb\u51fa\u529b\u5c64\u306e\u30d0\u30a4\u30a2\u30b9: ", outB);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\u3092\u5b66\u7fd2\u3057\u305fNN\u3092\u691c\u8a3c\u3059\u308b");
        this.control.setParameter(0, 0, this.inertia, this.friction);
        this.control.stopSpeedControl();
        this.control.resetControl();
        this.middleLayer0.clear();
        this.outputLayer.clear();
        double acceleration = 0.0;
        double speed = 0.0;
        double position = 0.0;
        clock = -inc;
        int j3 = 0;
        while (j3 < this.dataNum) {
            clock += inc;
            mid0X[0] = sampleData[1][j3] * 0.002;
            mid0X[1] = sampleData[3][j3];
            this.middleLayer0.forward();
            this.outputLayer.forward();
            acceleration = outY[0];
            position += (speed += acceleration / (double)this.dataNum) / (double)this.dataNum;
            this.patternData1[1][j3] = sampleData[1][j3] * 0.001;
            this.patternData1[2][j3] = -10.0;
            this.patternData1[3][j3] = -10.0;
            this.patternData1[4][j3] = sampleData[2][j3] * 100.0;
            this.patternData1[5][j3] = sampleData[3][j3];
            this.patternData1[6][j3] = sampleData[4][j3] * 2.0;
            this.patternData1[7][j3] = acceleration * 1.0;
            this.patternData1[8][j3] = speed * 10.0;
            this.patternData1[9][j3] = position * 20.0;
            ++j3;
        }
        this.updatePattern();
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### TargetLearner \u7d42\u4e86 #####");
    }

    public static void saveData(String[] text, ArrayList<double[][]> dataList, String fileName) {
        ArrayList<String> buf = new ArrayList<String>();
        int textLength = text.length;
        buf.add(String.valueOf(textLength) + "\r\n");
        if (textLength > 0) {
            buf.add(text[0]);
            int i = 1;
            while (i < text.length) {
                buf.add("," + text[i]);
                ++i;
            }
            buf.add("\r\n");
        }
        int dataSize = dataList.size();
        buf.add(String.valueOf(dataSize) + "\r\n");
        if (dataSize > 0) {
            int k = 0;
            while (k < dataSize) {
                double[][] data = dataList.get(k);
                buf.add(String.valueOf(data.length) + "\r\n");
                int i = 0;
                while (i < data.length) {
                    StringBuilder str = new StringBuilder();
                    str.append(data[i][0]);
                    int j = 1;
                    while (j < data[0].length) {
                        str.append(",").append(data[i][j]);
                        ++j;
                    }
                    buf.add(String.valueOf(str.toString()) + "\r\n");
                    ++i;
                }
                ++k;
            }
        }
        LogEditor.saveText(buf, fileName);
    }
}

