/*
 * Decompiled with CFR 0.152.
 */
package task.qu;

import quan.QuBasis;
import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompVec;
import util.comp.Complex;

public class BellsInequality
extends Task {
    int epoch = 6;
    int interval = 1;
    int delta = 30;
    int dataNum = 200;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Bell's Inequality", 6, this.patternData1, "Bell's Inequality");
        this.stepMode = true;
        this.bellsInequality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bellsInequality() {
        DJ._print("BellsInequality.bellsInequality() ========================");
        DJ.print("\u25a0\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\uff1aBell's Inequality");
        DJ.print("  \u5c40\u6240\u5b9f\u5728\u8ad6\u3092\u4eee\u5b9a\u3057\u3066\u5f97\u3089\u308c\u308b\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306f\u3001\n  \u5b9f\u9a13\u306b\u3088\u308a\u6210\u7acb\u3057\u306a\u3044\u3053\u3068\u304c\u8a3c\u660e\u3055\u308c\u307e\u3057\u305f\u3002\n  \u672c\u30bf\u30b9\u30af\u3067\u306f\u3001\u91cf\u5b50\u8a08\u7b97\u306b\u3088\u308a\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u304c\n  \u7834\u3089\u308c\u308b\u3053\u3068\u3092\u793a\u3057\u307e\u3059\u3002");
        DJ._print("\u30fb\u30d9\u30eb\u306e\u5b9f\u9a13\n\u3000\u7e54\u59ebVega\u3068\u5f66\u661fAltair\u306f\u4e92\u3044\u306e\u6e2c\u5b9a\u7d50\u679c\u304c\u76f8\u624b\u306b\u4f1d\u308f\u3089\u306a\u3044\u3088\u3046\u306b\u3001\n\u3000\u5341\u5206\u306b\u96e2\u308c\u305f\u8ddd\u96e2\uff08\u5929\u306e\u5ddd\u306e\u4e21\u5cb8\u3001\u304a\u3088\u305d\uff11\uff15\u5149\u5e74\uff09\u3092\u9694\u3066\u3066\u3001\n\u3000\u3082\u3064\u308c\u305f\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u305d\u308c\u305e\u308c\u4e00\u65b9\u3092\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u6e2c\u5b9a\u306b\u4f7f\u3046\u57fa\u5e95\u306f\uff13\u500b(b0, b1, b2)\u6709\u308a\u307e\u3059\u304c\u3001\u7e54\u59eb\u306f\u57fa\u5e95b0\u3068b2\u304b\u3089\u3001\n\u3000\u5f66\u661f\u306f\u57fa\u5e95b1\u3068b2\u304b\u3089\u6e2c\u5b9a\u3054\u3068\u306b\u3069\u3061\u3089\u304b\u3092\u30e9\u30f3\u30c0\u30e0\u306b\u9078\u3093\u3067\u4f7f\u3044\u307e\u3059\u3002\n\u3000\u5148\u306b\u7e54\u59eb\u304c\u6e2c\u5b9a\u3057\u307e\u3059\u3002\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u6e2c\u5b9a\u306b\u4f7f\u3063\u305f\u57fa\u5e95\u306b\u5f93\u3063\u3066\u9077\u79fb\u3057\u307e\u3059\u3002\n\u3000\u7e54\u59eb\u306e\u6e2c\u5b9a\u306b\u3088\u308a\u3001\u3082\u3064\u308c\u3066\u3044\u308b\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3068\n\u3000\u540c\u3058\u91cf\u5b50\u72b6\u614b\u306b\u9077\u79fb\u3057\u307e\u3059\u3002\u305d\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u5f8c\u304b\u3089\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u9078\u3093\u3060\u57fa\u5e95\u306e\u3069\u306e\u57fa\u5e95\u306b\u9077\u79fb\u3059\u308b\u304b\u306e\u78ba\u7387\u304c\u5b9a\u307e\u308a\u307e\u3059\u3002\n");
        DJ._print("\u30fb\u5c40\u6240\u5b58\u5728\u8ad6\uff08\u5c40\u6240\u6027\u3068\u5b58\u5728\u6027\uff09\u3092\u4eee\u5b9a\u3059\u308b\u3068\u6b21\u306e\u4e0d\u7b49\u5f0f\u304c\u6210\u7acb\u3057\u307e\u3059\u3002\n\u3000Bell\u306e\u4e0d\u7b49\u5f0f\uff1aP(b0_0, b1_1) <= P(b0_0, b2_1) + P(b2_0, b1_1)\n\u3000\u3053\u3053\u3067\u3001P()\u306f\u767a\u751f\u78ba\u7387\u3092\u8868\u3057\u307e\u3059\u3002\u672b\u5c3e\u306e_0\u3068_1\u306f\u3001\u305d\u308c\u305e\u308c\u3001\n\u3000\u6e2c\u5b9a\u7d50\u679c\u304c\u9078\u3093\u3060\u57fa\u5e95\u306e\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u5834\u5408\u3092\u8868\u3057\u3001\n\u3000\u6e2c\u5b9a\u7d50\u679c\u304c\u9078\u3093\u3060\u57fa\u5e95\u306e\u7b2c\uff10\u57fa\u5e95\u4ee5\u5916\u306b\u9077\u79fb\u3057\u305f\u5834\u5408\u3092\u8868\u3057\u307e\u3059\u3002\n\n\u3000P(b0_0, b1_1)\u306f\u7e54\u59eb\u304c\u57fa\u5e95b0\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u3001\n\u3000\u3000\u3000\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff11\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u5834\u5408\u306e\u78ba\u7387\u3067\u3059\u3002\n\n\u3000P(b0_0, b2_1)\u306f\u7e54\u59eb\u304c\u57fa\u5e95b0\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u3001\n\u3000\u3000\u3000\u5f66\u661f\u304cb2\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff11\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u5834\u5408\u306e\u78ba\u7387\u3067\u3059\u3002\n\n\u3000P(b2_0, b1_1)\u306f\u7e54\u59eb\u304c\u57fa\u5e95b2\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u3001\n\u3000\u3000\u3000\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u304c\u7b2c\uff11\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u5834\u5408\u306e\u78ba\u7387\u3067\u3059\u3002");
        DJ._print("\u30fb\u5c40\u6240\u5b58\u5728\u8ad6\u3067\u306f\u7d50\u679c\u306f\u6e2c\u5b9a\u3059\u308b\u524d\u304b\u3089\u5b9f\u5728\u3057\u3001\u96e2\u308c\u305f\u5834\u6240\u3067\u306e\u6e2c\u5b9a\n\u3000\u7d50\u679c\u306f\u4e92\u3044\u306b\u4ed6\u65b9\u306b\u306f\u5f71\u97ff\u3057\u306a\u3044\uff08\u76f8\u5bfe\u8ad6\u7684\u306b\u5149\u306e\u65e9\u3055\u4ee5\u4e0a\u306e\u901f\u3055\u3067\u306f\n\u3000\u60c5\u5831\u306f\u4f1d\u308f\u3089\u306a\u3044\uff09\u3068\u8003\u3048\u3066\u3001\u78ba\u7387\u306f\u4ee5\u4e0b\u306e\u96c6\u5408\u306b\u7f6e\u304d\u63db\u3048\u3089\u308c\u307e\u3059\u3002");
        DJ._print("\u30fb\u6e2c\u5b9a\u7d50\u679c\u3092\u96c6\u5408\uff08\u30d9\u30f3\u56f3\uff1aVenn Diagram\uff09\u3067\u8868\u3057\u307e\u3059\u3002\n\u3000\u30d9\u30f3\u56f3\u306f\u57fa\u5e95b0,b1,b2\u306b\u3088\u308b\u5168\u3066\u306e\u6e2c\u5b9a\u7d50\u679c\u3092\u542b\u3093\u3067\u3044\u307e\u3059\u3002");
        DJ._print("  \u5de6\u8fba\u3000\u3000\u3000P(b0_0, b1_1)\u306f\u96c6\u5408(b0_0,b1_1,b2_0)+(b0_0,b1_1,b2_1)\n  \u53f3\u8fba\u7b2c\uff11\u9805P(b0_0, b2_1)\u306f\u96c6\u5408(b0_0,b1_0,b2_1)+(b0_0,b1_1,b2_1)\n  \u53f3\u8fba\u7b2c\uff12\u9805P(b2_0, b1_1)\u306f\u96c6\u5408(b0_0,b1_1,b2_0)+(b0_1,b1_1,b2_0)");
        DJ._print("    \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510     \n    \u2502      \u3000            (b0_0,b1_1,b2_1)                  \u2502     \n    \u2502                    \u5de6\u8fba\u30fb\u53f3\u8fba\u7b2c\uff11\u9805                  \u2502     \n    \u2502      \u3000          \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2510 \n\u250c\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510                \u2502\u3000\u2502 \n\u2502  \u2502      \u3000          \u2502                \u2502                \u2502  \u2502 \n\u2502  \u2502(b0_0,b1_0,b2_1)  \u2502(b0_0,b1_0,b2_0)\u2502(b0_0,b1_1,b2_0)\u2502  \u2502 \n\u2502  \u2502   \u53f3\u8fba\u7b2c\uff11\u9805     \u2502\u3000              \u2502\u5de6\u8fba\u30fb\u53f3\u8fba\u7b2c\uff12\u9805\u2502  \u2502 \n\u2502  \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518  \u2502 \n\u2502                      \u2502                \u2502  (b0_1,b1_1,b2_0)  \u2502 \n\u2502  (b0_1,b1_0,b2_1)    \u2502(b0_1,b1_0,b2_0)\u2502    \u53f3\u8fba\u7b2c\uff12\u9805      \u2502 \n\u2502                      \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518 \n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518                       ");
        DJ._print("\u30fb\u4ee5\u4e0a\u306e\u3088\u3046\u306b\u3001\u5de6\u8fba\u306e\uff12\u500b\u306e\u8981\u7d20\u306f\u5168\u3066\u53f3\u8fba\u306e\u96c6\u5408\u306b\n  \u542b\u307e\u308c\u308b\u306e\u3067\u3001Bell\u306e\u4e0d\u7b49\u5f0f\u304c\u5c0e\u51fa\u3055\u308c\u307e\u3059\u3002\n\n  P(b0_0, b1_1) <= P(b0_0, b2_1) + P(b2_0, b1_1)");
        DJ.printS(3, "BellsInequality(0)", this);
        DJ.print("Code(0)\u30bf\u30b9\u30af\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ._print("\u30fb\u30bf\u30b9\u30af\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print("  \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570\uff1aepoch = ", this.epoch);
        DJ.print("  \u7d4c\u904e\u8868\u793a\u9593\u9694\uff1ainterval = ", this.interval);
        DJ.print("\u30fb\u91cf\u5b50\u8a08\u7b97\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print("  \u57fa\u5e95\u89d2\u5ea6\u306e\u5897\u5206\uff08\u5ea6\uff09\uff1adelta = ", this.delta);
        DJ.printS(1, "BellsInequality(1)", this);
        DJ.print("Code(1)\u6e2c\u5b9a\u7528\u57fa\u5e95\u306e\u89d2\u5ea6\u3092\u56fa\u5b9a\u3057\u305f\u5834\u5408");
        DJ._print("Code(1-1)\u2460\u6e2c\u5b9a\u7528\u57fa\u5e95\u89d2\u5ea6\u30920\u5ea6\u300160\u5ea6\u300130\u5ea6\u306b\u56fa\u5b9a");
        DJ.print("\u30fb\u7e54\u59eb\u3068\u5f66\u661f\u306f\u4ee5\u4e0b\u306e\uff13\u500b\u306e\u57fa\u5e95(b0, b1, b2)\u304b\u3089\u3001\n  \u305d\u308c\u305e\u308c\uff12\u500b\u306e\u57fa\u5e95(b0, b2)\u3068(b1, b2)\u3092\u4f7f\u3063\u3066\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n                                       \n  b0 : \u03b8 = 0\u03c0  &  \u03c0/2 =  0 &  90deg \n  b1 : \u03b8 = \u03c0/3 & 5\u03c0/6 = 60 & 150deg \n  b2 : \u03b8 = \u03c0/6 & 2\u03c0/3 = 30 & 120deg \n                                       \n\u3000\u5148\u306b\u7e54\u59eb\u304c\u6e2c\u5b9a\u3057\u3001\u6e2c\u5b9a\u306b\u3088\u308a\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\n  \u5f66\u661f\u304c\u5f8c\u304b\u3089\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n");
        DJ.printS(2, "BellsInequality(1-1)\u2461", this);
        DJ.print("Code(1-1)\u2461\u30d9\u30eb\u306e\u5b9f\u9a13\u306e\u91cf\u5b50\u56de\u8def");
        DJ._print("\u30fb\u30d9\u30eb\u306e\u5b9f\u9a13\u56de\u8def\u306fH\u30b2\u30fc\u30c8(Hadamard Gate)\u3068\u3001\n\u3000CX\u30b2\u30fc\u30c8(C-Not\u30b2\u30fc\u30c8)\u3067\u69cb\u6210\u3055\u308c\u307e\u3059\u3002\n\u3000H\u3068CX\u30b2\u30fc\u30c8\u306b\u3088\u308a\u7e54\u59eb\u3068\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3068qb1\u306f\u3082\u3064\u308c\u307e\u3059\u3002\n\u3000\u7e54\u59eb\u304c\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3092M0\u3067\u6e2c\u5b9a\u3059\u308b\u3068\u3001\u6e2c\u5b9a\u306b\u4f7f\u7528\u3057\u305f\u57fa\u5e95\u306b\n\u3000\u5f93\u3063\u3066\u9077\u79fb\u3057\u307e\u3059\u3002\u7e54\u59eb\u306e\u6e2c\u5b9a\u3068\u540c\u6642\u306b\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082\u9077\u79fb\u3057\u3001\n\u3000\u7e54\u59eb\u3068\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3068qb1\u306e\u3082\u3064\u308c\u3082\u89e3\u6d88\u3057\u307e\u3059\u3002\u305d\u306e\u5f8c\u3067\u3001\n\u3000\u5f66\u661f\u306f\u9078\u629e\u3057\u305f\u57fa\u5e95\u3092\u4f7f\u3044\u7b2c\uff11\u91cf\u5b50\u30d3\u30c3\u30c8qb1\u3092M1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n              \u250c-\u2510  \u250c-\u2510  \u250c\u2500\u2510          \nqb0 = [1 0]'\u2500\u2524H\u251c\u2500\u2524C\u251c\u2500\u2524M0\u2502          \n              \u251c-\u2524  \u2502|\u2502  \u251c\u2500\u2524  \u250c\u2500\u2510  \nqb1 = [1 0]'\u2500\u2524I\u251c\u2500\u2524X\u251c\u2500\u2524I \u251c\u2500\u2524M1\u2502  \n              \u2514-\u2518  \u2514-\u2518  \u2514\u2500\u2518  \u2514\u2500\u2518  ");
        DJ.printS(1, "BellsInequality(1-1)\u2462", this);
        DJ.print("Code(1-1)\u2462\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u751f\u6210");
        DJ.print("\u30fb\u7e54\u59eb\u3068\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8qb0=[1 0]'\u3068qb1=[1 0]'\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit qb0 = new QuBit();
        DJ.printF("qb0", qb0);
        QuBit qb1 = new QuBit();
        DJ.printF("qb1", qb1);
        DJ.print("\u30fb\u4e8c\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8qb0=qb1=[1 0]'\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\n  \uff12\u91cf\u5b50\u30d3\u30c3\u30c8qb0_1=[1 0 0 0]'\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit qb0_1 = qb0.interactQuBit(qb1);
        DJ.printF("qb0_1", qb0_1);
        DJ.printS(2, "BellsInequality(1-2)", this);
        DJ.print("Code(1-2)\u91cf\u5b50\u30b2\u30fc\u30c8\u306e\u751f\u6210");
        DJ._print("Code(1-2)\u2460H\u30b2\u30fc\u30c8\uff08Hadamard\u30b2\u30fc\u30c8\uff09\u306e\u751f\u6210");
        DJ.print("H\u30b2\u30fc\u30c8 \n          \u250c      \u2510 \n H = 1/\u221a2\u2502 1   1\u2502 \n          \u2502 1  -1\u2502 \n          \u2514      \u2518 ");
        QuGate hadamardGate = new QuGate("H_GATE");
        DJ.printF("hadamardGate", hadamardGate);
        DJ.printS(1, "BellsInequality(1-2)\u2461", this);
        DJ.print("Code(1-2)\u2461I\u30b2\u30fc\u30c8\uff08\u6052\u7b49\u30b2\u30fc\u30c8\uff09\u306e\u751f\u6210");
        DJ.print("I\u30b2\u30fc\u30c8 \n     \u250c      \u2510 \n I = \u2502 1   0\u2502 \n     \u2502 0   1\u2502 \n     \u2514      \u2518 ");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ.printS(1, "BellsInequality(1-2)\u2462", this);
        DJ.print("Code(1-2)\u2462H\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        DJ.print("H_I\u30b2\u30fc\u30c8:H?I \n            \u250c     \u2510 \n H?I = 1/\u221a2\u2502 I  I\u2502 \n            \u2502 I -I\u2502 \n            \u2514     \u2518 ");
        QuGate h_iGate = hadamardGate.interactQuGate(iGate);
        DJ.printF("h_iGate", h_iGate);
        DJ.printS(1, "BellsInequality(1-2)\u2463", this);
        DJ.print("Code(1-2)\u2463CX\u30b2\u30fc\u30c8\uff08C-Not\u30b2\u30fc\u30c8\uff09\u306e\u751f\u6210");
        DJ.print("CX\u30b2\u30fc\u30c8 \n      \u250c              \u2510 \n CX = \u2502 1   0   0   0\u2502 \n      \u2502 0   1   0   0\u2502 \n      \u2502 0   0   0   1\u2502 \n      \u2502 0   0   1   0\u2502 \n      \u2514              \u2518 ");
        DJ.print("\u30fbCX\u30b2\u30fc\u30c8\u306e\u751f\u6210\u306b\u306f\u3001\u91cf\u5b50\u30d3\u30c3\u30c8\u6570\u3001\u304a\u3088\u3073\n\u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        DJ.print(" QuGate cxGate = new QuGate( QuGate.CX_GATE, numOfBits, target, controlArray)");
        int numOfBits = 2;
        int target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray = new int[1];
        DJ.print(", controlArray", controlArray);
        DJ.print("controlArray", controlArray);
        QuGate cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.printF("cxGate", cxGate);
        DJ.printS(2, "BellsInequality(1-3)", this);
        DJ.print("Code(1-3)\u6e2c\u5b9a\u5bfe\u8c61\u3068\u306a\u308b\u91cf\u5b50\u30d3\u30c3\u30c8targetQuBit\u306e\u751f\u6210");
        DJ._print("Code(1-3)\u2460\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092H\u30b2\u30fc\u30c8\u3067\u91cd\u306d\u5408\u308f\u305b\u72b6\u614b\u306b");
        QuBit qbH01 = h_iGate.apply(qb0_1);
        DJ.printF("qbH01", qbH01);
        DJ.printS(1, "BellsInequality(1-3)\u2461", this);
        DJ.print("Code(1-3)\u2461\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092CX\u30b2\u30fc\u30c8\u3067\u3082\u3064\u308c\u72b6\u614b\u306b");
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8qbH01\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cxGate\u306b\u9069\u7528\u3057\u3001\n  \u6e2c\u5b9a\u5bfe\u8c61\u306e\u3082\u3064\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8targetQuBit\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("targetQuBit = cxGate.apply(qbH01");
        QuBit targetQuBit = cxGate.apply(qbH01);
        DJ.printF("targetQuBit", targetQuBit);
        DJ.printS(1, "BellsInequality(1-3)\u2462", this);
        DJ.print("Code(1-3)\u2462\u6e2c\u5b9a\u5bfe\u8c61\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
        boolean checked = targetQuBit.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ.printS(2, "BellsInequality(1-4)", this);
        DJ.print("Code(1-4)\u6e2c\u5b9a\u7528\u306e\uff13\u7a2e\u985e\u306e\u57fa\u5e95b0,b1,b2\u3092\u751f\u6210");
        double theta = 0.5235987755982988;
        int numOfQuBit = 1;
        QuBasis eQuBasis = new QuBasis(numOfQuBit);
        DJ.printF("eQuBasis", eQuBasis);
        DJ._print("Code(1-4)\u2460\u57fa\u5e95b0\u3092\u751f\u6210\uff08\u56de\u8ee2\u89d2\u30920\u5ea6\u3067\u6307\u5b9a\uff09");
        QuBasis b0QuBasis = new QuBasis(numOfQuBit);
        DJ.print("\u30fb\u57fa\u5e95b0QuBasis\u3068\u6052\u7b49\u57fa\u5e95eQuBasis\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\n\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b0_eQuBasis\u3092\u751f\u6210");
        QuBasis b0_eQuBasis = b0QuBasis.interactQuBasis(eQuBasis);
        DJ.printF("b0_eQuBasis", b0_eQuBasis);
        DJ.printS(1, "BellsInequality(1-4)\u2461", this);
        DJ.print("Code(1-4)\u2461\u57fa\u5e95b1\u3092\u751f\u6210\uff08\u56de\u8ee2\u89d2\u309260\u5ea6\u3067\u6307\u5b9a\uff09");
        QuBasis b1QuBasis = new QuBasis(theta * 2.0);
        DJ.printF("b1QuBasis", b1QuBasis);
        DJ.print("\u30fb\u57fa\u5e95b1QuBasis\u3068\u6052\u7b49\u57fa\u5e95eQuBasis\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\n  \uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b1_eQuBasis\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBasis b1_eQuBasis = b1QuBasis.interactQuBasis(eQuBasis);
        DJ.printF("b1_eQuBasis", b1_eQuBasis);
        DJ.print("\u30fb\u7e54\u59eb\u306f\u6e2c\u5b9a\u306b\u57fa\u5e95\uff08\u504f\u5149\u677f\uff09b0\u3068b2\u3092\u4f7f\u7528\u3059\u308b\u306e\u3067\u3001\n  \u3053\u306e\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b1_eQuBasis\u306f\u4f7f\u308f\u308c\u307e\u305b\u3093\u3002");
        DJ.printS(1, "BellsInequality(1-4)\u2462", this);
        DJ.print("Code(1-4)\u2462\u57fa\u5e95b2\u3092\u751f\u6210\uff08\u56de\u8ee2\u89d2\u309230\u5ea6\u3067\u6307\u5b9a\uff09");
        QuBasis b2QuBasis = new QuBasis(theta);
        DJ.printF("b2QuBasis", b2QuBasis);
        DJ.print("\u30fb\u57fa\u5e95b2QuBasis\u3068\u6052\u7b49\u57fa\u5e95eQuBasis\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\n  \uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b2_eQuBasis\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBasis b2_eQuBasis = b2QuBasis.interactQuBasis(eQuBasis);
        DJ.printF("b2_eQuBasis", b2_eQuBasis);
        DJ.printS(2, "BellsInequality(1-5)", this);
        DJ.print("Code(1-5)\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5de6\u8fba\u306e\u78ba\u7387 P(b0_0, b1_1)");
        DJ.print("Code(1-5)\u2460\u7e54\u59eb\u304c\u5bfe\u8c61\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u57fa\u5e95b0_e\u3067\u6e2c\u5b9a");
        DJ._print("\u30fb\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\u5404\u57fa\u5e95\u8ef8\u306e\u9077\u79fb\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        int tryalNo = 100;
        DJ.print("\u3000countQuBasis\u30eb\u30fc\u30c1\u30f3\u306e\u5185\u90e8\u3067\u8a66\u884c\u56de\u6570\u56de\u6e2c\u5b9a\u3055\u308c\u307e\u3059\u3002");
        int[] count = b0_eQuBasis.countQuBasis(targetQuBit, tryalNo);
        DJ._print("\u30fb\u5404\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u56de\u6570\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        DJ.print("count = ", count);
        DJ.printS(1, "BellsInequality(1-5)\u2461", this);
        DJ._print("Code(1-5)\u2461\u6e2c\u5b9a\u306b\u3088\u308a\u91cf\u5b50\u30d3\u30c3\u30c8\u304c\u9077\u79fb\u3057\u305f\u57fa\u5e95\u8ef8");
        DJ.print("\u30fb\u5404\u6e2c\u5b9a\u3067\u9077\u79fb\u3057\u305f\u57fa\u5e95\u8ef8\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        QuBit[] selectedQBArray = b0_eQuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u30fb\u9077\u79fb\u3057\u305f\u57fa\u5e95\u8ef8\u306b\u5bfe\u5fdc\u3059\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u8868\u793a\u3057\u307e\u3059\u3002\n\u3000\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u53e4\u5178\u30d3\u30c3\u30c8\u306f0,1,2,3\u306b\u306a\u308a\u307e\u3059\u3002");
        int[] classicBitArray = b0_eQuBasis.getClassicBit();
        DJ.print("classicBitArray = ", classicBitArray);
        DJ.printS(1, "BellsInequality(1-5)\u2462", this);
        DJ._print("Code(1-5)\u2462\u91cf\u5b50\u30d3\u30c3\u30c8\u304c\u5404\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387");
        QuBit qbb0e = b0_eQuBasis.basisChang(targetQuBit);
        DJ.printF("qbb0e", qbb0e);
        DJ.print("\u3000\u57fa\u5e95b0_e\u306e\u7b2c\uff10,\uff11\u9805\u3001\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u5171\u306b(1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u5168\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb0e = qbb0e.getTransProb();
        DJ.printF("tpb0e", tpb0e);
        DJ.print("\u3000\u57fa\u5e95b0_e\u306e\u7b2c\uff10\u9805\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387P(b0_0)\u306f1/2\u3067\u3059\u3002");
        DJ.printS(1, "BellsInequality(1-5)\u2463", this);
        DJ._print("Code(1-5)\u2463\u7e54\u59eb\u306e\u6e2c\u5b9a\u306b\u3088\u308a\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8");
        DJ.print("\u30fb\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8qbb0e_0\u3092\u57fa\u5e95b0\u304b\u3089\u53d6\u308a\u51fa\u3057\u307e\u3059\u3002\n\u3000\u53d6\u308a\u51fa\u3059\u57fa\u5e95\u8ef8\u306f\u5438\u53ce\u8ef8\u3067\u3042\u308b\u7b2c\uff10\u57fa\u5e95\u8ef8\u306a\u306e\u3067\u3001\n\u3000\u30a4\u30f3\u30c7\u30c3\u30af\u30b9QuBasis.BASIS_0\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002");
        QuBit qbb0e_0 = b0QuBasis.getBasisQuBit(0);
        DJ.printF("qbb0e_0", qbb0e_0);
        DJ.printS(1, "BellsInequality(1-5)\u2464", this);
        DJ._print("Code(1-5)\u2464\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a");
        DJ.print("\u30fb\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\u5404\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("tryalNo = ", tryalNo);
        count = b1QuBasis.countQuBasis(qbb0e_0, tryalNo);
        DJ.print("count = ", count);
        DJ._print("\u30fb\u5404\u6e2c\u5b9a\u3067\u9077\u79fb\u3057\u305f\u57fa\u5e95\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        selectedQBArray = b1QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u30fb\u9077\u79fb\u3057\u305f\u57fa\u5e95\u8ef8\u306b\u5bfe\u5fdc\u3059\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u8868\u793a\u3057\u307e\u3059\u3002\n\u3000\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u53e4\u5178\u30d3\u30c3\u30c8\u306f0,1\u3067\u3059\u3002");
        classicBitArray = b1QuBasis.getClassicBit();
        DJ.print("classicBitArray = ", classicBitArray);
        DJ.printS(1, "BellsInequality(1-5)\u2465", this);
        DJ._print("Code(1-5)\u2465\u57fa\u5e95b1\u306e\u7b2c\uff11\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387");
        QuBit qbb0eb1 = b1QuBasis.basisChang(qbb0e_0);
        DJ.printF("qbb0eb1", qbb0eb1);
        DJ.print("\u3000\u5f66\u661f\u306e\u6e2c\u5b9a\u3067\u306f\u7b2c\uff11\u57fa\u5e95\u8ef8\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306a\u306e\u3067\u3001\n\u3000\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u304c\u9077\u79fb\u78ba\u7387\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ._print("\u30fb\u5404\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb0eb1 = qbb0eb1.getTransProb();
        DJ.printF("tpb0eb1", tpb0eb1);
        DJ.print("\u3000\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u3088\u308a\u9077\u79fb\u78ba\u7387\u306fP(b1_1) = (-\u221a3/2)^2 = 3/4");
        DJ.print("\u3000\u5de6\u8fbaP(b0_0, b1_1) = P(b0_0)*P(b1_1) = 1/2 * 3/4 = 3/8");
        DJ.printS(1, "BellsInequality(1-5)\u2466", this);
        DJ._print("Code(1-5)\u2466\u7e54\u59eb\u3068\u5f66\u661f\u304c\u540c\u6642\u306b\u6e2c\u5b9a\u3059\u308b\u5834\u5408");
        DJ.print("\u30fb\u57fa\u5e95b0QuBasis\u3068\u57fa\u5e95b1QuBasis\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\n\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b0_b1QuBasis\u3092\u751f\u6210");
        QuBasis b0_b1QuBasis = b0QuBasis.interactQuBasis(b1QuBasis);
        DJ.printF("b0_b1QuBasis", b0_b1QuBasis);
        DJ._print("\u30fb\u57fa\u5e95b0_b1\u306e\u5404\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387");
        QuBit qbb0_b1 = b0_b1QuBasis.basisChang(targetQuBit);
        DJ.printF("qbb0_b1", qbb0_b1);
        DJ.print("  \u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u304c[1 0]'\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8qbb0_b1\u306e\u7b2c\uff10\u9805\u3042\u308b\u3044\u306f\uff11\u9805\u306b\n  \u9077\u79fb\u3059\u308b\u78ba\u7387\u306e\u548c\u306f(1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u5168\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb0b1 = qbb0_b1.getTransProb();
        DJ.printF("tpb0b1", tpb0b1);
        DJ.print("\u3000\u57fa\u5e95b0_b1\u306e\u7b2c\uff10\u9805\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387P(0_0)\u306f1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u5de6\u8fba\u306e\u78ba\u7387P(b0_0, b1_1) \u306f\u3001\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57");
        Complex qbb0b1pa1 = qbb0_b1.getProbAmp(1);
        Complex tpb0b1pa1 = qbb0b1pa1.product(qbb0b1pa1);
        DJ.printF("P(b0_0, b1_1)", tpb0b1pa1);
        DJ._print("\u30fb\u57fa\u5e95b0\u3068b1\u3067\u540c\u6642\u306b\u6e2c\u5b9a\u3057\u305f\u5834\u5408\u306e\u9077\u79fb\u78ba\u7387P(b0, b1)");
        CompVec b0_b1CompVec = qbb0_b1.copyProbAmpVec();
        b0_b1CompVec.product(b0_b1CompVec);
        DJ.printF("P(b0, b1)", b0_b1CompVec);
        DJ.print("\u3000\u5de6\u8fbaP(b0_0, b1_1) = 3/8");
        DJ.printS(2, "BellsInequality(1-6)", this);
        DJ._print("Code(1-6)\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff10\u9805\u306e\u78ba\u7387P(b0_0, b2_1)");
        DJ.print("\u30fb\u7e54\u59eb\u304c\u5bfe\u8c61\u91cf\u5b50\u30d3\u30c3\u30c8targetQuBit\u3092\u57fa\u5e95b0_e\u3067\u6e2c\u5b9a\u3057\u3001\n\u3000\u3082\u3064\u308c\u72b6\u614b\u304c\u89e3\u6d88\u3057\u305f\u5358\u72ec\u306e\u91cf\u5b50\u30d3\u30c3\u30c8qbb0e_0\u304c\n\u3000\u5f97\u3089\u308c\u308b\u307e\u3067\u306e\u904e\u7a0b\u306f(1-5)\u306e\u2463\u307e\u3067\u3068\u540c\u69d8\u3067\u3059\u3002");
        DJ.print("Code(1-6)\u2460\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u57fa\u5e95b2\u3067\u6e2c\u5b9a");
        DJ._print("\u30fb\u5f66\u661f\u304c\u91cf\u5b50\u30d3\u30c3\u30c8qbb0e_0\u3092\u57fa\u5e95b2QuBasis\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8qbb0e_0\u3092\u57fa\u5e95b2QuBasis\u3067\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\n\u3000\u5404\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("tryalNo = ", tryalNo);
        count = b2QuBasis.countQuBasis(qbb0e_0, tryalNo);
        DJ.print("count = ", count);
        DJ.printS(1, "BellsInequality(1-6)\u2461", this);
        DJ.print("Code(1-6)\u2461\u5f66\u661f\u306e\u6e2c\u5b9a\u3067\u9077\u79fb\u3057\u305f\u57fa\u5e95");
        DJ._print("\u30fb\u5404\u6e2c\u5b9a\u3067\u9077\u79fb\u3057\u305f\u57fa\u5e95\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        selectedQBArray = b2QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u30fb\u9077\u79fb\u3057\u305f\u57fa\u5e95\u8ef8\u306b\u5bfe\u5fdc\u3059\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u8868\u793a\u3057\u307e\u3059\u3002\n\u3000\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u53e4\u5178\u30d3\u30c3\u30c8\u306f0,1\u3067\u3059\u3002");
        classicBitArray = b2QuBasis.getClassicBit();
        DJ.print("classicBitArray = ", classicBitArray);
        DJ.printS(1, "BellsInequality(1-6)\u2462", this);
        DJ.print("Code(1-6)\u2462\u57fa\u5e95b2\u306e\u7b2c\uff11\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387");
        QuBit qbb0eb2 = b2QuBasis.basisChang(qbb0e_0);
        DJ.printF("qbb0eb2", qbb0eb2);
        DJ.print("\u3000\u5f66\u661f\u306e\u6e2c\u5b9a\u3067\u306f\u900f\u904e\u8ef8\u65b9\u5411\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306a\u306e\u3067\u3001\n\u3000\u7b2c\uff11\u57fa\u5e95\u306b\u9077\u79fb\u3059\u308b\u5834\u5408\u306e\u78ba\u7387\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.print("\u3000\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u3088\u308a\u9077\u79fb\u78ba\u7387\u306fP(b2_1) = (-1/2)^2 = 1/4");
        DJ._print("\u30fb\u5404\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb0eb2 = qbb0eb2.getTransProb();
        DJ.printF("tpb0eb2", tpb0eb2);
        DJ.print("\u3000\u7b2c\uff11\u8981\u7d20\u3088\u308a\u9077\u79fb\u78ba\u7387\u306fP(b2_1) = 1/4");
        DJ.print("\u3000\u53f3\u8fbaP(b0_0, b2_1) = P(b0_0)*P(b2_1) = 1/2*1/4 = 1/8");
        DJ.printS(1, "BellsInequality(1-6)\u2463", this);
        DJ._print("Code(1-6)\u2463\u7e54\u59eb\u3068\u5f66\u661f\u304c\u540c\u6642\u306b\u6e2c\u5b9a\u3059\u308b\u5834\u5408");
        DJ.print("\u30fb\u57fa\u5e95b0\u3068b2\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u57fa\u5e95b0_2\u3092\u751f\u6210");
        QuBasis b0_b2QuBasis = b0QuBasis.interactQuBasis(b2QuBasis);
        DJ.printF("b0_b2QuBasis", b0_b2QuBasis);
        DJ._print("\u30fb\u57fa\u5e95b0_2\u306e\u5404\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387");
        QuBit qbb0_b2 = b0_b2QuBasis.basisChang(targetQuBit);
        DJ.printF("qbb0_b2", qbb0_b2);
        DJ.print("  \u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u304c[1 0]'\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8qbb0_b2\u306e\u7b2c\uff10\u9805\u3042\u308b\u3044\u306f\uff11\u9805\u306b\n  \u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u5171\u306b(1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u5168\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb0b2 = qbb0_b2.getTransProb();
        DJ.printF("tpb0b2", tpb0b2);
        DJ.print("\u3000\u57fa\u5e95b0_b2\u306e\u7b2c\uff10\u9805\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387P(0_0)\u306f1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u53f3\u8fbaP(b0_0, b2_1) \u306e\u78ba\u7387\u306f\u3001qbb0_b2\u306e\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57");
        Complex b0b2pa1 = qbb0_b2.getProbAmp(1);
        Complex tpb0b2pa1 = b0b2pa1.product(b0b2pa1);
        DJ.printF("P(b0_0, b2_1)", tpb0b2pa1);
        DJ._print("\u30fb\u57fa\u5e95b0\u3068b2\u3067\u540c\u6642\u306b\u6e2c\u5b9a\u3057\u305f\u5834\u5408\u306e\u3001\n  \u5404\u57fa\u5e95\u3078\u306e\u9077\u79fb\u78ba\u7387P(b0, b2) \u3092\u6c42\u3081\u307e\u3059\u3002");
        CompVec b0_b2CompVec = qbb0_b2.copyProbAmpVec();
        b0_b2CompVec.product(b0_b2CompVec);
        DJ.printF("P(b0, b2)", b0_b2CompVec);
        DJ.print("\u3000\u53f3\u8fba\u7b2c\uff10\u9805P(b0_0, b2_1) = 1/8");
        DJ.printS(2, "BellsInequality(1-7)", this);
        DJ._print("Code(1-7)\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff11\u9805\u306e\u78ba\u7387P(b2_0, b1_1)");
        DJ._print("Code(1-7)\u2460\u7e54\u59eb\u304c\u6e2c\u5b9a\u5bfe\u8c61\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u57fa\u5e95b2_e\u3067\u6e2c\u5b9a");
        DJ.printF("targetQuBit", targetQuBit);
        DJ.printF("b2_eQuBasis", b2_eQuBasis);
        QuBit qbb2e = b2_eQuBasis.basisChang(targetQuBit);
        DJ.printF("qbb2e", qbb2e);
        DJ.print("\u30fb\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u304c\uff10\u306b\u306a\u308b\u3001\u3059\u306a\u308f\u3061\n  \u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u8ef8\u304b\u7b2c\uff11\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u3001\n  (\u221a3/(2\u221a2))^2 + (1/2\u221a2)^2 = 3/8 +1/8 = 1/2 \u3067\u3059\u3002");
        DJ.printS(1, "BellsInequality(1-7)\u2461", this);
        DJ._print("Code(1-7)\u2461\u6e2c\u5b9a\u3067\u91cf\u5b50\u30d3\u30c3\u30c8\u304c\u5404\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387");
        double[][] tpb2e0 = qbb2e.getTransProb();
        DJ.printF("tpb2e0", tpb2e0);
        DJ._print("\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387P(b2_0)\u306f0.5\u3067\u3059\u3002");
        DJ.printS(1, "BellsInequality(1-7)\u2462", this);
        DJ.print("Code(1-7)\u2462\u7e54\u59eb\u306e\u6e2c\u5b9a\u306b\u3088\u308a\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8");
        DJ._print("\u30fb\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3057\u305f\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8qbb2e_0\u3092b2QuBasis\u304b\u3089\u53d6\u308a\u51fa\u3057\u307e\u3059\u3002");
        DJ.printF("b2QuBasis", b2QuBasis);
        DJ._print("\u30fb\u53d6\u308a\u51fa\u3059\u57fa\u5e95\u8ef8\u306f\u5438\u53ce\u8ef8\u3067\u3042\u308b\u7b2c\uff10\u57fa\u5e95\u8ef8\u306a\u306e\u3067\u3001\n\u3000\u30a4\u30f3\u30c7\u30c3\u30af\u30b9QuBasis.BASIS_0\u3067\u6307\u5b9a\u3057\u307e\u3059\u3002");
        QuBit qbb2e_0 = b2QuBasis.getBasisQuBit(0);
        DJ.printF("qbb2e_0", qbb2e_0);
        DJ.printS(1, "BellsInequality(1-7)\u2463", this);
        DJ._print("Code(1-7)\u2463\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a");
        DJ.printF("b1QuBasis", b1QuBasis);
        QuBit qbb2eb1 = b1QuBasis.basisChang(qbb2e_0);
        DJ.printF("qbb2eb1", qbb2eb1);
        DJ.print("\u3000\u5f66\u661f\u306e\u6e2c\u5b9a\u3067\u306f\u900f\u904e\u8ef8\u65b9\u5411\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306a\u306e\u3067\u3001\n\u3000\u7b2c\uff11\u57fa\u5e95\u306b\u9077\u79fb\u3059\u308b\u5834\u5408\u306e\u78ba\u7387\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.print("\u3000\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u3088\u308a\u9077\u79fb\u78ba\u7387\u306fP(b1_1) = (-1/2)^2 = 1/4");
        DJ.printS(1, "BellsInequality(1-7)\u2464", this);
        DJ._print("Code(1-7)\u2464\u57fa\u5e95b1\u306e\u7b2c\uff11\u57fa\u5e95\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387");
        double[][] tpb2eb1 = qbb2eb1.getTransProb();
        DJ.printF("tpb2eb1", tpb2eb1);
        DJ.print("\u3000\u7b2c\uff11\u8ef8\u3078\u306e\u9077\u79fb\u78ba\u7387\u306fP(b1_1) = 1/4");
        DJ.print("\u3000\u3088\u3063\u3066\u3001\u53f3\u8fba\u7b2c\uff11\u9805P(b2_0, b1_1) = 1/2 * 1/4 = 1/8");
        DJ._print("\u30fb\u4ee5\u4e0a\u306b\u3088\u308aBell\u306e\u4e0d\u7b49\u5f0f\u304c\u5c0e\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\n\n\u3000P(b0_0, b1_1) <= P(b0_0, b2_1) + P(b2_0, b1_1)");
        DJ.printS(2, "BellsInequality(1-7)\u2465", this);
        DJ._print("Code(1-7)\u2465\u7e54\u59eb\u3068\u5f66\u661f\u304c\u540c\u6642\u306b\u6e2c\u5b9a\u3059\u308b\u5834\u5408");
        DJ.print("\u30fb\u57fa\u5e95b2\u3068b1\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u57fa\u5e95b2_b1\u3092\u751f\u6210");
        QuBasis b2_b1QuBasis = b2QuBasis.interactQuBasis(b1QuBasis);
        DJ.printF("b2_b1QuBasis", b2_b1QuBasis);
        DJ._print("\u30fb\u57fa\u5e95b2_b1\u306e\u5404\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387");
        QuBit qbb2_b1 = b2_b1QuBasis.basisChang(targetQuBit);
        DJ.printF("qbb2_b1", qbb2_b1);
        DJ.print("  \u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u304c[1 0]'\u3078\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8qbb2_b1\u306e\u7b2c\uff10\u9805\u3042\u308b\u3044\u306f\uff11\u9805\u306b\n  \u9077\u79fb\u3059\u308b\u78ba\u7387\u306f(1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u5168\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] tpb2b1 = qbb2_b1.getTransProb();
        DJ.printF("tpb2b1", tpb2b1);
        DJ.print("\u3000\u57fa\u5e95b2_b1\u306e\u7b2c\uff10\u9805\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387P(2_0)\u306f1/2\u3067\u3059\u3002");
        DJ._print("\u30fb\u53f3\u8fba\u306e\u78ba\u7387P(b2_0, b1_1) \u306f\u3001\u7b2c\uff11\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57");
        Complex qbb2b1pa1 = qbb2_b1.getProbAmp(1);
        Complex tpb2b1pa1 = qbb2b1pa1.product(qbb2b1pa1);
        DJ.printF("P(b2_0, b1_1)", tpb2b1pa1);
        DJ._print("\u30fb\u57fa\u5e95b2\u3068b1\u3067\u540c\u6642\u306b\u6e2c\u5b9a\u3057\u305f\u5834\u5408\u306e\u3001\n  \u5404\u57fa\u5e95\u3078\u306e\u9077\u79fb\u78ba\u7387P(b2, b1) \u3092\u6c42\u3081\u307e\u3059\u3002");
        CompVec b2_b1CompVec = qbb2_b1.copyProbAmpVec();
        b2_b1CompVec.product(b2_b1CompVec);
        DJ.printF("P(b2, b1)", b2_b1CompVec);
        DJ.print("\u3000\u53f3\u8fba\u7b2c\uff11\u9805P(b2_0, b1_1) = 1/8");
        DJ.printS(2, "BellsInequality(1-8)", this);
        DJ.print("Code(1-8)\u6e2c\u5b9a\u7d50\u679c\u306e\u307e\u3068\u3081");
        DJ.print("Code(1-8)\u2460\u5404\u8fba\u306e\u78ba\u7387");
        double tpb0e_0 = tpb0e[0][0];
        double tpb0eb1_1 = tpb0eb1[1][0];
        double tpb0e_0b1_1 = tpb0e_0 * tpb0eb1_1;
        DJ.printF("\u30fb\u5de6\u8fba\u306e\u78ba\u7387 P(b0_0, b1_1)=", tpb0e_0b1_1);
        double tpb0eb2_1 = tpb0eb2[1][0];
        double tpb0e_0b2_1 = tpb0e_0 * tpb0eb2_1;
        DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff10\u9805\u78ba\u7387 P(b0_0, b2_1)=", tpb0e_0b2_1);
        double tpb2e0_0 = tpb2e0[0][0];
        double tpb2eb1_1 = tpb2eb1[1][0];
        double tpb2_0b1_1 = tpb2e0_0 * tpb2eb1_1;
        DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff11\u9805\u78ba\u7387 P(b2_0, b1_1)=", tpb2_0b1_1);
        DJ._print("\u30fb\u6e2c\u5b9a\u7d50\u679c");
        DJ.printF_("\u3000\u5de6\u8fba\u306e\u78ba\u7387 (", tpb0e_0b1_1);
        DJ.printF_(") >= \u53f3\u8fba\u306e\u78ba\u7387(", tpb0e_0b2_1 + tpb2_0b1_1);
        DJ.print(")");
        DJ._print("\u30fb\u3053\u306e\u3088\u3046\u306b\u3001\u57fa\u5e95\u306e\u56de\u8ee2\u89d2\u5ea6\u304c\uff13\uff10\u5ea6\u3068\uff16\uff10\u5ea6\u306e\u5834\u5408\u306f\u3001\n  \u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u304c\u6210\u7acb\u3057\u307e\u305b\u3093\u3002\n  \u5b9f\u969b\u306e\u5b9f\u9a13\u7d50\u679c\u306f\u91cf\u5b50\u8ad6\u7684\u306b\u5c0e\u304b\u308c\u305f\u7d50\u679c\u3068\u4e00\u81f4\u3057\u3001\n  \u5c40\u6240\u5b9f\u5728\u8ad6\u7684\u306b\u5c0e\u304b\u308c\u308b\u7d50\u679c\u306b\u306f\u306a\u308a\u307e\u305b\u3093\u3002");
        DJ.print("\u30fb\u305d\u306e\u7406\u7531\u306f\u5c40\u6240\u5b9f\u5728\u8ad6\u3067\u306e\u4eee\u5b9a\uff08\u5c40\u6240\u6027\u3068\u5b9f\u5728\u6027\uff09\u304c\u8aa4\u3063\u3066\u3044\u308b\n  \u70ba\u3068\u8003\u3048\u3089\u308c\u307e\u3059\u3002\u304a\u305d\u3089\u304f\u3001\u76f8\u5bfe\u8ad6\u7684\u306a\u5c40\u6240\u6027\u306f\u6e80\u305f\u3055\u308c\u3066\u3044\u308b\n  \u3067\u3057\u3087\u3046\u304b\u3089\u3001\u5b9f\u5728\u6027\u306b\u8aa4\u308a\u304c\u3042\u308b\u306e\u3067\u306f\u306a\u3044\u304b\u3068\u63a8\u6e2c\u3055\u308c\u307e\u3059\u3002");
        DJ.printS(1, "BellsInequality(1-8)\u2461", this);
        DJ._print("Code(1-8)\u2461\u8a08\u7b97\u904e\u7a0b\u306e\u78ba\u8a8d");
        DJ._print("    \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510     \n    \u2502      \u3000            (b0_0,b1_1,b2_1)                  \u2502     \n    \u2502                    \u5de6\u8fba\u30fb\u53f3\u8fba\u7b2c\uff11\u9805                  \u2502     \n    \u2502      \u3000          \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2510 \n\u250c\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510                \u2502\u3000\u2502 \n\u2502  \u2502      \u3000          \u2502                \u2502                \u2502  \u2502 \n\u2502  \u2502(b0_0,b1_0,b2_1)  \u2502(b0_0,b1_0,b2_0)\u2502(b0_0,b1_1,b2_0)\u2502  \u2502 \n\u2502  \u2502   \u53f3\u8fba\u7b2c\uff11\u9805     \u2502\u3000              \u2502\u5de6\u8fba\u30fb\u53f3\u8fba\u7b2c\uff12\u9805\u2502  \u2502 \n\u2502  \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518  \u2502 \n\u2502                      \u2502                \u2502  (b0_1,b1_1,b2_0)  \u2502 \n\u2502  (b0_1,b1_0,b2_1)    \u2502(b0_1,b1_0,b2_0)\u2502    \u53f3\u8fba\u7b2c\uff12\u9805      \u2502 \n\u2502                      \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518 \n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518                       ");
        DJ._print("\u30fb\u8a08\u7b97\u904e\u7a0b\u306e\u5909\u6570");
        DJ.printF("\u3000tpb0e_0", tpb0e_0);
        DJ.printF("\u3000tpb0eb1_1", tpb0eb1_1);
        DJ.printF("\u3000tpb0eb2_1", tpb0eb2_1);
        DJ.printF("\u3000tpb2e0_0", tpb2e0_0);
        DJ.printF("\u3000tpb2eb1_1", tpb2eb1_1);
        this.stepMode = true;
        DJ.printS(3, "BellsInequality(2)", this);
        DJ._print("Code(2)\u6e2c\u5b9a\u7528\u57fa\u5e95\u89d2\u5ea6\u03b8\u3092\u5909\u5316\u3055\u305b\u3066\u3001\u78ba\u7387\u3092\u30b0\u30e9\u30d5\u8868\u793a");
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        DJ._print("\u30fb\u30b0\u30e9\u30d5\u8868\u793a\u7528\u5909\u6570\u306e\u6e96\u5099\u3057\u307e\u3059\u3002");
        int iMax = 90 / this.delta + 1;
        if (this.epoch > iMax) {
            this.epoch = iMax;
        }
        DJ.print("\u3000\u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570\uff1aepoch = ", this.epoch);
        DJ.print("\u3000\u8a08\u7b97\u306e\u7e70\u308a\u8fd4\u3057\u56de\u6570\uff1aiMax = ", iMax);
        DJ.print("\u3000\u7d4c\u904e\u8868\u793a\u9593\u9694\uff1ainterval = ", this.interval);
        DJ.print("\u30fb\u57fa\u5e95b0\u306f\u5909\u5316\u3057\u306a\u3044\u306e\u3067\u30b0\u30e9\u30d5\u8868\u793a\u4e2d\u306f\u751f\u6210\u3057\u307e\u305b\u3093\u3002");
        DJ.printF("b0QuBasis", b0QuBasis);
        DJ._print("\u30fb\u57fa\u5e95b0\u3068\u6052\u7b49\u57fa\u5e95e\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001  \uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95b0_e\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("  \u57fa\u5e95b0_e\u3092 \u4f7f\u3046\u306e\u306f\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6e2c\u5b9a\u3059\u308b\u7e54\u59eb\u3060\u3051\u3067\u3059\u3002");
        DJ.printF("b0_eQuBasis", b0_eQuBasis);
        DJ.printS(0, "BellsInequality(2-1)", this);
        DJ._print("Code(2-1)\u78ba\u7387\u30b0\u30e9\u30d5\u306e\u63cf\u753b\u30eb\u30fc\u30d7\u958b\u59cb");
        int i = 0;
        while (i <= this.epoch) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            DJ.print_("===== \u89d2\u5ea6\u03b8\u3092\u5909\u3048\u3066\u8a08\u7b97\uff1ai=", i);
            int angle = i * this.delta;
            DJ.print_(", angle[deg]=", angle);
            theta = Math.PI * (double)angle / 180.0;
            DJ.printF_(", theta[rad]=", theta);
            DJ.print(" =====");
            b1QuBasis = new QuBasis(theta * 2.0);
            b2QuBasis = new QuBasis(theta);
            b2_eQuBasis = b2QuBasis.interactQuBasis(eQuBasis);
            qbb2e_0 = b2QuBasis.getBasisQuBit(0);
            qbb2e = b2_eQuBasis.basisChang(targetQuBit);
            qbb2eb1 = b1QuBasis.basisChang(qbb2e_0);
            tpb0e = qbb0e.getTransProb();
            tpb0e_0 = tpb0e[0][0];
            qbb0e_0 = b0QuBasis.getBasisQuBit(0);
            qbb0eb1 = b1QuBasis.basisChang(qbb0e_0);
            tpb0eb1 = qbb0eb1.getTransProb();
            tpb0eb1_1 = tpb0eb1[1][0];
            tpb0e_0b1_1 = tpb0e_0 * tpb0eb1_1;
            qbb0eb2 = b2QuBasis.basisChang(qbb0e_0);
            tpb0eb2 = qbb0eb2.getTransProb();
            tpb0eb2_1 = tpb0eb2[1][0];
            tpb0e_0b2_1 = tpb0e_0 * tpb0eb2_1;
            tpb2e0 = qbb2e.getTransProb();
            tpb2e0_0 = tpb2e0[0][0];
            tpb2eb1 = qbb2eb1.getTransProb();
            tpb2eb1_1 = tpb2eb1[1][0];
            tpb2_0b1_1 = tpb2e0_0 * tpb2eb1_1;
            DJ.printF_("\u3000\u5de6\u8fba\u306e\u78ba\u7387 (", tpb0e_0b1_1);
            double tpb0b2_b2b1 = tpb0e_0b2_1 + tpb2_0b1_1;
            if (tpb0e_0b1_1 > tpb0b2_b2b1) {
                DJ.printF_(") > (", tpb0b2_b2b1);
            } else {
                DJ.printF_(") <= (", tpb0b2_b2b1);
            }
            DJ.print(") \u53f3\u8fba\u306e\u78ba\u7387");
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                this.patternData0[0][i] = theta;
                this.patternData0[1][i] = tpb0e_0b1_1;
                this.patternData0[2][i] = tpb0b2_b2b1;
                this.patternData0[3][i] = 10.0;
                this.patternData0[4][i] = 10.0;
                this.patternData1[0][i] = theta;
                this.patternData1[1][i] = tpb0e_0b1_1;
                this.patternData1[2][i] = tpb0b2_b2b1;
                this.patternData1[3][i] = tpb0e_0b2_1;
                this.patternData1[4][i] = tpb2_0b1_1;
                this.updatePattern();
                BellsInequality bellsInequality = this;
                synchronized (bellsInequality) {
                    try {
                        this.wait(100L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            String id = Integer.toString(i + 1);
            DJ.printS(0, "BellsInequality(2-" + id + ")", this);
            ++i;
        }
        DJ._print("\u30b0\u30e9\u30d5\u8868\u793a\u7d42\u4e86");
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("\u91cf\u5b50\u8a08\u7b97\u306e\u5b8c\u4e86");
        DJ.print("BellsInequality.bellsInequality() =============================");
    }
}

