/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import quan.QuBasis;
import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.LogEditor;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;
import view.Console;
import view.GraphViewerLauncher;
import view.PatternViewerLauncher;
import view.PropertyViewer;
import view.SomViewerLauncher;

public class DJ {
    private static Console console;
    private static Random random;
    private static double average;
    private static double stdDev;
    private static final String DEFAULT_FILE_NAME = "DaiJa_text";

    static {
        average = 0.0;
        stdDev = 1.0;
    }

    public DJ(Console aConsole) {
        console = aConsole;
    }

    public static boolean checkDJ() {
        return console != null;
    }

    public static Random getRandom() {
        if (random == null) {
            random = new Random(314159265L);
        }
        return random;
    }

    public static ArrayList<Integer> permutationRandom(int num) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < num) {
            list.add(i);
            ++i;
        }
        Collections.shuffle(list);
        return list;
    }

    public static double sigmoid(double x) {
        double y = 1.0 / (1.0 + Math.exp(-x));
        return y;
    }

    public static double tanh(double x) {
        double y = Math.tanh(x);
        return y;
    }

    public static double reLU(double x) {
        double y = x <= 0.0 ? 0.0 : x;
        return y;
    }

    public static double leakyReLU(double x) {
        double y = x <= 0.0 ? 0.01 * x : x;
        return y;
    }

    public static int boolToInt(boolean b) {
        int i = b ? 1 : 0;
        return i;
    }

    public static double average(double[][] original) {
        double sum = 0.0;
        int row = original.length;
        int col = original[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                sum += original[i][j];
                ++j;
            }
            ++i;
        }
        int elementNumber = row * col;
        if (sum != 0.0 && elementNumber <= 0) {
            LogEditor.print("***** ERROR ***** DJ.avarage(): ");
            LogEditor.print("Element number of array <= 0.");
            return Double.NaN;
        }
        double average_ = sum / (double)elementNumber;
        return average_;
    }

    public static double stdDev(double[][] original) {
        double average_ = DJ.average(original);
        double sum = 0.0;
        int row = original.length;
        int col = original[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                double diff = original[i][j] - average_;
                sum += diff * diff;
                ++j;
            }
            ++i;
        }
        int elementNumber = row * col;
        if (sum != 0.0 && elementNumber <= 0) {
            LogEditor.print("***** ERROR ***** DJr.stdDev(): ");
            LogEditor.print("Element number of array <= 0.");
            return Double.NaN;
        }
        double stdDev_ = Math.sqrt(sum / (double)elementNumber);
        return stdDev_;
    }

    public static double[][] normalize(double[][] original) {
        average = DJ.average(original);
        stdDev = DJ.stdDev(original);
        if (stdDev <= Double.MIN_VALUE) {
            LogEditor.print("***** ERROR ***** DJ.normalize(): ");
            LogEditor.print("Standard Deviation is neary Zero.");
            return null;
        }
        int row = original.length;
        int col = original[0].length;
        double[][] normalizedArray = new double[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                normalizedArray[i][j] = (original[i][j] - average) / stdDev;
                ++j;
            }
            ++i;
        }
        return normalizedArray;
    }

    public static double[][] reshape(double[] original, int resultRow, int resultCol) {
        double[][] result = new double[resultRow][resultCol];
        int k = 0;
        int i = 0;
        while (i < resultRow) {
            int j = 0;
            while (j < resultCol) {
                result[i][j] = original[k];
                ++k;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double getSquareError(double[] y, double[] teach) {
        double sum = 0.0;
        int nodeNum = y.length;
        int k = 0;
        while (k < nodeNum) {
            double deff = y[k] - teach[k];
            sum += deff * deff;
            ++k;
        }
        return sum;
    }

    public static double getEntropyError(double[] y, double[] teach) {
        double sum = 0.0;
        int nodeNum = y.length;
        int k = 0;
        while (k < nodeNum) {
            sum -= teach[k] * Math.log(y[k] + 1.0E-7);
            ++k;
        }
        return sum;
    }

    public static void printL() {
        LogEditor.print("");
    }

    public static void printL(int num) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < num - 1) {
            sb.append("\n");
            ++i;
        }
        LogEditor.print(sb.toString());
    }

    public static void printS(int num, String comment, Task task) {
        if (task.stepMode) {
            LogEditor.print("\n### \u4e00\u6642\u505c\u6b62\u4e2d ### " + comment + "\uff08Run/Pause\u30dc\u30bf\u30f3\u3067\u5b9f\u884c\u518d\u958b\uff09");
            task.stepMode();
        }
        DJ.printL(num);
    }

    public static void print_(int val) {
        LogEditor.print_(Integer.toString(val));
    }

    public static void print(int val) {
        LogEditor.print(Integer.toString(val));
    }

    public static void _print_(int val) {
        LogEditor._print_(Integer.toString(val));
    }

    public static void _print(int val) {
        LogEditor._print(Integer.toString(val));
    }

    public static void print_(float val) {
        LogEditor.print_(Float.toString(val));
    }

    public static void print(float val) {
        LogEditor.print(Float.toString(val));
    }

    public static void _print_(float val) {
        LogEditor._print_(Float.toString(val));
    }

    public static void _print(float val) {
        LogEditor._print(Float.toString(val));
    }

    public static void print_(double val) {
        LogEditor.print_(Double.toString(val));
    }

    public static void print(double val) {
        LogEditor.print(Double.toString(val));
    }

    public static void _print_(double val) {
        LogEditor._print_(Double.toString(val));
    }

    public static void _print(double val) {
        LogEditor._print(Double.toString(val));
    }

    public static void printF_(double val) {
        LogEditor.print_(DJ.toFormat(val));
    }

    public static void printF(double val) {
        LogEditor.print(DJ.toFormat(val));
    }

    public static void _printF_(double val) {
        LogEditor._print_(DJ.toFormat(val));
    }

    public static void _printF(double val) {
        LogEditor._print(DJ.toFormat(val));
    }

    public static void print_(Complex val) {
        LogEditor.print_(val.toString());
    }

    public static void print(Complex val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(Complex val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(Complex val) {
        LogEditor._print(val.toString());
    }

    public static void print_(String message) {
        LogEditor.print_(message);
    }

    public static void print(String message) {
        LogEditor.print(message);
    }

    public static void _print_(String message) {
        LogEditor._print_(message);
    }

    public static void _print(String message) {
        LogEditor._print(message);
    }

    public static void print_(String message, String val) {
        LogEditor.print_(String.valueOf(message) + val);
    }

    public static void print(String message, String val) {
        LogEditor.print(String.valueOf(message) + val);
    }

    public static void _print_(String message, String val) {
        LogEditor._print_(String.valueOf(message) + val);
    }

    public static void _print(String message, String val) {
        LogEditor._print(String.valueOf(message) + val);
    }

    public static void print_(String message, int val) {
        LogEditor.print_(String.valueOf(message) + Integer.toString(val));
    }

    public static void print(String message, int val) {
        LogEditor.print(String.valueOf(message) + Integer.toString(val));
    }

    public static void _print_(String message, int val) {
        LogEditor._print_(String.valueOf(message) + Integer.toString(val));
    }

    public static void _print(String message, int val) {
        LogEditor._print(String.valueOf(message) + Integer.toString(val));
    }

    public static void print_(String message, float val) {
        LogEditor.print_(String.valueOf(message) + Float.toString(val));
    }

    public static void print(String message, float val) {
        LogEditor.print(String.valueOf(message) + Float.toString(val));
    }

    public static void _print_(String message, float val) {
        LogEditor._print_(String.valueOf(message) + Float.toString(val));
    }

    public static void _print(String message, float val) {
        LogEditor._print(String.valueOf(message) + Float.toString(val));
    }

    public static void print_(String message, double val) {
        LogEditor.print_(String.valueOf(message) + Double.toString(val));
    }

    public static void print(String message, double val) {
        LogEditor.print(String.valueOf(message) + Double.toString(val));
    }

    public static void _print_(String message, double val) {
        LogEditor._print_(String.valueOf(message) + Double.toString(val));
    }

    public static void _print(String message, double val) {
        LogEditor._print(String.valueOf(message) + Double.toString(val));
    }

    public static void printF_(String message, double val) {
        LogEditor.print_(DJ.toFormat(message, val));
    }

    public static void printF(String message, double val) {
        LogEditor.print(DJ.toFormat(message, val));
    }

    public static void _printF_(String message, double val) {
        LogEditor._print_(DJ.toFormat(message, val));
    }

    public static void _printF(String message, double val) {
        LogEditor._print(DJ.toFormat(message, val));
    }

    public static String toFormat(String label, double val) {
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F ");
        sb.append(DJ.toFormat(val));
        return sb.toString();
    }

    public static String toFormat(double val) {
        DecimalFormat fmt = new DecimalFormat("##.#####");
        String string = fmt.format(val);
        if (string.contains("-")) {
            return string;
        }
        return " " + string;
    }

    public static void print_(String message, Complex val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, Complex val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, Complex val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, Complex val) {
        LogEditor._print(val.toString(message));
    }

    public static void printF_(String message, Complex val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, Complex val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, Complex val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, Complex val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void print_(String message, int[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print(String message, int[] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, int[] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, int[] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString(int[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(array[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(String message, int[][] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print(String message, int[][] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, int[][] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, int[][] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString(int[][] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[[").append(array[0][0]);
        int j = 1;
        while (j < array[0].length) {
            sb.append(", ").append(array[0][j]);
            ++j;
        }
        sb.append("]\n");
        int i = 1;
        while (i < array.length) {
            sb.append("[").append(array[i][0]);
            int j2 = 1;
            while (j2 < array[i].length) {
                sb.append(", ").append(array[i][j2]);
                ++j2;
            }
            sb.append("]\n");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(String message, float[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print(String message, float[] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, float[] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, float[] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString(float[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(array[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(String message, float[][] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print(String message, float[][] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, float[][] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, float[][] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString(float[][] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[[").append(array[0][0]);
        int j = 1;
        while (j < array[0].length) {
            sb.append(", ").append(array[0][j]);
            ++j;
        }
        sb.append("]\n");
        int i = 1;
        while (i < array.length) {
            sb.append("[").append(array[i][0]);
            int j2 = 1;
            while (j2 < array[i].length) {
                sb.append(", ").append(array[i][j2]);
                ++j2;
            }
            sb.append("]\n");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(String message, double[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print__(String message, double[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString_(val));
    }

    public static void print(String message, double[] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, double[] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, double[] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString_(double[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=");
        sb.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(array[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String arrayToString(double[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[").append(array[0]);
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(array[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void printF_(String message, double[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void printF__(String message, double[] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToFormat_(val));
    }

    public static void printF(String message, double[] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void _printF_(String message, double[] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void _printF(String message, double[] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static String arrayToFormat_(double[] array) {
        DecimalFormat fmt = new DecimalFormat("##.#####");
        StringBuilder sb = new StringBuilder();
        sb.append("=");
        sb.append("[").append(fmt.format(array[0]));
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(fmt.format(array[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String arrayToFormat(double[] array) {
        DecimalFormat fmt = new DecimalFormat("##.#####");
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[").append(fmt.format(array[0]));
        int i = 1;
        while (i < array.length) {
            sb.append(", ").append(fmt.format(array[i]));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(String message, double[][] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void print(String message, double[][] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print_(String message, double[][] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static void _print(String message, double[][] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToString(val));
    }

    public static String arrayToString(double[][] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[[").append(array[0][0]);
        int j = 1;
        while (j < array[0].length) {
            sb.append(", ").append(array[0][j]);
            ++j;
        }
        sb.append("]\n");
        int i = 1;
        while (i < array.length) {
            sb.append("[").append(array[i][0]);
            int j2 = 1;
            while (j2 < array[i].length) {
                sb.append(", ").append(array[i][j2]);
                ++j2;
            }
            sb.append("]\n");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void printF_(String message, double[][] val) {
        LogEditor.print_(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void printF(String message, double[][] val) {
        LogEditor.print(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void _printF_(String message, double[][] val) {
        LogEditor._print_(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static void _printF(String message, double[][] val) {
        LogEditor._print(String.valueOf(message) + DJ.arrayToFormat(val));
    }

    public static String arrayToFormat(double[][] array) {
        DecimalFormat fmt = new DecimalFormat("##.#####");
        StringBuilder sb = new StringBuilder();
        sb.append("=\n");
        sb.append("[[").append(fmt.format(array[0][0]));
        int j = 1;
        while (j < array[0].length) {
            sb.append(", ").append(fmt.format(array[0][j]));
            ++j;
        }
        sb.append("]\n");
        int i = 1;
        while (i < array.length) {
            sb.append("[").append(fmt.format(array[i][0]));
            int j2 = 1;
            while (j2 < array[i].length) {
                sb.append(", ").append(fmt.format(array[i][j2]));
                ++j2;
            }
            sb.append("]\n");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void print_(Complex[] val) {
        LogEditor.print_(Complex.toString(val));
    }

    public static void print(Complex[] val) {
        LogEditor.print(Complex.toString(val));
    }

    public static void _print_(Complex[] val) {
        LogEditor._print_(Complex.toString(val));
    }

    public static void _print(Complex[] val) {
        LogEditor._print(Complex.toString(val));
    }

    public static void print_(Complex[] val, boolean orient) {
        LogEditor.print_(Complex.toString(val, orient));
    }

    public static void print(Complex[] val, boolean orient) {
        LogEditor.print(Complex.toString(val, orient));
    }

    public static void _print_(Complex[] val, boolean orient) {
        LogEditor._print_(Complex.toString(val, orient));
    }

    public static void _print(Complex[] val, boolean orient) {
        LogEditor._print(Complex.toString(val, orient));
    }

    public static void printF_(Complex[] val) {
        LogEditor.print_(Complex.toFormat(val));
    }

    public static void printF(Complex[] val) {
        LogEditor.print(Complex.toFormat(val));
    }

    public static void _printF_(Complex[] val) {
        LogEditor._print_(Complex.toFormat(val));
    }

    public static void _printF(Complex[] val) {
        LogEditor._print(Complex.toFormat(val));
    }

    public static void printF_(Complex[] val, boolean orient) {
        LogEditor.print_(Complex.toFormat(val, orient));
    }

    public static void printF(Complex[] val, boolean orient) {
        LogEditor.print(Complex.toFormat(val, orient));
    }

    public static void _printF_(Complex[] val, boolean orient) {
        LogEditor._print_(Complex.toFormat(val, orient));
    }

    public static void _printF(Complex[] val, boolean orient) {
        LogEditor._print(Complex.toFormat(val, orient));
    }

    public static void print_(String message, Complex[] val) {
        LogEditor.print_(Complex.toString(message, val));
    }

    public static void print(String message, Complex[] val) {
        LogEditor.print(Complex.toString(message, val));
    }

    public static void _print_(String message, Complex[] val) {
        LogEditor._print_(Complex.toString(message, val));
    }

    public static void _print(String message, Complex[] val) {
        LogEditor._print(Complex.toString(message, val));
    }

    public static void print_(String message, Complex[] val, boolean orient) {
        LogEditor.print_(Complex.toString(message, val, orient));
    }

    public static void print(String message, Complex[] val, boolean orient) {
        LogEditor.print(Complex.toString(message, val, orient));
    }

    public static void _print_(String message, Complex[] val, boolean orient) {
        LogEditor._print_(Complex.toString(message, val, orient));
    }

    public static void _print(String message, Complex[] val, boolean orient) {
        LogEditor._print(Complex.toString(message, val, orient));
    }

    public static void printF_(String message, Complex[] val) {
        LogEditor.print_(Complex.toFormat(message, val));
    }

    public static void printF(String message, Complex[] val) {
        LogEditor.print(Complex.toFormat(message, val));
    }

    public static void _printF_(String message, Complex[] val) {
        LogEditor._print_(Complex.toFormat(message, val));
    }

    public static void _printF(String message, Complex[] val) {
        LogEditor._print(Complex.toFormat(message, val));
    }

    public static void printF_(String message, Complex[] val, boolean orient) {
        LogEditor.print_(Complex.toFormat(message, val, orient));
    }

    public static void printF(String message, Complex[] val, boolean orient) {
        LogEditor.print(Complex.toFormat(message, val, orient));
    }

    public static void _printF_(String message, Complex[] val, boolean orient) {
        LogEditor._print_(Complex.toFormat(message, val, orient));
    }

    public static void _printF(String message, Complex[] val, boolean orient) {
        LogEditor._print(Complex.toFormat(message, val, orient));
    }

    public static void print_(Complex[][] val) {
        LogEditor.print_(Complex.toString(val));
    }

    public static void print(Complex[][] val) {
        LogEditor.print(Complex.toString(val));
    }

    public static void _print_(Complex[][] val) {
        LogEditor._print_(Complex.toString(val));
    }

    public static void _print(Complex[][] val) {
        LogEditor._print(Complex.toString(val));
    }

    public static void printF_(Complex[][] val) {
        LogEditor.print_(Complex.toFormat(val));
    }

    public static void printF(Complex[][] val) {
        LogEditor.print(Complex.toFormat(val));
    }

    public static void _printF_(Complex[][] val) {
        LogEditor._print_(Complex.toFormat(val));
    }

    public static void _printF(Complex[][] val) {
        LogEditor._print(Complex.toFormat(val));
    }

    public static void print_(String message, Complex[][] val) {
        LogEditor.print_(Complex.toString(message, val));
    }

    public static void print(String message, Complex[][] val) {
        LogEditor.print(Complex.toString(message, val));
    }

    public static void _print_(String message, Complex[][] val) {
        LogEditor._print_(Complex.toString(message, val));
    }

    public static void _print(String message, Complex[][] val) {
        LogEditor._print(Complex.toString(message, val));
    }

    public static void printF_(String message, Complex[][] val) {
        LogEditor.print_(Complex.toFormat(message, val));
    }

    public static void printF(String message, Complex[][] val) {
        LogEditor.print(Complex.toFormat(message, val));
    }

    public static void _printF_(String message, Complex[][] val) {
        LogEditor._print_(Complex.toFormat(message, val));
    }

    public static void _printF(String message, Complex[][] val) {
        LogEditor._print(Complex.toFormat(message, val));
    }

    public static void print_(CompVec val) {
        LogEditor.print_(val.toString());
    }

    public static void print(CompVec val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(CompVec val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(CompVec val) {
        LogEditor._print(val.toString());
    }

    public static void print_(boolean orient, CompVec val) {
        LogEditor.print_(val.toString(orient));
    }

    public static void print(boolean orient, CompVec val) {
        LogEditor.print(val.toString(orient));
    }

    public static void _print_(boolean orient, CompVec val) {
        LogEditor._print_(val.toString(orient));
    }

    public static void _print(boolean orient, CompVec val) {
        LogEditor._print(val.toString(orient));
    }

    public static void printF_(CompVec val) {
        LogEditor.print_(val.toFormat());
    }

    public static void printF(CompVec val) {
        LogEditor.print(val.toFormat());
    }

    public static void _printF_(CompVec val) {
        LogEditor._print_(val.toFormat());
    }

    public static void _printF(CompVec val) {
        LogEditor._print(val.toFormat());
    }

    public static void printF_(CompVec val, boolean orient) {
        LogEditor.print_(val.toFormat(orient));
    }

    public static void printF(CompVec val, boolean orient) {
        LogEditor.print(val.toFormat(orient));
    }

    public static void _printF_(CompVec val, boolean orient) {
        LogEditor._print_(val.toFormat(orient));
    }

    public static void _printF(CompVec val, boolean orient) {
        LogEditor._print(val.toFormat(orient));
    }

    public static void print_(String message, CompVec val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, CompVec val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, CompVec val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, CompVec val) {
        LogEditor._print(val.toString(message));
    }

    public static void print_(String message, CompVec val, boolean orient) {
        LogEditor.print_(val.toString(message, orient));
    }

    public static void print(String message, CompVec val, boolean orient) {
        LogEditor.print(val.toString(message, orient));
    }

    public static void _print_(String message, CompVec val, boolean orient) {
        LogEditor._print_(val.toString(message, orient));
    }

    public static void _print(String message, CompVec val, boolean orient) {
        LogEditor._print(val.toString(message, orient));
    }

    public static void printF_(String message, CompVec val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, CompVec val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, CompVec val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, CompVec val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void printF_(String message, CompVec val, boolean orient) {
        LogEditor.print_(val.toFormat(message, orient));
    }

    public static void printF(String message, CompVec val, boolean orient) {
        LogEditor.print(val.toFormat(message, orient));
    }

    public static void _printF_(String message, CompVec val, boolean orient) {
        LogEditor._print_(val.toFormat(message, orient));
    }

    public static void _printF(String message, CompVec val, boolean orient) {
        LogEditor._print(val.toFormat(message, orient));
    }

    public static void print_(CompMat val) {
        LogEditor.print_(val.toString());
    }

    public static void print(CompMat val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(CompMat val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(CompMat val) {
        LogEditor._print(val.toString());
    }

    public static void printF_(CompMat val) {
        LogEditor.print_(val.toFormat());
    }

    public static void printF(CompMat val) {
        LogEditor.print(val.toFormat());
    }

    public static void _printF_(CompMat val) {
        LogEditor._print_(val.toFormat());
    }

    public static void _printF(CompMat val) {
        LogEditor._print(val.toFormat());
    }

    public static void print_(String message, CompMat val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, CompMat val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, CompMat val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, CompMat val) {
        LogEditor._print(val.toString(message));
    }

    public static void printF_(String message, CompMat val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, CompMat val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, CompMat val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, CompMat val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void print_(QuGate val) {
        LogEditor.print_(val.toString());
    }

    public static void print(QuGate val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(QuGate val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(QuGate val) {
        LogEditor._print(val.toString());
    }

    public static void printF_(QuGate val) {
        LogEditor.print_(val.toFormat());
    }

    public static void printF(QuGate val) {
        LogEditor.print(val.toFormat());
    }

    public static void _printF_(QuGate val) {
        LogEditor._print_(val.toFormat());
    }

    public static void _printF(QuGate val) {
        LogEditor._print(val.toFormat());
    }

    public static void print_(String message, QuGate val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, QuGate val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, QuGate val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, QuGate val) {
        LogEditor._print(val.toString(message));
    }

    public static void printF_(String message, QuGate val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, QuGate val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, QuGate val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, QuGate val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void print_(QuBasis val) {
        LogEditor.print_(val.toString());
    }

    public static void print(QuBasis val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(QuBasis val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(QuBasis val) {
        LogEditor._print(val.toString());
    }

    public static void printF_(QuBasis val) {
        LogEditor.print_(val.toFormat());
    }

    public static void printF(QuBasis val) {
        LogEditor.print(val.toFormat());
    }

    public static void _printF_(QuBasis val) {
        LogEditor._print_(val.toFormat());
    }

    public static void _printF(QuBasis val) {
        LogEditor._print(val.toFormat());
    }

    public static void print_(String message, QuBasis val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, QuBasis val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, QuBasis val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, QuBasis val) {
        LogEditor._print(val.toString(message));
    }

    public static void printF_(String message, QuBasis val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, QuBasis val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, QuBasis val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, QuBasis val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void print_(QuBit val) {
        LogEditor.print_(val.toString());
    }

    public static void print(QuBit val) {
        LogEditor.print(val.toString());
    }

    public static void _print_(QuBit val) {
        LogEditor._print_(val.toString());
    }

    public static void _print(QuBit val) {
        LogEditor._print(val.toString());
    }

    public static void print_(QuBit val, boolean orient) {
        LogEditor.print_(val.toString(orient));
    }

    public static void print(QuBit val, boolean orient) {
        LogEditor.print(val.toString(orient));
    }

    public static void _print_(QuBit val, boolean orient) {
        LogEditor._print_(val.toString(orient));
    }

    public static void _print(QuBit val, boolean orient) {
        LogEditor._print(val.toString(orient));
    }

    public static void printF_(QuBit val) {
        LogEditor.print_(val.toFormat());
    }

    public static void printF(QuBit val) {
        LogEditor.print(val.toFormat());
    }

    public static void _printF_(QuBit val) {
        LogEditor._print_(val.toFormat());
    }

    public static void _printF(QuBit val) {
        LogEditor._print(val.toFormat());
    }

    public static void printF_(QuBit val, boolean orient) {
        LogEditor.print_(val.toFormat(orient));
    }

    public static void printF(QuBit val, boolean orient) {
        LogEditor.print(val.toFormat(orient));
    }

    public static void _printF_(QuBit val, boolean orient) {
        LogEditor._print_(val.toFormat(orient));
    }

    public static void _printF(QuBit val, boolean orient) {
        LogEditor._print(val.toFormat(orient));
    }

    public static void print_(String message, QuBit val) {
        LogEditor.print_(val.toString(message));
    }

    public static void print(String message, QuBit val) {
        LogEditor.print(val.toString(message));
    }

    public static void _print_(String message, QuBit val) {
        LogEditor._print_(val.toString(message));
    }

    public static void _print(String message, QuBit val) {
        LogEditor._print(val.toString(message));
    }

    public static void print_(String message, QuBit val, boolean orient) {
        LogEditor.print_(val.toString(message, orient));
    }

    public static void print(String message, QuBit val, boolean orient) {
        LogEditor.print(val.toString(message, orient));
    }

    public static void _print_(String message, QuBit val, boolean orient) {
        LogEditor._print_(val.toString(message, orient));
    }

    public static void _print(String message, QuBit val, boolean orient) {
        LogEditor._print(val.toString(message, orient));
    }

    public static void printF_(String message, QuBit val) {
        LogEditor.print_(val.toFormat(message));
    }

    public static void printF(String message, QuBit val) {
        LogEditor.print(val.toFormat(message));
    }

    public static void _printF_(String message, QuBit val) {
        LogEditor._print_(val.toFormat(message));
    }

    public static void _printF(String message, QuBit val) {
        LogEditor._print(val.toFormat(message));
    }

    public static void printF_(String message, QuBit val, boolean orient) {
        LogEditor.print_(val.toFormat(message, orient));
    }

    public static void printF(String message, QuBit val, boolean orient) {
        LogEditor.print(val.toFormat(message, orient));
    }

    public static void _printF_(String message, QuBit val, boolean orient) {
        LogEditor._print_(val.toFormat(message, orient));
    }

    public static void _printF(String message, QuBit val, boolean orient) {
        LogEditor._print(val.toFormat(message, orient));
    }

    public static void printList_(String message, ArrayList list) {
        StringBuilder sb = DJ.listToStringBuffer(list);
        LogEditor.print_(String.valueOf(message) + sb.toString());
    }

    public static void printList(String message, ArrayList list) {
        StringBuilder sb = DJ.listToStringBuffer(list);
        LogEditor.print(String.valueOf(message) + sb.toString());
    }

    public static void _printList_(String message, ArrayList list) {
        StringBuilder sb = DJ.listToStringBuffer(list);
        LogEditor._print_(String.valueOf(message) + sb.toString());
    }

    public static void _printList(String message, ArrayList list) {
        StringBuilder sb = DJ.listToStringBuffer(list);
        LogEditor._print(String.valueOf(message) + sb.toString());
    }

    public static StringBuilder listToStringBuffer(ArrayList list) {
        StringBuilder sb = new StringBuilder();
        sb.append(list.get(0));
        int i = 1;
        while (i < list.size()) {
            sb.append(", ").append(list.get(i));
            ++i;
        }
        return sb;
    }

    public static String stringArrayToString(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        sb.append(stringArray[0]);
        int i = 1;
        while (i < stringArray.length) {
            sb.append(", ").append(stringArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static PatternViewerLauncher pattern(int patternType0, double[][] patternArray0, String patternComment0) {
        PatternViewerLauncher patternVL = new PatternViewerLauncher(patternType0, patternArray0, patternComment0);
        return patternVL;
    }

    public static PatternViewerLauncher pattern(int patternType0, double[][] patternTensor0, String patternComment0, int patternType1, double[][] patternTensor1, String patternComment1) {
        PatternViewerLauncher patternVL = new PatternViewerLauncher(patternType0, patternTensor0, patternComment0, patternType1, patternTensor1, patternComment1);
        return patternVL;
    }

    public static PatternViewerLauncher pattern(int patternType0, double[][][] patternTensor0, String patternComment0, int patternType1, double[][] patternTensor1, String patternComment1) {
        PatternViewerLauncher patternVL = new PatternViewerLauncher(patternType0, patternTensor0, patternComment0, patternType1, patternTensor1, patternComment1);
        return patternVL;
    }

    public static PatternViewerLauncher pattern(int patternType0, double[][][] patternTensor0, String patternComment0, int patternType1, double[][][] patternTensor1, String patternComment1) {
        PatternViewerLauncher patternVL = new PatternViewerLauncher(patternType0, patternTensor0, patternComment0, patternType1, patternTensor1, patternComment1);
        return patternVL;
    }

    public static GraphViewerLauncher graph(int epoch, int interval, String[] dataName, double[] graphData) {
        GraphViewerLauncher graphVL = new GraphViewerLauncher(epoch, interval, dataName, graphData);
        return graphVL;
    }

    public static SomViewerLauncher launchSomViewer(int somType, String somComment) {
        SomViewerLauncher somViewerLauncher = new SomViewerLauncher(somType, somComment);
        return somViewerLauncher;
    }

    public static PropertyViewer getPropertyViewer() {
        return console.getPropertyViewer();
    }
}

