/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import util.LogEditor;
import util.TimeStamp;

public class FileAccessor {
    private static FileAccessor fileAccessor;
    private static Frame parent;
    static final String FILE_NAME = "Daija-";
    static final String EXTENSION = "ini";
    BufferedWriter fileWriter;
    BufferedReader fileReader;
    String fileName;
    String fileFullName;
    String fileDirectory;
    File fileId;
    boolean continueFlag;

    public static FileAccessor createFileAccessor() {
        if (fileAccessor == null) {
            fileAccessor = new FileAccessor();
        }
        return fileAccessor;
    }

    public static FileAccessor createFileAccessor(Frame parentFrame) {
        if (fileAccessor == null) {
            fileAccessor = new FileAccessor(parentFrame);
        } else {
            parent = parentFrame;
        }
        return fileAccessor;
    }

    private FileAccessor() {
    }

    private FileAccessor(Frame parentFrame) {
        parent = parentFrame;
    }

    private boolean openFileReader(String targetFileFullName) {
        if (targetFileFullName == null) {
            LogEditor.addLog("FileAccessor.openFileReader(): TargetFileFullName is null");
            return false;
        }
        try {
            this.fileId = new File(targetFileFullName);
            this.fileReader = new BufferedReader(new FileReader(this.fileId));
            this.fileFullName = targetFileFullName;
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.openFileReader(): Failed to open [" + targetFileFullName + "]." + "\n" + "IOException = " + ex.toString());
            return false;
        }
        return true;
    }

    private boolean openFileWriter(String targetFileFullName) {
        try {
            this.fileId = new File(targetFileFullName);
            this.fileWriter = new BufferedWriter(new FileWriter(this.fileId));
            this.fileFullName = targetFileFullName;
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.openFileWriter(): Failed to open [" + targetFileFullName + "]." + "\n" + "IOException = " + ex.toString());
            return false;
        }
        return true;
    }

    private boolean closeFileReader() {
        try {
            if (this.fileReader != null) {
                this.fileReader.close();
            }
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.closeFileReader():Failed to close [" + this.fileFullName + "]." + "\n" + "IOException = " + ex.toString());
            return false;
        }
        return true;
    }

    private boolean closeFileWriter() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.closeFileWriter():Failed to close [" + this.fileFullName + "]." + "\n" + "IOException = " + ex.toString());
            return false;
        }
        return true;
    }

    public boolean loadTextFile(ArrayList<String> textBuffer, String newFileName) {
        this.fileName = newFileName;
        if (parent == null) {
            this.fileFullName = this.fileName;
        } else {
            FileDialog fd = new FileDialog(parent, "Read Text File", 0);
            fd.setFile(this.fileName);
            fd.setVisible(true);
            this.fileName = fd.getFile();
            if (this.fileName == null) {
                LogEditor.addLog("FileAccessor.readTextFile(): Failed to get file name.\nFilename = " + this.fileName);
                return false;
            }
            this.fileDirectory = fd.getDirectory();
            this.fileFullName = String.valueOf(this.fileDirectory) + this.fileName;
        }
        return this.readTextFile(textBuffer, this.fileFullName);
    }

    public boolean getTextFile(ArrayList<String> textBuffer, String newFileName) {
        this.fileName = newFileName;
        this.fileFullName = String.valueOf(this.fileDirectory) + this.fileName;
        return this.readTextFile(textBuffer, this.fileFullName);
    }

    public boolean readTextFile(ArrayList<String> textBuffer, String newFileName) {
        this.fileName = newFileName;
        this.fileFullName = newFileName;
        boolean fileReadFlag = false;
        StringBuilder stringBuffer = new StringBuilder();
        if (!this.openFileReader(this.fileFullName)) {
            LogEditor.addLog("FileAccessor.readTextFile(): Failed to open [" + this.fileFullName + "].");
            return false;
        }
        try {
            String buf;
            while ((buf = this.fileReader.readLine()) != null) {
                textBuffer.add(buf);
            }
            if (!this.closeFileReader()) {
                LogEditor.addLog("FileAccessor.readTextFile(): Failed to close [" + this.fileFullName + "].");
                return false;
            }
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.readTextFile(): Failed to read [" + this.fileFullName + "].\n" + "IOException = " + ex.toString());
            return false;
        }
        return true;
    }

    public boolean saveTextFile(ArrayList<String> textBuffer, String newFileName) {
        this.fileName = String.valueOf(newFileName) + "_" + TimeStamp.getDateAndTime() + "." + EXTENSION;
        if (parent != null) {
            FileDialog fd = new FileDialog(parent, "Save Text File", 1);
            fd.setFile(this.fileName);
            fd.setVisible(true);
            this.fileName = fd.getFile();
            if (this.fileName != null) {
                this.fileDirectory = fd.getDirectory();
                this.fileFullName = String.valueOf(this.fileDirectory) + this.fileName;
            } else {
                LogEditor.addLog("FileAccessor.writeTextFile(): File name is null.");
                return false;
            }
        }
        return this.writeTextFile(textBuffer, this.fileFullName);
    }

    public boolean writeTextFile(ArrayList<String> textBuffer) {
        if (parent == null) {
            this.fileFullName = "Daija-.ini";
        } else {
            FileDialog fd = new FileDialog(parent, "Write Text File", 1);
            this.fileName = FILE_NAME + TimeStamp.getDateAndTime() + "." + EXTENSION;
            fd.setFile(this.fileName);
            fd.setVisible(true);
            this.fileName = fd.getFile();
            if (this.fileName == null) {
                LogEditor.addLog("FileAccessor.writeTextFile(): Failed to get file name.");
                return false;
            }
            this.fileDirectory = fd.getDirectory();
            this.fileFullName = String.valueOf(this.fileDirectory) + this.fileName;
        }
        return this.writeTextFile(textBuffer, this.fileFullName);
    }

    public boolean writeTextFile(ArrayList<String> textBuffer, String newFileName) {
        if (!this.openFileWriter(newFileName)) {
            return false;
        }
        try {
            ListIterator<String> anEnum = textBuffer.listIterator();
            while (anEnum.hasNext()) {
                this.fileWriter.write((String)anEnum.next());
            }
            if (!this.closeFileWriter()) {
                return false;
            }
        }
        catch (IOException ex) {
            LogEditor.addLog("FileAccessor.writeTextFile(): Failed to access [" + newFileName + "].\n" + "IOException = " + ex.toString());
            return false;
        }
        LogEditor.addLog("FileAccessor.writeTextFile(): [" + this.fileFullName + "] is saved.");
        return true;
    }
}

