/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import task.Task;
import util.FileAccessor;
import util.TimeStamp;
import view.Console;
import view.PropertyViewer;

public class LogEditor {
    Task task;
    private static Console console;
    private static PropertyViewer propertyViewer;
    private static FileAccessor fileAccessor;
    private static final String DEFAULT_FILE_NAME = "DaiJa_text";
    private static final String FILE_NAME = "Daija_Log";
    private static final String EXTENSION = "dat";
    private static final String LOG_FILE_NAME = "Daija_Log.dat";
    private static final ArrayList<String> READ_TEXT_BUFFER;
    private static final ArrayList<String> WRITE_TEXT_BUFFER;
    public static final boolean LOG_ACTIVE = true;
    public static final boolean LOG_STOP = false;
    private static boolean logActiveFlag;
    public static final int ITEM_ERROR = 0;
    public static final int ITEM_MESSAGE = 1;
    private static final boolean[] LOG_STATE;
    public static boolean ERR;
    public static boolean MSG;
    private static final boolean NG = false;
    private static final boolean OK = true;

    static {
        READ_TEXT_BUFFER = new ArrayList(100);
        WRITE_TEXT_BUFFER = new ArrayList(100);
        logActiveFlag = false;
        LOG_STATE = new boolean[2];
    }

    public LogEditor(Console aConsole) {
        console = aConsole;
        fileAccessor = FileAccessor.createFileAccessor(console);
        this.initializelogStatus();
        this.updateLogStatusFlag();
    }

    private void initializelogStatus() {
        LogEditor.LOG_STATE[0] = true;
        LogEditor.LOG_STATE[1] = true;
    }

    private void updateLogStatusFlag() {
        ERR = LOG_STATE[0];
        MSG = LOG_STATE[1];
    }

    private void resetLogStatusFlag() {
        ERR = false;
        MSG = false;
        LogEditor.addLog("LogEditor.resetLogStatusFlag(): LogStatusFlags are reset.");
    }

    public static void addLog(String message) {
        if (ERR || MSG) {
            WRITE_TEXT_BUFFER.add(String.valueOf(message) + "\n");
            if (console != null) {
                console.writeToTextArea(String.valueOf(message) + "\n");
            }
        }
    }

    public static void print_(String message) {
        if (ERR || MSG) {
            WRITE_TEXT_BUFFER.add(message);
            if (console != null) {
                console.writeToTextArea(message);
            }
        }
    }

    public static void print(String message) {
        LogEditor.addLog(message);
    }

    public static void _print_(String message) {
        if (ERR || MSG) {
            WRITE_TEXT_BUFFER.add("\n" + message);
            if (console != null) {
                console.writeToTextArea("\n" + message);
            }
        }
    }

    public static void _print(String message) {
        LogEditor.addLog("\n" + message);
    }

    public void setLogActive() {
        if (logActiveFlag) {
            this.updateLogStatusFlag();
            LogEditor.addLog("LogEditor.setLogActive(): Logging is set.");
            logActiveFlag = false;
        } else {
            LogEditor.addLog("LogEditor.setLogActive(): Logging is going to reset.");
            this.resetLogStatusFlag();
            logActiveFlag = true;
        }
    }

    public boolean dumpLog() {
        if (fileAccessor == null) {
            LogEditor.addLog("LogEditor.dumpLog(): fileAccessor is null.");
            LogEditor.addLog("LogEditor.dumpLog(): Log is not dumped.");
            return false;
        }
        String logFileName = FILE_NAME + TimeStamp.getDateAndTime() + "." + EXTENSION;
        fileAccessor.writeTextFile(WRITE_TEXT_BUFFER, logFileName);
        WRITE_TEXT_BUFFER.clear();
        LogEditor.addLog("LogEditor.dumpLog(): Log is dumped.");
        return true;
    }

    public boolean loadLog() {
        if (console != null) {
            LogEditor.addLog("LogEditor.loadLog(): Console is null.");
            LogEditor.addLog("LogEditor.loadLog(): Log is not loaded.");
            return false;
        }
        if (fileAccessor == null) {
            LogEditor.addLog("LogEditor.loadLog(): fileAccessor is null.");
            LogEditor.addLog("LogEditor.loadLog(): Log is not loaded.");
            return false;
        }
        READ_TEXT_BUFFER.clear();
        if (fileAccessor.loadTextFile(READ_TEXT_BUFFER, LOG_FILE_NAME)) {
            Iterator<String> anIterator = READ_TEXT_BUFFER.iterator();
            while (anIterator.hasNext()) {
                console.writeToTextArea(String.valueOf(anIterator.next()) + "\n");
            }
            LogEditor.addLog("LogEditor.loadLog(): Log is loaded.");
            return true;
        }
        LogEditor.addLog("LogEditor.loadLog(): Loading is failed.");
        LogEditor.addLog("LogEditor.loadLog(): Log is not loaded.");
        return false;
    }

    public void clearLog() {
        WRITE_TEXT_BUFFER.clear();
        READ_TEXT_BUFFER.clear();
        LogEditor.addLog("LogEditor.clearLog(): Log buffer is cleared.");
    }

    public static ArrayList<String> loadText() {
        return LogEditor.loadText(DEFAULT_FILE_NAME);
    }

    public static ArrayList<String> loadText(String fileName) {
        if (fileAccessor == null) {
            LogEditor.addLog("LogEditor.loadText(): fileAccessor is null.");
            LogEditor.addLog("LogEditor.loadText(): Text file is not loaded.");
            console.setVisible(true);
            return null;
        }
        READ_TEXT_BUFFER.clear();
        if (fileAccessor.loadTextFile(READ_TEXT_BUFFER, fileName)) {
            LogEditor.addLog("LogEditor.loadLog(): Text file is loaded.");
            return READ_TEXT_BUFFER;
        }
        LogEditor.addLog("LogEditor.loadLog(): Loading is failed.");
        LogEditor.addLog("LogEditor.loadLog(): Text file is not loaded.");
        return null;
    }

    public static ArrayList<String> getText(String fileName) {
        READ_TEXT_BUFFER.clear();
        if (fileAccessor.getTextFile(READ_TEXT_BUFFER, fileName)) {
            LogEditor.addLog("LogEditor.loadLog(): Text file is loaded.");
            return READ_TEXT_BUFFER;
        }
        LogEditor.addLog("LogEditor.loadLog(): Loading is failed.");
        LogEditor.addLog("LogEditor.loadLog(): Text file is not loaded.");
        return null;
    }

    public static boolean saveText(ArrayList<String> elementList) {
        return LogEditor.saveText(elementList, DEFAULT_FILE_NAME);
    }

    public static boolean saveText(ArrayList<String> elementList, String fileName) {
        if (fileAccessor == null) {
            LogEditor.addLog("LogEditor.saveText(): fileAccessor is null.");
            LogEditor.addLog("LogEditor.saveText(): Text file is not saved.");
            return false;
        }
        fileAccessor.writeTextFile(elementList, fileName);
        LogEditor.addLog("LogEditor.saveText(): Text file is saved.");
        return true;
    }

    public static int[][] loadIntData(String file) {
        ArrayList<String> stringList = LogEditor.getText(file);
        int rowNum = stringList.size();
        if (rowNum < 1) {
            LogEditor.print("***** ERROR ***** LogEditor.loadIntData():");
            LogEditor.print(" Number of row: " + rowNum + " < 1");
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String lineString = stringList.get(0);
        LogEditor.loadIntLine(lineString, arrayList);
        int columnNum = arrayList.size();
        int[][] intArray = new int[rowNum][columnNum];
        int j = 1;
        while (j < columnNum) {
            intArray[0][j] = arrayList.get(j);
            ++j;
        }
        int i = 1;
        while (i < rowNum) {
            lineString = stringList.get(i);
            arrayList.clear();
            LogEditor.loadIntLine(lineString, arrayList);
            int j2 = 1;
            while (j2 < columnNum) {
                intArray[i][j2] = arrayList.get(j2);
                ++j2;
            }
            ++i;
        }
        return intArray;
    }

    private static void loadIntLine(String lineString, ArrayList<Integer> arrayList) {
        StringTokenizer lineToken = new StringTokenizer(lineString, ",");
        while (lineToken.hasMoreTokens()) {
            String nextStr = lineToken.nextToken().trim();
            if ("".equals(nextStr)) {
                LogEditor.print("***** WARNING ***** LogEditor.loadIntLine():");
                LogEditor.print(" Next token in a lineString is void.");
                continue;
            }
            int d = Integer.parseInt(nextStr);
            arrayList.add(d);
        }
    }

    public static double[][] loadData(String file) {
        ArrayList<String> stringList = LogEditor.getText(file);
        int rowNum = stringList.size();
        if (rowNum < 1) {
            LogEditor.print("***** ERROR ***** LogEditor.loadData():");
            LogEditor.print(" Number of row: " + rowNum + " < 1");
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String lineString = stringList.get(0);
        LogEditor.loadLine(lineString, arrayList);
        int columnNum = arrayList.size();
        double[][] doubletArray = new double[rowNum][columnNum];
        int j = 1;
        while (j < columnNum) {
            doubletArray[0][j] = arrayList.get(j);
            ++j;
        }
        int i = 1;
        while (i < rowNum) {
            lineString = stringList.get(i);
            arrayList.clear();
            LogEditor.loadLine(lineString, arrayList);
            int j2 = 1;
            while (j2 < columnNum) {
                doubletArray[i][j2] = arrayList.get(j2);
                ++j2;
            }
            ++i;
        }
        return doubletArray;
    }

    private static void loadLine(String lineString, ArrayList<Double> arrayList) {
        StringTokenizer lineToken = new StringTokenizer(lineString, ",");
        while (lineToken.hasMoreTokens()) {
            String nextStr = lineToken.nextToken().trim();
            if ("".equals(nextStr)) {
                LogEditor.print("***** WARNING ***** LogEditor.loadtxt():");
                LogEditor.print(" Next token in a lineString is void.");
                continue;
            }
            double d = Double.parseDouble(nextStr);
            arrayList.add(d);
        }
    }

    public static void saveData(String[] text, double[][] data, String fileName) {
        ArrayList<String> buf = new ArrayList<String>(text.length + data.length);
        int i = 0;
        while (i < text.length) {
            buf.add(String.valueOf(text[i]) + "\r\n");
            ++i;
        }
        i = 0;
        while (i < data.length) {
            StringBuilder str = new StringBuilder();
            str.append(data[i][0]);
            int j = 1;
            while (j < data[0].length) {
                str.append(",").append(data[i][j]);
                ++j;
            }
            buf.add(String.valueOf(str.toString()) + "\r\n");
            ++i;
        }
        LogEditor.saveText(buf, fileName);
    }
}

