/*
 * Decompiled with CFR 0.152.
 */
package util.comp;

import java.util.Random;
import quan.QuBit;
import util.DJ;
import util.comp.CompVec;
import util.comp.Complex;

public class CompMat {
    public static long RANDOM_SEED = 314L;
    private Complex[][] complexMatrix;

    public CompMat() {
    }

    public CompMat(int row, int col) {
        this.complexMatrix = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j] = new Complex();
                ++j;
            }
            ++i;
        }
    }

    public CompMat(int order) {
        this.complexMatrix = new Complex[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                this.complexMatrix[i][j] = new Complex(0.0, 0.0);
                ++j;
            }
            this.complexMatrix[i][i] = new Complex(1.0, 0.0);
            ++i;
        }
    }

    public CompMat(int order, Complex element) {
        this.complexMatrix = new Complex[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                this.complexMatrix[i][j] = element.copyComplex();
                ++j;
            }
            ++i;
        }
    }

    public CompMat(Complex[] dataArray) {
        int length = dataArray.length;
        int order = (int)Math.sqrt(length);
        this.complexMatrix = new Complex[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                this.complexMatrix[i][j] = dataArray[i * order + j];
                ++j;
            }
            ++i;
        }
    }

    public CompMat(Complex[][] dataMat) {
        this.complexMatrix = dataMat;
    }

    public CompMat(QuBit[] quBitArray) {
        int length = quBitArray.length;
        this.complexMatrix = new Complex[length][length];
        int i = 0;
        while (i < length) {
            QuBit aQuBit = quBitArray[i];
            int j = 0;
            while (j < length) {
                this.complexMatrix[j][i] = aQuBit.getProbAmp(j);
                ++j;
            }
            ++i;
        }
    }

    public CompMat(int row, int col, long randomSeed) {
        Random random = new Random(randomSeed);
        random = new Random(randomSeed);
        this.complexMatrix = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j] = new Complex(random.nextDouble(), 0.0);
                ++j;
            }
            ++i;
        }
    }

    public double getReal(int row, int col) {
        return this.complexMatrix[row][col].getReal();
    }

    public void setReal(int row, int col, double real) {
        this.complexMatrix[row][col].setReal(real);
    }

    public double getImag(int row, int col) {
        return this.complexMatrix[row][col].getImag();
    }

    public void setImag(int row, int col, double imag) {
        this.complexMatrix[row][col].setImag(imag);
    }

    public Complex getComp(int row, int col) {
        return this.complexMatrix[row][col];
    }

    public Complex copyComp(int row, int col) {
        return this.complexMatrix[row][col].copyComplex();
    }

    public void setComp(int row, int col, double real, double imag) {
        this.complexMatrix[row][col].setComplex(real, imag);
    }

    public void setComp(int row, int col, Complex element) {
        this.complexMatrix[row][col].setComplex(element);
    }

    public CompVec getRow(int rowNumber) {
        CompVec row = new CompVec(this.complexMatrix[rowNumber]);
        return row;
    }

    public CompVec copyColumn(int colNumber) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompVec resultVec = new CompVec(row);
        int i = 0;
        while (i < row) {
            Complex aComp = this.complexMatrix[i][colNumber];
            resultVec.setComp(i, aComp.getReal(), aComp.getImag());
            ++i;
        }
        return resultVec;
    }

    public Complex[][] getMatrix() {
        return this.complexMatrix;
    }

    public CompMat copyCompMat() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _compMat = new CompMat(row, col);
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                _compMat.setComp(i, j, this.complexMatrix[i][j]);
                ++j;
            }
            ++i;
        }
        return _compMat;
    }

    public Complex[][] copyMatrix() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _compMat = new CompMat(row, col);
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                _compMat.setComp(i, j, this.complexMatrix[i][j]);
                ++j;
            }
            ++i;
        }
        return _compMat.complexMatrix;
    }

    public void setArray(Complex[][] complexMatrix) {
        int row = complexMatrix.length;
        int col = complexMatrix[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j].setComplex(complexMatrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public int rowNumber() {
        return this.complexMatrix.length;
    }

    public int colNumber() {
        return this.complexMatrix[0].length;
    }

    public void product(double real) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j].mul(real);
                ++j;
            }
            ++i;
        }
    }

    public void product(Complex comp) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j].mul(comp);
                ++j;
            }
            ++i;
        }
    }

    public void product(CompMat operand) {
        int row = this.complexMatrix.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of row (=" + row + ") is less than one.");
            return;
        }
        int col = this.complexMatrix[0].length;
        if (col < 1) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of col (=" + col + ") is less than one.");
            return;
        }
        int operandRow = operand.rowNumber();
        if (operandRow != row) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of row is not same.\n target matrix row is " + row + ", \n" + " operand matrix length is " + operandRow + ".");
            return;
        }
        int operandCol = operand.colNumber();
        if (operandCol != col) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of col is not same.\n target matrix col is " + col + ", \n" + " operand matrix length is " + operandCol + ".");
            return;
        }
        Complex[][] operandMatrix = operand.getMatrix();
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                this.complexMatrix[i][j].mul(operandMatrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public CompMat conjugate() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _conjugate = new CompMat(col, row);
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                _conjugate.setComp(j, i, this.complexMatrix[i][j].conjugate());
                ++j;
            }
            ++i;
        }
        return _conjugate;
    }

    public CompVec innerProduct(CompVec operand) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int operandlength = operand.length();
        if (row != operandlength) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompMat)\n Element numbers are not same. target row number is " + row + ", " + " operand length is " + operandlength + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        CompVec _innerProduct = new CompVec(col);
        int i = 0;
        while (i < col) {
            int k = 0;
            while (k < row) {
                Complex conj = _conjugate.copyComp(i, k);
                conj.mul(operand.getComp(k));
                _innerProduct.getComp(i).add(conj);
                ++k;
            }
            ++i;
        }
        return _innerProduct;
    }

    public CompMat innerProduct(CompMat operand) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int operandRow = operand.rowNumber();
        int operandCol = operand.colNumber();
        if (row != operandRow) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompMat)\n Element numbers are not same. target row number is " + row + ", " + " operand row number is " + operandRow + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        CompMat _innerProduct = new CompMat(col, operandCol);
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < operandCol) {
                int k = 0;
                while (k < row) {
                    Complex conj = _conjugate.copyComp(i, k);
                    conj.mul(operand.getComp(k, j));
                    _innerProduct.getComp(i, j).add(conj);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return _innerProduct;
    }

    public QuBit innerProduct(QuBit operand) {
        int operandLength;
        int row = this.complexMatrix.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** CompMat.innerProduct(QuBit operand)\n target row number is less than one.");
            return null;
        }
        int col = this.complexMatrix[0].length;
        if (col % 2 != 0) {
            DJ.print("***** ERROR ***** CompMat.innerProduct(QuBit operand)\n target column number is (" + col + ") is not even number.");
        }
        if (row != (operandLength = operand.getProbAmpLength())) {
            DJ.print("***** ERROR ***** Complex.innerProduct(QuBit operand)\n Element numbers are not same.\n target row number is " + row + ", \n" + " operand length is " + operandLength + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        QuBit resultQB = new QuBit(col / 2);
        CompVec _innerProduct = resultQB.getProbAmp();
        int i = 0;
        while (i < col) {
            int k = 0;
            while (k < operandLength) {
                Complex conj = _conjugate.copyComp(i, k);
                conj.mul(operand.getProbAmp(k));
                _innerProduct.getComp(i).add(conj);
                ++k;
            }
            ++i;
        }
        return resultQB;
    }

    public boolean equals(CompMat cm) {
        if (this == cm) {
            return true;
        }
        int thisRow = this.rowNumber();
        if (thisRow != cm.rowNumber()) {
            return false;
        }
        int thisCol = this.colNumber();
        if (thisCol != cm.colNumber()) {
            return false;
        }
        int i = 0;
        while (i < thisRow) {
            int j = 0;
            while (j < thisCol) {
                Complex thisComp = this.complexMatrix[i][j];
                if (!thisComp.equals(cm.complexMatrix[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        int i = 0;
        while (i < size) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }

    public String toString() {
        int index;
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < row) {
            sb.append("[");
            int j = 0;
            while (j < col) {
                sb.append(this.complexMatrix[i][j].toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int[] maxWide = new int[col];
        int j = 0;
        while (j < col) {
            maxWide[j] = 5;
            ++j;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        int i = 0;
        while (i < row) {
            int j2 = 0;
            while (j2 < col) {
                String text = this.complexMatrix[i][j2].toFormat();
                if (this.complexMatrix[i][j2].getReal() >= 0.0) {
                    buf[i][j2] = " " + text;
                    wides[i][j2] = text.length() + 1;
                } else {
                    buf[i][j2] = text;
                    wides[i][j2] = text.length();
                }
                if (wides[i][j2] > maxWide[j2]) {
                    maxWide[j2] = wides[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "  ";
        int gap = filler.length();
        int spaces = maxWide[0];
        int j3 = 1;
        while (j3 < col) {
            spaces = spaces + gap + maxWide[j3];
            ++j3;
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        int i2 = 0;
        while (i2 < row) {
            sb.append("\u2502");
            int j4 = 0;
            while (j4 < col) {
                sb.append(buf[i2][j4]);
                sb.append(this.getSpace(maxWide[j4] - wides[i2][j4])).append(filler);
                ++j4;
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
            ++i2;
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518\n");
        return sb.toString();
    }

    public String toString(String label) {
        int index;
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":\n[");
        int i = 0;
        while (i < row) {
            sb.append("[");
            int j = 0;
            while (j < col) {
                sb.append(this.complexMatrix[i][j].toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return String.valueOf(label) + ":" + str;
    }

    public static String toString(Complex[][] complexArray) {
        int index;
        int row = complexArray.length;
        int col = complexArray[0].length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < row) {
            sb.append("[");
            int j = 0;
            while (j < col) {
                sb.append(complexArray[i][j].toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder("F\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toFormat());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toString());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toFormat());
                sb.append("  ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }
}

