/*
 * Decompiled with CFR 0.152.
 */
package util.comp;

import java.util.ArrayList;
import quan.QuBit;
import util.DJ;
import util.comp.CompMat;
import util.comp.Complex;

public class CompVec {
    public static final boolean H_VEC = false;
    public static final boolean V_VEC = true;
    private Complex[] complexArray;

    public CompVec() {
    }

    public CompVec(int length) {
        this.complexArray = new Complex[length];
        int i = 0;
        while (i < length) {
            this.complexArray[i] = new Complex();
            ++i;
        }
    }

    public CompVec(int length, double real, double image) {
        this.complexArray = new Complex[length];
        int i = 0;
        while (i < length) {
            this.complexArray[i] = new Complex(real, image);
            ++i;
        }
    }

    public CompVec(int length, Complex complex) {
        this.complexArray = new Complex[length];
        int i = 0;
        while (i < length) {
            this.complexArray[i] = complex.copyComplex();
            ++i;
        }
    }

    public CompVec(int length, int index) {
        this.complexArray = Complex.complexArray(length);
        this.complexArray[index].setComplex(1.0, 0.0);
    }

    public CompVec(double[] dataArray) {
        int dataLength = dataArray.length;
        if (dataLength % 2 != 0) {
            DJ.print("***** ERROR ***** CompVec.CompVec(double[] dataArray)\n Number of data (" + dataLength + ") is not even number.");
        }
        int compLength = dataLength / 2;
        this.complexArray = new Complex[compLength];
        int i = 0;
        while (i < compLength) {
            int i2 = i * 2;
            this.complexArray[i] = new Complex(dataArray[i2], dataArray[i2 + 1]);
            ++i;
        }
    }

    public CompVec(Complex[] complexArray) {
        int compLength = complexArray.length;
        this.complexArray = new Complex[compLength];
        int i = 0;
        while (i < compLength) {
            this.complexArray[i] = complexArray[i].copyComplex();
            ++i;
        }
    }

    public CompVec(ArrayList<QuBit> quBitList) {
        int qbListLength = quBitList.size();
        int compLength = qbListLength * 2;
        this.complexArray = new Complex[compLength];
        int i = 0;
        while (i < qbListLength) {
            QuBit quBit = quBitList.get(i);
            this.complexArray[i * 2] = quBit.copyProbAmp(0);
            this.complexArray[i * 2 + 1] = quBit.copyProbAmp(1);
            ++i;
        }
    }

    public double getReal(int index) {
        return this.complexArray[index].getReal();
    }

    public void setReal(int index, double real) {
        this.complexArray[index].setReal(real);
    }

    public double getImag(int index) {
        return this.complexArray[index].getImag();
    }

    public void setImag(int index, Double imag) {
        this.complexArray[index].setImag(imag);
    }

    public Complex getComp(int index) {
        return this.complexArray[index];
    }

    public Complex copyComp(int index) {
        return this.complexArray[index].copyComplex();
    }

    public void setComp(int index, Complex complex) {
        this.complexArray[index].setComplex(complex);
    }

    public void setComp(int index, double real, double imag) {
        this.complexArray[index].setComplex(real, imag);
    }

    public Complex[] getArray() {
        return this.complexArray;
    }

    public CompVec copyCompVec() {
        int length = this.complexArray.length;
        CompVec _compVec = new CompVec(length);
        int i = 0;
        while (i < length) {
            _compVec.setComp(i, this.complexArray[i]);
            ++i;
        }
        return _compVec;
    }

    public Complex[] copyArray() {
        int length = this.complexArray.length;
        CompVec _compVec = new CompVec(length);
        int i = 0;
        while (i < length) {
            _compVec.setComp(i, this.complexArray[i]);
            ++i;
        }
        return _compVec.complexArray;
    }

    public void setArray(Complex[] operandArray) {
        this.complexArray = operandArray;
    }

    public void copyArray(Complex[] operandArray) {
        int length = this.complexArray.length;
        int operandLength = operandArray.length;
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.product(vector)\n Array length are not same.\n target array length is " + length + ", \n" + " operand array length is " + operandLength + ".");
            return;
        }
        int i = 0;
        while (i < length) {
            this.complexArray[i].setComplex(operandArray[i]);
            ++i;
        }
    }

    public int length() {
        return this.complexArray.length;
    }

    public void sum(CompVec operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.sum(CompVec)\n target vector length (=" + length + ") is less than one.");
            return;
        }
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.sum(vector)\n Vecter length are not same.\n target vector length is " + length + ", \n" + " operand vecter length is " + operandLength + ".");
            return;
        }
        Complex[] operandArray = operand.getArray();
        int i = 0;
        while (i < length) {
            this.complexArray[i].add(operandArray[i]);
            ++i;
        }
    }

    public void product(double real) {
        int length = this.complexArray.length;
        int i = 0;
        while (i < length) {
            this.complexArray[i].mul(real);
            ++i;
        }
    }

    public void product(Complex comp) {
        int length = this.complexArray.length;
        int i = 0;
        while (i < length) {
            this.complexArray[i].mul(comp);
            ++i;
        }
    }

    public void product(CompVec operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.product(CompVec)\n target vector length (=" + length + ") is less than one.");
            return;
        }
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.product(vector)\n Vecter length are not same.\n target vector length is " + length + ", \n" + " operand vecter length is " + operandLength + ".");
            return;
        }
        Complex[] operandArray = operand.getArray();
        int i = 0;
        while (i < length) {
            this.complexArray[i].mul(operandArray[i]);
            ++i;
        }
    }

    public CompVec conjugate() {
        int length = this.complexArray.length;
        CompVec _conjugate = new CompVec(length);
        int i = 0;
        while (i < length) {
            _conjugate.setComp(i, this.complexArray[i].conjugate());
            ++i;
        }
        return _conjugate;
    }

    public Complex innerProduct(CompVec operand) {
        int length = this.complexArray.length;
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompVec)\n vecter length are not same. target vecter length is " + length + ", " + " operand length is " + operandLength + ".");
            return null;
        }
        CompVec _conjugate = this.conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        int i = 0;
        while (i < operandLength) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(operand.getComp(i));
            _innerProduct.add(conj);
            ++i;
        }
        return _innerProduct;
    }

    public Complex innerProduct() {
        int length = this.complexArray.length;
        CompVec _conjugate = this.conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        int i = 0;
        while (i < length) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(this.getComp(i));
            _innerProduct.add(conj);
            ++i;
        }
        return _innerProduct;
    }

    public CompVec innerProduct(CompMat operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.innerProduct(CompMat)\n target vector length (=" + length + ") is less than one.");
            return null;
        }
        CompVec conjuVec = this.conjugate();
        int row = operand.rowNumber();
        if (length != row) {
            DJ.print("***** ERROR ***** CompVec.innerProduct(CompMat)\n Vecter length is not equal to row number of Matrix.\n target vector length is " + length + ", \n" + " operand Matrix row number is " + row + ".");
            return null;
        }
        int col = operand.colNumber();
        CompVec resultVec = new CompVec(col);
        Complex[] resultArray = resultVec.complexArray;
        int j = 0;
        while (j < col) {
            CompVec aCompVec = operand.copyColumn(j);
            int k = 0;
            while (k < length) {
                Complex aComplex = conjuVec.copyComp(k);
                aComplex.mul(operand.getComp(k, j));
                resultVec.getComp(j).add(aComplex);
                ++k;
            }
            ++j;
        }
        return resultVec;
    }

    public boolean equals(CompVec cv) {
        if (this == cv) {
            return true;
        }
        int thisLength = this.length();
        if (thisLength != cv.length()) {
            return false;
        }
        int i = 0;
        while (i < thisLength) {
            Complex thisComp = this.complexArray[i];
            if (!thisComp.equals(cv.complexArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        int i = 0;
        while (i < size) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }

    public String toString() {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < order) {
            sb.append(this.complexArray[i].toString());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toFormat() {
        int order = this.complexArray.length;
        int maxWide = 5;
        String[] buf = new String[order];
        int[] wides = new int[order];
        int i = 0;
        while (i < order) {
            int tempWide;
            String text = this.complexArray[i].toFormat();
            if (this.complexArray[i].getReal() >= 0.0) {
                buf[i] = " " + text;
                tempWide = text.length() + 1;
            } else {
                buf[i] = text;
                tempWide = text.length();
            }
            wides[i] = tempWide;
            if (tempWide > maxWide) {
                maxWide = tempWide;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder("F \n");
        sb.append("\u250c").append(this.getSpace(maxWide)).append("\u2510\n");
        int i2 = 0;
        while (i2 < order) {
            sb.append("\u2502");
            sb.append(buf[i2]);
            sb.append(this.getSpace(maxWide - wides[i2]));
            sb.append("\u2502");
            sb.append("\n");
            ++i2;
        }
        sb.append("\u2514").append(this.getSpace(maxWide)).append("\u2518");
        return sb.toString();
    }

    public String toFormat(boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder("F \n[") : new StringBuilder("F [");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toString(String label) {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < order) {
            sb.append(this.complexArray[i].toString());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(String label, boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":\n[") : new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return String.valueOf(label) + ":" + str;
    }

    public String toFormat(String label, boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":F\n[") : new StringBuilder(String.valueOf(label) + ":F [");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public static String toString(Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toString());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder("F[");
        int i = 0;
        while (i < order) {
            sb.append(complexArray[i].toFormat());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder("F \n[") : new StringBuilder("F [");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < order) {
            sb.append(complexArray[i].toString());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":\n[") : new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F [");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toFormat());
            sb.append("  ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":F\n[") : new StringBuilder(String.valueOf(label) + ":F [");
        int i = 0;
        while (i < order) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
            } else {
                sb.append("  ");
            }
            ++i;
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }
}

