/*
 * Decompiled with CFR 0.152.
 */
package util.comp;

import java.text.DecimalFormat;
import util.DJ;

public class Complex {
    public static final boolean H_COMP = false;
    public static final boolean V_COMP = true;
    private double real;
    private double imag;

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public static Complex[] complexArray(int length) {
        Complex[] compAry = new Complex[length];
        int i = 0;
        while (i < length) {
            compAry[i] = new Complex();
            ++i;
        }
        return compAry;
    }

    public static Complex[][] complexMatrix(int row, int col) {
        Complex[][] compMat = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                compMat[i][j] = new Complex();
                ++j;
            }
            ++i;
        }
        return compMat;
    }

    public static Complex[][] identityMatrix(int order) {
        Complex[][] identity = new Complex[order][order];
        int i = 0;
        while (i < order) {
            int j = 0;
            while (j < order) {
                identity[i][j] = new Complex();
                ++j;
            }
            identity[i][i] = new Complex(1.0, 0.0);
            ++i;
        }
        return identity;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImag(double imag) {
        this.imag = imag;
    }

    public Complex copyComplex() {
        return new Complex(this.real, this.imag);
    }

    public void setComplex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public void setComplex(Complex complex) {
        this.real = complex.getReal();
        this.imag = complex.getImag();
    }

    public void add(double real) {
        this.real += real;
    }

    public void sub(double real) {
        this.real -= real;
    }

    public void mul(double real) {
        this.real *= real;
        this.imag *= real;
    }

    public void div(double real) {
        this.real /= real;
        this.imag /= real;
    }

    public static Complex div(double real, Complex comp) {
        double deno = comp.real * comp.real + comp.imag * comp.imag;
        double _real = real * comp.real / deno;
        double _imag = real * comp.imag / deno;
        return new Complex(_real, _imag);
    }

    public void add(Complex comp) {
        this.real += comp.real;
        this.imag += comp.imag;
    }

    public void sub(Complex comp) {
        this.real -= comp.real;
        this.imag -= comp.imag;
    }

    public void mul(Complex comp) {
        double _real = this.real * comp.real - this.imag * comp.imag;
        this.imag = this.real * comp.imag + this.imag * comp.real;
        this.real = _real;
    }

    public void div(Complex comp) {
        double denominator = comp.real * comp.real + comp.imag * comp.imag;
        double _real = (this.real * comp.real + this.imag * comp.imag) / denominator;
        this.imag = (this.imag * comp.real - this.real * comp.imag) / denominator;
        this.real = _real;
    }

    public static Complex[] copyComplex(Complex[] compArray) {
        int length = compArray.length;
        Complex[] resultArray = new Complex[length];
        int i = 0;
        while (i < length) {
            resultArray[i] = new Complex(compArray[i].real, compArray[i].imag);
            ++i;
        }
        return resultArray;
    }

    public static Complex[][] copyComplex(Complex[][] compArray) {
        int row = compArray.length;
        int col = compArray[0].length;
        Complex[][] resultArray = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                resultArray[i][j] = new Complex(compArray[i][j].real, compArray[i][j].imag);
                ++j;
            }
            ++i;
        }
        return resultArray;
    }

    public Complex product(Complex comp) {
        double _real = this.real * comp.real - this.imag * comp.imag;
        double _imag = this.real * comp.imag + this.imag * comp.real;
        Complex _product = new Complex(_real, _imag);
        return _product;
    }

    public static void product(Complex[] target, double real) {
        int targetLength = target.length;
        int i = 0;
        while (i < targetLength) {
            target[i].mul(real);
            ++i;
        }
    }

    public static void product(Complex[] target, Complex comp) {
        int targetLength = target.length;
        int i = 0;
        while (i < targetLength) {
            target[i].mul(comp);
            ++i;
        }
    }

    public static void product(Complex[][] target, double real) {
        int targetLength = target.length;
        int lowLength = target[0].length;
        int i = 0;
        while (i < targetLength) {
            int j = 0;
            while (j < lowLength) {
                target[i][j].mul(real);
                ++j;
            }
            ++i;
        }
    }

    public static void product(Complex[][] target, Complex comp) {
        int targetLength = target.length;
        int lowLength = target[0].length;
        int i = 0;
        while (i < targetLength) {
            int j = 0;
            while (j < lowLength) {
                target[i][j].mul(comp);
                ++j;
            }
            ++i;
        }
    }

    public static Complex[] product(Complex[][] target, Complex[] operand) {
        int row = target.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[] operand)\n tatrget row number (=" + row + ") is less than one.");
            return null;
        }
        int col = target[0].length;
        int operandRow = operand.length;
        if (row != operandRow) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[] operand)\n Element number are not same.\n target row number is " + row + ", \n" + " operand row number is " + operandRow + ".");
            return null;
        }
        Complex[] _products = new Complex[col];
        int i = 0;
        while (i < col) {
            _products[i] = new Complex(0.0, 0.0);
            int k = 0;
            while (k < row) {
                Complex element = target[i][k].copyComplex();
                element.mul(operand[k]);
                _products[i].add(element);
                ++k;
            }
            ++i;
        }
        return _products;
    }

    public static Complex[][] product(Complex[][] target, Complex[][] operand) {
        int row = target.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[][] operand)\n target row number (=" + row + ") is less than one.");
            return null;
        }
        int col = target[0].length;
        int operandRow = operand.length;
        if (row != operandRow) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[][] operand)\n Element number are not same.\n target row number is " + row + ", \n" + " operand row number is " + operandRow + ".");
            return null;
        }
        int operandCol = operand[0].length;
        Complex[][] _products = new Complex[col][operandCol];
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < operandCol) {
                _products[i][j] = new Complex(0.0, 0.0);
                int k = 0;
                while (k < row) {
                    Complex conj = target[i][k].copyComplex();
                    conj.mul(operand[k][j]);
                    _products[i][j].add(conj);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return _products;
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imag);
    }

    public static Complex[] conjugate(Complex[] target) {
        int length = target.length;
        Complex[] _conjugate = new Complex[length];
        int i = 0;
        while (i < length) {
            _conjugate[i] = target[i].conjugate();
            ++i;
        }
        return _conjugate;
    }

    public static Complex[][] conjugate(Complex[][] target) {
        int row = target.length;
        int col = target[0].length;
        Complex[][] _conjugate = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                _conjugate[j][i] = target[i][j].conjugate();
                ++j;
            }
            ++i;
        }
        return _conjugate;
    }

    public double square() {
        return this.real * this.real + this.imag * this.imag;
    }

    public double abs() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    public double arg() {
        return Math.atan(this.imag / this.real);
    }

    public static Complex innerProduct(Complex[] target, Complex[] operand) {
        int targetLength = target.length;
        int operandLength = operand.length;
        if (targetLength != operandLength) {
            DJ.print("***** ERROR ***** Complex.innerProduct()\n Vecter length is not same. multiplicand vecter length is " + targetLength + ", " + " multiplier vecter length is " + operandLength + ".");
            return null;
        }
        Complex[] _conjugate = Complex.conjugate(target);
        Complex _innerProduct = new Complex(0.0, 0.0);
        int i = 0;
        while (i < targetLength) {
            _conjugate[i].mul(operand[i]);
            _innerProduct.add(_conjugate[i]);
            ++i;
        }
        return _innerProduct;
    }

    public static Complex innerProduct(Complex[] target) {
        int targetLength = target.length;
        Complex[] _conjugate = Complex.conjugate(target);
        Complex _innerProduct = new Complex(0.0, 0.0);
        int i = 0;
        while (i < targetLength) {
            _conjugate[i].mul(target[i]);
            _innerProduct.add(_conjugate[i]);
            ++i;
        }
        return _innerProduct;
    }

    public static Complex[] innerProduct(Complex[][] target, Complex[] operand) {
        int targetLength = target.length;
        if (targetLength < 1) {
            DJ.print("***** ERROR ***** Complex.innerProduct(Matrix, vector)\n Number of tatrget length is less than one.");
            return null;
        }
        int rowLength = target[0].length;
        int operandLength = operand.length;
        if (rowLength != operandLength) {
            DJ.print("***** ERROR ***** Complex.innerProduct(vector, vector)\n Vecter length is not same.\n target matrix row length is " + rowLength + ", \n" + " operand vecter length is " + operandLength + ".");
            return null;
        }
        Complex[][] _conjugate = Complex.conjugate(target);
        Complex[] _innerProducts = new Complex[targetLength];
        int i = 0;
        while (i < targetLength) {
            Complex _innerProduct = new Complex(0.0, 0.0);
            int j = 0;
            while (j < operandLength) {
                _conjugate[i][j].mul(operand[j]);
                _innerProduct.add(_conjugate[i][j]);
                ++j;
            }
            _innerProducts[i] = _innerProduct;
            ++i;
        }
        return _innerProducts;
    }

    public static Complex[][] innerProduct(Complex[][] target, Complex[][] operand) {
        int row = target.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[][] operand)\n target row number (=" + row + ") is less than one.");
            return null;
        }
        int col = target[0].length;
        int operandRow = operand.length;
        if (row != operandRow) {
            DJ.print("***** ERROR ***** Complex.product(Complex[][] target, Complex[][] operand)\n Element number are not same.\n target row number is " + row + ", \n" + " operand row number is " + operandRow + ".");
            return null;
        }
        int operandCol = operand[0].length;
        Complex[][] _products = new Complex[col][operandCol];
        int i = 0;
        while (i < col) {
            int j = 0;
            while (j < operandCol) {
                _products[i][j] = new Complex(0.0, 0.0);
                int k = 0;
                while (k < row) {
                    Complex conj = target[k][i].copyComplex().conjugate();
                    conj.mul(operand[k][j]);
                    _products[i][j].add(conj);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return _products;
    }

    public static Complex norm(Complex[] target) {
        Complex _innerProduct = Complex.innerProduct(target);
        Complex norm = _innerProduct.sqrt();
        return norm;
    }

    public Complex sqrt() {
        Complex sqrt = new Complex();
        if (this.imag >= -4.9E-324 && this.imag <= Double.MIN_VALUE) {
            if (this.real >= 0.0) {
                sqrt.setReal(Math.sqrt(this.real));
            } else {
                sqrt.setImag(Math.sqrt(-this.real));
            }
        } else {
            double aa = this.real * this.real;
            double bb = this.imag * this.imag;
            double rtab = Math.sqrt(aa + bb);
            double _real = Math.sqrt(0.5 * (this.real + rtab));
            double _imag = Math.sqrt(0.5 * (-this.real + rtab));
            sqrt.setReal(_real);
            if (this.imag >= 0.0) {
                sqrt.setImag(_imag);
            } else {
                sqrt.setImag(-_imag);
            }
        }
        return sqrt;
    }

    public static Complex euler(double phi) {
        double sinPi = Math.sin(phi);
        double cosPi = Math.cos(phi);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinPi <= p && sinPi >= m) {
            sinPi = 0.0;
        }
        if (cosPi <= p && cosPi >= m) {
            cosPi = 0.0;
        }
        return new Complex(cosPi, sinPi);
    }

    public static Complex determinant(Complex[][] target) {
        Complex det = new Complex(1.0, 0.0);
        int row = target.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** Complex.determinant(Complex[][] target)_0\n target row length is " + row + ", " + " Order of tatrget is less than one.");
            return null;
        }
        int col = target[0].length;
        if (row != col) {
            DJ.print("***** ERROR ***** Complex.determinant(Complex[][] target)_1\n target is not square matrix.\n target row length is " + row + ", \n" + " target col length is " + col + ".");
            return null;
        }
        Complex[][] _target = new Complex[row][col];
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < col) {
                _target[i][j] = target[i][j].copyComplex();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < col - 1) {
            Complex temp;
            int j;
            int k;
            if (_target[i][i].abs() == 0.0) {
                k = i + 1;
                while (k < row) {
                    if (_target[k][i].abs() != 0.0) break;
                    ++k;
                }
                if (k < row) {
                    j = 0;
                    while (j < row) {
                        temp = _target[i][j];
                        _target[i][j] = _target[k][j];
                        _target[k][j] = temp;
                        ++j;
                    }
                    det.mul(-1.0);
                }
            }
            k = i + 1;
            while (k < col) {
                Complex r = _target[k][i].copyComplex();
                r.div(_target[i][i]);
                j = i;
                while (j < col) {
                    temp = r.product(_target[i][j]);
                    _target[k][j].sub(temp);
                    ++j;
                }
                ++k;
            }
            det.mul(_target[i][i]);
            ++i;
        }
        det.mul(_target[col - 1][col - 1]);
        return det;
    }

    public boolean equals(Complex c) {
        if (this == c) {
            return true;
        }
        if (this.real != c.real) {
            return false;
        }
        return this.imag == c.imag;
    }

    public String toString() {
        String realString = String.valueOf(this.real);
        String imageString = String.valueOf(this.imag);
        if (imageString.contains("E-")) {
            return String.valueOf(realString) + "+" + imageString + "i";
        }
        if (imageString.contains("-")) {
            return String.valueOf(realString) + imageString + "i";
        }
        return String.valueOf(realString) + "+" + imageString + "i";
    }

    public String toString(String label) {
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":");
        sb.append(this.toString());
        return sb.toString();
    }

    public String toFormat() {
        DecimalFormat fmt = new DecimalFormat("##.#####");
        String realString = fmt.format(this.real);
        String imageString = fmt.format(this.imag);
        if (imageString.contains("-")) {
            return String.valueOf(realString) + imageString + "i";
        }
        return String.valueOf(realString) + "+" + imageString + "i";
    }

    public String toFormat(String label) {
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F ");
        sb.append(this.toFormat());
        return sb.toString();
    }

    public static String toString(Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toString());
            sb.append(", ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(Complex[] complexArray, boolean orient) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append(",\n");
            } else {
                sb.append(", ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder("F[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toFormat());
            sb.append(", ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray, boolean orient) {
        int length = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder("F \n[") : new StringBuilder("F [");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append(",\n");
            } else {
                sb.append(", ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toString());
            sb.append(", ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray, boolean orient) {
        int length = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":\n[") : new StringBuilder(String.valueOf(label) + ":[");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append(",\n");
            } else {
                sb.append(", ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F [");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toFormat());
            sb.append(", ");
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray, boolean orient) {
        int length = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(String.valueOf(label) + ":F\n[") : new StringBuilder(String.valueOf(label) + ":F [");
        int i = 0;
        while (i < length) {
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append(",\n");
            } else {
                sb.append(", ");
            }
            ++i;
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toString());
                sb.append(", ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder("F\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toFormat());
                sb.append(", ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toString());
                sb.append(", ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(String.valueOf(label) + ":F\n[");
        int i = 0;
        while (i < colLength) {
            sb.append("[");
            int j = 0;
            while (j < order) {
                sb.append(complexArray[i][j].toFormat());
                sb.append(", ");
                ++j;
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
            ++i;
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }
}

