/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultCaret;
import task.SelfOrganizingMap;
import task.Task;
import util.DJ;
import util.LogEditor;
import view.AboutDialog;
import view.PropertyViewer;

public class Console
extends JFrame {
    public static Image icon16;
    public static final String ICON16_FILE = "image/som16.jpg";
    public static final String BOUNDS_NAME = "consoleBounds";
    private LogEditor editor;
    private DJ dj;
    private PropertyViewer propertyViewer;
    public static final boolean PROPERTY_OPEN = true;
    public static final boolean PROPERTY_CLOSE = false;
    private static boolean propertyFlag;
    Task task;
    private JButton abortButton;
    private JMenuItem abortMenuItem;
    private JMenuItem aboutMenuItem;
    private JPanel buttonPanel;
    private JButton clearButton;
    private JMenuItem clearLogMenuItem;
    private JButton dumpButton;
    private JMenuItem dumpMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem graphMenuItem;
    private JMenu helpMenu;
    private JButton loadButton;
    private JMenuItem loadMenuItem;
    private JPanel logPanel;
    private JScrollPane logScrollPane;
    private JTextArea logTextArea;
    private JMenuBar mainMenuBar;
    private JButton onButton;
    private JMenuItem patternMenuItem;
    private JButton propertyButton;
    private JMenu propertyMenu;
    private JMenuItem propertyMenuItem;
    private JMenuItem reReadPropertyMenuItem;
    private JButton runButton;
    private JMenu runMenu;
    private JMenuItem runPauseMenuItem;
    private JMenuItem savePropertyMenuItem;
    private JMenuItem somMenuItem;
    private JMenuItem startStopLogMenuItem;
    private JButton stepButton;
    private JMenu viewerMenu;

    static {
        propertyFlag = false;
    }

    public Console() {
        this.initComponents();
        ((DefaultCaret)this.logTextArea.getCaret()).setUpdatePolicy(2);
        this.initialize();
        this.setBounds();
        this.logTextArea.append(" \u5b9f\u884c\u958b\u59cb\u306e\u30ac\u30a4\u30c9\n");
        this.logTextArea.append(" ############################################################\n");
        this.logTextArea.append(" ##\n");
        this.logTextArea.append(" ##      \u30fb\u30bf\u30b9\u30af\u306e\u5b9f\u884c\u3092\u958b\u59cb\u3059\u308b\u306b\u306f\u3001             \n");
        this.logTextArea.append(" ##      \u3000\u30b3\u30f3\u30bd\u30fc\u30eb\u306e\u300cRun/Pause\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \n");
        this.logTextArea.append(" ##\n");
        this.logTextArea.append(" ############################################################\n");
    }

    public final void setBounds() {
        Rectangle rect = this.propertyViewer.getBoundsValue(BOUNDS_NAME);
        if (rect != null) {
            this.setBounds(rect);
        } else {
            this.setBounds(0, 0, 600, 400);
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.dumpButton = new JButton();
        this.loadButton = new JButton();
        this.clearButton = new JButton();
        this.onButton = new JButton();
        this.abortButton = new JButton();
        this.runButton = new JButton();
        this.propertyButton = new JButton();
        this.stepButton = new JButton();
        this.logPanel = new JPanel();
        this.logScrollPane = new JScrollPane();
        this.logTextArea = new JTextArea();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.dumpMenuItem = new JMenuItem();
        this.loadMenuItem = new JMenuItem();
        this.propertyMenu = new JMenu();
        this.savePropertyMenuItem = new JMenuItem();
        this.reReadPropertyMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.startStopLogMenuItem = new JMenuItem();
        this.clearLogMenuItem = new JMenuItem();
        this.viewerMenu = new JMenu();
        this.propertyMenuItem = new JMenuItem();
        this.graphMenuItem = new JMenuItem();
        this.patternMenuItem = new JMenuItem();
        this.somMenuItem = new JMenuItem();
        this.runMenu = new JMenu();
        this.runPauseMenuItem = new JMenuItem();
        this.abortMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("DaiJa : Console");
        this.setName("logFrame");
        this.setSize(new Dimension(600, 400));
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.setPreferredSize(new Dimension(600, 24));
        this.dumpButton.setText("Dump");
        this.dumpButton.setMargin(new Insets(2, 5, 2, 5));
        this.dumpButton.setMaximumSize(new Dimension(33, 22));
        this.dumpButton.setMinimumSize(new Dimension(33, 22));
        this.dumpButton.setPreferredSize(new Dimension(44, 18));
        this.loadButton.setText("Load");
        this.loadButton.setMargin(new Insets(2, 10, 2, 10));
        this.loadButton.setPreferredSize(new Dimension(48, 18));
        this.clearButton.setText("Clear");
        this.clearButton.setMargin(new Insets(2, 10, 2, 10));
        this.clearButton.setPreferredSize(new Dimension(48, 18));
        this.onButton.setText("On / Off");
        this.onButton.setMargin(new Insets(2, 10, 2, 10));
        this.onButton.setPreferredSize(new Dimension(66, 18));
        this.abortButton.setText("Abort");
        this.abortButton.setMargin(new Insets(2, 10, 2, 10));
        this.abortButton.setPreferredSize(new Dimension(52, 18));
        this.runButton.setText("Run / Pause");
        this.runButton.setMargin(new Insets(2, 10, 2, 10));
        this.runButton.setPreferredSize(new Dimension(85, 18));
        this.propertyButton.setText("Property");
        this.propertyButton.setMargin(new Insets(2, 10, 2, 10));
        this.propertyButton.setPreferredSize(new Dimension(67, 18));
        this.stepButton.setText("Step");
        this.stepButton.setToolTipText("");
        this.stepButton.setMargin(new Insets(2, 10, 2, 10));
        this.stepButton.setPreferredSize(new Dimension(45, 18));
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.stepAction(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dumpButton, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertyButton, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abortButton, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepButton, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runButton, -2, 94, -2).addContainerGap(28, Short.MAX_VALUE)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dumpButton, -2, -1, -2).addComponent(this.loadButton, -2, -1, -2).addComponent(this.clearButton, -2, -1, -2).addComponent(this.onButton, -2, -1, -2).addComponent(this.runButton, -2, -1, -2).addComponent(this.propertyButton, -2, -1, -2).addComponent(this.abortButton, -2, -1, -2).addComponent(this.stepButton, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.logPanel.setLayout(new BorderLayout());
        this.logScrollPane.setHorizontalScrollBarPolicy(32);
        this.logScrollPane.setVerticalScrollBarPolicy(22);
        this.logScrollPane.setAutoscrolls(true);
        this.logScrollPane.setPreferredSize(new Dimension(600, 200));
        this.logTextArea.setFont(new Font("BIZ UD\u30b4\u30b7\u30c3\u30af", 0, 14));
        this.logScrollPane.setViewportView(this.logTextArea);
        this.logPanel.add((Component)this.logScrollPane, "Center");
        this.getContentPane().add((Component)this.logPanel, "Center");
        this.fileMenu.setText("File");
        this.dumpMenuItem.setText("DumpLogFile");
        this.dumpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.dumpLogAction(evt);
            }
        });
        this.fileMenu.add(this.dumpMenuItem);
        this.loadMenuItem.setText("LoadLogFile");
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.loadLogAction(evt);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.propertyMenu.setText("Property");
        this.savePropertyMenuItem.setText("SavePropertyFile");
        this.savePropertyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.savePropertyAction(evt);
            }
        });
        this.propertyMenu.add(this.savePropertyMenuItem);
        this.reReadPropertyMenuItem.setText("ReadPropertyFile");
        this.reReadPropertyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.readPropertyAction(evt);
            }
        });
        this.propertyMenu.add(this.reReadPropertyMenuItem);
        this.fileMenu.add(this.propertyMenu);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.exitMenuAction(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.startStopLogMenuItem.setText("Start/Stop Log");
        this.startStopLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.start_stopLogAction(evt);
            }
        });
        this.editMenu.add(this.startStopLogMenuItem);
        this.clearLogMenuItem.setText("Clear Log");
        this.clearLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.clearLogAction(evt);
            }
        });
        this.editMenu.add(this.clearLogMenuItem);
        this.mainMenuBar.add(this.editMenu);
        this.viewerMenu.setText("Viewer");
        this.propertyMenuItem.setText("PropertyViewer");
        this.propertyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.propertyViewerAction(evt);
            }
        });
        this.viewerMenu.add(this.propertyMenuItem);
        this.graphMenuItem.setText("GraphViewer");
        this.graphMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.graphViewerAction(evt);
            }
        });
        this.viewerMenu.add(this.graphMenuItem);
        this.patternMenuItem.setText("PatternViewer");
        this.patternMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.patternViewerAction(evt);
            }
        });
        this.viewerMenu.add(this.patternMenuItem);
        this.somMenuItem.setText("SomViewer");
        this.somMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.somViewerAction(evt);
            }
        });
        this.viewerMenu.add(this.somMenuItem);
        this.mainMenuBar.add(this.viewerMenu);
        this.runMenu.setText("Run");
        this.runPauseMenuItem.setText("Run/Pause");
        this.runPauseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.run_pauseAction(evt);
            }
        });
        this.runMenu.add(this.runPauseMenuItem);
        this.abortMenuItem.setText("Abort");
        this.abortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.abortAction(evt);
            }
        });
        this.runMenu.add(this.abortMenuItem);
        this.mainMenuBar.add(this.runMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Console.this.aboutAction(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.pack();
    }

    private void exitMenuAction(ActionEvent evt) {
        this.logTextArea.append("Console: <Exit> menu item is selected.\n");
        this.closeWindow();
    }

    private void propertyViewerAction(ActionEvent evt) {
        this.showPropertyViewer();
    }

    private void patternViewerAction(ActionEvent evt) {
        if (this.task != null) {
            this.task.showPattern();
        } else {
            this.logTextArea.append("Task is not run.\n");
            this.logTextArea.append("Click Run/Pause button to run the task.\n");
        }
    }

    private void graphViewerAction(ActionEvent evt) {
        if (this.task != null) {
            this.task.showGraph();
        } else {
            this.logTextArea.append("Task is not run.\n");
            this.logTextArea.append("Click Run/Pause button to run the task.\n");
        }
    }

    private void somViewerAction(ActionEvent evt) {
        if (this.task instanceof SelfOrganizingMap) {
            ((SelfOrganizingMap)this.task).showSom();
        } else {
            this.logTextArea.append("Task is not SelfOrganizingMap.\n");
        }
    }

    private void dumpLogAction(ActionEvent evt) {
        this.logTextArea.append("Console: <DumpLogFile> menu item is selected.\n");
        if (this.editor != null) {
            this.editor.dumpLog();
        } else {
            this.logTextArea.append("***** ERROR ***** Console: Logs are not dumped. \n");
        }
    }

    private void loadLogAction(ActionEvent evt) {
        this.logTextArea.append("Console: <LoadLogFile> menu item is selected.\n");
        if (this.editor != null) {
            this.editor.loadLog();
        } else {
            this.logTextArea.append("***** ERROR ***** Console: Logs are not loaded. \n");
        }
    }

    private void savePropertyAction(ActionEvent evt) {
        if (this.propertyViewer != null) {
            this.propertyViewer.restoreBoundsList();
            this.propertyViewer.restoreParamerList();
            this.propertyViewer.restoreProperty();
        }
    }

    private void readPropertyAction(ActionEvent evt) {
        if (this.propertyViewer != null) {
            this.propertyViewer.readProperty();
        }
    }

    private void start_stopLogAction(ActionEvent evt) {
        this.logTextArea.append("Console: <Start/Stop Log> menu is selected.\n");
        if (this.editor != null) {
            this.editor.setLogActive();
        } else {
            this.logTextArea.append("***** ERROR ***** Console: Log start/stop-operation is failed. \n");
        }
    }

    private void clearLogAction(ActionEvent evt) {
        this.logTextArea.setText("Console: <Clear> menu is selected.\n");
        if (this.editor != null) {
            this.editor.clearLog();
        } else {
            this.logTextArea.append("***** ERROR ***** Console: Log is not cleared. \n");
        }
    }

    private void run_pauseAction(ActionEvent evt) {
        this.logTextArea.append("Console: <Run / Pause> menu is selected.\n");
        if (this.propertyViewer.checkParameterChange()) {
            this.task = this.taskOperation();
        }
    }

    private void abortAction(ActionEvent evt) {
        this.logTextArea.append("Console: <Abort> menu is selected.\n");
        if (this.task != null) {
            this.task.abortTask();
        } else {
            this.logTextArea.append("***** ERROR ***** Console: There is no task to abort. \n");
        }
    }

    private void aboutAction(ActionEvent evt) {
        AboutDialog abouDialogt = new AboutDialog((Frame)this, true);
        abouDialogt.setCenterLocation(abouDialogt);
        abouDialogt.setVisible(true);
    }

    private void stepAction(ActionEvent evt) {
        if (this.task != null) {
            this.task.stepTask();
        }
    }

    private void initialize() {
        icon16 = Toolkit.getDefaultToolkit().getImage(ICON16_FILE);
        Console_button_actionAdapter buttonAdapter = new Console_button_actionAdapter(this);
        this.dumpButton.addActionListener(buttonAdapter);
        this.loadButton.addActionListener(buttonAdapter);
        this.clearButton.addActionListener(buttonAdapter);
        this.propertyButton.addActionListener(buttonAdapter);
        this.onButton.addActionListener(buttonAdapter);
        this.abortButton.addActionListener(buttonAdapter);
        this.runButton.addActionListener(buttonAdapter);
        this.stepButton.addActionListener(buttonAdapter);
        this.addWindowListener(new WindowClosing());
        this.editor = new LogEditor(this);
        this.dj = new DJ(this);
        if (!DJ.checkDJ()) {
            System.out.println("***** ERROR ***** LogFrame.initialize: DJ is wrong.");
            System.exit(1);
        }
        this.showPropertyViewer();
    }

    public PropertyViewer createPropertyViewer() {
        if (this.propertyViewer == null) {
            this.propertyViewer = new PropertyViewer(this);
            if (this.propertyViewer.stringList == null) {
                System.out.println("***** ERROR ***** Console.createPropertyViewer():");
                System.out.println("Failed to open a property file.");
                System.exit(0);
            }
            this.propertyViewer.putBounds();
        }
        return this.propertyViewer;
    }

    public void showPropertyViewer() {
        this.createPropertyViewer();
        if (!this.propertyViewer.isShowing()) {
            propertyFlag = false;
        }
        if (propertyFlag) {
            this.propertyViewer.setVisible(false);
            propertyFlag = false;
            this.logTextArea.append("Console.showPropertyFrame(): PropertyFrame is closed.\n");
        } else {
            this.propertyViewer.setVisible(true);
            propertyFlag = true;
            this.logTextArea.append("Console.showPropertyFrame(): PropertyFrame is opened.\n");
        }
    }

    public PropertyViewer getPropertyViewer() {
        return this.propertyViewer;
    }

    public void writeToTextArea(String log) {
        this.logTextArea.append(log);
    }

    void button_actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "On / Off": {
                this.logTextArea.append("Console: <On / Off> button is clicked.\n");
                if (this.editor != null) {
                    this.editor.setLogActive();
                    break;
                }
                this.logTextArea.append("***** ERROR ***** Console: Log on/off-operation is failed. \n");
                break;
            }
            case "Dump": {
                this.logTextArea.append("Console: <Dump> button is clicked.\n");
                if (this.editor != null) {
                    this.editor.dumpLog();
                    break;
                }
                this.logTextArea.append("***** ERROR ***** Console: Logs are not dumped. \n");
                break;
            }
            case "Load": {
                this.logTextArea.append("Console: <Load> button is clicked.\n");
                if (this.editor != null) {
                    this.editor.loadLog();
                    break;
                }
                this.logTextArea.append("***** ERROR ***** Console: Logs are not loaded. \n");
                break;
            }
            case "Clear": {
                this.logTextArea.setText("Console: <Clear> button is clicked.\n");
                if (this.editor != null) {
                    this.editor.clearLog();
                    break;
                }
                this.logTextArea.append("***** ERROR ***** Console: Log is not cleared. \n");
                break;
            }
            case "Property": {
                this.logTextArea.append("Console: <Property> button is clicked.\n");
                this.showPropertyViewer();
                break;
            }
            case "Abort": {
                this.logTextArea.append("Console: <Abort> button is clicked.\n");
                if (this.task == null) break;
                this.task.abortTask();
                break;
            }
            case "Run / Pause": {
                this.moveCaretToEnd();
                this.logTextArea.append("Console: <Run / Pause> button is clicked.\n");
                if (!this.propertyViewer.checkParameterChange()) break;
                this.task = this.taskOperation();
            }
        }
    }

    private void moveCaretToEnd() {
        int end = this.logTextArea.getDocument().getLength();
        this.logTextArea.setCaretPosition(end);
    }

    public Task taskOperation() {
        Class<?> appClass = null;
        if (this.task == null) {
            String className = this.propertyViewer.getAppName();
            try {
                appClass = Class.forName(className);
                this.task = (Task)appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                this.logTextArea.append("Console.taskOperation(): ReflectiveOperationException.\n");
                this.logTextArea.append("Console.taskOperation(): Failed to get an application.\n");
            }
            this.propertyViewer.putParameter(appClass, this.task);
            this.task.startTask();
        } else {
            this.task.pauseTask();
        }
        return this.task;
    }

    public boolean startThread(Thread thread) {
        if (thread == null) {
            this.logTextArea.setText("Console.startThread():There are no taskThread. \n***** ERROR ***** 'taskThread' is not started. \n");
            return false;
        }
        thread.start();
        return true;
    }

    private void closeWindow() {
        int ans = JOptionPane.showConfirmDialog(this, "\u672c\u5f53\u306b\u7d42\u4e86\u3057\u307e\u3059\u304b?", "\u7d42\u4e86\u78ba\u8a8d", 0, 2);
        if (ans == 0) {
            this.logTextArea.append("Console.closeWindow(): Exit from DaiJa.\n");
            System.out.println("Console.closeWindow(): Exit from DaiJa.");
            System.exit(0);
        }
    }

    class Console_button_actionAdapter
    implements ActionListener {
        Console adaptee;

        Console_button_actionAdapter(Console adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.button_actionPerformed(e);
        }
    }

    class WindowClosing
    extends WindowAdapter {
        WindowClosing() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Console.this.closeWindow();
        }
    }
}

