/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import util.DJ;
import util.TimeStamp;
import view.Box;
import view.Dot;
import view.Edge;
import view.Fig;
import view.PropertyViewer;
import view.Quad;
import view.Rect;
import view.Viewer;

public class GraphViewer
extends Viewer {
    public static final String BOUNDS_NAME = "graphBounds";
    int epoch;
    int interval;
    int sampleNum;
    int sampleCount;
    int epochCount;
    int dataNum;
    String[] dataName;
    double[] graphData;
    ArrayList<float[]> dataList;
    private Edge axes;
    GraphDrawer grapher;
    int lastBtn = 2;
    private JButton backButton;
    private JPanel controlPanel;
    private JButton downButton;
    private JButton frontButton;
    private Canvas graphCanvas;
    private JPanel mainPanel;
    private JButton upButton;

    public GraphViewer(int epoch, int interval, String[] dataName, double[] graphData) {
        this.initComponents();
        this.epoch = epoch;
        this.interval = interval;
        this.sampleNum = epoch / interval;
        this.sampleCount = 0;
        this.epochCount = 0;
        this.dataNum = dataName.length;
        this.dataName = dataName;
        this.dataList = new ArrayList();
        this.graphData = graphData;
        float[] dataSet = this.getVector(graphData);
        this.dataList.add(dataSet);
        ++this.sampleCount;
        this.setBounds();
        this.grapher = new GraphDrawer();
        this.mainPanel.add((Component)this.grapher, "Center");
    }

    private float[] getVector(double[] aVector) {
        int length = aVector.length;
        float[] dataSet = new float[length];
        int i = 0;
        while (i < length) {
            dataSet[i] = (float)aVector[i];
            ++i;
        }
        return dataSet;
    }

    public final void setBounds() {
        PropertyViewer propertyViewer = DJ.getPropertyViewer();
        Rectangle rect = propertyViewer.getBoundsValue(BOUNDS_NAME);
        if (rect != null) {
            this.setBounds(rect);
        } else {
            this.setBounds(0, 400, 600, 400);
        }
    }

    public void updateGraph(int epochCount, double[] graphData) {
        this.epochCount = epochCount;
        float[] dataSet = this.getVector(graphData);
        this.dataList.add(dataSet);
        ++this.sampleCount;
        this.grapher.repaint();
    }

    public boolean shiftGraphAxis(int shift) {
        if (this.grapher == null) {
            return false;
        }
        this.grapher.shiftEdge(shift);
        return true;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.graphCanvas = new Canvas();
        this.controlPanel = new JPanel();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.frontButton = new JButton();
        this.backButton = new JButton();
        this.setTitle("DaiJa : Graph viewer");
        this.setFocusable(false);
        this.setLocation(new Point(0, 400));
        this.setName("graphFrame");
        this.setSize(new Dimension(600, 400));
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setPreferredSize(new Dimension(600, 200));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.graphCanvas, "First");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setPreferredSize(new Dimension(600, 24));
        this.controlPanel.setRequestFocusEnabled(false);
        this.upButton.setText("Up");
        this.upButton.setPreferredSize(new Dimension(72, 18));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphViewer.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("Down");
        this.downButton.setMaximumSize(new Dimension(72, 18));
        this.downButton.setMinimumSize(new Dimension(72, 18));
        this.downButton.setPreferredSize(new Dimension(72, 18));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphViewer.this.downButtonActionPerformed(evt);
            }
        });
        this.frontButton.setText("Front");
        this.frontButton.setPreferredSize(new Dimension(72, 18));
        this.frontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphViewer.this.frontButtonActionPerformed(evt);
            }
        });
        this.backButton.setText("Back");
        this.backButton.setPreferredSize(new Dimension(72, 18));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphViewer.this.backButtonActionPerformed(evt);
            }
        });
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.downButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 284, Short.MAX_VALUE).addComponent(this.backButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frontButton, -2, -1, -2).addContainerGap()));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downButton, -2, -1, -2).addComponent(this.upButton, -2, -1, -2).addComponent(this.backButton, -2, -1, -2).addComponent(this.frontButton, -2, -1, -2)).addGap(0, 2, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.axes.setEdge(this.axes.l, this.axes.r, this.axes.b, this.axes.t / 5.0f);
        this.grapher.repaint();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.axes.setEdge(this.axes.l, this.axes.r, this.axes.b, this.axes.t * 5.0f);
        this.grapher.repaint();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        if (this.lastBtn <= 2) {
            this.axes.setEdge(0, this.axes.r / 2, this.axes.b, this.axes.t);
            --this.lastBtn;
        } else {
            this.sampleNum = this.epoch / this.interval;
            this.axes.setEdge(0, this.sampleNum, this.axes.b, this.axes.t);
            this.lastBtn = -3;
        }
        this.grapher.repaint();
    }

    private void frontButtonActionPerformed(ActionEvent evt) {
        this.sampleNum = this.epoch / this.interval;
        if (this.lastBtn > 0) {
            this.axes.setEdge(this.sampleNum - this.sampleNum / this.lastBtn, this.sampleNum, this.axes.b, this.axes.t);
            ++this.lastBtn;
        } else {
            this.axes.setEdge(0, this.sampleNum, this.axes.b, this.axes.t);
            this.lastBtn = 2;
        }
        this.grapher.repaint();
    }

    public class GraphDrawer
    extends Canvas {
        private static final String TAG_ERROR = "Error";
        private static final String TAG_EPOCH = "Epoch";
        private static final int FRAME_SPACE = 2;
        private static final int FRAME_DOUBLE = 4;
        private static final int AXIS_LEFT = 40;
        private static final int AXIS_RIGHT = 0;
        private static final int AXIS_TOP = 15;
        private static final int AXIS_BOTOM = 20;
        private static final int AXIS_SUB = 5;
        private static final int MAX_COLOR = 11;
        private final Color[] colorPalet = new Color[11];
        private Box screen;
        private Rect aide;
        private Rect board;
        private Quad param;

        GraphDrawer() {
            this.setColorPalet();
            GraphViewer.this.axes = Edge.edge();
            GraphViewer.this.sampleNum = GraphViewer.this.epoch / GraphViewer.this.interval;
            GraphViewer.this.axes.setEdge(0, GraphViewer.this.sampleNum, 0.0f, 2.5f);
        }

        public void shiftEdge(int shift) {
            GraphViewer.this.axes.setEdge(GraphViewer.this.axes.l, GraphViewer.this.axes.r, GraphViewer.this.axes.b, GraphViewer.this.axes.t / (float)Math.pow(5.0, shift));
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            this.screen = Box.box(size.height, size.width);
            g.setColor(Color.getHSBColor(0.1f, 0.1f, 0.2f));
            g.fillRect(0, 0, this.screen.w, this.screen.h);
            this.aide = Rect.rect(2, 2, this.screen.w - 4, this.screen.h - 4);
            g.setColor(Color.getHSBColor(0.13f, 1.0f, 1.0f));
            this.board = Rect.rect(this.aide.x + 40, this.aide.y + 15, this.aide.w - 40 - 0, this.aide.h - 15 - 20);
            g.drawRect(this.board.x, this.board.y, this.board.w, this.board.h);
            g.drawString(TAG_ERROR, this.board.x - 40, this.board.y + this.board.h / 2);
            g.drawString(TAG_EPOCH, this.board.x + this.board.w / 2, this.board.y + this.board.h + 20);
            g.setColor(Color.getHSBColor(0.13f, 0.5f, 0.5f));
            int j = 0;
            while (j <= 5) {
                float axis = GraphViewer.this.axes.t * (float)(5 - j) / 5.0f;
                g.drawString(String.format("%.2e", Float.valueOf(axis)), this.board.x - 40 + 5, this.board.y + this.board.h * j / 5);
                ++j;
            }
            int xMax = GraphViewer.this.axes.r * GraphViewer.this.interval;
            int xMin = GraphViewer.this.axes.l * GraphViewer.this.interval;
            int xWidth = xMax - xMin;
            int j2 = 0;
            while (j2 < 5) {
                float axis = (float)xWidth * (float)j2 / 5.0f + (float)xMin;
                g.drawString(String.format("%.0f", Float.valueOf(axis)), this.board.x + this.board.w * j2 / 5, this.board.y + this.board.h + 20 - 5);
                ++j2;
            }
            String axis = String.valueOf(xWidth + xMin);
            g.drawString(axis, this.board.x + this.board.w - 25, this.board.y + this.board.h + 20 - 5);
            int j3 = 1;
            while (j3 < 5) {
                g.drawLine(this.board.x - 5, this.board.y + this.board.h * j3 / 5, this.board.x + this.board.w, this.board.y + this.board.h * j3 / 5);
                ++j3;
            }
            j3 = 1;
            while (j3 < 5) {
                g.drawLine(this.board.x + this.board.w * j3 / 5, this.board.y, this.board.x + this.board.w * j3 / 5, this.board.y + this.board.h + 5);
                ++j3;
            }
            g.setColor(Color.WHITE);
            g.drawString(TimeStamp.getTimeFormated(), 50, 15);
            g.setColor(Color.YELLOW);
            g.drawString(TAG_EPOCH, this.screen.w - 100, 35);
            String epochStr = String.valueOf(GraphViewer.this.epochCount);
            g.drawString(epochStr, this.screen.w - 60, 35);
            this.drawGraph(g);
            this.writeData(g);
        }

        private void drawGraph(Graphics g) {
            this.updateParameter();
            int k = 2;
            while (k < GraphViewer.this.sampleCount) {
                float[] sDataSet = GraphViewer.this.dataList.get(k - 1);
                float[] eDataSet = GraphViewer.this.dataList.get(k);
                int i = 0;
                while (i < GraphViewer.this.dataNum) {
                    Fig sFig = Fig.fig(k - 2, sDataSet[i]);
                    Fig eFig = Fig.fig(k - 1, eDataSet[i]);
                    Dot sDot = this.getDot(sFig);
                    Dot eDot = this.getDot(eFig);
                    g.setColor(this.getPaletColor(i));
                    g.drawLine(sDot.e, sDot.f, eDot.e, eDot.f);
                    ++i;
                }
                ++k;
            }
        }

        private void updateParameter() {
            float xMag = (float)this.board.w / (float)(GraphViewer.this.axes.r - GraphViewer.this.axes.l);
            float xShift = -((float)GraphViewer.this.axes.l) * xMag + (float)this.board.x;
            float yMag = -((float)this.board.h) / (GraphViewer.this.axes.t - GraphViewer.this.axes.b);
            float yShift = -GraphViewer.this.axes.b * yMag + (float)(this.board.y + this.board.h);
            this.param = Quad.quad(xMag, xShift, yMag, yShift);
        }

        private Dot getDot(Fig fig) {
            int e = (int)((float)fig.t * this.param.m + this.param.n);
            int f = (int)(fig.v * this.param.s + this.param.t);
            return Dot.dot(e, f);
        }

        private void writeData(Graphics g) {
            int i = 0;
            while (i < GraphViewer.this.dataNum) {
                g.setColor(this.getPaletColor(i));
                g.drawString(GraphViewer.this.dataName[i], 72, 20 * i + 45);
                float val = (float)GraphViewer.this.graphData[i];
                g.drawString(String.valueOf(val), 152, 20 * i + 45);
                ++i;
            }
        }

        @Override
        public void update(Graphics g) {
            Dimension dim = this.getSize();
            Image offImage = this.createImage(dim.width, dim.height);
            Graphics offGraphics = offImage.getGraphics();
            if (offImage != null) {
                this.paint(offGraphics);
                g.drawImage(offImage, 0, 0, null);
            }
        }

        private void setColorPalet() {
            float aHue = 0.0f;
            float aMag = 0.9f;
            float aDim = 0.9f;
            int i = 0;
            while (i < 11) {
                aHue = 2.0f * (float)i / 11.0f;
                if (aHue > 1.0f) {
                    aHue -= 1.0f;
                    aMag = 0.6f;
                    aDim = 0.8f;
                }
                if (i == 5) {
                    aMag = 0.6f;
                }
                if (i == 13) {
                    aMag = 0.3f;
                }
                this.colorPalet[i] = Color.getHSBColor(aHue, aMag, aDim);
                ++i;
            }
        }

        private Color getPaletColor(int id) {
            return this.colorPalet[id];
        }
    }
}

