/*
 * Decompiled with CFR 0.152.
 */
package view;

import util.DJ;
import view.GraphViewer;
import view.ViewerLauncher;

public class GraphViewerLauncher
extends ViewerLauncher {
    private GraphViewer graphViewer;
    Thread graphViewerThread;
    int epoch;
    int interval;
    String[] dataName;
    double[] graphData;

    public GraphViewerLauncher(int epoch, int interval, String[] dataName, double[] graphData) {
        this.epoch = epoch;
        this.interval = interval;
        this.dataName = dataName;
        this.graphData = graphData;
        this.graphViewerThread = new Thread(this);
        this.graphViewerThread.setPriority(5);
        this.startThread();
    }

    private void startThread() {
        this.graphViewerThread.start();
    }

    @Override
    public void run() {
        this.graphViewer = new GraphViewer(this.epoch, this.interval, this.dataName, this.graphData);
        this.graphViewer.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphViewer getGraphViewer() {
        Boolean waitFlag = true;
        GraphViewerLauncher graphViewerLauncher = this;
        synchronized (graphViewerLauncher) {
            while (waitFlag.booleanValue()) {
                try {
                    this.wait(1L);
                    if (this.graphViewer == null) continue;
                    waitFlag = false;
                }
                catch (InterruptedException e) {
                    DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Exception occur in while loop:" + e.toString());
                }
            }
        }
        if (this.graphViewer == null) {
            DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n" + " Failed to get graphViewer.");
        }
        return this.graphViewer;
    }
}

