/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import task.Task;
import util.LogEditor;
import util.TimeStamp;
import view.BoundsProperty;
import view.Console;
import view.DoubleProperty;
import view.FloatProperty;
import view.IntProperty;
import view.Property;
import view.StringProperty;
import view.Viewer;

public class PropertyViewer
extends Viewer {
    public static final String FILE_NAME = "Property.ini";
    public static final String BOUNDS_NAME = "propertyBounds";
    private static Console console;
    ArrayList<String> stringList;
    Class clazz;
    Task task;
    String appName;
    ArrayList<BoundsProperty> boundsList;
    ArrayList<Property> parameterList;
    ArrayList<String> buf;
    CardLayout cardLayout = new CardLayout();
    private JButton cancelButton;
    private JButton cardButton;
    private JLabel commentLabel;
    private JPanel controlPanel;
    private JButton loadButton;
    private JPanel mainPanel;
    private JLabel nameLabel;
    private JPanel propertyPanel;
    private JTextArea propertyTextArea;
    private JButton saveButton;
    private JButton setButton;
    private JPanel tableCard;
    private JPanel tablePanel;
    private JScrollPane tableScrollPane;
    private JLabel taskLabel;
    private JTextField tasknameTextField;
    private JPanel textCard;
    private JScrollPane textScrollPane;
    private JPanel titlePanel;
    private JLabel typeLabel;
    private JLabel valueLabel;

    public PropertyViewer(Console aConsole) {
        this.initComponents();
        console = aConsole;
        this.readProperty();
    }

    public final void readProperty() {
        this.stringList = LogEditor.loadText(FILE_NAME);
        if (this.stringList == null) {
            LogEditor.print("***** ERROR ***** PropertyViewer.readProperty():");
            LogEditor.print("Failed to read a property file.");
            return;
        }
        int propertyNum = this.stringList.size();
        int i = 0;
        while (i < propertyNum) {
            String line = this.stringList.get(i);
            this.writeToTextArea(String.valueOf(line) + "\n");
            ++i;
        }
        this.analizeProperty();
        this.placeParameterStrip();
    }

    private void analizeProperty() {
        this.writeToTextArea("\n\u30a2\u30d7\u30ea\u3068\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u62bd\u51fa\n");
        this.boundsList = new ArrayList();
        this.parameterList = new ArrayList();
        int propertyNum = this.stringList.size();
        int i = 0;
        while (i < propertyNum) {
            String line = this.stringList.get(i);
            if (!line.startsWith("#") && !line.startsWith("[")) {
                if (line.startsWith("APL")) {
                    this.pickoutAppName(line);
                } else if (line.startsWith("BND")) {
                    this.pickoutBounds(line);
                } else if (line.startsWith("PRM")) {
                    this.pickoutParameter(line);
                }
            }
            ++i;
        }
        if (this.parameterList != null) {
            int prmNum = this.parameterList.size();
            int i2 = 0;
            while (i2 < prmNum) {
                Property prop = this.parameterList.get(i2);
                this.writeToTextArea("Param: Name=" + prop.getName() + ", Type=" + prop.getType() + ", Value=" + prop.getValue() + ", Comment=" + prop.getComment() + "\n");
                ++i2;
            }
        }
    }

    private void pickoutAppName(String line) {
        StringTokenizer token = new StringTokenizer(line, ",");
        if (token.hasMoreTokens()) {
            String propertyLabel = token.nextToken();
            if (token.hasMoreTokens()) {
                this.appName = token.nextToken();
                this.writeToTextArea("Application: Name=" + this.appName + "\n");
                this.tasknameTextField.setText(this.appName);
                return;
            }
        }
        LogEditor.print("***** WARNING ***** PropertyViewer.pickoutAppName(): ");
        LogEditor.print("There are no next-token.");
    }

    public String getAppName() {
        return this.appName;
    }

    private void pickoutBounds(String line) {
        Property prop;
        StringTokenizer token = new StringTokenizer(line, ",");
        String propertyLabel = token.nextToken();
        String propertyType = token.nextToken();
        try {
            Class<?> propClass = Class.forName("view." + propertyType);
            prop = (Property)propClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LogEditor.print("***** WARNING ***** PropertyViewer.pickoutBounds():");
            LogEditor.print("ReflectiveOperationException occur.");
            return;
        }
        prop.setType(propertyType);
        prop.setName(token.nextToken());
        Rectangle rect = new Rectangle();
        rect.x = Integer.parseInt(token.nextToken());
        rect.y = Integer.parseInt(token.nextToken());
        rect.width = Integer.parseInt(token.nextToken());
        rect.height = Integer.parseInt(token.nextToken());
        prop.setValue(rect);
        prop.setComment(token.nextToken());
        this.writeToTextArea("Bounds: Name=" + prop.getName() + ", Type=" + prop.getType() + ", x=" + ((Rectangle)prop.getValue()).x + ", y=" + ((Rectangle)prop.getValue()).y + ", w=" + ((Rectangle)prop.getValue()).width + ", h=" + ((Rectangle)prop.getValue()).height + "\n");
        this.boundsList.add((BoundsProperty)prop);
    }

    private ArrayList<BoundsProperty> getBoundsProperty() {
        return this.boundsList;
    }

    public Rectangle getBoundsValue(String boundsName) {
        int boundsNum = this.boundsList.size();
        Rectangle rect = null;
        int i = 0;
        while (i < boundsNum) {
            BoundsProperty boundsProp = this.boundsList.get(i);
            String propName = boundsProp.getName();
            if (propName.equals(boundsName)) {
                rect = (Rectangle)boundsProp.getValue();
                break;
            }
            ++i;
        }
        return rect;
    }

    public void restoreBoundsList() {
        int boundsNum = this.boundsList.size();
        int i = 0;
        while (i < boundsNum) {
            String propName;
            BoundsProperty boundsProp = this.boundsList.get(i);
            switch (propName = boundsProp.getName()) {
                case "consoleBounds": {
                    Rectangle viewerRect = console.getBounds();
                    boundsProp.setValue(viewerRect);
                    break;
                }
                case "propertyBounds": {
                    Rectangle viewerRect = this.getBounds();
                    boundsProp.setValue(viewerRect);
                    break;
                }
                case "patternBounds": {
                    Rectangle viewerRect = this.getViewerBounds("patternViewer");
                    if (viewerRect == null) break;
                    boundsProp.setValue(viewerRect);
                    break;
                }
                case "graphBounds": {
                    Rectangle viewerRect = this.getViewerBounds("graphViewer");
                    if (viewerRect == null) break;
                    boundsProp.setValue(viewerRect);
                    break;
                }
            }
            ++i;
        }
    }

    private Rectangle getViewerBounds(String viewerName) {
        Rectangle bounds = null;
        try {
            Class<?> superClass = this.task.getClass().getSuperclass();
            Field viewer = superClass.getDeclaredField(viewerName);
            viewer.setAccessible(true);
            JFrame aViewer = (JFrame)viewer.get(this.task);
            bounds = aViewer.getBounds();
        }
        catch (NullPointerException e) {
            LogEditor.print("***** WARNING ***** PropertyViewer.getViewerBounds():");
            LogEditor.print("There is no " + viewerName + ".");
        }
        catch (ReflectiveOperationException e) {
            LogEditor.print("***** ERROR ***** PropertyViewer.getViewerBounds():");
            LogEditor.print("ReflectiveOperationException occur.");
        }
        return bounds;
    }

    private void pickoutParameter(String line) {
        StringTokenizer token = new StringTokenizer(line, ",");
        int tokenNum = token.countTokens();
        if (tokenNum < 5) {
            LogEditor.print("***** WARNING ***** PropertyViewer.pickoutParameter():");
            LogEditor.print(" token=" + tokenNum + " < 5.");
            return;
        }
        String propertyLabel = token.nextToken();
        String propertyType = token.nextToken();
        Property prop = null;
        switch (propertyType) {
            case "int": {
                prop = new IntProperty();
                prop.setName(token.nextToken());
                String propertyValue = token.nextToken().trim();
                prop.setValue(Integer.parseInt(propertyValue));
                break;
            }
            case "double": {
                prop = new DoubleProperty();
                prop.setName(token.nextToken());
                String propertyValue = token.nextToken().trim();
                prop.setValue(Double.parseDouble(propertyValue));
                break;
            }
            case "float": {
                prop = new FloatProperty();
                prop.setName(token.nextToken());
                String propertyValue = token.nextToken().trim();
                prop.setValue(Float.valueOf(Float.parseFloat(propertyValue)));
                break;
            }
            case "String": {
                prop = new StringProperty();
                prop.setName(token.nextToken());
                String propertyValue = token.nextToken().trim();
                prop.setValue(propertyValue);
                break;
            }
        }
        if (prop != null) {
            prop.setComment(token.nextToken());
            this.parameterList.add(prop);
        }
    }

    /*
     * Exception decompiling
     */
    private void placeParameterStrip() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl50 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl50 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void restoreParamerList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl58 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl58 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean checkParameterChange() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl56 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl56 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean disposal() {
        LogEditor.print("PropertyViewer.disposal():\u3000disposal() is called.");
        int ans = JOptionPane.showConfirmDialog(console, "\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5909\u66f4\u306f\u6709\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u305b\u3093\u3002\n\u3000\u306f\u3044\u3001\u5909\u66f4\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002\n\u3000\u3044\u3044\u3048\u3001\u5909\u66f4\u3092\u7834\u68c4\u3057\u307e\u3059\u3002\n\u3000\u30bf\u30b9\u30af\u306e\u5b9f\u884c\u3092\u53d6\u6d88\u307e\u3059\u3002", "\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059", 1, 2);
        switch (ans) {
            case 0: {
                this.restoreParamerList();
                LogEditor.print("PropertyViewer.disposal(): All parameters are saved.");
                break;
            }
            case 1: {
                this.placeParameterStrip();
                LogEditor.print("PropertyViewer.disposal(): Changed parameter are discarded.");
                break;
            }
            default: {
                LogEditor.print("PropertyViewer.disposal(): Task run operation is canceled.");
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tableCard = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.propertyPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.taskLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.commentLabel = new JLabel();
        this.tasknameTextField = new JTextField();
        this.tablePanel = new JPanel();
        this.textCard = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.propertyTextArea = new JTextArea();
        this.controlPanel = new JPanel();
        this.saveButton = new JButton();
        this.loadButton = new JButton();
        this.cardButton = new JButton();
        this.cancelButton = new JButton();
        this.setButton = new JButton();
        this.setTitle("DaiJa : Property viewer");
        this.mainPanel.setPreferredSize(new Dimension(600, 350));
        this.mainPanel.setLayout(new CardLayout());
        this.tableCard.setPreferredSize(new Dimension(600, 350));
        this.tableCard.setLayout(new BorderLayout());
        this.tableScrollPane.setHorizontalScrollBarPolicy(31);
        this.propertyPanel.setPreferredSize(new Dimension(600, 348));
        this.propertyPanel.setLayout(new BorderLayout());
        this.titlePanel.setPreferredSize(new Dimension(600, 55));
        this.taskLabel.setHorizontalAlignment(11);
        this.taskLabel.setText("  Task");
        this.typeLabel.setText("Type");
        this.nameLabel.setText("Name");
        this.valueLabel.setText("Value");
        this.commentLabel.setText("Comment");
        this.tasknameTextField.setEditable(false);
        this.tasknameTextField.setText("Task name");
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addContainerGap().addGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeLabel, -2, 34, -2).addComponent(this.taskLabel, GroupLayout.Alignment.TRAILING, -2, 34, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.nameLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.valueLabel, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.commentLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.tasknameTextField, -2, 276, -2)).addContainerGap(266, Short.MAX_VALUE)));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, titlePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taskLabel).addComponent(this.tasknameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.nameLabel).addComponent(this.valueLabel).addComponent(this.commentLabel)).addGap(17, 17, 17)));
        this.propertyPanel.add((Component)this.titlePanel, "North");
        this.tablePanel.setMinimumSize(new Dimension(400, 180));
        this.tablePanel.setPreferredSize(new Dimension(400, 180));
        this.tablePanel.setLayout(new GridLayout(17, 0));
        this.propertyPanel.add((Component)this.tablePanel, "Center");
        this.tableScrollPane.setViewportView(this.propertyPanel);
        this.tableCard.add((Component)this.tableScrollPane, "Center");
        this.mainPanel.add((Component)this.tableCard, "tableCard");
        this.textCard.setPreferredSize(new Dimension(600, 350));
        this.textCard.setLayout(new BorderLayout());
        this.propertyTextArea.setColumns(20);
        this.propertyTextArea.setRows(5);
        this.textScrollPane.setViewportView(this.propertyTextArea);
        this.textCard.add((Component)this.textScrollPane, "Center");
        this.mainPanel.add((Component)this.textCard, "textCard");
        this.mainPanel.setLayout(this.cardLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setPreferredSize(new Dimension(600, 24));
        this.saveButton.setText("Save");
        this.saveButton.setMargin(new Insets(2, 10, 2, 10));
        this.saveButton.setPreferredSize(new Dimension(46, 18));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyViewer.this.saveButtonActionPerformed(evt);
            }
        });
        this.loadButton.setText("Re-read");
        this.loadButton.setMargin(new Insets(2, 10, 2, 10));
        this.loadButton.setPreferredSize(new Dimension(63, 18));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyViewer.this.loadButtonActionPerformed(evt);
            }
        });
        this.cardButton.setText("Next Page");
        this.cardButton.setMargin(new Insets(2, 10, 2, 10));
        this.cardButton.setPreferredSize(new Dimension(76, 18));
        this.cardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyViewer.this.cardButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("");
        this.cancelButton.setMargin(new Insets(2, 10, 2, 10));
        this.cancelButton.setPreferredSize(new Dimension(57, 18));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyViewer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.setButton.setText("Set");
        this.setButton.setMargin(new Insets(2, 10, 2, 10));
        this.setButton.setPreferredSize(new Dimension(38, 18));
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyViewer.this.setButtonActionPerformed(evt);
            }
        });
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.saveButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cardButton, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setButton, -2, 48, -2).addContainerGap()));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton, -2, -1, -2).addComponent(this.loadButton, -2, -1, -2).addComponent(this.cardButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.setButton, -2, -1, -2)).addGap(0, 2, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void cardButtonActionPerformed(ActionEvent evt) {
        this.cardLayout.next(this.mainPanel);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.restoreBoundsList();
        this.restoreParamerList();
        this.restoreProperty();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.readProperty();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.placeParameterStrip();
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        this.restoreParamerList();
    }

    public final void writeToTextArea(String text) {
        this.propertyTextArea.append(text);
    }

    public void putBounds() {
        Rectangle rect = this.getBoundsValue(BOUNDS_NAME);
        if (rect != null) {
            this.setBounds(rect);
        } else {
            this.setBounds(600, 0, 400, 400);
        }
    }

    public void putParameter(Class clazz, Task task) {
        this.clazz = clazz;
        this.task = task;
        int prmNum = this.parameterList.size();
        int i = 0;
        while (i < prmNum) {
            Property prmProp = this.parameterList.get(i);
            String fieldName = prmProp.getName();
            String fieldType = prmProp.getType();
            Object prmValue = null;
            switch (fieldType) {
                case "int": {
                    prmValue = (int)((Integer)prmProp.getValue());
                    break;
                }
                case "double": {
                    prmValue = (double)((Double)prmProp.getValue());
                    break;
                }
                case "String": {
                    prmValue = (String)prmProp.getValue();
                    break;
                }
                case "float": {
                    prmValue = Float.valueOf(((Float)prmProp.getValue()).floatValue());
                    break;
                }
                default: {
                    LogEditor.print("***** ERROR ***** PropertyViewer.putParameter():");
                    LogEditor.print("No such a parameter type:" + fieldType);
                    return;
                }
            }
            try {
                Field prmField = clazz.getDeclaredField(fieldName);
                prmField.setAccessible(true);
                this.writeToTextArea(String.valueOf(fieldName) + " Before: " + prmField.get(task).toString() + ", ");
                prmField.set(task, prmValue);
                this.writeToTextArea(" After:" + prmField.get(task).toString() + "\n");
            }
            catch (ReflectiveOperationException e) {
                LogEditor.print("***** WARNING ***** PropertyViewer.putParameter():");
                LogEditor.print("ReflectiveOperationException occur:" + fieldName);
            }
            ++i;
        }
    }

    public void restoreProperty() {
        this.buf = new ArrayList(100);
        this.addRL("#Title:DaiJa Property file");
        String taskName = this.appName.replaceFirst("task.", "");
        String fileName = "DaiJaProperty_" + taskName + "_" + TimeStamp.getDateAndTime() + ".ini";
        this.addRL("#File name:" + fileName);
        this.addRL("#");
        this.addRL("[TIME] #Date and Time");
        this.addRL("VAL,String,date," + TimeStamp.getDateStamp() + ",\u5e74\uff0f\u6708\uff0f\u65e5");
        this.addRL("VAL,String,time," + TimeStamp.getTimeStamp() + ",\u6642\uff1a\u5206\uff1a\u79d2");
        this.addRL("#");
        this.addRL("[BND] #Bounds properties");
        int boundsNum = this.boundsList.size();
        int i = 0;
        while (i < boundsNum) {
            BoundsProperty boundsProp = this.boundsList.get(i);
            String propName = boundsProp.getName();
            Rectangle rect = (Rectangle)boundsProp.getValue();
            this.addRL("BND,BoundsProperty," + propName + "," + rect.x + "," + rect.y + "," + rect.width + "," + rect.height + "," + boundsProp.getComment());
            ++i;
        }
        this.addRL("#");
        this.addRL("[APL] #Application");
        this.addRL("APL," + this.appName);
        this.addRL("#");
        this.addRL("[PRM] #Parameters");
        int parameterNum = this.parameterList.size();
        int i2 = 0;
        while (i2 < parameterNum) {
            Property prmProp = this.parameterList.get(i2);
            String prmName = prmProp.getName();
            String prmType = prmProp.getType();
            String value = String.valueOf(prmProp.getValue());
            String comment = prmProp.getComment();
            this.addRL("PRM," + prmType + "," + prmName + "," + value + "," + comment);
            ++i2;
        }
        this.addRL("#");
        this.addRL("[EOF] #End of file");
        LogEditor.saveText(this.buf, fileName);
    }

    private void addRL(String line) {
        this.buf.add(String.valueOf(line) + "\r\n");
    }
}

