/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class SomDrawer
extends Canvas {
    public static final int MAX_INDEX = 1000;
    private Image offImage;
    private Graphics offGraphics;
    private Color[] colorPalet;
    private static final int X_SPACE = 20;
    private static final int Y_SPACE = 20;
    private float zMax;
    private float zMin;
    private static final int MAP_SIZE_X = 400;
    private static final int MAP_SIZE_Y = 400;
    private int mapSizeX = 400;
    private int mapSizeY = 400;
    private static final int GRID_X = 40;
    private static final int GRID_Y = 40;
    private int numOfGridX;
    private int deltax;
    private int numOfGridY;
    private int deltay;
    private static final int NUM_OF_CONTOUR = 12;
    private int maxColor = 13;
    private int numOfContour;
    private double[][] f;
    private double[][] out;
    private double fmax;
    private double fmin;
    private String[][] theLabelMap;
    private boolean evaluateFlag;
    private boolean borderFlag;

    public SomDrawer() {
        this.setSize(this.mapSizeY, this.mapSizeX);
        this.numOfGridX = 40;
        this.numOfGridY = 40;
        this.numOfContour = 12;
        this.maxColor = this.numOfContour + 1;
        this.setColorPalet();
    }

    public void dataset() {
        int j;
        this.fmax = 0.0;
        this.fmin = 1.0E30;
        int i = 0;
        while (i <= this.numOfGridX) {
            j = 0;
            while (j <= this.numOfGridY) {
                if (this.f[i][j] >= this.fmax) {
                    this.fmax = this.f[i][j];
                }
                if (this.f[i][j] <= this.fmin) {
                    this.fmin = this.f[i][j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= this.numOfGridX) {
            j = 0;
            while (j <= this.numOfGridY) {
                this.out[i][j] = (this.f[i][j] - this.fmin) / (this.fmax - this.fmin);
                ++j;
            }
            ++i;
        }
    }

    double getDab(int k, double level, double[] d) {
        return (level - d[k + 1]) / (d[k] - d[k + 1]);
    }

    int getXab(int k, double level, double d, double[] x) {
        return (int)((1.0 - d) * x[k + 1] + d * x[k] + 0.5);
    }

    int getYab(int k, double level, double d, double[] y) {
        return (int)((1.0 - d) * y[k + 1] + d * y[k] + 0.5);
    }

    double getDae(int k, double level, double[] d) {
        return (level - d[k]) / (d[6] - d[k]);
    }

    int getXae(int k, double level, double d, double[] x) {
        return (int)((1.0 - d) * x[k] + d * x[6] + 0.5);
    }

    int getYae(int k, double level, double d, double[] y) {
        return (int)((1.0 - d) * y[k] + d * y[6] + 0.5);
    }

    double getDbe(int k, double level, double[] d) {
        return (level - d[6]) / (d[k + 1] - d[6]);
    }

    int getXbe(int k, double level, double d, double[] x) {
        return (int)((1.0 - d) * x[6] + d * x[k + 1] + 0.5);
    }

    int getYbe(int k, double level, double d, double[] y) {
        return (int)((1.0 - d) * y[6] + d * y[k + 1] + 0.5);
    }

    void fillDelta(Graphics g, int colorIndex, double x1, double x2, double x3, double y1, double y2, double y3) {
        Color gc = g.getColor();
        g.setColor(this.getPaletColor(colorIndex));
        int[] px = new int[]{(int)x1, (int)x2, (int)x3, (int)x1};
        int[] py = new int[]{(int)y1, (int)y2, (int)y3, (int)y1};
        g.fillPolygon(py, px, 4);
        g.setColor(gc);
    }

    void fillQuad(Graphics g, int colorIndex, double x1, double x2, double x3, double x4, double y1, double y2, double y3, double y4) {
        Color gc = g.getColor();
        g.setColor(this.getPaletColor(colorIndex));
        int[] px = new int[]{(int)x1, (int)x2, (int)x3, (int)x4, (int)x1};
        int[] py = new int[]{(int)y1, (int)y2, (int)y3, (int)y4, (int)y1};
        g.fillPolygon(py, px, 5);
        g.setColor(gc);
    }

    @Override
    public void paint(Graphics g) {
        int j;
        g.translate(10, 10);
        g.setColor(Color.darkGray);
        g.fillRect(0, 0, this.mapSizeY + 40, this.mapSizeX + 40);
        g.setColor(Color.lightGray);
        g.translate(20, 20);
        if (this.f == null) {
            return;
        }
        this.numOfGridX = this.f.length - 1;
        this.numOfGridY = this.f[0].length - 1;
        this.out = new double[this.numOfGridX + 1][this.numOfGridY + 1];
        this.deltax = this.mapSizeX / this.numOfGridX;
        if (this.deltax < 4) {
            this.deltax = 4;
        }
        this.deltay = this.mapSizeY / this.numOfGridY;
        if (this.deltay < 4) {
            this.deltay = 4;
        }
        this.dataset();
        double[] x = new double[7];
        double[] y = new double[7];
        double[] d = new double[7];
        int i = 0;
        while (i < this.numOfGridX) {
            j = 0;
            while (j < this.numOfGridY) {
                double x1 = i * this.deltax;
                double x2 = (i + 1) * this.deltax;
                double y1 = j * this.deltay;
                double y2 = (j + 1) * this.deltay;
                double xcent = (x1 + x2) / 2.0;
                double ycent = (y1 + y2) / 2.0;
                x[1] = x1;
                x[2] = x2;
                x[3] = x2;
                x[4] = x1;
                x[5] = x[1];
                x[6] = xcent;
                y[1] = y1;
                y[2] = y1;
                y[3] = y2;
                y[4] = y2;
                y[5] = y[1];
                y[6] = ycent;
                d[1] = this.out[i][j];
                d[2] = this.out[i + 1][j];
                d[3] = this.out[i + 1][j + 1];
                d[4] = this.out[i][j + 1];
                d[5] = d[1];
                d[6] = (d[1] + d[2] + d[3] + d[4]) / 4.0;
                int k = 1;
                while (k <= 4) {
                    boolean continuFlag = false;
                    int line = 0;
                    while (line <= this.numOfContour) {
                        double level = 1.0 / (double)this.numOfContour * (double)line;
                        if (this.borderFlag) {
                            level = this.zMax;
                        }
                        int levelIndex = 0;
                        if (d[k] > level) {
                            levelIndex += 4;
                        }
                        if (d[k + 1] > level) {
                            levelIndex += 2;
                        }
                        if (d[6] > level) {
                            ++levelIndex;
                        }
                        switch (levelIndex) {
                            case 0: {
                                continuFlag = true;
                                break;
                            }
                            case 1: {
                                double dae = this.getDae(k, level, d);
                                double xae = this.getXae(k, level, dae, x);
                                double yae = this.getYae(k, level, dae, y);
                                double dbe = this.getDbe(k, level, d);
                                double xbe = this.getXbe(k, level, dbe, x);
                                double ybe = this.getYbe(k, level, dbe, y);
                                this.fillDelta(g, line, x[6], xbe, xae, y[6], ybe, yae);
                                g.drawLine((int)ybe, (int)xbe, (int)yae, (int)xae);
                                break;
                            }
                            case 2: {
                                double dab = this.getDab(k, level, d);
                                double xab = this.getXab(k, level, dab, x);
                                double yab = this.getYab(k, level, dab, y);
                                double dbe = this.getDbe(k, level, d);
                                double xbe = this.getXbe(k, level, dbe, x);
                                double ybe = this.getYbe(k, level, dbe, y);
                                this.fillDelta(g, line, x[k + 1], xab, xbe, y[k + 1], yab, ybe);
                                g.drawLine((int)yab, (int)xab, (int)ybe, (int)xbe);
                                break;
                            }
                            case 3: {
                                double dae = this.getDae(k, level, d);
                                double xae = this.getXae(k, level, dae, x);
                                double yae = this.getYae(k, level, dae, y);
                                double dab = this.getDab(k, level, d);
                                double xab = this.getXab(k, level, dab, x);
                                double yab = this.getYab(k, level, dab, y);
                                this.fillQuad(g, line, x[k + 1], x[6], xae, xab, y[k + 1], y[6], yae, yab);
                                g.drawLine((int)yae, (int)xae, (int)yab, (int)xab);
                                break;
                            }
                            case 4: {
                                double dab = this.getDab(k, level, d);
                                double xab = this.getXab(k, level, dab, x);
                                double yab = this.getYab(k, level, dab, y);
                                double dae = this.getDae(k, level, d);
                                double xae = this.getXae(k, level, dae, x);
                                double yae = this.getYae(k, level, dae, y);
                                this.fillDelta(g, line, x[k], xab, xae, y[k], yab, yae);
                                g.drawLine((int)yab, (int)xab, (int)yae, (int)xae);
                                break;
                            }
                            case 5: {
                                double dab = this.getDab(k, level, d);
                                double xab = this.getXab(k, level, dab, x);
                                double yab = this.getYab(k, level, dab, y);
                                double dbe = this.getDbe(k, level, d);
                                double xbe = this.getXbe(k, level, dbe, x);
                                double ybe = this.getYbe(k, level, dbe, y);
                                this.fillQuad(g, line, x[6], x[k], xab, xbe, y[6], y[k], yab, ybe);
                                g.drawLine((int)yab, (int)xab, (int)ybe, (int)xbe);
                                break;
                            }
                            case 6: {
                                double dae = this.getDae(k, level, d);
                                double xae = this.getXae(k, level, dae, x);
                                double yae = this.getYae(k, level, dae, y);
                                double dbe = this.getDbe(k, level, d);
                                double xbe = this.getXbe(k, level, dbe, x);
                                double ybe = this.getYbe(k, level, dbe, y);
                                this.fillQuad(g, line, x[k], x[k + 1], xbe, xae, y[k], y[k + 1], ybe, yae);
                                g.drawLine((int)ybe, (int)xbe, (int)yae, (int)xae);
                                break;
                            }
                            case 7: {
                                this.fillDelta(g, line, x[k], x[k + 1], x[6], y[k], y[k + 1], y[6]);
                                break;
                            }
                        }
                        if (continuFlag) break;
                        ++line;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Color sc = g.getColor();
        g.setColor(Color.red);
        i = 0;
        while (i < this.numOfGridX) {
            j = 0;
            while (j < this.numOfGridY) {
                String ls = this.theLabelMap[i / 2][j / 2];
                if (ls != null) {
                    int fontHight = g.getFontMetrics().getHeight();
                    g.drawString(ls, j * this.deltay, i * this.deltax + fontHight / 2);
                }
                j += 2;
            }
            i += 2;
        }
        g.setColor(sc);
    }

    @Override
    public void update(Graphics g) {
        Dimension canvasSize = this.getSize();
        this.offImage = this.createImage(canvasSize.width, canvasSize.height);
        this.offGraphics = this.offImage.getGraphics();
        if (this.offImage != null) {
            this.paint(this.offGraphics);
            g.drawImage(this.offImage, 0, 0, null);
        }
    }

    void showLabel(Graphics g, String[][] aLabelMap) {
        Color sc = g.getColor();
        g.setColor(Color.red);
        int i = 0;
        while (i < this.numOfGridX) {
            int j = 0;
            while (j < this.numOfGridY) {
                String ls = aLabelMap[i / 2][j / 2];
                if (ls != null) {
                    g.drawString(ls, (this.numOfGridY - j) * this.deltay, i * this.deltax);
                }
                j += 2;
            }
            i += 2;
        }
        g.setColor(sc);
    }

    private void setColorPalet() {
        this.maxColor = this.numOfContour + 1;
        this.colorPalet = new Color[this.maxColor];
        int i = this.maxColor - 1;
        while (i >= 0) {
            float aDim;
            float aMag;
            float aHue = 2.0f - 2.0f * (float)i / (float)this.maxColor;
            if (aHue < 1.0f) {
                if (aHue > 0.8f) {
                    aMag = 0.7f;
                    aDim = 0.5f;
                } else {
                    aMag = 1.0f;
                    aDim = 1.0f;
                }
            } else if ((aHue -= 1.0f) < 0.4f) {
                aMag = 0.7f;
                aDim = 0.5f;
            } else if (aHue < 0.7f) {
                aMag = 0.6f;
                aDim = 0.4f;
            } else if (aHue < 0.95f) {
                aMag = 0.55f;
                aDim = 0.35f;
            } else {
                aMag = 0.4f;
                aDim = 0.25f;
            }
            this.colorPalet[i] = Color.getHSBColor(aHue, aMag, aDim);
            --i;
        }
    }

    private Color getPaletColor(int id) {
        return this.colorPalet[id];
    }

    public Color[] getColorPalet() {
        return this.colorPalet;
    }

    int getY(double yValue) {
        return this.mapSizeX - (int)yValue;
    }

    public void setUMapXSize(float uMapXSize) {
        this.mapSizeX = (int)uMapXSize;
    }

    public float getUMapXSize() {
        return this.mapSizeX;
    }

    public void setUMapYSize(float uMapYSize) {
        this.mapSizeY = (int)uMapYSize;
    }

    public float getUMapYSize() {
        return this.mapSizeY;
    }

    public void setZMax(float newMax) {
        this.zMax = newMax;
    }

    public float getZMax() {
        return this.zMax;
    }

    public void setZMin(float newMin) {
        this.zMin = newMin;
    }

    public float getZMin() {
        return this.zMin;
    }

    public void setNumOfContour(float numOfContour) {
        this.numOfContour = (int)numOfContour;
        this.setColorPalet();
    }

    public float getNumOfContour() {
        return this.numOfContour;
    }

    public boolean getEvaluateFlag() {
        return this.evaluateFlag;
    }

    public void setEvaluateFlag(boolean evaluateFlag) {
        this.evaluateFlag = evaluateFlag;
    }

    public boolean getBorderFlag() {
        return this.borderFlag;
    }

    public void setBorderFlag(boolean borderFlag) {
        this.borderFlag = borderFlag;
    }

    public void setCodeMap(double[][] newMapVector) {
        this.f = newMapVector;
    }

    public void setUMap(double[][] newUMatrix) {
        this.f = newUMatrix;
    }

    public void setLabelMap(String[][] newLabelMatrix) {
        this.theLabelMap = newLabelMatrix;
    }
}

