/*
 * Decompiled with CFR 0.152.
 */
package active;

import active.Activator;

public class Sigmoid
extends Activator {
    @Override
    public void function(double[] u, double[] y) {
        int length = u.length;
        for (int i = 0; i < length; ++i) {
            y[i] = 1.0 / (1.0 + Math.exp(-u[i]));
        }
    }

    @Override
    public void function(double[][] u, double[][] y) {
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < u[0].length; ++j) {
                y[i][j] = 1.0 / (1.0 + Math.exp(-u[i][j]));
            }
        }
    }

    @Override
    public void derivative(double[] u, double[] y, double[] dydu) {
        for (int i = 0; i < u.length; ++i) {
            dydu[i] = (1.0 - y[i]) * y[i];
        }
    }

    @Override
    public void derivative(double[][] u, double[][] y, double[][] dydu) {
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < u[0].length; ++j) {
                dydu[i][j] = (1.0 - y[i][j]) * y[i][j];
            }
        }
    }

    private double sigmoid(double u) {
        double y = 1.0 / (1.0 + Math.exp(-u));
        return y;
    }
}

