/*
 * Decompiled with CFR 0.152.
 */
package active;

import active.Activator;

public class SoftMax
extends Activator {
    @Override
    public void function(double[] u, double[] y) {
        int i;
        int length = u.length;
        double sum = 0.0;
        double[] expU = new double[length];
        for (i = 0; i < length; ++i) {
            expU[i] = Math.exp(u[i]);
            sum += expU[i];
        }
        for (i = 0; i < length; ++i) {
            y[i] = expU[i] / sum;
        }
    }

    @Override
    public void function(double[][] u, double[][] y) {
        int j;
        int i;
        int row = u.length;
        int col = u[0].length;
        double sum = 0.0;
        double[][] expU = new double[row][col];
        for (i = 0; i < row; ++i) {
            for (j = 0; j < col; ++j) {
                expU[i][j] = Math.exp(u[i][j]);
                sum += expU[i][j];
            }
        }
        for (i = 0; i < row; ++i) {
            for (j = 0; j < col; ++j) {
                y[i][j] = expU[i][j] / sum;
            }
        }
    }

    @Override
    public void derivative(double[] u, double[] y, double[] dydu) {
        int length = u.length;
        for (int i = 0; i < length; ++i) {
            dydu[i] = 1.0;
        }
    }

    @Override
    public void derivative(double[][] u, double[][] y, double[][] dudy) {
        int row = u.length;
        int col = u[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                dudy[i][j] = 1.0;
            }
        }
    }
}

