/*
 * Decompiled with CFR 0.152.
 */
package layer;

import active.Activator;
import java.util.Random;
import util.DJ;

public abstract class Layer {
    public static final int SGD = 0;
    public static final int ADA_GRAD = 1;
    public int inNodeNum;
    public int outNodeNum;
    public double[] x;
    public double[][] w;
    public double[] b;
    public double[] u;
    public double[] y;
    public double[] c;
    public double[] e;
    public double[] dEdX;
    public double[][] dEdW;
    public double[] dEdB;
    public double[] dEdU;
    public double[] dYdU;
    public double[] dEdY;
    public double[][] dEdW_sum;
    public double[] dEdB_sum;
    public double[][] hWeight;
    public double[] hBias;
    public Activator activator;
    public String activatorName;
    public GradientDescent gradientDescent;
    public double eta;

    public Layer(int inputNodeNum, int outputNodeNum) {
        this.inNodeNum = inputNodeNum;
        this.outNodeNum = outputNodeNum;
        this.x = new double[inputNodeNum];
        this.w = new double[outputNodeNum][inputNodeNum];
        this.b = new double[outputNodeNum];
        this.u = new double[outputNodeNum];
        this.y = new double[outputNodeNum];
        this.c = new double[outputNodeNum];
        this.e = new double[outputNodeNum];
        this.dEdX = new double[inputNodeNum];
        this.dEdW = new double[outputNodeNum][inputNodeNum];
        this.dEdB = new double[outputNodeNum];
        this.dEdU = new double[outputNodeNum];
        this.dYdU = new double[outputNodeNum];
        this.dEdY = new double[outputNodeNum];
        this.dEdW_sum = new double[outputNodeNum][inputNodeNum];
        this.dEdB_sum = new double[outputNodeNum];
        this.hWeight = new double[outputNodeNum][inputNodeNum];
        this.hBias = new double[outputNodeNum];
    }

    public void initialize() {
    }

    public void initialize(double eta, double initialCoef, String activatorName, int gradientDescentType) {
        this.activatorName = activatorName;
        this.eta = eta;
        Random randum = DJ.getRandom();
        for (int i = 0; i < this.outNodeNum; ++i) {
            for (int j = 0; j < this.inNodeNum; ++j) {
                this.w[i][j] = initialCoef * randum.nextGaussian();
                this.hWeight[i][j] = 1.0E-8;
            }
            this.b[i] = initialCoef * randum.nextGaussian();
            this.hBias[i] = 1.0E-8;
        }
        this.activator = Activator.createActivator(activatorName);
        switch (gradientDescentType) {
            case 1: {
                this.gradientDescent = new AdaGrad();
                break;
            }
            default: {
                this.gradientDescent = new SGD();
            }
        }
    }

    public double[] getX() {
        return this.x;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public double[][] getW() {
        return this.w;
    }

    public void setW(double[][] w) {
        this.w = w;
    }

    public double[] getB() {
        return this.b;
    }

    public void setB(double[] b) {
        this.b = b;
    }

    public double[] getU() {
        return this.u;
    }

    public void setU(double[] u) {
        this.u = u;
    }

    public double[] getY() {
        return this.y;
    }

    public void setY(double[] y) {
        this.y = y;
    }

    public double[] getC() {
        return this.c;
    }

    public void setC(double[] c) {
        this.c = c;
    }

    public double[] getE() {
        return this.e;
    }

    public void setE(double[] e) {
        this.e = e;
    }

    public double[] getdEdX() {
        return this.dEdX;
    }

    public void setdEdX(double[] dEdX) {
        this.dEdX = dEdX;
    }

    public double[] getdEdY() {
        return this.dEdY;
    }

    public void setdEdY(double[] dEdY) {
        this.dEdY = dEdY;
    }

    public void forward() {
        this.calcuOutput();
    }

    private void calcuOutput() {
        for (int i = 0; i < this.outNodeNum; ++i) {
            this.u[i] = this.b[i];
            for (int j = 0; j < this.inNodeNum; ++j) {
                this.u[i] = this.u[i] + this.w[i][j] * this.x[j];
            }
        }
        this.activator.function(this.u, this.y);
    }

    public void backward(double[] c) {
        this.calcuGradient(c);
    }

    public void backward() {
        this.calcuGradient();
    }

    public void calcuError() {
        for (int i = 0; i < this.outNodeNum; ++i) {
            this.e[i] = this.y[i] - this.c[i];
        }
        this.dEdY = this.e;
    }

    private void calcuGradient(double[] c) {
        this.activator.derivative(this.u, this.y, this.dYdU);
        for (int j = 0; j < this.inNodeNum; ++j) {
            this.dEdX[j] = 0.0;
        }
        for (int i = 0; i < this.outNodeNum; ++i) {
            this.e[i] = this.y[i] - c[i];
            this.dEdU[i] = this.e[i] * this.dYdU[i];
            this.dEdB[i] = this.dEdU[i];
            this.dEdB_sum[i] = this.dEdB_sum[i] + this.dEdB[i];
            for (int j = 0; j < this.inNodeNum; ++j) {
                this.dEdW[i][j] = this.dEdU[i] * this.x[j];
                this.dEdW_sum[i][j] = this.dEdW_sum[i][j] + this.dEdW[i][j];
                this.dEdX[j] = this.dEdX[j] + this.w[i][j] * this.dEdU[i];
            }
        }
    }

    private void calcuGradient() {
        switch (this.activatorName) {
            case "active.Sigmoid": {
                for (int i = 0; i < this.outNodeNum; ++i) {
                    this.dYdU[i] = (1.0 - this.y[i]) * this.y[i];
                    this.dEdU[i] = this.dEdY[i] * this.dYdU[i];
                    this.dEdB[i] = this.dEdU[i];
                    this.dEdB_sum[i] = this.dEdB_sum[i] + this.dEdB[i];
                    for (int j = 0; j < this.inNodeNum; ++j) {
                        this.dEdW[i][j] = this.dEdU[i] * this.x[j];
                        this.dEdW_sum[i][j] = this.dEdW_sum[i][j] + this.dEdW[i][j];
                        this.dEdX[j] = this.dEdX[j] + this.w[i][j] * this.dEdU[i];
                    }
                }
                break;
            }
            case "active.ReLU": {
                for (int j = 0; j < this.inNodeNum; ++j) {
                    this.dEdX[j] = 0.0;
                }
                for (int i = 0; i < this.outNodeNum; ++i) {
                    if (!(this.u[i] >= 0.0)) continue;
                    this.dYdU[i] = 1.0;
                    this.dEdU[i] = this.dEdY[i];
                    this.dEdB[i] = this.dEdU[i];
                    this.dEdB_sum[i] = this.dEdB_sum[i] + this.dEdB[i];
                    for (int j = 0; j < this.inNodeNum; ++j) {
                        this.dEdW[i][j] = this.dEdU[i] * this.x[j];
                        this.dEdW_sum[i][j] = this.dEdW_sum[i][j] + this.dEdW[i][j];
                        this.dEdX[j] = this.dEdX[j] + this.w[i][j] * this.dEdU[i];
                    }
                }
                break;
            }
            default: {
                for (int j = 0; j < this.inNodeNum; ++j) {
                    this.dEdX[j] = 1.0;
                }
            }
        }
    }

    public void update() {
        this.gradientDescent.descent();
    }

    private void updateGradient() {
        for (int i = 0; i < this.outNodeNum; ++i) {
            this.b[i] = this.b[i] - this.eta * this.dEdB_sum[i];
            this.dEdB_sum[i] = 0.0;
            for (int j = 0; j < this.inNodeNum; ++j) {
                this.w[i][j] = this.w[i][j] - this.eta * this.dEdW_sum[i][j];
                this.dEdW_sum[i][j] = 0.0;
            }
        }
    }

    class AdaGrad
    extends GradientDescent {
        AdaGrad() {
        }

        @Override
        void descent() {
            for (int i = 0; i < Layer.this.outNodeNum; ++i) {
                Layer.this.hBias[i] = Layer.this.hBias[i] + Layer.this.dEdB_sum[i] * Layer.this.dEdB_sum[i];
                Layer.this.b[i] = Layer.this.b[i] - Layer.this.eta / Math.sqrt(Layer.this.hBias[i]) * Layer.this.dEdB_sum[i];
                Layer.this.dEdB_sum[i] = 0.0;
                for (int j = 0; j < Layer.this.inNodeNum; ++j) {
                    Layer.this.hWeight[i][j] = Layer.this.hWeight[i][j] + Layer.this.dEdW_sum[i][j] * Layer.this.dEdW_sum[i][j];
                    Layer.this.w[i][j] = Layer.this.w[i][j] - Layer.this.eta / Math.sqrt(Layer.this.hWeight[i][j]) * Layer.this.dEdW_sum[i][j];
                    Layer.this.dEdW_sum[i][j] = 0.0;
                }
            }
        }
    }

    abstract class GradientDescent {
        GradientDescent() {
        }

        abstract void descent();
    }

    class SGD
    extends GradientDescent {
        SGD() {
        }

        @Override
        void descent() {
            for (int i = 0; i < Layer.this.outNodeNum; ++i) {
                Layer.this.b[i] = Layer.this.b[i] - Layer.this.eta * Layer.this.dEdB_sum[i];
                Layer.this.dEdB_sum[i] = 0.0;
                for (int j = 0; j < Layer.this.inNodeNum; ++j) {
                    Layer.this.w[i][j] = Layer.this.w[i][j] - Layer.this.eta * Layer.this.dEdW_sum[i][j];
                    Layer.this.dEdW_sum[i][j] = 0.0;
                }
            }
        }
    }
}

