/*
 * Decompiled with CFR 0.152.
 */
package meta;

import java.util.HashMap;
import java.util.Map;
import meta.Entity;
import util.DJ;

public class Assets
extends Entity {
    static int numOfAssets = 0;
    protected int assetsNo;
    protected Map<String, Integer> integerMap;
    protected Map<String, Double> doubleMap;
    protected Map<String, Boolean> booleanMap;
    protected Map<String, String> textMap;

    public Assets() {
        this.initAssets();
    }

    private void initAssets() {
        this.assetsNo = numOfAssets++;
        this.entityName = "Assert" + this.assetsNo;
        DJ.print_("Assets is created! --- ");
    }

    public void setAssetsNo(int assetsNo) {
        this.assetsNo = assetsNo;
    }

    public int getAssetsNo() {
        return this.assetsNo;
    }

    private void makeIntegerMap() {
        this.integerMap = new HashMap<String, Integer>();
    }

    private void makeDoubleMap() {
        this.doubleMap = new HashMap<String, Double>();
    }

    private void makeBooleanMap() {
        this.booleanMap = new HashMap<String, Boolean>();
    }

    private void makeTextMap() {
        this.textMap = new HashMap<String, String>();
    }

    public void appendInteger(String key, int value) {
        if (this.integerMap == null) {
            this.makeIntegerMap();
        }
        this.integerMap.put(key, value);
    }

    public void appendDouble(String key, double value) {
        if (this.doubleMap == null) {
            this.makeDoubleMap();
        }
        this.doubleMap.put(key, value);
    }

    public void appendBoolean(String key, boolean flag) {
        if (this.booleanMap == null) {
            this.makeBooleanMap();
        }
        this.booleanMap.put(key, flag);
    }

    public void appendString(String key, String text) {
        if (this.textMap == null) {
            this.makeTextMap();
        }
        this.textMap.put(key, text);
    }

    public int getIntegerValue(String key) {
        return this.integerMap.get(key);
    }

    public void setIntegerValue(String key, int value) {
        if (this.integerMap == null) {
            DJ._print("Assets.setIntegerValue() Error:Integer asset is null. key=" + key + ", Value=" + value + ".");
        } else {
            this.integerMap.put(key, value);
        }
    }

    public double getDoubleValue(String key) {
        return this.doubleMap.get(key);
    }

    public void setDoubleValue(String key, double value) {
        if (this.doubleMap == null) {
            DJ._print("Assets.setDoubleValue() Error:Double asset is null. key=" + key + ", Value=" + value + ".");
        } else {
            this.doubleMap.put(key, value);
        }
    }

    public boolean getBooleanValue(String key) {
        return this.booleanMap.get(key);
    }

    public void setBooleanValue(String key, boolean flag) {
        if (this.booleanMap == null) {
            DJ._print("Assets.setBooleanValue() Error:Boolean asset is null. key=" + key + ", Value=" + flag + ".");
        } else {
            this.booleanMap.put(key, flag);
        }
    }

    public String getStringValue(String key) {
        return this.textMap.get(key);
    }

    public void setStringValue(String key, String text) {
        if (this.textMap == null) {
            DJ._print("Assets.setStringValue() Error:String asset is null. key=" + key + ", Value=" + text + ".");
        } else {
            this.textMap.put(key, text);
        }
    }
}

