/*
 * Decompiled with CFR 0.152.
 */
package meta;

import java.util.ArrayList;
import meta.Assets;
import meta.Chaos;
import meta.Entity;
import util.DJ;

public class Domain
extends Entity {
    static int numOfDomain = 0;
    protected int domainNo;
    protected ArrayList<Domain> childDomainList;
    protected ArrayList<Domain> parentDomainList;
    private ArrayList<Domain> domainTree;
    private Assets assets;

    public Domain() {
        this.initDomain();
    }

    private void initDomain() {
        this.domainNo = numOfDomain++;
        this.entityName = "Domain" + this.domainNo;
        this.childDomainList = new ArrayList();
        this.parentDomainList = new ArrayList();
        this.domainTree = new ArrayList();
        this.domainTree.add(this);
        this.assets = new Assets();
        DJ.print_("Domain is created! --- ");
    }

    public void setDomainNo(int domainNo) {
        this.domainNo = domainNo;
    }

    public int getDomainNo() {
        return this.domainNo;
    }

    public void registerDomain(Domain domain) {
        this.childDomainList.add(domain);
        domain.parentDomainList.add(this);
        DJ.print("Domain is added!");
    }

    public String whoAreYou() {
        String who = this.getClass().getSimpleName();
        String parent = "none";
        if (!this.parentDomainList.isEmpty()) {
            parent = this.parentDomainList.get(0).getEntityName();
        }
        String child = "none";
        if (!this.childDomainList.isEmpty()) {
            child = this.childDomainList.get(0).getEntityName();
        }
        return "Name:" + this.entityName + ", Class:" + who + ", Parent:" + parent + ", Child:" + child;
    }

    public ArrayList<Domain> getChildDomainList() {
        return this.childDomainList;
    }

    public ArrayList<Domain> getAncestorList() {
        ArrayList<Domain> ancestorList = new ArrayList<Domain>();
        ancestorList = this.getAncestorDomain(this, ancestorList);
        return ancestorList;
    }

    private ArrayList<Domain> getAncestorDomain(Domain aDomain, ArrayList<Domain> ancestorList) {
        if (aDomain.parentDomainList == null) {
            DJ._print("There are no parent-domain list.");
            DJ.print("Domain name:" + aDomain.getEntityName());
            return ancestorList;
        }
        DJ.print("Domain name:" + aDomain.getEntityName());
        if (this.parentDomainList.size() < 1) {
            if (aDomain instanceof Chaos) {
                DJ.print("This domain is Chaos.");
            }
            return ancestorList;
        }
        Domain parentDomain = aDomain.parentDomainList.get(0);
        if (parentDomain == null) {
            DJ._print("Parent domain is null.");
        } else {
            DJ.print("Parent-domain name:" + parentDomain.getEntityName());
            ancestorList.add(parentDomain);
            if (parentDomain instanceof Chaos) {
                DJ._print("Root domain is Chaos.");
            } else {
                ancestorList = this.getAncestorDomain(parentDomain, ancestorList);
            }
        }
        return ancestorList;
    }

    public ArrayList<Domain> getAllDomain() {
        ArrayList<Domain> allDomainList = new ArrayList<Domain>();
        ArrayList<Domain> AncestorList = this.getAncestorList();
        int size = AncestorList.size();
        Domain topDomain = AncestorList.get(size - 1);
        allDomainList = this.appendChildDomain(topDomain, allDomainList);
        return allDomainList;
    }

    private ArrayList<Domain> appendChildDomain(Domain aDomain, ArrayList<Domain> domainList) {
        domainList.add(aDomain);
        if (aDomain.childDomainList == null) {
            DJ._print("Domain.appendChildDomain(): Domain[" + aDomain.getEntityName() + "] is null.");
            return domainList;
        }
        int numOfChildren = aDomain.childDomainList.size();
        if (numOfChildren < 1) {
            DJ._print("Domain.appendChildDomain(): Domain[" + aDomain.getEntityName() + "] has no child.");
            return domainList;
        }
        for (int i = 0; i < numOfChildren; ++i) {
            Domain aChildDomain = aDomain.childDomainList.get(i);
            this.appendChildDomain(aChildDomain, domainList);
        }
        return domainList;
    }

    public ArrayList<Domain> getDomailTree() {
        return this.domainTree;
    }

    public static String getDomainNames(ArrayList<Domain> aDomainList) {
        StringBuilder sb = new StringBuilder("Domain names:");
        sb.append(aDomainList.get((int)0).entityName);
        for (int i = 1; i < aDomainList.size(); ++i) {
            sb.append(", ").append(aDomainList.get((int)i).entityName);
        }
        sb.append(".");
        return sb.toString();
    }

    public void printAncestorList() {
        ArrayList<Domain> anAncestorList = this.getAncestorList();
        DJ.print_("\u5148\u7956\u7cfb\u7d71\uff1a");
        if (anAncestorList.size() < 1) {
            DJ.print("There are no ancestor.");
            return;
        }
        DJ.print(Domain.getDomainNames(anAncestorList));
    }

    public void printChildList() {
        DJ.print_("\u5b50\u9818\u57df\u7cfb\u7d71\uff1a");
        if (this.childDomainList.size() < 1) {
            DJ.print("There are no child.");
            return;
        }
        DJ.print(Domain.getDomainNames(this.childDomainList));
    }

    public void printAllDomain() {
        ArrayList<Domain> allDomainList = this.getAllDomain();
        if (allDomainList == null) {
            DJ._print("Domain.printAllDomain(): All-Domain-List is null.");
            return;
        }
        if (allDomainList.size() < 1) {
            DJ._print("Domain.printAllDomain(): There are no Domain.");
            return;
        }
        DJ.print_("\u5168\u9818\u57df\u7cfb\u7d71\uff1a");
        DJ.print(Domain.getDomainNames(allDomainList));
    }

    public void setAssets(Assets assets) {
        this.assets = assets;
    }

    public Assets getAssets() {
        return this.assets;
    }
}

