/*
 * Decompiled with CFR 0.152.
 */
package quan;

import java.util.Random;
import quan.QuBit;
import util.DJ;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuBasis {
    public static final int BASIS_0 = 0;
    public static final int BASIS_1 = 1;
    public static final int BASIS_2 = 2;
    public static final int BASIS_3 = 3;
    private CompMat basisMat;
    private int[] qbCounter;
    private QuBit[] selectedQuBits;
    private int classicBit;
    private int[] clBitArray;
    private final long randomSeed = 314L;
    private final Random random = new Random(314L);

    public QuBasis(int numOfQuBit) {
        int order = QuBasis.numOfProbAmp(numOfQuBit);
        this.basisMat = new CompMat(order);
    }

    public QuBasis(CompMat basisMat) {
        this.basisMat = basisMat;
    }

    public QuBasis(long theta) {
        this.basisMat = new QuBasis((double)theta * Math.PI / 180.0).getBasisMat();
    }

    public QuBasis(double theta) {
        this.basisMat = QuBasis.rotate(theta, 0.0, 0.0);
    }

    public QuBasis(double theta, double lamda, double phi) {
        this.basisMat = QuBasis.rotate(theta, lamda, phi);
    }

    public static QuBasis makeQuBasis(int order) {
        CompMat basisMat = new CompMat(order, order);
        QuBasis quBasis = new QuBasis(basisMat);
        return quBasis;
    }

    public int getOrder() {
        return this.basisMat.rowNumber();
    }

    public CompMat getBasisMat() {
        return this.basisMat;
    }

    public CompVec getBasisVec(int basisIndex) {
        int row = this.basisMat.rowNumber();
        CompVec basisVec = new CompVec(row);
        for (int i = 0; i < row; ++i) {
            basisVec.setComp(i, this.basisMat.getComp(i, basisIndex));
        }
        return basisVec;
    }

    public CompVec copyBasisVec(int basisIndex) {
        int row = this.basisMat.rowNumber();
        CompVec basisVec = new CompVec(row);
        for (int i = 0; i < row; ++i) {
            basisVec.setComp(i, this.basisMat.copyComp(i, basisIndex));
        }
        return basisVec;
    }

    public QuBit getBasisQuBit(int basisIndex) {
        int row = this.basisMat.rowNumber();
        QuBit basisQuBit = new QuBit(QuBit.calcNumOfQuBit(row));
        for (int i = 0; i < row; ++i) {
            basisQuBit.setProbAmp(i, this.basisMat.copyComp(i, basisIndex));
        }
        return basisQuBit;
    }

    public void setElement(int row, int col, Complex element) {
        this.basisMat.setComp(row, col, element);
    }

    public void setBasisMat(CompMat basisMat) {
        this.basisMat = basisMat;
    }

    public static int numOfProbAmp(int numQuBit) {
        int numProbAmp = 1;
        for (int i = 1; i <= numQuBit; ++i) {
            numProbAmp *= 2;
        }
        return numProbAmp;
    }

    public static double[][] makeRealIdentity(int order) {
        double[][] ientity = new double[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                ientity[i][j] = 0.0;
            }
            ientity[i][i] = 1.0;
        }
        return ientity;
    }

    public static Complex[][] standardBasisComplex(int order) {
        Complex[][] stdBasis = new Complex[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                stdBasis[i][j] = new Complex(0.0, 0.0);
            }
            stdBasis[i][i] = new Complex(1.0, 0.0);
        }
        return stdBasis;
    }

    public static CompMat standardBasis(int order) {
        CompMat basis = new CompMat(order, order);
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                basis.setComp(i, j, 0.0, 0.0);
            }
            basis.setComp(i, i, 1.0, 0.0);
        }
        return basis;
    }

    public QuBasis Conjugate() {
        int row = this.basisMat.rowNumber();
        QuBasis conjugate = QuBasis.makeQuBasis(row);
        CompMat _conjugate = conjugate.basisMat;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < row; ++j) {
                _conjugate.setComp(j, i, this.basisMat.getComp(i, j).Conjugate());
            }
        }
        return conjugate;
    }

    public static Complex[][] rotate2(double theta, double lamda, double phi) {
        Complex[][] rotor = Complex.complexMatrix(2, 2);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinTheta <= p && sinTheta >= m) {
            sinTheta = 0.0;
        }
        if (cosTheta <= p && cosTheta >= m) {
            cosTheta = 0.0;
        }
        rotor[0][0].setReal(cosTheta);
        rotor[0][1].setReal(-sinTheta);
        rotor[0][1].mul(Complex.euler(lamda));
        rotor[1][0].setReal(sinTheta);
        rotor[1][0].mul(Complex.euler(phi));
        rotor[1][1].setReal(cosTheta);
        rotor[1][1].mul(Complex.euler(lamda + phi));
        return rotor;
    }

    public static CompMat rotate(double theta, double lamda, double phi) {
        CompMat rotorMat = new CompMat(2, 2);
        Complex[][] rotor = rotorMat.getMatrix();
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinTheta <= p && sinTheta >= m) {
            sinTheta = 0.0;
        }
        if (cosTheta <= p && cosTheta >= m) {
            cosTheta = 0.0;
        }
        rotor[0][0].setReal(cosTheta);
        rotor[0][1].setReal(-sinTheta);
        rotor[0][1].mul(Complex.euler(lamda));
        rotor[1][0].setReal(sinTheta);
        rotor[1][0].mul(Complex.euler(phi));
        rotor[1][1].setReal(cosTheta);
        rotor[1][1].mul(Complex.euler(lamda + phi));
        return rotorMat;
    }

    public static QuBasis gramSchmidt(Complex[][] referenceVectors) {
        int row = referenceVectors.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** QuBasis.gramSchmidt(Complex[][] referenceVectors)\n row length (=" + row + ") is less than one.");
            return null;
        }
        int col = referenceVectors[0].length;
        if (row != col) {
            DJ.print("***** ERROR ***** QuBasis.gramSchmidt(Complex[][] referenceVectors)\n row and col length is not same.\n row length is " + row + ", \n col length is " + col + ".");
            return null;
        }
        QuBasis orthonormalBasis = QuBasis.makeQuBasis(row);
        Complex[][] u = orthonormalBasis.basisMat.getMatrix();
        for (int j = 0; j < col; ++j) {
            u[0][j] = referenceVectors[0][j].copyComplex();
        }
        Complex norm = Complex.norm(u[0]);
        for (int j = 0; j < col; ++j) {
            u[0][j].div(norm);
        }
        for (int i = 1; i < row; ++i) {
            int j;
            Complex[] _u = new Complex[row];
            for (j = 0; j < col; ++j) {
                _u[j] = referenceVectors[i][j].copyComplex();
            }
            for (int k = 0; k < i; ++k) {
                Complex innPro = Complex.innerProduct(u[k], referenceVectors[i]);
                for (int j2 = 0; j2 < col; ++j2) {
                    u[i][j2] = u[k][j2].product(innPro);
                    _u[j2].sub(u[i][j2]);
                }
            }
            norm = Complex.norm(_u);
            for (j = 0; j < col; ++j) {
                u[i][j] = _u[j];
                u[i][j].div(norm);
            }
        }
        return orthonormalBasis;
    }

    public void checkOrthonormal(String label) {
        Complex innPro;
        Complex[][] orthonormalArrays = this.basisMat.copyMatrix();
        DJ.printF(label, orthonormalArrays);
        DJ._print("\u884c\u5217\u5f0f|" + label + "|\u304c\u30bc\u30ed\u3067\u306a\u3051\u308c\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb");
        Complex determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|" + label + "|", determinant);
        DJ.printF("  |" + label + "|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = orthonormalArrays.length;
        for (int i = 0; i < length; ++i) {
            DJ.print("" + i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] uArray = orthonormalArrays[i];
            innPro = Complex.innerProduct(uArray);
            DJ.printF_("  innPro(" + label + "[" + i + "])", innPro);
            Complex norm = Complex.norm(uArray);
            DJ.printF("  norm(" + label + "[" + i + "])", norm);
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        for (int i = 0; i < length; ++i) {
            Complex[] uArray_i = orthonormalArrays[i];
            for (int k = i + 1; k < length; ++k) {
                DJ.print_("" + i + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                Complex[] uArray_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(uArray_i, uArray_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
            }
        }
    }

    public static void checkOrthonormal(Complex[][] referenceVectors) {
        int i;
        Complex[] u_k;
        Complex norm;
        Complex innPro;
        DJ.printF("v", referenceVectors);
        DJ.print("\u884c\u5217\u5f0f|v|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        Complex determinant = Complex.determinant(referenceVectors);
        DJ.print_("|v|", determinant);
        DJ.printF("  |v|", determinant);
        DJ._print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e\u5404\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = referenceVectors.length;
        for (int i2 = 0; i2 < length; ++i2) {
            DJ.print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e" + i2 + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] v = referenceVectors[i2];
            innPro = Complex.innerProduct(v);
            DJ.print_("innPro(v[" + i2 + "])", innPro);
            DJ.printF("  innPro(v[" + i2 + "])", innPro);
            norm = Complex.norm(v);
            DJ.print_("norm(v[" + i2 + "])", norm);
            DJ.printF("  norm(v[" + i2 + "])", norm);
        }
        DJ._print("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        for (int i3 = 0; i3 < length; ++i3) {
            Complex[] u_i = referenceVectors[i3];
            for (int k = i3 + 1; k < length; ++k) {
                DJ.print_("\u53c2\u7167\u30d9\u30af\u30c8\u30eb\u306e" + i3 + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                u_k = referenceVectors[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
            }
        }
        QuBasis orthonormalVec = QuBasis.gramSchmidt(referenceVectors);
        DJ.printF("u", orthonormalVec);
        Complex[][] orthonormalArrays = orthonormalVec.getBasisMat().getMatrix();
        DJ.print("\u884c\u5217\u5f0f|u|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|u|", determinant);
        DJ.printF("  |u|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        length = referenceVectors.length;
        for (i = 0; i < length; ++i) {
            DJ.print("\u5c0e\u51fa\u57fa\u5e95\u306e" + i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] u = orthonormalArrays[i];
            innPro = Complex.innerProduct(u);
            DJ.print_("innPro(u[" + i + "])", innPro);
            DJ.printF("  innPro(u[" + i + "])", innPro);
            norm = Complex.norm(u);
            DJ.print_("norm(u[" + i + "])", norm);
            DJ.printF("  norm(u[" + i + "])", norm);
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        for (i = 0; i < length; ++i) {
            Complex[] u_i = orthonormalArrays[i];
            for (int k = i + 1; k < length; ++k) {
                DJ.print_("\u5c0e\u51fa\u57fa\u5e95\u306e" + i + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                u_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
            }
        }
    }

    public void checkOrthonormal() {
        Complex innPro;
        Complex[][] referenceVectors = this.basisMat.getMatrix();
        DJ.print("v", referenceVectors);
        DJ.printF("v", referenceVectors);
        DJ.print("\u884c\u5217\u5f0f|v|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        Complex determinant = Complex.determinant(referenceVectors);
        DJ.print_("|v|", determinant);
        DJ.printF("  |v|", determinant);
        QuBasis orthonormalVec = QuBasis.gramSchmidt(referenceVectors);
        DJ._print("u", orthonormalVec);
        DJ.printF("u", orthonormalVec);
        Complex[][] orthonormalArrays = orthonormalVec.getBasisMat().getMatrix();
        DJ.print("\u884c\u5217\u5f0f|u|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|u|", determinant);
        DJ.printF("  |u|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = referenceVectors.length;
        for (int i = 0; i < length; ++i) {
            DJ.print("" + i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] u = orthonormalArrays[i];
            innPro = Complex.innerProduct(u);
            DJ.print_("innPro(u[" + i + "])", innPro);
            DJ.printF("  innPro(u[" + i + "])", innPro);
            Complex norm = Complex.norm(u);
            DJ.print_("norm(u[" + i + "])", norm);
            DJ.printF("  norm(u[" + i + "])", norm);
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        for (int i = 0; i < length; ++i) {
            Complex[] u_i = orthonormalArrays[i];
            for (int k = i + 1; k < length; ++k) {
                DJ.print_("" + i + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                Complex[] u_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
            }
        }
    }

    public int[] getQBCounter() {
        return this.qbCounter;
    }

    public QuBit[] getSelectedQuBits() {
        return this.selectedQuBits;
    }

    public int[] getClassicBit() {
        return this.clBitArray;
    }

    public int[] countQuBasis(QuBit targetQuBit, int trialNumber) {
        int numOfBasis = this.basisMat.colNumber();
        this.qbCounter = new int[numOfBasis];
        this.selectedQuBits = new QuBit[trialNumber];
        this.clBitArray = new int[trialNumber];
        for (int i = 0; i < trialNumber; ++i) {
            this.selectedQuBits[i] = this.measurement(targetQuBit);
            this.clBitArray[i] = this.classicBit;
        }
        return this.qbCounter;
    }

    public QuBit measurement(QuBit targetQuBit) {
        int numOfProbAmp = targetQuBit.getProbAmpLength();
        QuBit paQuBit = this.basisChang(targetQuBit);
        double paAccum = 0.0;
        int resultQubitNum = QuBit.calcNumOfQuBit(this.basisMat.rowNumber());
        QuBit resultQubit = new QuBit(resultQubitNum);
        boolean errorCheck = false;
        double randomNum = this.random.nextDouble();
        if (this.qbCounter == null) {
            this.qbCounter = new int[numOfProbAmp];
        }
        for (int i = 0; i < numOfProbAmp; ++i) {
            if (!(randomNum <= (paAccum += paQuBit.getProbAmp(i).square()))) continue;
            for (int k = 0; k < numOfProbAmp; ++k) {
                resultQubit.setProbAmp(k, this.basisMat.copyComp(k, i));
            }
            int n = i;
            this.qbCounter[n] = this.qbCounter[n] + 1;
            this.classicBit = i;
            errorCheck = true;
            break;
        }
        if (!errorCheck) {
            DJ.print("***** ERROR ***** QuBasis.innerProduct(QuBit operand)\n basisMat row number is less than one.");
            return null;
        }
        return resultQubit;
    }

    public QuBit basisChang(QuBit operand) {
        int row = this.basisMat.rowNumber();
        if (row < 1) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n basisMat row number is less than one.");
            return null;
        }
        int col = this.basisMat.colNumber();
        if (col % 2 != 0) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n basisMat column number is (" + col + ") is not even number.");
            return null;
        }
        int probAmpLength = operand.getProbAmpLength();
        if (row != probAmpLength) {
            DJ.print("***** ERROR ***** QuBasis.basisChang(QuBit operand)\n Element numbers are not same.\n basisMat row number is " + row + ", \n ProbAmp length is " + probAmpLength + ".");
            return null;
        }
        CompMat _basisMat = this.basisMat.conjugate();
        int numOfQuBit = QuBit.calcNumOfQuBit(row);
        QuBit resultQB = new QuBit(numOfQuBit);
        CompVec _product = resultQB.getProbAmp();
        for (int i = 0; i < col; ++i) {
            for (int k = 0; k < row; ++k) {
                Complex conj = _basisMat.getComp(i, k);
                conj.mul(operand.getProbAmp(k));
                _product.getComp(i).add(conj);
            }
        }
        return resultQB;
    }

    public CompMat basisChang(CompMat quBitMat) {
        int row = this.basisMat.rowNumber();
        if (row < 1) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n basisMat row number is less than one.");
            return null;
        }
        int col = this.basisMat.colNumber();
        if (col != row) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n basisMat column number is (" + col + ") not equal to row number.");
            return null;
        }
        int numOfQuBit = quBitMat.rowNumber();
        if (!QuBit.checkPowerOfTwo(numOfQuBit)) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n number of QuBits is not power of two.");
            return null;
        }
        int order = quBitMat.colNumber();
        if (order != row) {
            DJ.print("***** ERROR ***** quBasis.basisChang(CompMat quBitMat)\n order of QuBits (" + order + ") is not equal to QuBasis(" + row + ")");
            return null;
        }
        CompMat _basisMat = this.basisMat.conjugate();
        CompMat resultQBMat = new CompMat(col, numOfQuBit);
        for (int i = 0; i < col; ++i) {
            for (int j = 0; j < numOfQuBit; ++j) {
                for (int k = 0; k < order; ++k) {
                    Complex conj = _basisMat.copyComp(i, k);
                    conj.mul(quBitMat.getComp(k, j));
                    Complex val = resultQBMat.getComp(i, j);
                    val.add(conj);
                }
            }
        }
        return resultQBMat;
    }

    public QuBasis interactQuBasis(QuBasis operandBasis) {
        int row0 = this.basisMat.rowNumber();
        int col0 = this.basisMat.colNumber();
        CompMat operandMat = operandBasis.basisMat;
        int row1 = operandMat.rowNumber();
        int col1 = operandMat.colNumber();
        int row = row0 * row1;
        int numOfQuBit = QuBit.calcNumOfQuBit(row);
        QuBasis interactedBasis = new QuBasis(numOfQuBit);
        for (int i0 = 0; i0 < row0; ++i0) {
            for (int j0 = 0; j0 < col0; ++j0) {
                for (int i1 = 0; i1 < row1; ++i1) {
                    for (int j1 = 0; j1 < col1; ++j1) {
                        int i = i0 * row1 + i1;
                        int j = j0 * col1 + j1;
                        Complex element = this.basisMat.copyComp(i0, j0);
                        element.mul(operandMat.getComp(i1, j1));
                        interactedBasis.setElement(i, j, element);
                    }
                }
            }
        }
        return interactedBasis;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            space.append(" ");
        }
        return space.toString();
    }

    public String toString() {
        int row = this.basisMat.rowNumber();
        int col = this.basisMat.colNumber();
        int[] maxWide = new int[col];
        for (int j = 0; j < col; ++j) {
            maxWide[j] = 5;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                String text = this.basisMat.getComp(i, j).toString();
                if (this.basisMat.getReal(i, j) >= 0.0) {
                    buf[i][j] = " " + text;
                    wides[i][j] = text.length() + 1;
                } else {
                    buf[i][j] = text;
                    wides[i][j] = text.length();
                }
                if (wides[i][j] <= maxWide[j]) continue;
                maxWide[j] = wides[i][j];
            }
        }
        StringBuilder sb = new StringBuilder();
        String filler = "\u2502";
        int gap = filler.length();
        int spaces = maxWide[0];
        for (int j = 1; j < col; ++j) {
            spaces = spaces + gap + 1 + maxWide[j];
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        for (int i = 0; i < row; ++i) {
            sb.append("\u2502");
            for (int j = 0; j < col; ++j) {
                sb.append(buf[i][j]);
                sb.append(this.getSpace(maxWide[j] - wides[i][j])).append(filler);
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public String toFormat() {
        int row = this.basisMat.rowNumber();
        int col = this.basisMat.colNumber();
        int[] maxWide = new int[col];
        for (int j = 0; j < col; ++j) {
            maxWide[j] = 5;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                String text = this.basisMat.getComp(i, j).toFormat();
                if (this.basisMat.getReal(i, j) >= 0.0) {
                    buf[i][j] = " " + text;
                    wides[i][j] = text.length() + 1;
                } else {
                    buf[i][j] = text;
                    wides[i][j] = text.length();
                }
                if (wides[i][j] <= maxWide[j]) continue;
                maxWide[j] = wides[i][j];
            }
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "\u2502";
        int gap = filler.length();
        int spaces = maxWide[0];
        for (int j = 1; j < col; ++j) {
            spaces = spaces + gap + 1 + maxWide[j];
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        for (int i = 0; i < row; ++i) {
            sb.append("\u2502");
            for (int j = 0; j < col; ++j) {
                sb.append(buf[i][j]);
                sb.append(this.getSpace(maxWide[j] - wides[i][j])).append(filler);
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public String toString(String label) {
        String str = this.toString();
        return label + "\n" + str;
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return label + ":" + str;
    }
}

