/*
 * Decompiled with CFR 0.152.
 */
package quan;

import java.util.ArrayList;
import quan.QuBasis;
import quan.QuGate;
import util.DJ;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuBit {
    public static final int PA0 = 0;
    public static final int PA1 = 1;
    public static final String STD0_QUBIT = "std0QuBit";
    public static final String STD1_QUBIT = "std1QuBit";
    public static final boolean H_BIT = false;
    public static final boolean V_BIT = true;
    public static boolean P2_FLAG = true;
    public static boolean N2_FLAG = false;
    private CompVec probAmp;

    public QuBit() {
        this.probAmp = new CompVec(2);
        this.probAmp.setReal(0, 1.0);
    }

    public QuBit(double radian) {
        double lamda = 0.0;
        double phi = 0.0;
        CompMat rotatedMat = QuBasis.rotate(radian, lamda, phi);
        this.probAmp = new CompVec(2);
        this.probAmp.setComp(0, rotatedMat.getComp(0, 0));
        this.probAmp.setComp(1, rotatedMat.getComp(1, 0));
    }

    public QuBit(Complex pa0) {
        this.probAmp = new CompVec(2);
        this.probAmp.setComp(0, pa0);
        this.probAmp.setComp(1, QuBit.getOtherPA(pa0));
    }

    public QuBit(Complex pa0, Complex pa1) {
        this.probAmp = new CompVec(2);
        this.probAmp.setComp(0, pa0);
        this.probAmp.setComp(1, pa1);
    }

    public QuBit(String quBitLabel) {
        switch (quBitLabel) {
            case "std0QuBit": {
                this.probAmp = new CompVec(2, 0);
                break;
            }
            case "std1QuBit": {
                this.probAmp = new CompVec(2, 1);
                break;
            }
            default: {
                DJ.print("***** ERROR ***** QuBit.QuBit(String quBitLabel)\n Argument is (" + quBitLabel + ") is wrong.");
            }
        }
    }

    public QuBit(int numOfQuBits) {
        int numOfProbAmps = QuBit.calcNumOfProbAmp(numOfQuBits);
        this.probAmp = new CompVec(numOfProbAmps);
    }

    public QuBit(int numOfQuBit, int index) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        if (index >= numOfProbAmp) {
            DJ.print("***** ERROR ***** QuBit.unitQuBit(int, int)\nindex (" + index + ") is greater than equal toNumber of ProbAmp (" + numOfProbAmp + ").");
        }
        this.probAmp = new CompVec(numOfProbAmp, index);
    }

    public QuBit(QuBit quBit) {
        this.probAmp = quBit.copyProbAmpVec();
    }

    public QuBit(CompVec probAmpVec) {
        int numOfProbAmps = probAmpVec.length();
        if (numOfProbAmps <= 0) {
            DJ.print("***** ERROR ***** QuBit.QuBit(CompVec probAmpVec)\n Number of ProbAmps (" + numOfProbAmps + ") is less than 1.");
        } else if (!QuBit.checkPowerOfTwo(numOfProbAmps)) {
            DJ.print("***** ERROR ***** QuBit.QuBit(CompVec probAmpVec)\n Number of ProbAmps (" + numOfProbAmps + ") is not power of 2.");
        } else {
            this.probAmp = probAmpVec.copyCompVec();
        }
    }

    public QuBit(Complex[] probAmpArray) {
        int numOfProbAmps = probAmpArray.length;
        if (numOfProbAmps % 2 != 0) {
            DJ.print("***** ERROR ***** QuBit.QuBit(Complex[] probAmp2)\n Number of QuBits (" + numOfProbAmps + ") is not even number.");
        } else {
            this.probAmp = new CompVec(numOfProbAmps);
            this.probAmp.copyArray(probAmpArray);
        }
    }

    public QuBit(ArrayList<QuBit> quBitList) {
        int numOfQuBits = quBitList.size();
        int numOfProbAmps = QuBit.calcNumOfProbAmp(numOfQuBits);
        this.probAmp = new CompVec(numOfProbAmps);
        for (int i = 0; i < numOfQuBits; ++i) {
            int index = i * 2;
            this.probAmp.setComp(index, quBitList.get(i).copyProbAmp(0));
            this.probAmp.setComp(index + 1, quBitList.get(i).copyProbAmp(1));
        }
    }

    public QuBit reverseQuBit() {
        QuBit reverseQB = new QuBit(this.probAmp.copyComp(1), this.probAmp.copyComp(0));
        return reverseQB;
    }

    public static QuBit unitQuBit(int numOfQuBit, int index) {
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        if (index >= numOfProbAmp) {
            DJ.print("***** ERROR ***** QuBit.unitQuBit(int, int)\nindex (" + index + ") is greater than equal toNumber of ProbAmp (" + numOfProbAmp + ").");
        }
        QuBit aQuBit = new QuBit(numOfQuBit);
        aQuBit.probAmp.setComp(index, 1.0, 0.0);
        return aQuBit;
    }

    public static QuBit[] standardQuBit(int numOfQuBit) {
        int order = QuBit.calcNumOfProbAmp(numOfQuBit);
        QuBit[] stdQuBitArray = new QuBit[order];
        for (int i = 0; i < order; ++i) {
            stdQuBitArray[i] = new QuBit(numOfQuBit);
            stdQuBitArray[i].probAmp.setComp(i, 1.0, 0.0);
        }
        return stdQuBitArray;
    }

    public static QuBit rotateDegreeQuBit(double angle) {
        double pai = Math.PI;
        double theta = pai * angle / 180.0;
        return QuBit.rotateRadianQuBit(theta);
    }

    public static QuBit rotateRadianQuBit(double theta) {
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double p = 6.123233995736766E-17;
        double m = -p;
        if (sinTheta <= p && sinTheta >= m) {
            sinTheta = 0.0;
        }
        if (cosTheta <= p && cosTheta >= m) {
            cosTheta = 0.0;
        }
        Complex pa0 = new Complex(cosTheta, 0.0);
        Complex pa1 = new Complex(sinTheta, 0.0);
        QuBit aQuBit = new QuBit(pa0, pa1);
        return aQuBit;
    }

    public static boolean checkPowerOfTwo(int numOfProbAmps) {
        boolean result = N2_FLAG;
        int operand = numOfProbAmps;
        if (operand >= 2 && (operand & operand - 1) == 0) {
            result = P2_FLAG;
        }
        return result;
    }

    public int getNumOfQuBit() {
        int numOfProbAmp = this.probAmp.length();
        int numOfQuBit = QuBit.calcNumOfQuBit(numOfProbAmp);
        return numOfQuBit;
    }

    public int getProbAmpLength() {
        return this.probAmp.length();
    }

    public Complex getProbAmp(int index) {
        return this.probAmp.getComp(index);
    }

    public void setProbAmp(int index, Complex probAmp) {
        this.probAmp.setComp(index, probAmp);
    }

    public Complex copyProbAmp(int index) {
        return this.probAmp.copyComp(index);
    }

    public CompVec getProbAmp() {
        return this.probAmp;
    }

    public CompVec copyProbAmpVec() {
        CompVec _probAmp = this.probAmp.copyCompVec();
        return _probAmp;
    }

    public Complex[] getProbAmpArray() {
        return this.probAmp.getArray();
    }

    public Complex[] copyProbArray() {
        Complex[] _probAmp = this.probAmp.copyArray();
        return _probAmp;
    }

    public void setProbAmp(CompVec probAmps) {
        Complex[] complexArray = probAmps.copyArray();
        this.probAmp.copyArray(complexArray);
    }

    public static ArrayList<QuBit> QuBits(int numOfQuBits) {
        ArrayList<QuBit> aQuBits = new ArrayList<QuBit>();
        for (int i = 0; i < numOfQuBits; ++i) {
            QuBit aQuBit = new QuBit();
            aQuBits.add(aQuBit);
        }
        return aQuBits;
    }

    public void sum(QuBit operand) {
        this.probAmp.sum(operand.getProbAmp());
    }

    public void product(double value) {
        this.probAmp.product(value);
    }

    public void product(Complex value) {
        this.probAmp.product(value);
    }

    public CompVec basisChang() {
        int paLength = this.probAmp.length();
        int numOfQuBit = QuBit.calcNumOfQuBit(paLength);
        QuBasis stdBasis = new QuBasis(numOfQuBit);
        CompMat basisMat = stdBasis.getBasisMat();
        int row = basisMat.rowNumber();
        CompVec probAmpVec = new CompVec(paLength);
        for (int i = 0; i < paLength; ++i) {
            for (int k = 0; k < paLength; ++k) {
                Complex basis = basisMat.copyComp(i, k);
                basis.mul(this.probAmp.getComp(k));
                Complex val = probAmpVec.getComp(i);
                val.add(basis);
            }
        }
        return probAmpVec;
    }

    public CompVec basisChang(QuBasis operandBasis) {
        int length = this.probAmp.length();
        if (length < 1) {
            DJ.print("***** ERROR ***** QuBit.basisChang(QuBasis operandBasis)\n Qubit length(=" + length + ") is less than one.");
            return null;
        }
        CompMat basisMat = operandBasis.getBasisMat();
        int row = basisMat.rowNumber();
        if (row != length) {
            DJ.print("***** ERROR ***** quBasis.basisChang(QuBasis operandBasis)\n basisMat row number(=" + row + ") is \nnot equal to length of Qubit(=" + length + ") .");
            return null;
        }
        CompMat _basisMat = basisMat.conjugate();
        CompVec probAmpVec = new CompVec(row);
        for (int i = 0; i < row; ++i) {
            for (int k = 0; k < length; ++k) {
                Complex basis = _basisMat.copyComp(i, k);
                basis.mul(this.probAmp.getComp(k));
                Complex val = probAmpVec.getComp(i);
                val.add(basis);
            }
        }
        return probAmpVec;
    }

    public static Complex getOtherPA(Complex oneOfProbAmp) {
        Complex conjyuPA = oneOfProbAmp.Conjugate();
        conjyuPA.mul(oneOfProbAmp);
        Complex comp1 = new Complex(1.0, 0.0);
        comp1.sub(conjyuPA);
        Complex otherPA = comp1.sqrt();
        return otherPA;
    }

    public void apply(QuGate gate) {
        int gateOrder;
        int paLength = this.probAmp.length();
        if (paLength != (gateOrder = gate.getOrder())) {
            DJ.print("***** ERROR ***** QuBit.apply(QuGate gate)\n QuBit's probability-amplitude length (" + paLength + ") is not equal to Gate order (" + gateOrder + ").");
            return;
        }
        Complex[] _qbVec = this.probAmp.getArray();
        Complex[][] _gateMat = gate.getElement();
        Complex[] result = Complex.product(_gateMat, _qbVec);
        this.probAmp.copyArray(result);
    }

    public boolean entangleCheck() {
        boolean judgment = false;
        int probAmpLength = this.probAmp.length();
        int numOfQuBit = probAmpLength / 2;
        Complex front = this.probAmp.copyComp(0);
        Complex rear = this.probAmp.getComp(probAmpLength - 1);
        front.mul(rear);
        for (int i = 1; i < numOfQuBit; ++i) {
            Complex _front = this.probAmp.copyComp(i);
            rear = this.probAmp.getComp(probAmpLength - i - 1);
            _front.mul(rear);
            Complex def = _front.copyComplex();
            def.sub(front);
            if (!(def.abs() > 1.0E-15)) continue;
            judgment = true;
        }
        return judgment;
    }

    public boolean entangleDetails() {
        boolean judgment = false;
        int probAmpLength = this.probAmp.length();
        int numOfQuBit = probAmpLength / 2;
        Complex front = this.probAmp.copyComp(0);
        Complex rear = this.probAmp.getComp(probAmpLength - 1);
        front.mul(rear);
        DJ.print("$ (0) product = ", front);
        for (int i = 1; i < numOfQuBit; ++i) {
            Complex _front = this.probAmp.copyComp(i);
            rear = this.probAmp.getComp(probAmpLength - i - 1);
            _front.mul(rear);
            DJ.print("$ (" + i + ") product = ", _front);
            Complex def = _front.copyComplex();
            def.sub(front);
            DJ.print("$ difference = ", def.abs());
            if (def.abs() > 1.0E-15) {
                judgment = true;
            }
            DJ.print("$ judgment = ", Boolean.toString(judgment));
        }
        return judgment;
    }

    public static String entangleStatus(boolean judgment) {
        String diagnosis = judgment ? "Entangled" : "Not entangle";
        return diagnosis;
    }

    public QuBit Conjugate() {
        int length = this.probAmp.length();
        QuBit _conjugate = new QuBit(length);
        for (int i = 0; i < length; ++i) {
            _conjugate.setProbAmp(i, this.probAmp.getComp(i).Conjugate());
        }
        return _conjugate;
    }

    public Complex innerProduct(QuBit operand) {
        CompVec operandVec;
        int operandLength;
        int length = this.probAmp.length();
        if (length != (operandLength = (operandVec = operand.getProbAmp()).length())) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompVec)\n vecter length are not same. target vecter length is " + length + ",  operand length is " + operandLength + ".");
            return null;
        }
        CompVec _conjugate = this.probAmp.Conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        for (int i = 0; i < length; ++i) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(operandVec.getComp(i));
            _innerProduct.add(conj);
        }
        return _innerProduct;
    }

    public Complex innerProduct() {
        int length = this.probAmp.length();
        CompVec _conjugate = this.probAmp.Conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        for (int i = 0; i < length; ++i) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(this.probAmp.getComp(i));
            _innerProduct.add(conj);
        }
        return _innerProduct;
    }

    public static int calcNumOfQuBit(int numOfProbAmp) {
        int numOfQuBit = (int)(Math.log(numOfProbAmp) / Math.log(2.0));
        return numOfQuBit;
    }

    public static int calcNumOfProbAmp(int numOfQuBit) {
        int numOfProbAmp = 1;
        for (int i = 1; i <= numOfQuBit; ++i) {
            numOfProbAmp *= 2;
        }
        return numOfProbAmp;
    }

    public Complex[] interactQuBit2(Complex[] probAmpArray) {
        Complex[] probAmpArray4 = Complex.complexArray(4);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                probAmpArray4[i * 2 + j].setComplex(this.probAmp.getReal(i), this.probAmp.getImag(i));
                probAmpArray4[i * 2 + j].mul(probAmpArray[j]);
            }
        }
        return probAmpArray4;
    }

    public QuBit interactQuBit2(QuBit quBit) {
        CompVec _probAmpVec = quBit.getProbAmp();
        int numOfQuBit = 2;
        QuBit quBit2 = new QuBit(numOfQuBit);
        CompVec probAmp4Vec = quBit2.probAmp;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Complex comp = probAmp4Vec.getComp(i * 2 + j);
                comp.setComplex(this.probAmp.getReal(i), this.probAmp.getImag(i));
                comp.mul(_probAmpVec.getComp(j));
            }
        }
        return quBit2;
    }

    public static QuBit interactQuBit(CompVec probAmpVec) {
        Complex[] probAmpArray = probAmpVec.getArray();
        Complex[] probAmp4Array = QuBit.interactQuBit(probAmpArray);
        QuBit interactedquBit = new QuBit(probAmp4Array);
        return interactedquBit;
    }

    public QuBit interactQuBit(QuBit quBit) {
        int numOfPaOp;
        int _numOfPa;
        int numOfQuBit = this.getNumOfQuBit();
        int numOfPa = this.getProbAmpLength();
        int numOfQuBitOp = quBit.getNumOfQuBit();
        int _numOfQuBit = numOfQuBit + numOfQuBitOp;
        if (_numOfQuBit != QuBit.calcNumOfQuBit(_numOfPa = numOfPa * (numOfPaOp = quBit.getProbAmpLength()))) {
            DJ.print("***** ERROR ***** QuBit.interactQuBit(QuBit quBit)\n Number of QuBit (" + _numOfQuBit + ") is not equal to Number of QuBit (" + QuBit.calcNumOfQuBit(_numOfPa));
        }
        QuBit _quBit = new QuBit(_numOfQuBit);
        CompVec _probAmpVec = _quBit.getProbAmp();
        CompVec probAmpVecOp = quBit.getProbAmp();
        for (int i = 0; i < numOfPa; ++i) {
            for (int j = 0; j < numOfPaOp; ++j) {
                Complex comp = _probAmpVec.getComp(i * numOfPaOp + j);
                comp.setComplex(this.probAmp.getReal(i), this.probAmp.getImag(i));
                comp.mul(probAmpVecOp.getComp(j));
            }
        }
        return _quBit;
    }

    public static Complex[] interactQuBit(Complex[] probAmpArray) {
        int paLength = probAmpArray.length;
        if (paLength < 4) {
            DJ.print("***** ERROR ***** QuBit.interactQuBit(Complex[] probAmpArray)\n Number of probability amplitudes (" + paLength + ") is less than 4.");
        }
        if (paLength % 2 != 0) {
            DJ.print("***** ERROR ***** QuBit.interactQuBit(Complex[] probAmpArray)\n Number of probability amplitudes (" + paLength + ") is not even number.");
            return null;
        }
        int resultSize = QuBit.calcNumOfProbAmp(paLength / 2);
        Complex[] interactedQB = new Complex[resultSize];
        interactedQB[resultSize - 2] = probAmpArray[paLength - 2];
        interactedQB[resultSize - 1] = probAmpArray[paLength - 1];
        int paTempSize = 1;
        for (int i = 0; i < paLength - 2; i += 2) {
            int k;
            int paId = paLength - 4 - i;
            int index = resultSize - (paTempSize *= 2);
            for (k = 0; k < paTempSize; ++k) {
                interactedQB[index - paTempSize + k] = probAmpArray[paId].product(interactedQB[index + k]);
            }
            for (k = 0; k < paTempSize; ++k) {
                interactedQB[index + k] = probAmpArray[paId + 1].copyComplex().product(interactedQB[index + k]);
            }
        }
        return interactedQB;
    }

    public static Complex[] _interactQuBit_(ArrayList<QuBit> quBits) {
        int numOfQuBit = quBits.size();
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        Complex[] _probAmps = new Complex[numOfProbAmp];
        QuBit _quBitE = quBits.get(numOfQuBit - 1);
        _probAmps[0] = _quBitE.copyProbAmp(0);
        _probAmps[1] = _quBitE.copyProbAmp(1);
        int paLength = 1;
        for (int i = numOfQuBit - 2; i >= 0; --i) {
            paLength *= 2;
            for (int k = 0; k < paLength; ++k) {
                QuBit _quBit = quBits.get(i);
                Complex _pa1 = _quBit.copyProbAmp(1);
                _pa1.mul(_probAmps[k]);
                _probAmps[paLength + k] = _pa1;
                Complex _pa0 = _quBit.copyProbAmp(0);
                _pa0.mul(_probAmps[k]);
                _probAmps[k] = _pa0;
            }
        }
        return _probAmps;
    }

    public static QuBit interactQuBit(ArrayList<QuBit> quBits) {
        int numOfQuBit = quBits.size();
        int numOfProbAmp = QuBit.calcNumOfProbAmp(numOfQuBit);
        QuBit interactedQb = new QuBit(QuBit.calcNumOfQuBit(numOfProbAmp));
        CompVec _probAmps = interactedQb.probAmp;
        QuBit _quBitE = quBits.get(numOfQuBit - 1);
        _probAmps.setComp(0, _quBitE.copyProbAmp(0));
        _probAmps.setComp(1, _quBitE.copyProbAmp(1));
        int paLength = 1;
        for (int i = numOfQuBit - 2; i >= 0; --i) {
            paLength *= 2;
            for (int k = 0; k < paLength; ++k) {
                QuBit _quBit = quBits.get(i);
                Complex _pa1 = _quBit.copyProbAmp(1);
                _pa1.mul(_probAmps.getComp(k));
                _probAmps.setComp(paLength + k, _pa1);
                Complex _pa0 = _quBit.copyProbAmp(0);
                _pa0.mul(_probAmps.getComp(k));
                _probAmps.setComp(k, _pa0);
            }
        }
        return interactedQb;
    }

    public double[][] getTransProb() {
        int paLength = this.probAmp.length();
        int numOfQuBit = QuBit.calcNumOfQuBit(paLength);
        double[][] probArray = new double[2][numOfQuBit];
        int k = paLength / 2;
        for (int i = 0; i < numOfQuBit; ++i) {
            double c0 = 0.0;
            double c1 = 0.0;
            int j = 0;
            do {
                int m;
                for (m = 0; m < k; ++m) {
                    c0 += this.probAmp.getComp(j).square();
                    ++j;
                }
                for (m = 0; m < k; ++m) {
                    c1 += this.probAmp.getComp(j).square();
                    ++j;
                }
            } while (j < paLength);
            k /= 2;
            probArray[0][i] = c0;
            probArray[1][i] = c1;
        }
        return probArray;
    }

    public double[][] extract() {
        int paLength = this.probAmp.length();
        int numOfQuBit = QuBit.calcNumOfQuBit(paLength);
        double[][] probArray = new double[2][numOfQuBit];
        for (int i = 0; i < numOfQuBit; ++i) {
            int k = (int)Math.pow(2.0, numOfQuBit - 1 - i);
            boolean flag = true;
            int count = 0;
            double c0 = 0.0;
            double c1 = 0.0;
            for (int j = 0; j < paLength; ++j) {
                Complex _probAmp = this.probAmp.getComp(j);
                if (flag) {
                    c0 += _probAmp.square();
                } else {
                    c1 += _probAmp.square();
                }
                if (++count < k) continue;
                count = 0;
                flag = !flag;
            }
            probArray[0][i] = c0;
            probArray[1][i] = c1;
        }
        return probArray;
    }

    public boolean equals(QuBit qb) {
        if (this == qb) {
            return true;
        }
        int thisLength = this.probAmp.length();
        int length = qb.getProbAmpLength();
        if (length != thisLength) {
            return false;
        }
        Complex[] thisProbAmp = this.getProbAmpArray();
        Complex[] probAmp = qb.getProbAmpArray();
        for (int i = 0; i < thisLength; ++i) {
            if (thisProbAmp[i].equals(probAmp[i])) continue;
            return false;
        }
        return true;
    }

    private static String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            space.append(" ");
        }
        return space.toString();
    }

    public String toString() {
        int length = this.probAmp.length();
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toString());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toString());
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(boolean orient) {
        int length = this.probAmp.length();
        StringBuilder sb = orient ? new StringBuilder("\n[") : new StringBuilder(" [");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toString());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toString());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toFormat() {
        int order = this.probAmp.length();
        int maxWide = 5;
        String[] buf = new String[order];
        int[] wides = new int[order];
        for (int i = 0; i < order; ++i) {
            int tempWide;
            String text = this.probAmp.getComp(i).toFormat();
            if (this.probAmp.getReal(i) >= 0.0) {
                buf[i] = " " + text;
                tempWide = text.length() + 1;
            } else {
                buf[i] = text;
                tempWide = text.length();
            }
            wides[i] = tempWide;
            if (tempWide <= maxWide) continue;
            maxWide = tempWide;
        }
        StringBuilder sb = new StringBuilder("F \n");
        sb.append("\u250c").append(QuBit.getSpace(maxWide)).append("\u2510\n");
        for (int i = 0; i < order; ++i) {
            sb.append("\u2502");
            sb.append(buf[i]);
            sb.append(QuBit.getSpace(maxWide - wides[i]));
            sb.append("\u2502");
            sb.append("\n");
        }
        sb.append("\u2514").append(QuBit.getSpace(maxWide)).append("\u2518");
        return sb.toString();
    }

    public String toFormat(boolean orient) {
        int length = this.probAmp.length();
        StringBuilder sb = orient ? new StringBuilder("F\n[") : new StringBuilder("F [");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toFormat());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toFormat());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(String label) {
        int length = this.probAmp.length();
        StringBuilder sb = new StringBuilder(label + ":[");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toString());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toString());
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(String label, boolean orient) {
        int length = this.probAmp.length();
        StringBuilder sb = orient ? new StringBuilder(label + ":\n[") : new StringBuilder(label + ":[");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toString());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toString());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return label + ":" + str;
    }

    public String toFormat(String label, boolean orient) {
        int length = this.probAmp.length();
        StringBuilder sb = orient ? new StringBuilder(label + ":F\n[") : new StringBuilder(label + ":F [");
        for (int i = 0; i < length; i += 2) {
            sb.append(this.probAmp.getComp(i).toFormat());
            sb.append(", ");
            sb.append(this.probAmp.getComp(i + 1).toFormat());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(CompMat quBitMap) {
        int col = quBitMap.rowNumber();
        int row = quBitMap.rowNumber();
        int[] maxWide = new int[col];
        for (int j = 0; j < col; ++j) {
            maxWide[j] = 5;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                String text = quBitMap.getComp(i, j).toFormat();
                if (quBitMap.getReal(i, j) >= 0.0) {
                    buf[i][j] = " " + text;
                    wides[i][j] = text.length() + 1;
                } else {
                    buf[i][j] = text;
                    wides[i][j] = text.length();
                }
                if (wides[i][j] <= maxWide[j]) continue;
                maxWide[j] = wides[i][j];
            }
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "\uff1a";
        int gap = filler.length();
        int spaces = maxWide[0];
        for (int j = 1; j < col; ++j) {
            spaces = spaces + gap + 1 + maxWide[j];
        }
        sb.append("\u250c").append(QuBit.getSpace(spaces)).append("\u2510\n");
        for (int i = 0; i < row; ++i) {
            sb.append("\u2502");
            for (int j = 0; j < col; ++j) {
                sb.append(buf[i][j]);
                sb.append(QuBit.getSpace(maxWide[j] - wides[i][j])).append(filler);
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
        }
        sb.append("\u2514").append(QuBit.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public static String toFormat(String label, CompMat quBitMap) {
        String str = QuBit.toFormat(quBitMap);
        return label + ":" + str;
    }

    public static String toFormat(QuBit[] quBitArray) {
        int col = quBitArray.length;
        int row = quBitArray[0].getProbAmpLength();
        int[] maxWide = new int[col];
        for (int j = 0; j < col; ++j) {
            maxWide[j] = 5;
        }
        CompMat probAmpMat = new CompMat(row, col);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                Complex element = quBitArray[j].copyProbAmp(i);
                probAmpMat.setComp(i, j, element);
            }
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                String text = probAmpMat.getComp(i, j).toFormat();
                if (probAmpMat.getReal(i, j) >= 0.0) {
                    buf[i][j] = " " + text;
                    wides[i][j] = text.length() + 1;
                } else {
                    buf[i][j] = text;
                    wides[i][j] = text.length();
                }
                if (wides[i][j] <= maxWide[j]) continue;
                maxWide[j] = wides[i][j];
            }
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "\uffe4";
        int gap = filler.length();
        int spaces = maxWide[0];
        for (int j = 1; j < col; ++j) {
            spaces = spaces + gap + 1 + maxWide[j];
        }
        sb.append("\u250c").append(QuBit.getSpace(spaces)).append("\u2510\n");
        for (int i = 0; i < row; ++i) {
            sb.append("\u2502");
            for (int j = 0; j < col; ++j) {
                sb.append(buf[i][j]);
                sb.append(QuBit.getSpace(maxWide[j] - wides[i][j])).append(filler);
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
        }
        sb.append("\u2514").append(QuBit.getSpace(spaces)).append("\u2518");
        return sb.toString();
    }

    public static String toFormat(String label, QuBit[] quBitArray) {
        String str = QuBit.toFormat(quBitArray);
        return label + ":" + str;
    }

    public static String toString(ArrayList<QuBit> quBitsList) {
        int order = quBitsList.size();
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toString());
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toString(ArrayList<QuBit> quBitsList, boolean orient) {
        int order = quBitsList.size();
        StringBuilder sb = orient ? new StringBuilder("\n") : new StringBuilder();
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toString());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toFormat(ArrayList<QuBit> quBitsList) {
        int order = quBitsList.size();
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toFormat());
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toFormat(ArrayList<QuBit> quBitsList, boolean orient) {
        int order = quBitsList.size();
        StringBuilder sb = orient ? new StringBuilder("\n") : new StringBuilder(" ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toFormat());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toString(String label, ArrayList<QuBit> quBitsList) {
        int order = quBitsList.size();
        StringBuilder sb = new StringBuilder(label + " ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toString());
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toString(String label, ArrayList<QuBit> quBitsList, boolean orient) {
        int order = quBitsList.size();
        StringBuilder sb = orient ? new StringBuilder(label + "\n") : new StringBuilder(label + " ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toString());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toFormat(String label, ArrayList<QuBit> quBitsList) {
        int order = quBitsList.size();
        StringBuilder sb = new StringBuilder(label + " ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toFormat());
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }

    public static String toFormat(String label, ArrayList<QuBit> quBitsList, boolean orient) {
        int order = quBitsList.size();
        StringBuilder sb = orient ? new StringBuilder(label + "\n") : new StringBuilder(label + " ");
        for (int i = 0; i < order; ++i) {
            sb.append("(").append(i).append("):");
            sb.append(quBitsList.get(i).toFormat());
            if (orient) {
                sb.append(",\n");
                continue;
            }
            sb.append(", ");
        }
        int index = sb.length();
        sb.delete(index - 2, index);
        return sb.toString();
    }
}

