/*
 * Decompiled with CFR 0.152.
 */
package task;

import data.Control;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class AdaptivityVerifier
extends Task {
    int epoch = 50000;
    int batchNum = 1;
    int interval = 200;
    double initialCoef = 0.05;
    double eta = 0.05;
    int dataNum = 1000;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 2;
    int midNodeNum = 6;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;
    double squareError;
    double meanError;
    double aveError;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[8][this.dataNum];
        this.patternData1 = new double[8][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "AdaptivityVerifier:Try while Learning", 6, this.patternData1, "AdaptivityVerifier:Learning");
        this.graphShift = 9;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.adaptivityVerifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptivityVerifier() {
        DJ._print("DaiJa_V3, AdaptivityVerifier.adaptivityVerifier() ==========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff08\u8ca0\u8377\uff09\u3092\u8a2d\u5b9a");
        Control control = new Control();
        control.setParameter(10, 10, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        DJ._print(" \u5236\u5fa1\u7cfb\u304b\u3089\u6240\u671b\u901f\u5ea6\uff08\uff33\u5b57\u30ab\u30fc\u30d6\u5fdc\u7b54\uff09\u3092\u53ce\u96c6\u3059\u308b");
        double[] inputData = new double[this.dataNum];
        double[] correctData = new double[this.dataNum];
        double inc = 1.0 / (double)this.dataNum;
        double clock = -inc;
        for (int j = 0; j < this.dataNum; ++j) {
            inputData[j] = clock += inc;
            correctData[j] = control.getS_Curve(clock);
            this.patternData0[0][j] = clock;
            this.patternData1[0][j] = clock;
        }
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 1);
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 1);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        double[] outS = new double[outC.length];
        this.middleLayer0.setdEdY(outdEdX);
        this.outputLayer.setX(mid0Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.squareError = 0.0;
            this.meanError = 0.0;
            control.resetControl();
            control.disturber(i);
            for (int j = 0; j < this.dataNum; ++j) {
                int index = j;
                mid0X[0] = inputData[index];
                mid0X[1] = correctData[index];
                this.middleLayer0.forward();
                this.outputLayer.forward();
                control.setForce(outY[0] / 0.0048828125);
                control.execute();
                outS[0] = control.getSpeed();
                outC[0] = correctData[index];
                this.outputLayer.backward(outC, outS);
                this.middleLayer0.backward();
                if (j % this.batchNum == 0) {
                    this.middleLayer0.update();
                    this.outputLayer.update();
                }
                if (!this.intervalFlag) continue;
                this.squareError = outE[0] * outE[0] / 2.0;
                this.meanError += this.squareError;
                this.patternData0[1][j] = outY[0] * 0.1;
                this.patternData0[2][j] = outS[0];
                this.patternData0[3][j] = correctData[j];
                this.patternData0[4][j] = control.getAcceleration() * 100.0;
                this.patternData0[5][j] = 10.0;
                this.patternData0[6][j] = control.getPosition();
                this.patternData0[7][j] = control.getMass() * 1.0;
                if (i >= 10000) continue;
                this.patternData1[1][j] = this.patternData0[1][j];
                this.patternData1[2][j] = 10.0;
                this.patternData1[3][j] = this.patternData0[7][j];
                this.patternData1[4][j] = this.patternData0[4][j];
                this.patternData1[5][j] = this.patternData0[2][j];
                this.patternData1[6][j] = this.patternData0[6][j];
                this.patternData1[7][j] = this.patternData0[3][j];
            }
            this.aveError = this.meanError / (double)this.dataNum;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i);
                DJ.print_(", squareError = ", this.squareError);
                DJ.print(", aveError = ", this.aveError);
                this.graphData[0] = this.squareError;
                this.graphData[1] = this.aveError;
                this.updateViewer(i);
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                AdaptivityVerifier adaptivityVerifier = this;
                synchronized (adaptivityVerifier) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (!this.abortFlag) continue;
            DJ._print("##### Abort action requested");
            this.epoch = i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print("\u30fb\u30a8\u30dd\u30c3\u30af\u5b9f\u884c\u56de\u6570");
        DJ.print(" Last epoch = ", this.epoch);
        DJ.print_("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        for (int k = 0; k < this.graphData.length; ++k) {
            DJ.print_("  " + this.dataName[k] + "=" + this.graphData[k]);
        }
        DJ.print("");
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf\u6570: ", this.dataNum);
        DJ.print("\u529b\u64cd\u4f5c\u91cf\u306e\u63a8\u5b9a\u5024: f~", this.patternData0[1]);
        DJ.print("\u5fdc\u7b54\u901f\u5ea6: v", this.patternData0[2]);
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### AdaptivityVerifier \u7d42\u4e86 #####");
    }
}

