/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Collections;
import layer.LinearLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class ExorLogic
extends Task {
    int epoch = 50;
    int interval = 1;
    double initialCoef = 0.5;
    double eta = 0.5;
    int dataNum = 64;
    int inNodeNum = 2;
    int midNodeNum = 2;
    int outNodeNum = 1;
    private LinearLayer middleLayer;
    private LinearLayer outputLayer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[4][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(3, this.patternData0, "ExorLogic");
        this.graphShift = 1;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.exOR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exOR() {
        DJ._print("ExorLogic.exOR() ==================");
        DJ.print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" initialCoef=", this.initialCoef);
        DJ.print_(", eta=", this.eta);
        DJ.print_(", epoch=", this.epoch);
        DJ.print_(", interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1a", this.dataNum);
        DJ._print("\u3000\u5404\u5c64\u306e\u30cb\u30e5\u30fc\u30ed\u30f3\u6570");
        DJ.print_(" \u5165\u529b\u5c64\uff1a", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\uff1a", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\uff1a", this.outNodeNum);
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6b63\u89e3\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        int[][] inputData = new int[this.dataNum][2];
        int[] correctData = new int[this.dataNum];
        for (int i = 0; i < this.dataNum; ++i) {
            boolean b0 = DJ.getRandom().nextBoolean();
            boolean b1 = DJ.getRandom().nextBoolean();
            boolean bExor = b0 ^ b1;
            inputData[i][0] = DJ.boolToInt(b0);
            inputData[i][1] = DJ.boolToInt(b1);
            correctData[i] = DJ.boolToInt(bExor);
        }
        ArrayList<Integer> indexList = DJ.permutationRandom(this.dataNum);
        DJ.print("inputData", inputData);
        DJ.print("correctData", correctData);
        this.patternData0 = new double[4][this.dataNum];
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer = new LinearLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        double[] midX = this.middleLayer.getX();
        double[] midY = this.middleLayer.getY();
        this.outputLayer = new LinearLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Step", 0);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        this.middleLayer.setdEdY(outdEdX);
        this.outputLayer.setX(midY);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(1);
        }
        double squareError = 0.0;
        double meanError = 0.0;
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            Collections.shuffle(indexList);
            for (int j = 0; j < this.dataNum; ++j) {
                int index = indexList.get(j);
                for (int k = 0; k < 2; ++k) {
                    midX[k] = inputData[index][k];
                }
                this.middleLayer.forward();
                this.outputLayer.forward();
                outC[0] = correctData[index];
                this.outputLayer.backward(outC);
                this.middleLayer.backward();
                this.middleLayer.update();
                this.outputLayer.update();
                if (!this.intervalFlag) continue;
                squareError = outE[0] * outE[0] / 2.0;
                meanError += squareError;
                this.patternData0[0][j] = midX[0];
                this.patternData0[1][j] = midX[1];
                this.patternData0[2][j] = outY[0];
                this.patternData0[3][j] = outC[0];
            }
            double aveError = meanError / (double)this.dataNum;
            meanError = 0.0;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ._print_(" i=" + i);
                DJ.print_(", squareError = ", squareError);
                DJ.print(", aveError = ", aveError);
                this.graphData[0] = squareError;
                this.graphData[1] = aveError;
                this.updateViewer(i);
                DJ.print_(" lapTime = ", this.lapTime);
                DJ.print("[msec]");
                ExorLogic exorLogic = this;
                synchronized (exorLogic) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (!this.abortFlag) continue;
            DJ._print("##### Abort action requested");
            this.epoch = i;
        }
        DJ._print(" End of all epoch ---------------");
        DJ._print("\u30fb\u5404\u5c64\u306e\u5909\u6570\u306e\u6700\u7d42\u5024");
        DJ.print(" Last epoch = ", this.epoch);
        DJ._print("\u3000\u4e2d\u9593\u5c64\u306e\u30d0\u30a4\u30a2\u30b9\u3068\u91cd\u307f");
        DJ.print(" midLayer.bias", this.middleLayer.getB());
        DJ.print(" midLayer.weight", this.middleLayer.getW());
        DJ._print("\u3000\u51fa\u529b\u5c64\u306e\u30d0\u30a4\u30a2\u30b9\u3068\u91cd\u307f");
        DJ.print("outLayer.bias", this.outputLayer.getB());
        DJ.print("outLayer.weight", this.outputLayer.getW());
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }
}

