/*
 * Decompiled with CFR 0.152.
 */
package task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.StringTokenizer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;
import view.SomViewer;
import view.SomViewerLauncher;

public class SelfOrganizingMap
extends Task {
    public static final int LEARN_ONLINE = 0;
    public static final int LEARN_BATCH = 1;
    public static final int INITIAL_SHUFFLE = 0;
    public static final int INITIAL_LOAD = 1;
    public static final int RANDOM_SHUFFLE = 0;
    public static final int LINEAR_SHUFFLE = 1;
    public static final long DEFAULT_RANDOM_SEED = 314159265358979L;
    public static final int QUANTITY_OFF = 0;
    int epoch = 400;
    int interval = 1;
    public double learningRate = 0.1;
    public double learningRadius = 10.0;
    public double lastRadius = 1.0;
    public String factorFileName = "FactorFile";
    public int numOfTrial = 0;
    public int dimOfCodeX = 20;
    public int dimOfCodeY = 20;
    public int uMapXSize = 400;
    public int uMapYSize = 400;
    public int numOfContour = 10;
    public int baseContour = 10;
    public double borderContour = 0.2;
    public int evaluationType = 0;
    public double quantumCoeff = 1.0;
    public double disorderCoef = 1.0;
    public int learningType = 0;
    public int initialType = 0;
    public int shuffleMethod = 0;
    public int quantityFlag = 0;
    private double quantity = 0.0;
    private final long randomSeed = 314159265358979L;
    private int index;
    private long numberOfLearning = 500L;
    private int sleepTime = 1;
    private String titleLine = "#SOM Facter File : ";
    private String[] factorNames;
    private int dimOfFactor;
    private int numOfFactor;
    private double[][] factorVectors;
    private String[] factorLabels;
    private double[] minElement;
    private double[] maxElement;
    private double[][] trialVectors;
    private String[] trialLabels;
    private ArrayList<Integer> indexList;
    private int numOfCodeVector;
    private double[][] codeVectorArray;
    private int dimOfUX;
    private int dimOfUY;
    private double[][] uMatrix;
    private String[][] labelMap;
    private double quantumError;
    private double disorderError;
    private int oldNumOfUpper;
    private double[][] wN;
    private double[][] wD;
    private Random randamGenerator;
    private SomViewerLauncher somViewerLauncher;
    private SomViewer somViewer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.graphShift = 1;
        if (this.quantityFlag == 0) {
            this.graphData = new double[2];
            this.dataName = new String[2];
            this.dataName[0] = "uMapDisorder";
            this.dataName[1] = "quantumError";
        } else {
            this.graphData = new double[3];
            this.dataName = new String[3];
            this.dataName[0] = "uMapDisorder";
            this.dataName[1] = "quantumError";
            this.dataName[2] = "Quantity";
        }
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.somViewerLauncher = DJ.launchSomViewer(0, "SelfOrganizingMap");
        this.selfOrganizingMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selfOrganizingMap() {
        DJ._print("SelfOrganizingMap.selfOrganizingMap() ==================");
        DJ._print(" ##### \u5165\u529b\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f #####");
        DJ.print(" \u5165\u529b\u30c7\u30fc\u30bf\u306e\u30d5\u30a1\u30a4\u30eb\u540d\uff1a", this.factorFileName);
        if (!this.loadFactor(this.factorFileName)) {
            DJ.print("***** ERROR ***** SelfOrganizingMap.selfOrganizingMap() Failed to load Factor Data file.");
            return;
        }
        DJ._print(" ##### SOM\u306e\u6e96\u5099 #####");
        this.numOfCodeVector = this.dimOfCodeX * this.dimOfCodeY;
        this.codeVectorArray = new double[this.numOfCodeVector][this.dimOfFactor];
        this.wN = new double[this.numOfCodeVector][this.dimOfFactor];
        this.wD = new double[this.numOfCodeVector][this.dimOfFactor];
        this.dimOfUX = this.dimOfCodeX * 2;
        this.dimOfUY = this.dimOfCodeY * 2;
        this.uMatrix = new double[this.dimOfUX][this.dimOfUY];
        this.labelMap = new String[this.dimOfCodeX][this.dimOfCodeY];
        this.numberOfLearning = this.epoch * this.numOfFactor;
        DJ._print("\u30fb\u5404\u8981\u56e0\u3054\u3068\u306e\u6700\u5c0f\u5024\u3068\u6700\u5927\u5024\u3092\u6c42\u3081\u308b");
        this.minElement = new double[this.dimOfFactor];
        this.maxElement = new double[this.dimOfFactor];
        this.getMinMaxOfVector();
        DJ.print("Minimum of Factor", this.minElement);
        DJ.print("Maximum of Factor", this.maxElement);
        DJ._print("\u30fb\u53c2\u7167\u30d9\u30af\u30bf\u3092\u751f\u6210");
        if (this.initialType == 0) {
            switch (this.shuffleMethod) {
                default: {
                    this.randamGenerator = new Random(314159265358979L);
                    for (int id = 0; id < this.numOfCodeVector; ++id) {
                        this.codeVectorArray[id] = this.getRandomShuffledCode(this.minElement, this.maxElement);
                    }
                    break;
                }
                case 1: 
            }
        }
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        this.somViewer = this.somViewerLauncher.getSomViewer();
        if (this.somViewer == null) {
            DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n SomViewer is null.");
            return;
        }
        this.somViewer.appendComment(this.titleLine);
        this.somViewer.setProperty(this.numOfTrial, this.evaluationType, this.numOfContour, this.baseContour, this.borderContour, this.uMapXSize, this.uMapYSize);
        this.somViewer.setParameter(this.dimOfFactor, this.dimOfCodeX, this.dimOfCodeY, this.factorNames, this.numOfFactor, this.factorVectors, this.factorLabels);
        this.somViewer.setMap(this.codeVectorArray, this.uMatrix, this.labelMap);
        this.somViewer.setVisible(true);
        this.oldNumOfUpper = 0;
        this.quantumError = 0.0;
        this.quantity = 0.0;
        double disorderShift = (double)(this.dimOfFactor * this.numOfCodeVector) / this.disorderCoef;
        double quantumShift = (double)this.dimOfFactor / this.quantumCoeff * 100.0;
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_("\u3000\u5b66\u7fd2\u65b9\u6cd5\uff1alearningType=", this.learningType);
        DJ.print(",  0:\u9010\u6b21\u5b66\u7fd2(\u7dda\u5f62\u95a2\u6570), 1:\u4e00\u62ec\u5b66\u7fd2(\u7dda\u5f62\u95a2\u6570), 2:\u4e00\u62ec\u5b66\u7fd2(\u6307\u6570\u95a2\u6570)");
        DJ.print_("\u3000\u30a8\u30dd\u30c3\u30af\u56de\u6570\uff1aepoch=", this.epoch);
        DJ.print(", \u8868\u793a\u9593\u9694\uff1ainterval=", this.interval);
        DJ.print("\u3000\u30a8\u30dd\u30c3\u30af\u6bce\u306e\u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff08\u56e0\u5b50\u30d9\u30af\u30bf\u6570\uff09\uff1anumOfFactor=", this.numOfFactor);
        DJ.print_("\u3000\u5b66\u7fd2\u4fc2\u6570\uff1alearningRate=", this.learningRate);
        DJ.print(", \u5b66\u7fd2\u534a\u5f84\uff1alearningRadius=", this.learningRadius);
        DJ.print_("\u3000\u8a55\u4fa1\u65b9\u6cd5\uff1aevaluationType=", this.evaluationType);
        DJ.print(", \u91cf\u5b50\u5316\u8aa4\u5dee\u8868\u793a\u4fc2\u6570\uff1aquantumCoeff=", this.quantumCoeff);
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf");
        DJ.print("\u3000\u5165\u529b\u30c7\u30fc\u30bf\u30fb\u30d5\u30a1\u30a4\u30eb : ", this.titleLine);
        DJ.print_("\u3000\u56e0\u5b50\u30d9\u30af\u30bf\u6b21\u6570\uff1adimOfFactor=", this.dimOfFactor);
        DJ.print("\u3000\u56e0\u5b50\u30d9\u30af\u30bf\u6570\uff1anumOfFactor=", this.numOfFactor);
        DJ.print("\u3000\u56e0\u5b50\u540d\u30ea\u30b9\u30c8\uff1afactorNames=", DJ.stringArrayToString(this.factorNames));
        DJ.print("\u3000\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217\uff1afactorVectors", this.factorVectors);
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u6570\uff1anumOfTrial=", this.numOfTrial);
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217\uff1atrialVectors", this.trialVectors);
        DJ.print("\u3000\u56e0\u5b50\u30d9\u30af\u30bf\u306e\u30e9\u30d9\u30eb\uff1afactorLabels=", DJ.stringArrayToString(this.factorLabels));
        DJ.print("\u3000\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u306e\u30e9\u30d9\u30eb\uff1atrialLabels=", DJ.stringArrayToString(this.trialLabels));
        DJ._print("\u30fb\u53c2\u7167\u30d9\u30af\u30bf");
        DJ.print_("\u3000\uff38\u8ef8\u683c\u5b50\u6570\uff1adimOfCodeX=", this.dimOfCodeX);
        DJ.print_(", \uff39\u8ef8\u683c\u5b50\u6570\uff1adimOfCodeY=", this.dimOfCodeY);
        DJ.print(", \u53c2\u7167\u30d9\u30af\u30bf\u6570\uff1anumOfCodeVector=", this.numOfCodeVector);
        DJ._print("\u30fb\uff35\u30de\u30c3\u30d7");
        DJ.print_("\u3000\uff38\u8ef8\u683c\u5b50\u6570\uff1adimOfUX=", this.dimOfUX);
        DJ.print_(", \uff39\u8ef8\u683c\u5b50\u6570\uff1adimOfUY=", this.dimOfUY);
        DJ.print_(", \uff38\u8ef8\u8868\u793a\u5e45\uff1auMapXSize=", this.uMapXSize);
        DJ.print(", \uff39\u8ef8\u8868\u793a\u5e45\uff1auMapYSize=", this.uMapYSize);
        DJ.print_("\u3000\u7b49\u9ad8\u7dda\u6570\uff1anumOfContour=", this.numOfContour);
        DJ.print_(", \u57fa\u6e96\u7b49\u9ad8\u7dda\uff1abaseContour=", this.baseContour);
        DJ.print(", \u5883\u754c\u7b49\u9ad8\u7dda\uff1aborderContour=", this.borderContour);
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            switch (this.learningType) {
                default: {
                    this.online(i);
                    break;
                }
                case 1: {
                    this.batch(i);
                }
            }
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                this.calculateUMatrix();
                this.makeLabelMap();
                this.appendLabelMap();
                int iCount = i * this.numOfFactor;
                this.somViewer.updateMap(iCount);
            }
            this.disorderError = this.getUmapDisorder(this.uMatrix) / disorderShift;
            double qErr = this.quantumError / quantumShift;
            this.quantumError = 0.0;
            if (this.intervalFlag) {
                this.graphData[0] = this.disorderError;
                this.graphData[1] = qErr;
                if (this.quantityFlag != 0) {
                    this.calculateQuantity();
                    this.graphData[2] = this.quantity;
                }
                this.updateGraph(i);
                DJ.print_(" i=" + i);
                DJ.print_(", " + this.dataName[0] + " = ", this.graphData[0]);
                if (this.quantityFlag == 0) {
                    DJ.print(", " + this.dataName[1] + " = ", this.graphData[1]);
                } else {
                    DJ.print_(", " + this.dataName[1] + " = ", this.graphData[1]);
                    DJ.print(", " + this.dataName[2] + " = ", this.quantity);
                }
                SelfOrganizingMap selfOrganizingMap = this;
                synchronized (selfOrganizingMap) {
                    try {
                        this.wait(this.sleepTime);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (!this.abortFlag) continue;
            DJ._print("##### Abort action requested #####");
            this.epoch = i;
        }
        DJ._print(" End of all epoch ---------------");
        DJ._print("\u30fb\u56e0\u5b50\u540d");
        DJ.print(" factorNames=", DJ.stringArrayToString(this.factorNames));
        DJ._print("\u30fb\u5b66\u7fd2\u6e08\u307f\u53c2\u7167\u30d9\u30af\u30bf");
        DJ.print(" codeVectorArray", this.codeVectorArray);
        DJ._print("\u30fb\u30e9\u30d9\u30eb\u30de\u30c3\u30d7[\uff38\u8ef8\u683c\u5b50\u6570\uff0a\uff39\u8ef8\u683c\u5b50\u6570]");
        DJ.print(" labelMap[" + this.labelMap.length + "] = ");
        for (int ix = 0; ix < this.labelMap.length; ++ix) {
            DJ.print(" labelMap = ", DJ.stringArrayToString(this.labelMap[ix]));
        }
        DJ._print(" Last epoch = ", this.epoch);
        DJ._print("\u3000\u6700\u7d42\u8aa4\u5dee\u3068\u8a08\u7b97\u91cf");
        if (this.graphViewer != null) {
            DJ.print(this.dataName[0] + " = ", this.graphData[0]);
            DJ.print(this.dataName[1] + " = ", this.graphData[1]);
            if (this.quantityFlag != 0) {
                DJ.print(this.dataName[2] + " = ", this.quantity);
            }
        }
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.finishTime = System.currentTimeMillis();
        DJ.print(", \u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
    }

    double[] getRandomShuffledCode(double[] min, double[] max) {
        double[] aCodeVector = new double[this.dimOfFactor];
        for (int i = 0; i < this.dimOfFactor; ++i) {
            aCodeVector[i] = (max[i] - min[i]) * this.randamGenerator.nextDouble() + min[i];
        }
        return aCodeVector;
    }

    private boolean loadFactor(String fileName) {
        ArrayList<String> stringList = LogEditor.getText(fileName);
        if (stringList == null) {
            DJ.print("***** ERROR ***** SelfOrganizingMap.loadFactor() Failed to load Factor-Vector file.");
            return false;
        }
        DJ.print(" \uff08\uff11\uff09String comment:\u5165\u529b\u30c7\u30fc\u30bf\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u30bf\u30a4\u30c8\u30eb\u3068\u30b3\u30e1\u30f3\u30c8");
        this.titleLine = stringList.get(0);
        DJ.print(" \uff08\uff12\uff09String[] factorName:\u56e0\u5b50\u540d\u914d\u5217");
        String dataNameLine = stringList.get(1);
        StringTokenizer dataNameToken = new StringTokenizer(dataNameLine, ",");
        ArrayList<String> factorNameList = new ArrayList<String>();
        while (dataNameToken.hasMoreTokens()) {
            factorNameList.add(dataNameToken.nextToken());
        }
        this.dimOfFactor = factorNameList.size();
        if (this.dimOfFactor < 1) {
            DJ.print("***** ERROR ***** SelfOrganizingMap.loadFactor() Dimension of factorNameList < 1.");
            return false;
        }
        this.factorNames = new String[this.dimOfFactor];
        for (int i = 0; i < this.dimOfFactor; ++i) {
            this.factorNames[i] = (String)factorNameList.get(i);
        }
        DJ.print(" \uff08\uff13\uff09double[][] factorVectors:\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217");
        DJ.print(" \uff08\uff14\uff09String[] factorLabels:\u56e0\u5b50\u30d9\u30af\u30bf\u30fb\u30e9\u30d9\u30eb\u914d\u5217");
        int numOfLines = stringList.size();
        this.numOfFactor = numOfLines - 2 - this.numOfTrial;
        if (this.numOfFactor < 1) {
            DJ.print("***** ERROR ***** SelfOrganizingMap.loadFactor() Number of Facter Vector is less than 1.");
            return false;
        }
        this.factorVectors = new double[this.numOfFactor][this.dimOfFactor];
        this.factorLabels = new String[this.numOfFactor];
        this.indexList = DJ.permutationRandom(this.numOfFactor);
        DJ.print(" \uff08\uff15\uff09double[][] trialVectors:\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u914d\u5217");
        DJ.print(" \uff08\uff16\uff09String[] trialLabels:\u8a66\u884c\u7528\u56e0\u5b50\u30d9\u30af\u30bf\u30fb\u30e9\u30d9\u30eb\u914d\u5217");
        if (this.numOfTrial < 1) {
            this.trialVectors = new double[1][this.dimOfFactor];
            this.trialLabels = new String[1];
        } else {
            this.trialVectors = new double[this.numOfTrial][this.dimOfFactor];
            this.trialLabels = new String[this.numOfTrial];
        }
        int rowNum = numOfLines - 2;
        for (int j = 0; j < rowNum; ++j) {
            String dataLine = stringList.get(j + 2);
            StringTokenizer dataToken = new StringTokenizer(dataLine, ",");
            for (int i = 0; i < this.dimOfFactor; ++i) {
                if (dataToken.hasMoreTokens()) {
                    double value = Double.parseDouble(dataToken.nextToken().trim());
                    if (j < this.numOfFactor) {
                        this.factorVectors[j][i] = value;
                        continue;
                    }
                    this.trialVectors[j - this.numOfFactor][i] = value;
                    continue;
                }
                if (j < this.numOfFactor) {
                    this.factorVectors[j][i] = 0.0;
                    continue;
                }
                this.trialVectors[j - this.numOfFactor][i] = 0.0;
            }
            if (dataToken.hasMoreTokens()) {
                String label = dataToken.nextToken();
                if (j < this.numOfFactor) {
                    this.factorLabels[j] = label;
                    continue;
                }
                this.trialLabels[j - this.numOfFactor] = label;
                continue;
            }
            if (j < this.numOfFactor) {
                this.factorLabels[j] = "";
                continue;
            }
            this.trialLabels[j - this.numOfFactor] = "";
        }
        return true;
    }

    private void getMinMaxOfVector() {
        for (int i = 0; i < this.dimOfFactor; ++i) {
            this.minElement[i] = Double.MAX_VALUE;
            this.maxElement[i] = -1.7976931348623157E308;
        }
        for (int j = 0; j < this.numOfFactor; ++j) {
            for (int i = 0; i < this.dimOfFactor; ++i) {
                if (this.factorVectors[j][i] < this.minElement[i]) {
                    this.minElement[i] = this.factorVectors[j][i];
                }
                if (!(this.factorVectors[j][i] > this.maxElement[i])) continue;
                this.maxElement[i] = this.factorVectors[j][i];
            }
        }
    }

    public int findWinner(double[] factorVector) {
        double leastNorm = Double.MAX_VALUE;
        int bestMatchIndex = -1;
        for (int i = 0; i < this.numOfCodeVector; ++i) {
            double delta;
            double aNorm = 0.0;
            for (int j = 0; j < this.dimOfFactor && !((aNorm += (delta = this.codeVectorArray[i][j] - factorVector[j]) * delta) > leastNorm); ++j) {
            }
            if (!(aNorm < leastNorm)) continue;
            leastNorm = aNorm;
            bestMatchIndex = i;
        }
        this.quantumError += Math.sqrt(leastNorm);
        return bestMatchIndex;
    }

    private void adaptNeighbour(double[] factorVector, int bestMatchIndex, int iCount) {
        double remainder = 1.0 - (double)iCount / (double)this.numberOfLearning;
        double radius = 1.0 + (this.learningRadius - 1.0) * remainder;
        int bestX = bestMatchIndex % this.dimOfCodeX;
        int bestY = bestMatchIndex / this.dimOfCodeX;
        for (int id = 0; id < this.numOfCodeVector; ++id) {
            int tempX = id % this.dimOfCodeX;
            int tempY = id / this.dimOfCodeX;
            double distance = this.getGridDistance(bestX, bestY, tempX, tempY);
            if (!(distance <= radius)) continue;
            double rate = this.learningRate * (1.0 - distance / radius) * remainder;
            this.adaptCode(id, factorVector, rate);
        }
    }

    private void adaptCode(int id, double[] factorVector, double rate) {
        double[] codeVector = this.codeVectorArray[id];
        for (int i = 0; i < this.dimOfFactor; ++i) {
            this.codeVectorArray[id][i] = codeVector[i] + rate * (factorVector[i] - codeVector[i]);
        }
    }

    private void online(int iEpoch) {
        Collections.shuffle(this.indexList);
        for (int j = 0; j < this.numOfFactor; ++j) {
            this.index = this.indexList.get(j);
            int bestMatchIndex = this.findWinner(this.factorVectors[this.index]);
            int currentCount = iEpoch * this.numOfFactor + j;
            this.adaptNeighbour(this.factorVectors[this.index], bestMatchIndex, currentCount);
            this.calculateUMatrix();
            this.makeLabelMap();
            this.appendLabelMap();
        }
    }

    private void batch(int iEpoch) {
        for (int id = 0; id < this.numOfCodeVector; ++id) {
            for (int k = 0; k < this.dimOfFactor; ++k) {
                this.wN[id][k] = 0.0;
                this.wD[id][k] = 0.0;
            }
        }
        double tau = 2.5;
        double et = this.learningRadius * Math.exp(-tau * (double)iEpoch / (double)this.epoch);
        double radius = Math.max(et, this.lastRadius);
        for (int j = 0; j < this.numOfFactor; ++j) {
            int bestMatchIndex = this.findWinner(this.factorVectors[j]);
            for (int id = 0; id < this.numOfCodeVector; ++id) {
                double sr = 2.0 * radius * radius;
                double norm = this.getGridNorm(bestMatchIndex, id);
                double nFunc = Math.exp(-norm / sr);
                for (int k = 0; k < this.dimOfFactor; ++k) {
                    this.wN[id][k] = this.wN[id][k] + nFunc * this.factorVectors[j][k];
                    this.wD[id][k] = this.wD[id][k] + nFunc;
                }
            }
        }
        for (int id = 0; id < this.numOfCodeVector; ++id) {
            for (int k = 0; k < this.dimOfFactor; ++k) {
                if (!(this.wD[id][k] > 0.0) && !(this.wD[id][k] < 0.0)) continue;
                this.codeVectorArray[id][k] = this.wN[id][k] / this.wD[id][k];
            }
        }
    }

    private double getGridDistance(int bestX, int bestY, int tempX, int tempY) {
        int delta = bestX - tempX;
        double distance = delta * delta;
        delta = bestY - tempY;
        distance += (double)(delta * delta);
        distance = Math.sqrt(distance);
        return distance;
    }

    private double getGridNorm(int bestIndex, int tempIndex) {
        int bestX = bestIndex % this.dimOfCodeX;
        int bestY = bestIndex / this.dimOfCodeX;
        int tempX = tempIndex % this.dimOfCodeX;
        int tempY = tempIndex / this.dimOfCodeX;
        int delta = bestX - tempX;
        double norm = delta * delta;
        delta = bestY - tempY;
        return norm += (double)(delta * delta);
    }

    private void calculateUMatrix() {
        int j;
        int i;
        for (i = 0; i < this.dimOfCodeX; ++i) {
            for (j = 0; j < this.dimOfCodeY; ++j) {
                double dz;
                double delta;
                int k;
                int id = this.dimOfCodeX * j + i;
                if (i < this.dimOfCodeX - 1) {
                    double dx = 0.0;
                    for (k = 0; k < this.dimOfFactor; ++k) {
                        delta = this.codeVectorArray[id][k] - this.codeVectorArray[id + 1][k];
                        dx += delta * delta;
                    }
                    this.uMatrix[2 * i + 1][2 * j] = Math.sqrt(dx);
                }
                if (j < this.dimOfCodeY - 1) {
                    double dy = 0.0;
                    for (k = 0; k < this.dimOfFactor; ++k) {
                        delta = this.codeVectorArray[id][k] - this.codeVectorArray[id + this.dimOfCodeX][k];
                        dy += delta * delta;
                    }
                    this.uMatrix[2 * i][2 * j + 1] = Math.sqrt(dy);
                }
                if (j >= this.dimOfCodeY - 1 || i >= this.dimOfCodeX - 1) continue;
                double dz1 = 0.0;
                double dz2 = 0.0;
                for (int k2 = 0; k2 < this.dimOfFactor; ++k2) {
                    double delta2 = this.codeVectorArray[id][k2] - this.codeVectorArray[id + this.dimOfCodeX + 1][k2];
                    dz1 += delta2 * delta2;
                    delta2 = this.codeVectorArray[id + this.dimOfCodeX][k2] - this.codeVectorArray[id + 1][k2];
                    dz2 += delta2 * delta2;
                }
                this.uMatrix[2 * i + 1][2 * j + 1] = dz = (Math.sqrt(dz1 / 2.0) + Math.sqrt(dz2 / 2.0)) / 2.0;
            }
        }
        for (i = 0; i < this.dimOfUX; i += 2) {
            for (j = 0; j < this.dimOfUY; j += 2) {
                double[] medtable;
                if (i > 0 && j > 0) {
                    medtable = new double[]{this.uMatrix[i - 1][j], this.uMatrix[i + 1][j], this.uMatrix[i][j - 1], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = (medtable[1] + medtable[2]) / 2.0;
                    continue;
                }
                if (j == 0 && i > 0) {
                    medtable = new double[]{this.uMatrix[i - 1][j], this.uMatrix[i + 1][j], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = medtable[1];
                    continue;
                }
                if (i == 0 && j > 0) {
                    medtable = new double[]{this.uMatrix[i + 1][j], this.uMatrix[i][j - 1], this.uMatrix[i][j + 1]};
                    Arrays.sort(medtable);
                    this.uMatrix[i][j] = medtable[1];
                    continue;
                }
                if (i != 0 || j != 0) continue;
                this.uMatrix[i][j] = (this.uMatrix[i + 1][j] + this.uMatrix[i][j + 1]) / 2.0;
            }
        }
    }

    public double getUmapDisorder(double[][] uMatrix) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int numOfX = uMatrix.length;
        int numOfY = uMatrix[0].length;
        for (int i = 0; i < numOfX; ++i) {
            for (int j = 0; j < numOfY; ++j) {
                if (uMatrix[i][j] < min) {
                    min = uMatrix[i][j];
                }
                if (!(uMatrix[i][j] > max)) continue;
                max = uMatrix[i][j];
            }
        }
        int numOfUpper = 0;
        double threshold = min + (max - min) * 0.5;
        for (int i = 0; i < numOfX; ++i) {
            for (int j = 0; j < numOfY; ++j) {
                if (!(uMatrix[i][j] >= threshold)) continue;
                ++numOfUpper;
            }
        }
        double diff = numOfUpper - this.oldNumOfUpper;
        double disorder = diff * diff;
        this.oldNumOfUpper = numOfUpper;
        return disorder;
    }

    public void makeLabelMap() {
        for (int i = 0; i < this.dimOfCodeX; ++i) {
            for (int j = 0; j < this.dimOfCodeY; ++j) {
                this.labelMap[i][j] = "";
            }
        }
        for (int id = 0; id < this.numOfFactor; ++id) {
            int j;
            int bestMatchIndex = this.findWinner(this.factorVectors[id]);
            int i = bestMatchIndex % this.dimOfCodeX;
            this.labelMap[i][j] = this.labelMap[i][j = bestMatchIndex / this.dimOfCodeX].equals("") ? this.factorLabels[id] : this.labelMap[i][j] + this.factorLabels[id];
        }
    }

    public void appendLabelMap() {
        if (this.numOfTrial < 1) {
            return;
        }
        for (int id = 0; id < this.numOfTrial; ++id) {
            int j;
            int bestMatchIndex = this.findWinner(this.trialVectors[id]);
            int i = bestMatchIndex % this.dimOfCodeX;
            this.labelMap[i][j] = this.labelMap[i][j = bestMatchIndex / this.dimOfCodeX].equals("") ? "\u2605" + this.trialLabels[id] : this.labelMap[i][j] + ":\u2605" + this.trialLabels[id];
        }
    }

    public final void calculateQuantity() {
        int id;
        double sum = 0.0;
        double xS = 0.0;
        double yS = 0.0;
        double xE = 0.0;
        double yE = 0.0;
        String labelS = "";
        String labelE = "";
        for (id = 0; id < this.labelMap.length && (labelS = this.labelMap[id][0]).equals(""); ++id) {
        }
        if (labelS.equals("")) {
            DJ.print("***** WARNING ***** SelfOrganizingMap.calculateQuantity() Failed to find first factor label.");
            this.quantity = -1.0;
            return;
        }
        ++id;
        while (id < this.labelMap.length - 1) {
            int k;
            boolean findFlag = false;
            while (id < this.labelMap.length) {
                labelE = this.labelMap[id][0];
                if (!labelE.equals("")) {
                    findFlag = true;
                    break;
                }
                ++id;
            }
            if (!findFlag) break;
            for (k = 0; k < this.numOfFactor; ++k) {
                if (!labelS.equals(this.factorLabels[k])) continue;
                xS = this.factorVectors[k][0];
                yS = this.factorVectors[k][1];
                break;
            }
            for (k = 0; k < this.numOfFactor; ++k) {
                if (!labelE.equals(this.factorLabels[k])) continue;
                xE = this.factorVectors[k][0];
                yE = this.factorVectors[k][1];
                break;
            }
            double val = (xE - xS) * (xE - xS) + (yE - yS) * (yE - yS);
            sum += Math.sqrt(val);
            ++id;
            labelS = labelE;
        }
        this.quantity = sum;
    }

    public void showSom() {
        if (this.somViewer != null) {
            if (this.somViewer.isShowing()) {
                this.somViewer.setVisible(false);
            } else {
                this.somViewer.setVisible(true);
            }
        } else {
            DJ._print("SomViewer is null.");
        }
    }
}

