/*
 * Decompiled with CFR 0.152.
 */
package task;

import data.Control;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class SpeedControl
extends Task {
    static final int THREE_LAYER = 3;
    int layerNum = 3;
    int epoch = 50000;
    int batchNum = 1;
    int interval = 500;
    double initialCoef = 0.05;
    double eta = 0.05;
    int dataNum = 1000;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 3;
    int midNodeNum = 8;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer middleLayer1;
    private ControlLayer outputLayer;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[10][this.dataNum];
        this.patternData1 = new double[10][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "SpeedControl:Learning", 6, this.patternData1, "SpeedControl:Trial");
        this.graphShift = 8;
        this.graphData = new double[2];
        this.dataName = new String[2];
        this.dataName[0] = "squareError";
        this.dataName[1] = "aveError";
        this.graphViewerLauncher = DJ.graph(this.epoch, this.interval, this.dataName, this.graphData);
        this.speedControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speedControl() {
        DJ._print("SpeedControl.speedControl() ==========================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u91cd\u307f\u3068\u30d0\u30a4\u30a2\u30b9\u306e\u521d\u671f\u5024\u4fc2\u6570:initialCoef=", this.initialCoef);
        DJ.print_(", \u5b66\u7fd2\u4fc2\u6570:eta=", this.eta);
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print_(" \u30d0\u30c3\u30c1\u6570:batchNum=", this.batchNum);
        DJ.print_(", \u7d4c\u904e\u8868\u793a\u9593\u9694:interval=", this.interval);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5404\u5c64\u306e\u30ce\u30fc\u30c9\u6570");
        DJ.print_(" \u5165\u529b\u5c64\u30ce\u30fc\u30c9\u6570:inNodeNum=", this.inNodeNum);
        DJ.print_(", \u4e2d\u9593\u5c64\u30ce\u30fc\u30c9\u6570:midNodeNum=", this.midNodeNum);
        DJ.print(", \u51fa\u529b\u5c64\u30ce\u30fc\u30c9\u6570:outNodeNum=", this.outNodeNum);
        DJ._print("\u30fb\u5b66\u7fd2\u5bfe\u8c61\uff08\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff09\u306e\u5b9f\u884c\u6e96\u5099");
        Control control = new Control();
        control.setParameter(10, 10, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        DJ._print(" \u76ee\u6a19\u5024\u3092\u53ce\u96c6\u3059\u308b");
        double[] correctData = new double[this.dataNum];
        double[] accelCmd = new double[this.dataNum];
        double[] speedCmd = new double[this.dataNum];
        double[] positionCmd = new double[this.dataNum];
        double spd = 0.0;
        double psn = 0.0;
        for (int j = 0; j < this.dataNum; ++j) {
            double clock = 0.0 + 1.0 / (double)this.dataNum * (double)j;
            accelCmd[j] = clock < 0.5 ? (1.0 - Math.cos(Math.PI * 4 * clock)) * 2.0 : (-1.0 + Math.cos(Math.PI * 4 * clock)) * 2.0;
            speedCmd[j] = spd += accelCmd[j] / (double)this.dataNum;
            positionCmd[j] = psn += speedCmd[j] / (double)this.dataNum;
            correctData[j] = speedCmd[j];
            this.patternData0[0][j] = clock;
            this.patternData1[0][j] = clock;
        }
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        if (this.layerNum == 3) {
            this.middleLayer0.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        } else {
            this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        }
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.middleLayer1 = new ControlLayer(this.midNodeNum, this.midNodeNum);
        if (this.layerNum == 3) {
            this.middleLayer1.initialize(this.eta, this.initialCoef, "active.ReLU", 1);
        } else {
            this.middleLayer1.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        }
        double[] mid1Y = this.middleLayer1.getY();
        double[] mid1dEdX = this.middleLayer1.getdEdX();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 1);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        double[] outS = new double[outC.length];
        if (this.layerNum == 3) {
            this.middleLayer0.setdEdY(mid1dEdX);
            this.middleLayer1.setdEdY(outdEdX);
            this.middleLayer1.setX(mid0Y);
            this.outputLayer.setX(mid1Y);
        } else {
            this.middleLayer0.setdEdY(outdEdX);
            this.outputLayer.setX(mid0Y);
        }
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        this.graphViewer = this.graphViewerLauncher.getGraphViewer();
        if (this.graphViewer != null) {
            this.graphViewer.shiftGraphAxis(this.graphShift);
        }
        DJ._print(" ##### \u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5b66\u7fd2\u958b\u59cb #####");
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            double squareError = 0.0;
            double meanError = 0.0;
            control.setParameter(10, 10, this.inertia, this.friction);
            control.resetControl();
            for (int j = 0; j < this.dataNum; ++j) {
                int index = j;
                mid0X[0] = accelCmd[index] * 0.05;
                mid0X[1] = correctData[index];
                mid0X[2] = positionCmd[index];
                this.middleLayer0.forward();
                if (this.layerNum == 3) {
                    this.middleLayer1.forward();
                }
                this.outputLayer.forward();
                double force = outY[0] / 0.0048828125;
                control.setForce(force);
                control.execute();
                outS[0] = control.getSpeed();
                outC[0] = correctData[index];
                this.outputLayer.backward(outC, outS);
                if (this.layerNum == 3) {
                    this.middleLayer1.backward();
                }
                this.middleLayer0.backward();
                if (j % this.batchNum == 0) {
                    this.middleLayer0.update();
                    if (this.layerNum == 3) {
                        this.middleLayer1.update();
                    }
                    this.outputLayer.update();
                }
                if (!this.intervalFlag) continue;
                squareError = outE[0] * outE[0] / 2.0;
                meanError += squareError;
                this.patternData0[1][j] = force * 0.001;
                this.patternData0[2][j] = outS[0];
                this.patternData0[3][j] = correctData[j];
                this.patternData0[4][j] = control.getAcceleration() * 100.0;
                this.patternData0[5][j] = -10.0;
                this.patternData0[6][j] = control.getPosition();
                this.patternData0[7][j] = accelCmd[j] * 0.1;
                this.patternData0[8][j] = speedCmd[j];
                this.patternData0[9][j] = positionCmd[j];
            }
            double aveError = meanError / (double)this.dataNum;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                DJ.print_(" i=" + i);
                DJ.print_(", squareError = ", squareError);
                DJ.print(", aveError = ", aveError);
                this.graphData[0] = squareError;
                this.graphData[1] = aveError;
                this.updateViewer(i);
                DJ.print_(", lapTime = ", this.lapTime);
                DJ.print("[msec]");
                SpeedControl speedControl = this;
                synchronized (speedControl) {
                    try {
                        this.wait(1L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (!this.abortFlag) continue;
            DJ._print("##### Abort action requested");
            this.epoch = i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        DJ._print("\u30fb\u30a8\u30dd\u30c3\u30af\u5b9f\u884c\u56de\u6570");
        DJ.print(" Last epoch = ", this.epoch);
        DJ.print_("\u30fb\u6700\u7d42\u8aa4\u5dee: ");
        for (int k = 0; k < this.graphData.length; ++k) {
            DJ.print_("  " + this.dataName[k] + "=" + this.graphData[k]);
        }
        DJ.print("");
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf\u6570: ", this.dataNum);
        DJ.print("\u529b\u64cd\u4f5c\u91cf\u306e\u63a8\u5b9a\u5024: f~", this.patternData0[1]);
        DJ.print("\u5fdc\u7b54\u901f\u5ea6: v", this.patternData0[2]);
        DJ._print("\u30fb\u691c\u8a3c\uff1a\u5b66\u7fd2\u3057\u305f\u9006\u95a2\u6570\u3067\u5236\u5fa1\u5bfe\u8c61\u3092\u99c6\u52d5\u3057\u3001\u5fdc\u7b54\u901f\u5ea6\u3092\u6bd4\u8f03\u3059\u308b");
        control.setParameter(10, 10, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        for (int j = 0; j < this.dataNum; ++j) {
            mid0X[0] = accelCmd[j] * 0.05;
            mid0X[1] = correctData[j];
            mid0X[2] = positionCmd[j];
            this.middleLayer0.forward();
            if (this.layerNum == 3) {
                this.middleLayer1.forward();
            }
            this.outputLayer.forward();
            double force = outY[0] / 0.0048828125;
            control.setForce(force);
            control.execute();
            this.patternData1[1][j] = force * 0.001;
            this.patternData1[2][j] = -10.0;
            this.patternData1[3][j] = -10.0;
            this.patternData1[4][j] = control.getAcceleration() * 100.0;
            this.patternData1[5][j] = control.getSpeed();
            this.patternData1[6][j] = control.getPosition();
            this.patternData1[7][j] = accelCmd[j] * 0.1;
            this.patternData1[8][j] = speedCmd[j];
            this.patternData1[9][j] = positionCmd[j];
        }
        this.updatePattern();
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### SpeedControl \u7d42\u4e86 #####");
    }
}

