/*
 * Decompiled with CFR 0.152.
 */
package task;

import data.Control;
import java.util.ArrayList;
import layer.ControlLayer;
import task.Task;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;

public class TargetSampler
extends Task {
    int epoch = 1;
    int batchNum = 1;
    int interval = 1;
    double initialCoef = 0.01;
    double eta = 0.01;
    int dataNum = 1000;
    int speedGain = 1280;
    int integralGain = 0;
    double inertia = 1.0;
    double friction = 2.0;
    int inNodeNum = 1;
    int midNodeNum = 1;
    int outNodeNum = 1;
    private ControlLayer middleLayer0;
    private ControlLayer outputLayer;
    private static final String FILE_NAME = "DaiJa-V4_SampledData.dat";

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "TargetSampler0");
        this.targetSampler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetSampler() {
        DJ._print("DaiJa_V3, TargetSampler.targetSampler() ======================");
        DJ._print("\u30fb\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print(", \u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570:epoch=", this.epoch);
        DJ.print(", \u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum=", this.dataNum);
        DJ.print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff08\u8ca0\u8377\uff09\u3092\u8a2d\u5b9a");
        Control control = new Control();
        control.setParameter(0, 0, this.inertia, this.friction);
        control.stopSpeedControl();
        control.resetControl();
        DJ._print("\u30fb\u5236\u5fa1\u5bfe\u8c61\u306e\u5b9f\u884c\u30c7\u30fc\u30bf\u3092\u53ce\u96c6");
        double[][] sampleData = new double[5][this.dataNum];
        double f = 0.0;
        double inc = 1.0 / (double)this.dataNum;
        double clock = -inc;
        for (int j = 0; j < this.dataNum; ++j) {
            sampleData[0][j] = clock += inc;
            int cycle = this.dataNum / 8;
            double fInc = 80.0;
            if (j > cycle * 8) {
                f = 0.0;
            } else if (j > cycle * 7) {
                f -= fInc;
            } else if (j > cycle * 5) {
                f += fInc;
            } else if (j > cycle * 4) {
                f -= fInc;
            } else if (j > cycle * 3) {
                f += fInc;
            } else if (j > cycle) {
                f -= fInc;
            } else if (j > 0) {
                f += fInc;
            }
            sampleData[1][j] = f;
            control.setForce(f);
            control.execute();
            sampleData[2][j] = control.getAcceleration();
            sampleData[3][j] = control.getSpeed();
            sampleData[4][j] = control.getPosition();
        }
        int dataNum_ = sampleData[0].length;
        if (dataNum_ != this.dataNum) {
            DJ.print("***** ERROR ***** TargetSampler.targetSampler()\n Size of sampleData(" + dataNum_ + ") is not equal to " + this.dataNum + ".");
            return;
        }
        for (int j = 0; j < this.dataNum; ++j) {
            this.patternData0[0][j] = sampleData[0][j];
            this.patternData0[1][j] = sampleData[1][j] * 0.001;
            this.patternData0[2][j] = sampleData[2][j] * 200.0;
            this.patternData0[3][j] = sampleData[3][j] * 5.0;
            this.patternData0[4][j] = sampleData[4][j] * 100.0;
        }
        DJ._print("\u30fb\u5b66\u7fd2\u5bfe\u8c61\uff08\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\uff09\u306e\u5b9f\u884c\u6e96\u5099");
        control.setParameter(10, 10, this.inertia, this.friction);
        control.stopSpeedControl();
        DJ._print(" \u5b66\u7fd2\u7528\u898b\u672c\u30c7\u30fc\u30bf\uff1asampleData");
        DJ.print_(", \u884c\u6570\uff1a" + sampleData.length + "\uff08\u6642\u70b9,\u64cd\u4f5c\u91cf,\u5fdc\u7b54\uff09");
        DJ.print(", \u5217\u6570\uff1a", sampleData[0].length + "\uff08\u9078\u70b9\uff09");
        DJ._print("\u30fb\u5165\u529b\u30c7\u30fc\u30bf\u3068\u6559\u5e2b\u30c7\u30fc\u30bf\u3092\u4f5c\u6210");
        double[] inputData = new double[this.dataNum];
        double[] correctData = new double[this.dataNum];
        clock = -inc;
        for (int j = 0; j < this.dataNum; ++j) {
            inputData[j] = clock += inc;
            correctData[j] = sampleData[2][j] * 10.0;
        }
        DJ._print("\u30fb\u30cb\u30e5\u30fc\u30e9\u30eb\u30cd\u30c3\u30c8\u306e\u5404\u5c64\u306e\u521d\u671f\u5316");
        this.middleLayer0 = new ControlLayer(this.inNodeNum, this.midNodeNum);
        this.middleLayer0.initialize(this.eta, this.initialCoef, "active.Sigmoid", 0);
        double[] mid0X = this.middleLayer0.getX();
        double[] mid0Y = this.middleLayer0.getY();
        this.outputLayer = new ControlLayer(this.midNodeNum, this.outNodeNum);
        this.outputLayer.initialize(this.eta, this.initialCoef, "active.Identity", 0);
        double[] outY = this.outputLayer.getY();
        double[] outC = this.outputLayer.getC();
        double[] outE = this.outputLayer.getE();
        double[] outdEdX = this.outputLayer.getdEdX();
        double[] outS = new double[outC.length];
        this.middleLayer0.setdEdY(outdEdX);
        this.outputLayer.setX(mid0Y);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                TargetSampler targetSampler = this;
                synchronized (targetSampler) {
                    try {
                        this.wait(100L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (!this.abortFlag) continue;
            DJ._print("##### Abort action requested");
            this.epoch = i;
        }
        DJ._print(" End of all epoch --------------------------------------------");
        this.updatePattern();
        DJ._print("\u30fb\u5236\u5fa1\u7cfb\u3068\u5236\u5fa1\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print_(" \u6bd4\u4f8b\u30b2\u30a4\u30f3:speedGain=", this.speedGain);
        DJ.print_(", \u7a4d\u5206\u30b2\u30a4\u30f3:integralGain=", this.integralGain);
        DJ.print_(", \u6163\u6027\u8cea\u91cf:inertia=", this.inertia);
        DJ.print(", \u7c98\u6027\u6469\u64e6:friction=", this.friction);
        DJ._print("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf");
        DJ.print(" \u53ce\u96c6\u30c7\u30fc\u30bf\u6570: ", this.dataNum);
        DJ.print_(" \u30af\u30ed\u30c3\u30af: ");
        DJ.print("clock", sampleData[0]);
        DJ.print_(" \u529b\u64cd\u4f5c\u91cf: ");
        DJ.print("fm", sampleData[1]);
        DJ.print_(" \u5fdc\u7b54\u52a0\u901f\u5ea6: ");
        DJ.print("a", sampleData[2]);
        DJ.print_(" \u5fdc\u7b54\u901f\u5ea6: ");
        DJ.print("v", sampleData[3]);
        DJ.print_(" \u5fdc\u7b54\u4f4d\u7f6e: ");
        DJ.print("p", sampleData[4]);
        DJ._print_("\u30fb\u53ce\u96c6\u30c7\u30fc\u30bf\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3059\u308b");
        TargetSampler.saveData(sampleData, FILE_NAME);
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        DJ._print("##### TargetSampler \u7d42\u4e86 #####");
    }

    public static void saveData(double[][] sampleData, String fileName) {
        int row = sampleData.length;
        ArrayList<String> buf = new ArrayList<String>(row);
        for (int i = 0; i < row; ++i) {
            StringBuilder str = new StringBuilder();
            str.append(sampleData[i][0]);
            for (int j = 1; j < sampleData[0].length; ++j) {
                str.append(",").append(sampleData[i][j]);
            }
            buf.add(str.toString() + "\r\n");
        }
        LogEditor.saveText(buf, fileName);
    }
}

