/*
 * Decompiled with CFR 0.152.
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;

public class DeutschAlgorithm
extends Task {
    int dataNum = 1000;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "DeutschAlgorithm", 6, this.patternData1, "DeutschAlgorithm");
        this.stepMode = true;
        this.deutschAlgorithm();
    }

    public void deutschAlgorithm() {
        double[][] resultTransProb;
        QuBit resultQB;
        this.stepMode = true;
        DJ._print("DeutschAlgorithm.deutschAlgorithm() ========================");
        DJ.print("\u25a0\u91cf\u5b50\u8a08\u7b97\u306e\u958b\u59cb");
        DJ._print("(1)\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306e\u6982\u8981");
        DJ.print("(2)\u30aa\u30e9\u30af\u30eb");
        DJ.print("(3)\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0");
        DJ.print("(4)\u95a2\u6570\u5225\u30aa\u30e9\u30af\u30eb");
        DJ.printS(1, "DeutschAlgorithm(1)", this);
        DJ.print("// ---------------------------------------------------");
        DJ.print("Code(1)\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306e\u6982\u8981");
        DJ._print("\u30fb\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306f\u95a2\u6570\uff46\u306e\u30bf\u30a4\u30d7\u304c\u3001\n\u3000\u5b9a\u6570\u578b\u304b\u5747\u8861\u578b\u304b\u3092\u5224\u5b9a\u3059\u308b\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3067\u3059\u3002\n\u3000\u5b9a\u6570\u578b\u306f\u3001\u5165\u529b\u304c\u5909\u5316\u3057\u3066\u3082\u51fa\u529b\u306f\u5b9a\u307e\u3063\u305f\u4e00\u65b9\u306e\u307f\u3067\n\u3000\u5747\u8861\u578b\u306f\u3001\u5165\u529b\u304c\u5909\u5316\u3059\u308b\u3068\u3001\u51fa\u529b\u3082\u5909\u5316\u3057\u307e\u3059\u3002\uff09");
        DJ._print("\u30fb\u95a2\u6570\uff46\u306e\u5165\u529b\u306f\uff10\u304b\uff11\u306e\uff12\u901a\u308a\u3001\u51fa\u529b\u3082\uff10\u304b\uff11\u306e\uff12\u901a\u308a\u3067\n  \u305d\u306e\u7d44\u307f\u5408\u308f\u305b\u306f\uff14\u901a\u308a\u306b\u306a\u308a\u307e\u3059\u3002\n  \u95a2\u6570f0\uff1a\u5165\u529b\u304c\uff10\u3067\u3082\uff11\u3067\u3082\u51fa\u529b\u306f\uff10\u3001f1(0)=f1(1)=0\n  \u95a2\u6570f1\uff1a\u5165\u529b\u304c\uff10\u3067\u3082\uff11\u3067\u3082\u51fa\u529b\u306f\uff11\u3001f2(0)=f2(1)=1\n  \u95a2\u6570f2\uff1a\u5165\u529b\u304c\uff10\u306a\u3089\u51fa\u529b\u306f\uff10\u3001f3(0)=0\n          \u5165\u529b\u304c\uff11\u306a\u3089\u51fa\u529b\u306f\uff11\u3001f3(1)=1\n  \u95a2\u6570f3\uff1a\u5165\u529b\u304c\uff10\u306a\u3089\u51fa\u529b\u306f\uff11\u3001f4(0)=1\n          \u5165\u529b\u304c\uff11\u306a\u3089\u51fa\u529b\u306f\uff10\u3001f4(1)=0");
        DJ._print("\u30fb\u95a2\u6570f0\u3068\u95a2\u6570f1\u306f\u5165\u529b\u304c\u5909\u5316\u3057\u3066\u3082\u51fa\u529b\u306f\u5909\u308f\u3089\u306a\u3044\u306e\u3067\n  \u95a2\u6570\u306e\u578b\u306f\u5b9a\u6570\u578bConstant\u3067\u3059\u3002\n\u3000\u95a2\u6570f2\u3068\u95a2\u6570f3\u306f\u5165\u529b\u304c\u5909\u5316\u3059\u308b\u3068\u51fa\u529b\u3082\u5909\u308f\u308b\u306e\u3067\n  \u95a2\u6570\u306e\u578b\u306f\u5747\u8861\u578bBalanced\u3067\u3059\u3002");
        DJ.printS(1, "DeutschAlgorithm(2)", this);
        DJ.print("Code(2)\u30aa\u30e9\u30af\u30eb");
        DJ._print("\u30fb\u4e00\u822c\u306b\u95a2\u6570\uff46\u306f\u30d6\u30e9\u30c3\u30af\u30fb\u30dc\u30c3\u30af\u30b9\u3068\u3057\u3066\u6271\u308f\u308c\u3001\n  \u305d\u306e\u5b9f\u88c5\u306b\u3064\u3044\u3066\u306f\u554f\u3044\u307e\u305b\u3093\u3002\u3064\u307e\u308a\u5165\u529b\u3092\u4e0e\u3048\u308b\u3068\n  \u51fa\u529b\u3092\u8fd4\u3059\u4fbf\u5229\u306a\u95a2\u6570\uff46\u3068\u3057\u3066\u5c0e\u5165\u3055\u308c\u308b\u305f\u3081\u3001\n  \u30aa\u30e9\u30af\u30eboracle\uff08\u795e\u8a17\u3001\u795e\u8a17\u6a5f\u68b0\uff09\u3068\u547c\u3070\u308c\u307e\u3059\u3002");
        DJ._print("\u203b\u3053\u3053\u3067\u306f\u91cf\u5b50\u30b2\u30fc\u30c8\u30af\u30e9\u30b9QuGate\u306e\u30e1\u30bd\u30c3\u30c9\u3068\u3057\u3066\n  \u5b9f\u88c5\u3057\u307e\u3059\u304c\u3001\u672c\u6765\u306e\u91cf\u5b50\u30b2\u30fc\u30c8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        DJ._print("Code(2-1)\u95a2\u6570fi\u306e\u691c\u8a3c");
        int numOfFuncType = 4;
        for (int funcType = 0; funcType < numOfFuncType; ++funcType) {
            DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af", funcType);
            for (int i = 0; i < 2; ++i) {
                DJ.print_("  in = ", i);
                int out = QuGate.deutschFunction(funcType, i);
                DJ.print(" \u2192 out = ", out);
            }
        }
        DJ.printS(2, "DeutschAlgorithm(2-2)", this);
        DJ.print("Code(2-2)\u30aa\u30e9\u30af\u30eb\uff08\u7591\u4f3c\u7684\u306a\u91cf\u5b50\u30b2\u30fc\u30c8Uf\uff09\u306e\u691c\u8a3c");
        DJ._print("\u30fb\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306b\u5bfe\u5fdc\u3059\u308b\u7591\u4f3c\u7684\u306a\u91cf\u5b50\u30b2\u30fc\u30c8Uf\n  public QuBit deutschGate(int functionType, QuBit inputQuBit)\n  @param functionType int // \u95a2\u6570\u30bf\u30a4\u30d7 \n  @param inputQuBit QuBit // \u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff09 \n  @return outputQuBit QuBit // \u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff09");
        DJ._print("\u30fb\u30aa\u30e9\u30af\u30eb\uff08\u7591\u4f3c\u7684\u306a\u91cf\u5b50\u30b2\u30fc\u30c8Uf\uff09\u306e               \n  \u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8inQuBit\u3068\u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8outQuBit\u306b\u5bfe\u5fdc\u3059\u308b\n  \u53e4\u5178\u30d3\u30c3\u30c8\u3092\u305d\u308c\u305e\u308c\u5165\u529binputCB\u3068\u51fa\u529boutputCB\u3068\u3057\u307e\u3059\u3002\n                                                         \n  inQuBit[i]           \u250c\u2500\u2500\u2500\u2510   outQuBit             \n  \u7b2c\uff10\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8 \u2500\u2524Oracle\u251c\u2500 \u7b2c\uff10\u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8   \n    inputCB[i][0]      \u2502      \u2502     outputCB[i][0]     \n  \u7b2c\uff11\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8 \u2500\u2524  Uf  \u251c\u2500 \u7b2c\uff11\u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8   \n    inputCB[i][1]      \u2514\u2500\u2500\u2500\u2518     outputCB[i][1]     \n  \u30a4\u30f3\u30c7\u30c3\u30af\u30b9i = 0,1\u306f\u5165\u529b\u306e\uff12\u30d1\u30bf\u30fc\u30f3\u3092\u8868\u308f\u3057\u307e\u3059\u3002    ");
        DJ._print("\u30fb\u30aa\u30e9\u30af\u30eb\uff08\u7591\u4f3c\u7684\u306a\u91cf\u5b50\u30b2\u30fc\u30c8Uf\uff09\u306e               \n  \u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8inputCB\u3068\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8outputCB\u306e\u95a2\u4fc2    \n    outputCB[i][0] = inputCB[i][0]                       \n    outputCB[i][1] = inputCB[i][1] \u2295 fi(inputCB[i][0])   \n  \u6f14\u7b97\u5b50\u2295\uff1a\u6392\u4ed6\u7684\u8ad6\u7406\u548cEX-OR                             \n  \u5165\u529binputCB\u306f 00 \u3068 10 \u306e\uff12\u30d1\u30bf\u30fc\u30f3\uff08input0\u306e\u307f\u5909\u5316\uff09  \n  \u30b2\u30fc\u30c8Uf\u306e\u5165\u51fa\u529b\u7279\u6027                                   \n  \u95a2\u6570    :f0        :f1         :f2         :f3         \n  inputCB :  00  10  :  00   10  :  00   10  :  00   10  \n  outputCB:  00  10  :  01   11  :  00   11  :  01   10  ");
        DJ.printS(2, "DeutschAlgorithm(2-3)", this);
        DJ.print("Code(2-3)\u30aa\u30e9\u30af\u30eb\u3078\u306e\u5165\u529b\u3092\u751f\u6210");
        int numOfInputType = 2;
        int[][] inputCB = new int[2][2];
        QuBit e0 = new QuBit("std0QuBit");
        QuBit e1 = new QuBit("std1QuBit");
        QuBit[][] inputQB = new QuBit[2][2];
        QuBit[] inQuBit = new QuBit[2];
        QuBit[] e = new QuBit[]{e0, e1};
        for (int i = 0; i < numOfInputType; ++i) {
            inputCB[i][0] = i % 2;
            inputCB[i][1] = i / 2;
            DJ._print("\u5165\u529b\u30d1\u30bf\u30fc\u30f3:", i + ", \u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
            DJ.print("\u3000\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\uff12\u500b\u3067\u306e\u5165\u529b");
            inputQB[i][0] = e[inputCB[i][0]];
            inputQB[i][1] = e[inputCB[i][1]];
            DJ.print_("  inputQB0 ", inputQB[i][0], false);
            DJ.print(",  inputQB1 ", inputQB[i][1], false);
            DJ.print("\u3000\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff11\u500b\u3067\u306e\u5165\u529b");
            inQuBit[i] = inputQB[i][0].interactQuBit(inputQB[i][1]);
            DJ.print("  inQuBit ", inQuBit[i], false);
        }
        DJ.printS(2, "DeutschAlgorithm(2-4)", this);
        DJ.print("Code(2-4)\u30aa\u30e9\u30af\u30eb\u306b\u8cea\u554f\uff1a\uff14\u30bf\u30a4\u30d7 \u00d7 \uff12\u30d1\u30bf\u30fc\u30f3");
        int[] outputCB = new int[2];
        for (int funcType = 0; funcType < numOfFuncType; ++funcType) {
            DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af" + funcType);
            for (int i = 0; i < numOfInputType; ++i) {
                DJ._print("\u3000\u5165\u529b\u30d1\u30bf\u30fc\u30f3\uff1ainputType = ", i);
                DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3078\u306e\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff09\uff1a");
                DJ.print("  inQuBit ", inQuBit[i], false);
                QuBit outQuBit = QuGate.deutschGate(funcType, inQuBit[i]);
                DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff11\u500b\uff09");
                DJ.print("  outQuBit", outQuBit, false);
                DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u3068\u51fa\u529b\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059\u3002");
                DJ.print("\u3000\u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u306b\u5909\u63db\u3057\u307e\u3059\u3002");
                double[][] outTransProb = outQuBit.getTransProb();
                DJ.printF("outTransProb", outTransProb);
                outputCB[0] = outTransProb[0][0] == 1.0 ? 0 : 1;
                outputCB[1] = outTransProb[0][1] == 1.0 ? 0 : 1;
                DJ._print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
                DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + outputCB[0] + outputCB[1] + "");
            }
            if (funcType >= numOfFuncType - 1) continue;
            DJ.printS(1, "DeutschAlgorithm(2-4)", this);
        }
        this.stepMode = true;
        DJ.printS(3, "DeutschAlgorithm(3)", this);
        DJ.print("Code(3)\u30c9\u30a4\u30c1\u30e5\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306e\u91cf\u5b50\u56de\u8def");
        DJ._print("\u30fb\u91cf\u5b50\u56de\u8def\u306f\u91cf\u5b50\u30b2\u30fc\u30c8\u3068\u30aa\u30e9\u30af\u30ebOracle\u3067\u69cb\u6210\u3055\u308c\u308b\n                  \u250c-\u2510\u250c\u2500\u2500\u2500\u2510\u250c-\u2510\u250c-\u2510  \nQB0 = [1 0]'-\u2500-\u2500\u2524H\u251c\u2524Oracle\u251c\u2524H\u251c\u2524M\u251c  \n             \u250c-\u2510\u2502 \u2502\u2502      \u2502\u2502 \u2502\u2514-\u2518  \nQB1 = [1 0]'-\u2524X\u251c\u2524H\u251c\u2524  Uf  \u251c\u2524I\u251c\u2500\u2500-  \n             \u2514-\u2518\u2514-\u2518\u2514\u2500\u2500\u2500\u2518\u2514-\u2518       ");
        DJ.print("  \u95a2\u6570\uff46\u306b\u3088\u308b\u7591\u4f3c\u7684\u306a\u91cf\u5b50\u30b2\u30fc\u30c8Uf\u306f\u30aa\u30e9\u30af\u30eb\u3068\u547c\u3070\u308c\u307e\u3059\u3002");
        DJ._print("\u30fb\u3053\u306e\u91cf\u5b50\u56de\u8def\u306e\u51fa\u529b\u306e\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u304c\u3001\n\u3000[1 0]'\uff08\u53e4\u5178\u30d3\u30c3\u30c8\uff10\uff09\u306a\u3089\u3070\u95a2\u6570\u306f\u5b9a\u6570\u578bConstant\u3067\u3001\n\u3000[0 1]'\uff08\u53e4\u5178\u30d3\u30c3\u30c8\uff11\uff09\u306a\u3089\u3070\u95a2\u6570\u306f\u5747\u8861\u578bBalanced\u3067\u3059\u3002");
        DJ._print("\u30fb\u91cf\u5b50\u56de\u8def\u3078\u306e\u5165\u529b");
        DJ.print("  \uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8QB0\u3068QB1\u306e\u521d\u671f\u5024\u306f\u3069\u3061\u3089\u3082[1 0]'\u3067\u3059\u304c\u3001\n  QB1\u306fX\u30b2\u30fc\u30c8\u3067\u53cd\u8ee2\u3055\u308c\u3001[0 1]'\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.printS(1, "DeutschAlgorithm(3-1)", this);
        DJ.print("Code(3-1)\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u751f\u6210\u3068X\u30b2\u30fc\u30c8\u3067\u53cd\u8ee2");
        DJ._print("\u30fb\uff12\u500b\u306e\u6a19\u6e96\u91cf\u5b50\u30d3\u30c3\u30c8QB0\u3068QB1\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit qb0 = new QuBit();
        QuBit qb1 = new QuBit();
        DJ.printF("qb0", qb0);
        DJ.print("\u30fbX\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuGate xGate = new QuGate("X_GATE");
        DJ.printF("xGate", xGate);
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8QB1\u3092X\u30b2\u30fc\u30c8\u3067\u53cd\u8ee2\u3057\u307e\u3059\u3002");
        qb1.apply(xGate);
        DJ.printF("qb1", qb1);
        DJ.print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8QB0\u3068QB1\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u307e\u3059\u3002QB0 \u2297 QB1");
        QuBit qb0_1 = qb0.interactQuBit(qb1);
        DJ.printF("qb0_1", qb0_1);
        DJ.printS(1, "DeutschAlgorithm(3-2)", this);
        DJ._print("Code(3-2)H\u30b2\u30fc\u30c8\uff08Hadamard\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210");
        QuGate hGate = new QuGate("H_GATE");
        DJ.printF("hGate", hGate);
        DJ.print("\u3000H\u30b2\u30fc\u30c8\u540c\u58eb\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u307e\u3059\u3002H \u2297 H");
        QuGate h_hGate = hGate.interactQuGate(hGate);
        DJ.printF("h_hGate", h_hGate);
        DJ._print(" \u91cf\u5b50\u30d3\u30c3\u30c8QB0_1\u3092\u91cf\u5b50\u30b2\u30fc\u30c8H_H\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        QuBit inputQuBit = h_hGate.apply(qb0_1);
        DJ.printF("inputQuBit", inputQuBit);
        DJ.printS(2, "DeutschAlgorithm(3-3)", this);
        DJ._print("Code(3-3)H_I\u30b2\u30fc\u30c8\u3092\u6e96\u5099");
        DJ._print("\u30fbI\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ.print("\u30fbH\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001H_I\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuGate h_iGate = hGate.interactQuGate(iGate);
        DJ.printF("h_iGate", h_iGate);
        DJ.printS(2, "DeutschAlgorithm(3-4)", this);
        DJ._print("Code(3-4)\u4eee\u60f3\u30b2\u30fc\u30c8\u3092\u547c\u3073\u51fa\u3057\n  public QuBit deutschGate(int functionType, QuBit inputQuBit)\n  @param functionType int // \u95a2\u6570\u30bf\u30a4\u30d7 \n  @param inputQuBit QuBit // \u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff09 \n  @return outputQuBit QuBit // \u51fa\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff09");
        DJ._print("\u3000\u6e2c\u5b9a\u5f8c\u306e\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f\uff11\u304b\uff10\u306b\u306a\u308a\u307e\u3059\u3002\n  \u9077\u79fb\u78ba\u7387\u304c[1 0]'\u306a\u3089\u3070\u7b2c\uff10\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3057\u3001\n  \u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff10\u306b\u306a\u308a\u3001\u95a2\u6570\u306f\u5b9a\u6570\u578bConstant\u3067\u3059\u3002\n  \u9077\u79fb\u78ba\u7387\u304c[0 1]'\u306a\u3089\u3070\u7b2c\uff11\u57fa\u5e95\u8ef8\u306b\u9077\u79fb\u3057\u3001\n  \u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff11\u306b\u306a\u308a\u3001\u95a2\u6570\u306f\u5747\u8861\u578bBalanced\u3067\u3059\u3002");
        numOfFuncType = 4;
        for (int funcType = 0; funcType < numOfFuncType; ++funcType) {
            DJ._print("funcType", funcType);
            QuBit outQuBit = QuGate.deutschGate(funcType, inputQuBit);
            DJ._printF("outQuBit", outQuBit);
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3092\u901a\u904e\u3057\u305f\uff12\u91cf\u5b50\u30d3\u30c3\u30c8outQuBit\u3092\u3000H_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
            resultQB = h_iGate.apply(outQuBit);
            DJ.printF("resultQB", resultQB);
            DJ.print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306f\u3082\u3064\u308c\u3066\u304a\u3089\u305a\u3001\n\u3000\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5206\u96e2\u3067\u304d\u307e\u3059\u3002");
            DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
            resultTransProb = resultQB.getTransProb();
            DJ.printF("resultTransProb", resultTransProb);
            DJ.print("\u3000\u6e2c\u5b9a\u5f8c\u306e\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f\uff11\u304b\uff10\u306b\u306a\u308a\u307e\u3059\u3002");
            if (funcType >= numOfFuncType - 1) continue;
            DJ.printS(1, "DeutschAlgorithm(3-4)", this);
        }
        this.stepMode = true;
        DJ.printS(3, "DeutschAlgorithm(4)", this);
        DJ.print("Code(4)\u95a2\u6570\u5225\u30aa\u30e9\u30af\u30eb");
        DJ._print("Code(4-0)\u2460\u95a2\u6570f0\u306e\u30aa\u30e9\u30af\u30eb");
        DJ.print("  f0(0) = f0(1) = 0\uff1a\u5165\u529b\u304c\uff10\u3067\u3082\uff11\u3067\u3082\u51fa\u529b\u306f\uff10");
        DJ._print("\u30fb\u95a2\u6570f0\u306fI\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u306b\u3088\u308a\u69cb\u6210\u3055\u308c\u307e\u3059\u3002");
        DJ.print("  \u95a2\u6570f0\u306e\u30aa\u30e9\u30af\u30eb \n  \u250c-\u2510 \n  \u2524I\u251c \n  \u251c-\u2524 \n  \u2524I\u251c \n  \u2514-\u2518 ");
        DJ._print("  I \u2297 I = \n \u250c   \u2510 \u250c   \u2510 \u250c       \u2510  \u250c   \u2510  \n \u25021 0\u2502\u2297\u25021 0\u2502=\u25021 0 0 0\u2502= \u2502I O\u2502  \n \u25020 1\u2502 \u25020 1\u2502 \u25020 1 0 0\u2502  \u2502O I\u2502  \n \u2514   \u2518 \u2514   \u2518 \u25020 0 1 0\u2502  \u2514   \u2518  \n                 \u25020 0 0 1\u2502           \n                 \u2514       \u2518           ");
        QuGate oracleF0Gate = iGate.interactQuGate(iGate);
        DJ.printF("oracleF0Gate", oracleF0Gate);
        DJ.printS(1, "DeutschAlgorithm(4-0)\u2461", this);
        DJ.print("Code(4-0)\u2461\u95a2\u6570f0\u306e\u30aa\u30e9\u30af\u30eb\u3092\u691c\u8a3c");
        DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af0");
        DJ.print("  \u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u3068\u51fa\u529b\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059\u3002");
        for (int i = 0; i < numOfInputType; ++i) {
            DJ._print("\u3000\u5165\u529b\u30d1\u30bf\u30fc\u30f3\uff1ainputType = ", i);
            QuBit outQuBit = oracleF0Gate.apply(inQuBit[i]);
            double[][] outTransProb = outQuBit.getTransProb();
            outputCB[0] = outTransProb[0][0] == 1.0 ? 0 : 1;
            outputCB[1] = outTransProb[0][1] == 1.0 ? 0 : 1;
            DJ.print("  \u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
            DJ.print("  \u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + outputCB[0] + outputCB[1] + "");
        }
        DJ.printS(1, "DeutschAlgorithm(4-0)\u2462", this);
        DJ.print("Code(4-0)\u2462\u3000\u95a2\u6570f0\u306e\u30aa\u30e9\u30af\u30eb\u306b\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u9069\u7528");
        DJ.print("QuBit outF0QuBit = oracleF0Gate.apply(inQuBit);");
        QuBit outF0QuBit = oracleF0Gate.apply(inputQuBit);
        DJ.printF("outF0QuBit", outF0QuBit);
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3092\u901a\u904e\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092H_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        resultQB = h_iGate.apply(outF0QuBit);
        DJ.printF("resultQB", resultQB);
        DJ.printS(1, "DeutschAlgorithm(4-0)\u2463", this);
        DJ.print("Code(4-0)\u2463\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306e\u9077\u79fb\u78ba\u7387");
        DJ.print("       \u250c \u2510 \u250c \u2510   \u250c \u2510   \u250c \u2510    \n 1/\u221a2(\u25021\u2502-\u25020\u2502+ 0\u25020\u2502+ 0\u25020\u2502) = \n       \u25020\u2502 \u25021\u2502   \u25020\u2502   \u25020\u2502    \n       \u25020\u2502 \u25020\u2502   \u25021\u2502   \u25020\u2502    \n       \u25020\u2502 \u25020\u2502   \u25020\u2502   \u25021\u2502    \n       \u2514 \u2518 \u2514 \u2518   \u2514 \u2518   \u2514 \u2518    \n                                     \n       \u250c \u2510 \u250c \u2510          \u250c \u2510 \u250c \u2510   \n 1/\u221a2(\u25021\u2502\u2297\u25021\u2502) - 1/\u221a2(\u25021\u2502\u2297\u25020\u2502)  \n       \u25020\u2502 \u25020\u2502          \u25020\u2502 \u25021\u2502   \n       \u2514 \u2518 \u2514 \u2518          \u2514 \u2518 \u2514 \u2518   \n         \u2191    \u2191            \u2191    \u2191     \n         \u2502    \u7b2c\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u2502    \u7b2c\uff11\u91cf\u5b50\u30d3\u30c3\u30c8 \n         \u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8      \u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8       \n");
        resultTransProb = resultQB.getTransProb();
        DJ.printF("resultTransProb", resultTransProb);
        DJ.print("\u3000\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f[1 0]'\u306b\u306a\u308a,\n  \u6e2c\u5b9a\u306b\u3088\u308a\u5f97\u3089\u308c\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff10\u306a\u306e\u3067\u3001\n  \u95a2\u6570f0\u306f\u5b9a\u6570\u578bConstant\u3067\u3042\u308b\u3068\u5224\u5b9a\u3055\u308c\u307e\u3059\u3002");
        DJ.printS(2, "DeutschAlgorithm(4-1)\u2460", this);
        DJ._print("Code(4-1)\u2460\u95a2\u6570f1\u306e\u30aa\u30e9\u30af\u30eb");
        DJ.print("\u3000f1(0) = f1(1) = 1\u5165\u529b\u304c\uff10\u3067\u3082\uff11\u3067\u3082\u51fa\u529b\u306f\uff11");
        DJ._print("\u30fb\u95a2\u6570f1\u306fI\u30b2\u30fc\u30c8\u3068X\u30b2\u30fc\u30c8\u306b\u3088\u308a\u69cb\u6210\u3055\u308c\u307e\u3059\u3002");
        DJ._print("  \u95a2\u6570f1\u306e\u30aa\u30e9\u30af\u30eb \n  \u250c-\u2510 \n  \u2524I\u251c \n  \u251c-\u2524 \n  \u2524X\u251c \n  \u2514-\u2518 ");
        DJ._print("  I \u2297 X = \n \u250c   \u2510 \u250c   \u2510 \u250c       \u2510  \u250c   \u2510  \n \u25021 0\u2502\u2297\u25020 1\u2502=\u25020 1 0 0\u2502= \u2502X O\u2502  \n \u25020 1\u2502 \u25021 0\u2502 \u25021 0 0 0\u2502  \u2502O X\u2502  \n \u2514   \u2518 \u2514   \u2518 \u25020 0 0 1\u2502  \u2514   \u2518  \n                 \u25020 0 1 0\u2502           \n                 \u2514       \u2518           ");
        DJ.print("I \u2297 X");
        QuGate oracleF1Gate = iGate.interactQuGate(xGate);
        DJ.printF("oracleF1Gate", oracleF1Gate);
        DJ.printS(1, "DeutschAlgorithm(4-1)\u2461", this);
        DJ.print("Code(4-1)\u2461\u3000\u95a2\u6570f1\u306e\u30aa\u30e9\u30af\u30eb\u3092\u691c\u8a3c");
        DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af1");
        DJ.print("  \u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u3068\u51fa\u529b\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059\u3002");
        for (int i = 0; i < numOfInputType; ++i) {
            DJ._print("\u3000\u5165\u529b\u30d1\u30bf\u30fc\u30f3\uff1ainputType = ", i);
            QuBit outQuBit = oracleF1Gate.apply(inQuBit[i]);
            double[][] outTransProb = outQuBit.getTransProb();
            outputCB[0] = outTransProb[0][0] == 1.0 ? 0 : 1;
            outputCB[1] = outTransProb[0][1] == 1.0 ? 0 : 1;
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + outputCB[0] + outputCB[1] + "");
        }
        DJ.printS(1, "DeutschAlgorithm(4-1)\u2462", this);
        DJ.print("Code(4-1)\u2462\u3000\u95a2\u6570f1\u306e\u30aa\u30e9\u30af\u30eb\u306b\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u9069\u7528");
        DJ.print("QuBit outF1QuBit = oracleF1Gate.apply(inQuBit);");
        QuBit outF1QuBit = oracleF1Gate.apply(inputQuBit);
        DJ.printF("outF1QuBit", outF1QuBit);
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3092\u901a\u904e\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092H_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3059\u308b\u3002");
        resultQB = h_iGate.apply(outF1QuBit);
        DJ.printF("resultQB", resultQB);
        DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        resultTransProb = resultQB.getTransProb();
        DJ.printF("resultTransProb", resultTransProb);
        DJ.print("\u3000\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f[1 0]'\u306b\u306a\u308a,\n  \u6e2c\u5b9a\u306b\u3088\u308a\u5f97\u3089\u308c\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff10\u306a\u306e\u3067\u3001\n  \u95a2\u6570f1\u306f\u5b9a\u6570\u578bConstant\u3067\u3042\u308b\u3068\u5224\u5b9a\u3055\u308c\u307e\u3059\u3002");
        DJ.printS(2, "DeutschAlgorithm(4-2)\u2460", this);
        DJ._print("Code(4-2)\u2460\u95a2\u6570f2\u306e\u30aa\u30e9\u30af\u30eb");
        DJ.print("  f2(0) = 0, f2(1) = 1\n  \u5165\u529b\u304c\uff10\u306a\u3089\u51fa\u529b\u306f\uff10\u3001\u5165\u529b\u304c\uff11\u306a\u3089\u51fa\u529b\u306f\uff11");
        DJ._print("\u30fb\u95a2\u6570f2\u306fCX\u30b2\u30fc\u30c8(control-not\u30b2\u30fc\u30c8)\u306b\u3088\u308a\u69cb\u6210\u3055\u308c\u307e\u3059\u3002");
        DJ._print("  \u95a2\u6570f2\u306e\u30aa\u30e9\u30af\u30eb \n  \u250c-\u2510 \n  \u2524C\u251c \n  \u2502|\u2502 \n  \u2524X\u251c \n  \u2514-\u2518 ");
        DJ._print(" \uff23\uff38\u30b2\u30fc\u30c8 = \n \u250c       \u2510  \u250c   \u2510  \n \u25021 0 0 0\u2502= \u2502I O\u2502  \n \u25020 1 0 0\u2502  \u2502O X\u2502  \n \u25020 0 0 1\u2502  \u2514   \u2518  \n \u25020 0 1 0\u2502           \n \u2514       \u2518           ");
        int _numOfBits = 2;
        int _target = 1;
        int[] _controlArray = new int[]{0};
        QuGate cxGate = new QuGate("CX_GATE", _numOfBits, _target, _controlArray);
        QuGate oracleF2Gate = new QuGate(_numOfBits);
        oracleF2Gate.setGateMat(cxGate.copyGateMat());
        DJ.printF("oracleF2Gate", oracleF2Gate);
        DJ.printS(1, "DeutschAlgorithm(4-2)\u2461", this);
        DJ.print("Code(4-2)\u2461\u95a2\u6570f2\u306e\u30aa\u30e9\u30af\u30eb\u3092\u691c\u8a3c");
        DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af2");
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u3068\u51fa\u529b\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059\u3002");
        for (int i = 0; i < numOfInputType; ++i) {
            DJ._print("\u3000\u5165\u529b\u30d1\u30bf\u30fc\u30f3\uff1ainputType = ", i);
            QuBit outQuBit = oracleF2Gate.apply(inQuBit[i]);
            double[][] outTransProb = outQuBit.getTransProb();
            outputCB[0] = outTransProb[0][0] == 1.0 ? 0 : 1;
            outputCB[1] = outTransProb[0][1] == 1.0 ? 0 : 1;
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + outputCB[0] + outputCB[1] + "");
        }
        DJ.printS(1, "DeutschAlgorithm(4-2)\u2462", this);
        DJ.print("Code(4-2)\u2462\u95a2\u6570f2\u306e\u30aa\u30e9\u30af\u30eb\u306b\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u9069\u7528");
        DJ.print("QuBit outF2QuBit = oracleF2Gate.apply(inQuBit);");
        QuBit outF2QuBit = oracleF2Gate.apply(inputQuBit);
        DJ.printF("outF2QuBit", outF2QuBit);
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3092\u901a\u904e\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092H_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        resultQB = h_iGate.apply(outF2QuBit);
        DJ.printF("resultQB", resultQB);
        DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        resultTransProb = resultQB.getTransProb();
        DJ.printF("resultTransProb", resultTransProb);
        DJ.print("\u3000\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f[0 1]'\u306b\u306a\u308a,\n  \u6e2c\u5b9a\u306b\u3088\u308a\u5f97\u3089\u308c\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff11\u306a\u306e\u3067\u3001\n  \u95a2\u6570f2\u306f\u5747\u8861\u578bBalanced\u3067\u3042\u308b\u3068\u5224\u5b9a\u3055\u308c\u307e\u3059\u3002");
        DJ.printS(2, "DeutschAlgorithm(4-3)\u2460", this);
        DJ._print("Code(4-3)\u2460\u95a2\u6570f3\u306e\u30aa\u30e9\u30af\u30eb\n  f3(0) = 1, f3(1) = 0");
        DJ.print("\u3000\u5165\u529b\u304c\uff10\u306a\u3089\u51fa\u529b\u306f\uff11\u3001\u5165\u529b\u304c\uff11\u306a\u3089\u51fa\u529b\u306f\uff10");
        DJ._print("\u30fb\u95a2\u6570f3\u306f\u4ee5\u4e0b\u306b\u793a\u3059XI_CX_XI\u30b2\u30fc\u30c8\u306b\u3088\u308a\u69cb\u6210\u3055\u308c\u307e\u3059\u3002");
        DJ._print("  \u95a2\u6570f3\u306e\u30aa\u30e9\u30af\u30eb\uff1aXI_CX_XI\u30b2\u30fc\u30c8 \n  \u250c\u2500-\u2500\u2510 \n  \u2524X C X\u251c \n  \u251c\u2500|\u2500\u2524 \n  \u2524I X I\u251c \n  \u2514\u2500-\u2500\u2518 ");
        DJ.printS(1, "DeutschAlgorithm(4-3)\u2461", this);
        DJ.print("Code(4-3)\u2461X\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u306b\u3088\u308a\u69cb\u6210\u3055\u308c\u308bX_I\u30b2\u30fc\u30c8");
        DJ._print("XI\u30b2\u30fc\u30c8 \n \u250c-\u2510 \n \u2502X\u2502 \n \u251c-\u2524 \n \u2502I\u2502 \n \u2514-\u2518 ");
        DJ._print("  X \u2297 I = \n \u250c   \u2510 \u250c   \u2510 \u250c       \u2510  \u250c   \u2510  \n \u25020 1\u2502\u2297\u25021 0\u2502=\u25020 0 1 0\u2502= \u2502O I\u2502  \n \u25021 0\u2502 \u25020 1\u2502 \u25020 0 0 1\u2502  \u2502I O\u2502  \n \u2514   \u2518 \u2514   \u2518 \u25021 0 0 0\u2502  \u2514   \u2518  \n                 \u25020 1 0 0\u2502           \n                 \u2514       \u2518           ");
        DJ.print("X \u2297 I");
        QuGate xiGate = xGate.interactQuGate(iGate);
        DJ.printF("xiGate", xiGate);
        DJ.printS(1, "DeutschAlgorithm(4-3)\u2462", this);
        DJ._print("Code(4-3)\u2462XI_CX\u30b2\u30fc\u30c8\n \u250c       \u2510  \u250c   \u2510  \n \u25021 0 0 0\u2502= \u2502I O\u2502  \n \u25020 1 0 0\u2502  \u2502O X\u2502  \n \u25020 0 0 1\u2502  \u2514   \u2518  \n \u25020 0 1 0\u2502           \n \u2514       \u2518           ");
        DJ.printF("cxGate", cxGate);
        DJ._print("\u3000\uff23\uff38\u30b2\u30fc\u30c8\u3068X_I\u30b2\u30fc\u30c8\u306e\u5185\u7a4d\u306b\u3088\u308aXI_CX\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3059\u308b\u3002");
        DJ._print("  XI\u30fbCX = \n \u250c       \u2510' \u250c       \u2510 \u250c       \u2510  \u250c   \u2510  \n \u25020 0 1 0\u2502\u30fb\u25021 0 0 0\u2502=\u25020 0 0 1\u2502= \u2502O X\u2502  \n \u25020 0 0 1\u2502  \u25020 1 0 0\u2502 \u25020 0 1 0\u2502  \u2502I O\u2502  \n \u25021 0 0 0\u2502  \u25020 0 0 1\u2502 \u25021 0 0 0\u2502  \u2514   \u2518  \n \u25020 1 0 0\u2502  \u25020 0 1 0\u2502 \u25020 1 0 0\u2502           \n \u2514       \u2518  \u2514       \u2518 \u2514       \u2518           ");
        QuGate cx_xiGate = cxGate.innerProduct(xiGate);
        DJ.printF("cx_xiGate", cx_xiGate);
        DJ.printS(1, "DeutschAlgorithm(4-3)\u2463", this);
        DJ._print("Code(4-3)\u2463XI_CX\u30b2\u30fc\u30c8\u3068X_I\u30b2\u30fc\u30c8\u306e\u5185\u7a4d\u306b\u3088\u308a\n  XI_CX_XI\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        DJ._print("  XI_CX\u30fbXI  = \n \u250c       \u2510' \u250c       \u2510 \u250c       \u2510  \u250c   \u2510  \n \u25020 0 0 1\u2502\u30fb\u25020 0 1 0\u2502=\u25021 0 0 0\u2502= \u2502I O\u2502  \n \u25020 0 1 0\u2502  \u25020 0 0 1\u2502 \u25020 1 0 0\u2502  \u2502O X\u2502  \n \u25021 0 0 0\u2502  \u25021 0 0 0\u2502 \u25020 0 0 1\u2502  \u2514   \u2518  \n \u25020 1 0 0\u2502  \u25020 1 0 0\u2502 \u25020 0 1 0\u2502           \n \u2514       \u2518  \u2514       \u2518 \u2514       \u2518           ");
        DJ._print("\u3000\u3088\u3063\u3066\u30aa\u30e9\u30af\u30eb\u306f\u3001");
        QuGate oracleF3Gate = xiGate.innerProduct(cx_xiGate);
        DJ.printF("oracleF3Gate", oracleF3Gate);
        DJ.printS(1, "DeutschAlgorithm(4-3)\u2464", this);
        DJ.print("Code(4-3)\u2464\u95a2\u6570f3\u306e\u30aa\u30e9\u30af\u30eb\u3092\u691c\u8a3c");
        DJ._print("\u30fb\u95a2\u6570\u30bf\u30a4\u30d7\uff1af3");
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u3068\u51fa\u529b\u3092\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u8868\u793a\u3057\u307e\u3059\u3002");
        for (int i = 0; i < numOfInputType; ++i) {
            DJ._print("\u3000\u5165\u529b\u30d1\u30bf\u30fc\u30f3\uff1ainputType = ", i);
            QuBit outQuBit = oracleF3Gate.apply(inQuBit[i]);
            double[][] outTransProb = outQuBit.getTransProb();
            outputCB[0] = outTransProb[0][0] == 1.0 ? 0 : 1;
            outputCB[1] = outTransProb[0][1] == 1.0 ? 0 : 1;
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u5165\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + inputCB[i][0] + inputCB[i][1] + "");
            DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u306e\u51fa\u529b\u53e4\u5178\u30d3\u30c3\u30c8\uff08\uff12\u9032\u6570\uff09" + outputCB[0] + outputCB[1] + "");
        }
        DJ.printS(1, "DeutschAlgorithm(4-3)\u2465", this);
        DJ.print("Code(4-3)\u2465\u95a2\u6570f3\u306e\u30aa\u30e9\u30af\u30eb\u306b\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u9069\u7528");
        DJ.print("QuBit outF3QuBit = oracleF3Gate.apply(inQuBit);");
        QuBit outF3QuBit = oracleF3Gate.apply(inputQuBit);
        DJ._print("  oracleF3Gate\u2020 \u30fb inQuBit= \n \u250c       \u2510'     \u250c  \u2510     \u250c  \u2510  \n \u25020 1 0 0\u2502 \u30fb1/2\u2502 1\u2502= 1/2\u2502-1\u2502  \n \u25021 0 0 0\u2502      \u2502-1\u2502     \u2502 1\u2502  \n \u25020 0 1 0\u2502      \u2502 1\u2502     \u2502 1\u2502  \n \u25020 0 0 1\u2502      \u2502-1\u2502     \u2502-1\u2502  \n \u2514       \u2518      \u2514  \u2518     \u2514  \u2518  ");
        DJ.printF("outF3QuBit", outF3QuBit);
        DJ.print("\u30fb\u30aa\u30e9\u30af\u30eb\u3092\u901a\u904e\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092H_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        resultQB = h_iGate.apply(outF3QuBit);
        DJ.printF("resultQB", resultQB);
        DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8resultQB\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        resultTransProb = resultQB.getTransProb();
        DJ.printF("resultTransProb", resultTransProb);
        DJ.print("\u3000\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u9077\u79fb\u78ba\u7387\u306f[0 1]'\u306b\u306a\u308a,\n  \u6e2c\u5b9a\u306b\u3088\u308a\u5f97\u3089\u308c\u308b\u53e4\u5178\u30d3\u30c3\u30c8\u306f\uff11\u3067\u3059\u306e\u3067\u3001\n  \u95a2\u6570f3\u306f\u5747\u8861\u578bBalanced\u3067\u3042\u308b\u3068\u5224\u5b9a\u3055\u308c\u307e\u3059\u3002");
        DJ.printS(2, "DeutschAlgorithm(X)", this);
        DJ._print("\u91cf\u5b50\u8a08\u7b97\u306e\u5b8c\u4e86");
        DJ.print("DeutschAlgorithm.deutschAlgorithm() ===========================");
    }
}

