/*
 * Decompiled with CFR 0.152.
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.Complex;

public class HadamardTest
extends Task {
    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.stepMode = true;
        this.hadamardTest();
    }

    public void hadamardTest() {
        DJ._print("HadamardTest.hadamardTest() ========================");
        DJ.print("(1)\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30c6\u30b9\u30c8 Hadamard test");
        DJ.print("(2)\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306e\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u3068\u56fa\u6709\u5024");
        DJ.print("(3)\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306bZ\u30b2\u30fc\u30c8\u3092\u4f7f\u7528");
        DJ.print("(4)\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306bX\u30b2\u30fc\u30c8\u3092\u4f7f\u7528");
        DJ.print("(5)\u975e\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u5834\u5408");
        DJ.printS(2, "HadamardTest(1)", this);
        DJ._print("Code(1)\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30c6\u30b9\u30c8 Hadamard test");
        DJ.print("\u30fb\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u3092\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u4f5c\u7528\u3055\u305b\u3001\n\u3000\u56fa\u6709\u5024\u3084\u671f\u5f85\u5024\u3092\u63a8\u5b9a\u3059\u308b\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u3067\u3059\u3002");
        DJ._print("\u30fb\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30c6\u30b9\u30c8\u306e\u91cf\u5b50\u56de\u8def\n\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8 \u250c-\u2510  \u250c-\u2510  \u250c-\u2510  \u250c-\u2510 \nqb0 = [1 0]' \u2500\u2524H\u251c\u2500\u2524C\u251c\u2500\u2524H\u251c\u2500\u2524M\u2502 \n\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8 \u251c-\u2524  \u251c|\u2524  \u251c-\u2524  \u2514-\u2518 \nqb1 = f  \u2500\u2500\u2500\u2524I\u251c\u2500\u2524U\u251c\u2500\u2524I\u251c\u2500\u2500    \n               \u2514-\u2518  \u2514-\u2518  \u2514-\u2518        \n\u5168\u91cf\u5b50\u72b6\u614b  qbf0   qbf1   qbf2   qbf3     ");
        DJ._print("\u30fb\u5165\u529b\u72b6\u614bf\u304c\u30e6\u30cb\u30bf\u30ea\u884c\u5217U\u306e\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u3068\u304d\u306f\u3001\n\u3000\u5bfe\u5fdc\u3059\u308b\u56fa\u6709\u5024v=exp(2\u03c0i\u03b8)\u304c\u63a8\u5b9a\u3067\u304d\u307e\u3059\u3002");
        DJ.printS(1, "HadamardTest(1-1)", this);
        DJ._print("Code(1-1)\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u6a19\u6e96\u91cf\u5b50\u30d3\u30c3\u30c8e0QB\u3092\u751f\u6210");
        QuBit e0QB = new QuBit("std0QuBit");
        DJ.printF("e0QB", e0QB);
        DJ.print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u306b\u6a19\u6e96\u91cf\u5b50\u30d3\u30c3\u30c8e0QB\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002");
        QuBit qb0 = new QuBit(e0QB);
        DJ.printF("qb0", qb0);
        DJ.printS(1, "HadamardTest(1-2)", this);
        DJ.print("Code(1-2)I\u30b2\u30fc\u30c8\uff08\u6052\u7b49\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ.print("Code(1-3)H\u30b2\u30fc\u30c8\uff08Hadamard\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210\n          \u250c      \u2510 \n H = 1/\u221a2\u2502 1   1\u2502 \n          \u2502 1  -1\u2502 \n          \u2514      \u2518 ");
        QuGate hQuGate = new QuGate("H_GATE");
        DJ.printF("hQuGate", hQuGate);
        DJ.printS(1, "HadamardTest(1-4)", this);
        DJ._print("Code(1-4)HI\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        DJ._print("\u30fbH\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("HI\u30b2\u30fc\u30c8:H\u2297I \n            \u250c     \u2510 \n H\u2297I = 1/\u221a2\u2502 I  I\u2502 \n            \u2502 I -I\u2502 \n            \u2514     \u2518 ");
        QuGate hiQuGate = hQuGate.interactQuGate(iGate);
        DJ.printF("hiQuGate", hiQuGate);
        this.stepMode = true;
        DJ.printS(1, "HadamardTest(2)", this);
        DJ._print("Code(2)\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306e\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb");
        DJ._print("Code(2-1)Z\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        QuGate zQuGate = new QuGate("Z_GATE");
        DJ.printF(",  zQuGate = r0Gate", zQuGate);
        DJ._print("\u30fbR0\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        DJ.print("  Z\u30b2\u30fc\u30c8\u306f\u4f4d\u76f8\u56de\u8ee2\u30b2\u30fc\u30c8R0(Rk,k=0)\u3068\u540c\u3058\u3067\u3059\u3002");
        DJ.print("     \u250c                      \u2510 \n Rk =\u2502 1   0                \u2502 \n     \u2502 0   exp(i2\u03c0/2^(k+1))\u2502 \n     \u2514                      \u2518 ");
        int k = 0;
        DJ.print_("k = ", k);
        QuGate r0QuGate = new QuGate("RK_GATE", k);
        DJ.printF(",  r0QuGate", r0QuGate);
        DJ.printS(1, "HadamardTest(2-2)", this);
        DJ._print("Code(2-2)Z\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb");
        DJ.print("  Z\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024\u306fv0=+1\u3068v1=-1\u3067\n\u3001  \u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306ff0=[1 0]'\u3068f1=[0 1]'\u3067\u3059\u3002Zf = vf");
        DJ._print("\u30fbZ\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u30d9\u30af\u30c8\u30ebf0=[1 0]'\u3092\u9069\u7528\u3057\u307e\u3059\u3002\n  z\u30fbf = +1\u30fbe0 = +1[1 0]'");
        QuBit z_e0QB = zQuGate.apply(e0QB);
        DJ.printF("z_e0QB", z_e0QB);
        DJ.print("\u30fb\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u95a2\u4fc2\u3092\u6e80\u305f\u3057\u3066\u3044\u307e\u3059\u3002");
        DJ._print("\u30fbZ\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u30d9\u30af\u30c8\u30ebf1=[0 1]'\u3092\u9069\u7528\u3057\u307e\u3059\u3002\n  z\u30fbf = -1\u30fbe1 = -1[0 1]'");
        QuBit e1QB = new QuBit("std1QuBit");
        QuBit z_e10QB = zQuGate.apply(e1QB);
        DJ.printF("z_e10QB", z_e10QB);
        DJ.print("\u30fb\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u95a2\u4fc2\u3092\u6e80\u305f\u3057\u3066\u3044\u307e\u3059\u3002");
        this.stepMode = true;
        DJ.printS(2, "HadamardTest(3)", this);
        DJ._print("Code(3)\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306bZ\u30b2\u30fc\u30c8\u3092\u4f7f\u7528");
        DJ._print("Code(3-1)\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u56fa\u6709\u5024\u3092\u8a2d\u5b9a");
        DJ.print("\u30fbZ\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024[1 0]\u3092\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8f\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002");
        QuBit f = new QuBit(e0QB);
        DJ.printF("f", f);
        DJ._print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3068\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8f\u3092\n  \u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u3057\u307e\u3059\u3002");
        QuBit qbf0 = qb0.interactQuBit(f);
        DJ.printF("qbf0", qbf0);
        DJ.printS(1, "HadamardTest(3-2)", this);
        DJ._print("Code(3-2)\u521d\u671f\u91cf\u5b50\u72b6\u614b\u306bHI\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        DJ.print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf1\u3092\u6c42\u3081\u307e\u3059\u3002");
        QuBit qbf1 = hiQuGate.apply(qbf0);
        DJ.printF("qbf1", qbf1);
        DJ.printS(1, "HadamardTest(3-3)", this);
        DJ._print("Code(3-3)\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebZ\u30b2\u30fc\u30c8\uff08C-Rk\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210");
        DJ.print("\u30fbC-Rk\u30b2\u30fc\u30c8\u306e\u751f\u6210\u3067\u306f\u3001\u91cf\u5b50\u30d3\u30c3\u30c8\u6570\u3001\n  \u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217\u3001\n  \u304a\u3088\u3073\u4f4d\u76f8\u30d1\u30e9\u30e1\u30fc\u30bfk=0\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        int numOfBits = 2;
        int target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray = new int[]{0};
        k = 0;
        DJ.print(", controlArray", controlArray);
        DJ.print("QuGate cU0Gate = QuGate.makeCUkQuGate(numOfBits, target, controlArray, k);");
        QuGate cR0Gate = QuGate.makeCRkQuGate(numOfBits, target, controlArray, k);
        DJ.printF("cR0Gate", cR0Gate);
        DJ.printS(1, "HadamardTest(3-4)", this);
        DJ._print("Code(3-4)\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebZ\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        DJ.print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf1\u306b\u91cf\u5b50\u30b2\u30fc\u30c8cR0Gate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u3092\u6c42\u3081\u307e\u3059\u3002");
        QuBit qbf2 = cR0Gate.apply(qbf1);
        DJ.printF("qbf2", qbf2);
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u3092\u6c42\u3081\u307e\u3059\u3002");
        QuBit qbf3 = hiQuGate.apply(qbf2);
        DJ.printF("qbf3", qbf3);
        DJ._print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8\u306f[1 0]'\u306b\u306a\u308a\u3001\n\u3000\u56fa\u6709\u30d9\u30af\u30c8\u30ebf=[1 0]'\u304c\u5f97\u3089\u308c\u307e\u3059\u3002\n  \u91cf\u5b50\u72b6\u614bf\u306f[1 0]'\u3067\u5909\u5316\u3057\u307e\u305b\u3093\u3002");
        DJ.printS(1, "HadamardTest(3-5)", this);
        DJ._print("Code(3-5)\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u306e\u6e2c\u5b9a");
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        double[][] result = qbf3.getTransProb();
        DJ.printF("result", result);
        DJ._print("\u30fb\u9077\u79fb\u78ba\u7387P0, P1\u306f\u5404\u3005\u306e\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u3067\u3059\u3002\n  P0 = 1^2 = 1   P1 = 0^2 = 0 ");
        DJ._print("\u30fb\u78ba\u7387p0=(1+cos\u03bb)/2\u3001p0=1\u3088\u308a\u3001cos\u03bb=2p0-1=1\u3001 \u2234  \u03bb=0, 2\u03c0\u3068\u306a\u308a\u3001\n\u3000\u56fa\u6709\u5024exp(i\u03bb)=+1\u304c\u5c0e\u304b\u308c\u307e\u3059\u3002 ");
        DJ._print("\u30fb\u78ba\u7387p1=(1-cos\u03bb)/2\u3001p1=0\u3088\u308a\u3001cos\u03bb=-2p1+1=1\u3001 \u2234  \u03bb=0, 2\u03c0\u3068\u306a\u308a\u3001\n\u3000\u56fa\u6709\u5024exp(i\u03bb)=1\u304c\u5c0e\u304b\u308c\u307e\u3059\u3002 ");
        DJ._print("\u30fb\u78ba\u7387P0\u3068\u78ba\u7387P1\u306f\u3001\u305d\u308c\u305e\u308c\u6b21\u5f0f\u3067\u4e0e\u3048\u3089\u308c\u307e\u3059\u3002\n  P0 = 1/2(1 + Re(f~Uf) = 1   \u2234\u3000\u671f\u5f85\u5024f~Uf = 2 P0 - 1 = 1  P1 = 1/2(1 - Re(f~Uf) = 0 \n  \u2234\u3000\u671f\u5f85\u5024f~Uf = -2 P1 + 1 = 1 \n  \u8a18\u53f7~\u306f\u5171\u5f79\u8ee2\u7f6e\u3092\u610f\u5473\u3059\u308b\u3002");
        DJ._print("\u30fb\u56fa\u6709\u5024v=-1\u3001\u56fa\u6709\u30d9\u30af\u30c8\u30ebf=[0 1]'\u306e\u5834\u5408\u306f\u3001\n  P0=0, P1=1 \u3067\u3001\u671f\u5f85\u5024f~Uf=-1 \u306b\u306a\u308a\u307e\u3059\u3002");
        this.stepMode = true;
        DJ.printS(2, "HadamardTest(4)", this);
        DJ._print("Code(4)\u5bfe\u8c61\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306bX\u30b2\u30fc\u30c8\u3092\u4f7f\u7528");
        DJ._print("\u30fb\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30c6\u30b9\u30c8\u306e\u91cf\u5b50\u56de\u8def\n\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8 \u250c-\u2510  \u250c-\u2510  \u250c-\u2510  \u250c-\u2510 \nqb0 = [1 0]' \u2500\u2524H\u251c\u2500\u2524C\u251c\u2500\u2524H\u251c\u2500\u2524M\u2502 \n\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8 \u251c-\u2524  \u251c|\u2524  \u251c-\u2524  \u2514-\u2518 \nqb1 = f  \u2500\u2500\u2500\u2524I\u251c\u2500\u2524X\u251c\u2500\u2524I\u251c\u2500\u2500    \n               \u2514-\u2518  \u2514-\u2518  \u2514-\u2518        \n\u5168\u91cf\u5b50\u72b6\u614b  qbf0   qbf1   qbf2   qbf3     ");
        DJ._print("Code(4-1)X\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        QuGate xQuGate = new QuGate("X_GATE");
        DJ.printF("xQuGate", xQuGate);
        DJ.printS(1, "HadamardTest(4-2)", this);
        DJ._print("Code(4-2)X\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb");
        DJ.print("  X\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024v\u306f+1\u3068-1\u3067\u3001\u56fa\u6709\u30d9\u30af\u30c8\u30ebf\u306f  (1/\u221a(2))[1 1]'\u3068(1/\u221a(2))[1 -1]'\u3067\u3059\u3002\n  X f = v f");
        DJ._print("\u30fb\u56fa\u6709\u30d9\u30af\u30c8\u30ebf0\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit f0 = hQuGate.apply(e0QB);
        DJ.printF("f0", f0);
        DJ._print("\u30fbX\u30b2\u30fc\u30c8\u306b\u56fa\u6709\u30d9\u30af\u30c8\u30ebf0\u3092\u9069\u7528\u3057\u307e\u3059\u3002\n  x f0 = +1 f0 = (1/\u221a(2)([1 0]'+[0 1]')");
        QuBit x_f0QB = xQuGate.apply(f0);
        DJ.printF("x_f0QB", x_f0QB);
        DJ.print("\u30fb\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u95a2\u4fc2\u3092\u6e80\u305f\u3057\u3066\u3044\u307e\u3059\u3002");
        DJ.printS(1, "HadamardTest(4-3)", this);
        DJ._print("Code(4-3)X\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb");
        DJ._print("\u30fb\u56fa\u6709\u30d9\u30af\u30c8\u30ebf1=(1/\u221a(2))[1 -1]'\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit f1 = new QuBit(f0);
        int pa1Id = 1;
        Complex pa1 = f1.copyProbAmp(pa1Id);
        pa1.mul(-1.0);
        f1.setProbAmp(pa1Id, pa1);
        DJ.printF("f1", f1);
        DJ._print("\u30fbX\u30b2\u30fc\u30c8\u306b\u56fa\u6709\u30d9\u30af\u30c8\u30ebf1\u3092\u9069\u7528\u3057\u307e\u3059\u3002\n  x f1 = -(1/\u221a(2)([1 0]'-[0 1]' = -1 f1)");
        QuBit x_f1QB = xQuGate.apply(f1);
        DJ.printF("x_f1QB", x_f1QB);
        DJ.print("\u30fb\u56fa\u6709\u5024\u3068\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u95a2\u4fc2\u3092\u6e80\u305f\u3057\u3066\u3044\u307e\u3059\u3002");
        DJ.printS(1, "HadamardTest(4-4)", this);
        DJ.print("Code(4-4)\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u56fa\u6709\u5024\u3092\u8a2d\u5b9a");
        DJ._print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3068X\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024f0\u3092\n  \u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u3057\u307e\u3059\u3002");
        qbf0 = qb0.interactQuBit(f0);
        DJ.printF("qbf0", qbf0);
        DJ._print("Code(4-5)\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614b\u306bH\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf1\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf1 = hiQuGate.apply(qbf0);
        DJ.printF("qbf1", qbf1);
        DJ.printS(1, "HadamardTest(4-6)", this);
        DJ._print("Code(4-6)\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebX\u30b2\u30fc\u30c8\uff08C-X\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210");
        DJ.print("  C-X\u30b2\u30fc\u30c8\u306e\u751f\u6210\u3067\u306f\u3001\u91cf\u5b50\u30b2\u30fc\u30c8\u540d\u3001\u91cf\u5b50\u30d3\u30c3\u30c8\u6570\u3001\n\u3000\u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        numOfBits = 2;
        target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        controlArray = new int[]{0};
        DJ.print(", controlArray", controlArray);
        DJ.print("QuGate cU0Gate = new QuGate(numOfBits, target, controlArray);");
        QuGate cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.printF("cxGate", cxGate);
        DJ.printS(1, "HadamardTest(4-7)", this);
        DJ._print("Code(4-7)\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebX\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        DJ.print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf1\u306b\u91cf\u5b50\u30b2\u30fc\u30c8cx0Gate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf2 = cxGate.apply(qbf1);
        DJ.printF("qbf2", qbf2);
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf3 = hiQuGate.apply(qbf2);
        DJ.printF("qbf3", qbf3);
        DJ._print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8\u306f[1 0]'\u306b\u306a\u308a\u3001\n\u3000\u56fa\u6709\u30d9\u30af\u30c8\u30ebf=[1 0]'\u304c\u5f97\u3089\u308c\u307e\u3059\u3002\n  \u91cf\u5b50\u72b6\u614bf\u306f(1/\u221a(2))[1 1]'\u3067\u5909\u5316\u3057\u307e\u305b\u3093\u3002");
        DJ.printS(1, "HadamardTest(4-8)", this);
        DJ._print("Code(4-8)\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u306e\u6e2c\u5b9a");
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        result = qbf3.getTransProb();
        DJ.printF("result", result);
        DJ._print("\u30fb\u9077\u79fb\u78ba\u7387P0, P1\u306f\u5404\u3005\u306e\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u3067\u3059\u3002\n  P0 = 1^2 = 1   P1 = 0^2 = 0 ");
        DJ._print("\u30fb\u78ba\u7387P0\u3068\u78ba\u7387P1\u306f\u3001\u305d\u308c\u305e\u308c\u6b21\u5f0f\u3067\u4e0e\u3048\u3089\u308c\u307e\u3059\u3002\n  P0 = 1/2(1 + Re(f~Uf)=1 \u2234\u3000\u671f\u5f85\u5024f~Uf=1 \n  P1 = 1/2(1 - Re(f~Uf)=0 \u2234\u3000\u671f\u5f85\u5024f~Uf=1 \n  \u8a18\u53f7~\u306f\u5171\u5f79\u8ee2\u7f6e\u3092\u610f\u5473\u3057\u307e\u3059\u3002");
        DJ.printS(2, "HadamardTest(4-9)", this);
        DJ.print("Code(4-9)X\u30b2\u30fc\u30c8\u3067\u56fa\u6709\u5024f1\u306e\u5834\u5408");
        DJ.print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u3068X\u30b2\u30fc\u30c8\u306e\u56fa\u6709\u5024f1\u3092\n  \u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u3057\u307e\u3059\u3002");
        qbf0 = qb0.interactQuBit(f1);
        DJ.printF("qbf0", qbf0);
        DJ._print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf1\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf1 = hiQuGate.apply(qbf0);
        DJ.printF("qbf1", qbf1);
        DJ.print("\u30fb\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf1\u306b\u91cf\u5b50\u30b2\u30fc\u30c8cx0Gate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf2 = cxGate.apply(qbf1);
        DJ.printF("qbf2", qbf2);
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf2\u306b\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u3092\u9069\u7528\u3057\u3001\n  \u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u3092\u6c42\u3081\u307e\u3059\u3002");
        qbf3 = hiQuGate.apply(qbf2);
        DJ.printF("qbf3", qbf3);
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u72b6\u614bqbf3\u306e\u9077\u79fb\u78ba\u7387\u3092\u6c42\u3081\u307e\u3059\u3002");
        result = qbf3.getTransProb();
        DJ.printF("result", result);
        DJ._print("\u30fb\u9077\u79fb\u78ba\u7387P0, P1\u306f\u5404\u3005\u306e\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u3067\u3059\u3002\n  P0 = 0^2 = 0   P1 = 1^2 = 1 ");
        DJ._print("\u30fb\u78ba\u7387P0\u3068\u78ba\u7387P1\u306f\u3001\u305d\u308c\u305e\u308c\u6b21\u5f0f\u3067\u4e0e\u3048\u3089\u308c\u307e\u3059\u3002\n  P0 = 1/2(1 + Re(f~Uf)=0 \u2234\u3000\u671f\u5f85\u5024f~Uf=-1 \n  P1 = 1/2(1 - Re(f~Uf)=1 \u2234\u3000\u671f\u5f85\u5024f~Uf=-1 \n  \u8a18\u53f7~\u306f\u5171\u5f79\u8ee2\u7f6e\u3092\u610f\u5473\u3059\u308b\u3002");
        this.stepMode = true;
        DJ.printS(3, "HadamardTest(5)", this);
        DJ._print("Code(5)\u975e\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u306e\u5834\u5408");
        DJ.print("\u30fb\u30e6\u30cb\u30bf\u30ea\u884c\u5217\u306bX\u30b2\u30fc\u30c8\u3001\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8f\u306b\n  \u975e\u56fa\u6709\u30d9\u30af\u30c8\u30eb\u3092\u4f7f\u3044\u3001\u671f\u5f85\u5024f~Uf\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ._print("Code(5-1)\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8f0\u3092\u89d2\u5ea6\u03b8=\u03c0/6\u3067\u8a2d\u5b9a");
        double theta = 0.5235987755982988;
        f0 = QuBit.rotateRadianQuBit(theta);
        DJ.printF("f0", f0);
        DJ.print("\u30fb\u88dc\u52a9\u91cf\u5b50\u30d3\u30c3\u30c8qb0\u306b\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8f0\u3092\n  \u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        qbf0 = qb0.interactQuBit(f0);
        DJ.printF("qbf0", qbf0);
        DJ.printS(1, "HadamardTest(5-2)", this);
        DJ.print("Code(5-2)\u91cf\u5b50\u30d3\u30c3\u30c8qbf0\u306bhi\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        qbf1 = hiQuGate.apply(qbf0);
        DJ.printF("qbf1", qbf1);
        DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8qbf1\u306bC-X\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3057\u307e\u3059\u3002");
        qbf2 = cxGate.apply(qbf1);
        DJ.printF("qbf2", qbf2);
        DJ.printS(1, "HadamardTest(5-3)", this);
        DJ.print("Code(5-3)\u91cf\u5b50\u30d3\u30c3\u30c8qbf2\u306bhi\u30b2\u30fc\u30c8\u3092\u9069\u7528");
        qbf3 = hiQuGate.apply(qbf2);
        DJ.printF("qbf3", qbf3);
        DJ._print("\u30fb\u5f97\u3089\u308c\u305f\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u3082\u3064\u308c\u3066\u3044\u308b\u305f\u3081\u3001\n  \u5206\u96e2\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u6e2c\u5b9a\u3057\u3066\u3001\n\u3000[1 0 0 0]'\u304b[0 1 0 0]'\u304c\u5f97\u3089\u308c\u308b\u78ba\u7387P0\u3068\u3001\n\u3000[0 0 1 0]'\u304b[0 0 0 1]\u304c\u5f97\u3089\u308c\u308b\u78ba\u7387P1\u306f\u3001\n  \u305d\u308c\u305e\u308c\u4ee5\u4e0b\u306e\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3054\u3068\u306e\u9077\u79fb\u78ba\u7387\u3092\u53ce\u96c6\u3057\u307e\u3059\u3002");
        result = qbf3.getTransProb();
        DJ.printF("result", result);
        DJ._print("\u30fb\u9077\u79fb\u78ba\u7387P0, P1\u306f\u5404\u3005\u306e\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u3067\u3059\u3002\nP0 = 0.68301^2 * 2 = 0.93303 \nP1 = 0.18301^2 * 2 = 0.06698 ");
        DJ._print("\u30fb\u3088\u3063\u3066\u78ba\u7387P0\u3068\u78ba\u7387P1\u306f\u3001\u305d\u308c\u305e\u308c\u6b21\u5f0f\u3067\u4e0e\u3048\u3089\u308c\u307e\u3059\u3002\nP0 = 1/2(1 + Re(f~Uf) = 0.93303 \n  \u2234\u3000\u671f\u5f85\u5024f~Uf = 2 P0 - 1 = 0.86603\nP1 = 1/2(1 - Re(f~Uf) = 0.06698 \n  \u2234\u3000\u671f\u5f85\u5024f~Uf = -2 P1 + 1 = 0.86603 \n   \u8a18\u53f7~\u306f\u5171\u5f79\u8ee2\u7f6e\u3092\u610f\u5473\u3057\u307e\u3059\u3002");
        this.stepMode = true;
        DJ._print("##### HadamardTest\u306e\u51e6\u7406\u3092\u7d42\u4e86\u3057\u307e\u3059\u3000#####");
    }
}

