/*
 * Decompiled with CFR 0.152.
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompVec;
import util.comp.Complex;

public class QuantumTeleportation
extends Task {
    int dataNum = 200;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Quantum Teleportation", 6, this.patternData1, "Quantum Teleportation");
        this.stepMode = true;
        this.quantumTeleportation();
    }

    public void quantumTeleportation() {
        DJ._print("QuantumTeleportation.quantumTeleportation() ==================");
        DJ.print("\u25a0\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\uff1aQuantum Teleportation");
        DJ.print("  \u91cf\u5b50\u72b6\u614b\u3092\u8ee2\u9001\u3059\u308b\u6280\u8853");
        DJ.print("(1)\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3");
        DJ.print("(2)\u521d\u671f\u5024\u3092\u8a2d\u5b9a");
        DJ.print("(3)\u91cf\u5b50\u3082\u3064\u308c\u72b6\u614b");
        DJ.print("(4)\u9006\u30d9\u30eb\u56de\u8def\u306b\u9069\u7528");
        DJ.print("(5)\u91cf\u5b50\u306e\u6e2c\u5b9a\u3068\u5fa9\u5143");
        DJ._print("\u30fb\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306f\u91cf\u5b50\u3082\u3064\u308c (Quantum entanglement)\u3068\n\u3000\u53e4\u5178\u7684\u306a\u60c5\u5831\u4f1d\u9054\u624b\u6bb5\u3092\u8907\u5408\u7684\u306b\u5229\u7528\u3057\u3066\u884c\u308f\u308c\u307e\u3059\u3002");
        DJ._print("\u30fb\u91cf\u5b50\u3082\u3064\u308c\u306e\u95a2\u4fc2\u306b\u3042\u308b2\u3064\u306e\u7c92\u5b50\u306e\u3046\u3061\u4e00\u65b9\u306e\u72b6\u614b\u3092\u89b3\u6e2c\u3059\u308b\u3068\n\u3000\u89b3\u6e2c\u3068\u540c\u6642\u306b\u96e2\u308c\u305f\u4f4d\u7f6e\u306b\u3042\u308b\u3082\u3046\u4e00\u65b9\u306e\u7c92\u5b50\u306e\u72b6\u614b\u304c\u78ba\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u72b6\u614b\u306e\u78ba\u5b9a\u306f\u3082\u3064\u308c\u305f\u91cf\u5b50\u304c\u3069\u3093\u306a\u306b\u96e2\u308c\u3066\u3044\u3066\u3082\u77ac\u6642\u306b\u4f1d\u308f\u308b\u3053\u3068\u304c\u3001\n\u3000\u5b9f\u9a13\u306b\u3088\u308a\u8a3c\u660e\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5149\u306e\u901f\u3055\u3092\u8d85\u8d8a\u3057\u3066\u3044\u308b\u3053\u306e\u73fe\u8c61\u306f\u3001\n\u3000\u76f8\u5bfe\u8ad6\u7684\u306a\u5c40\u6240\u6027\u3092\u7834\u308b\u305f\u3081\u3001\u91cf\u5b50\u529b\u5b66\u306b\u304a\u3051\u308b\u975e\u5c40\u6240\u6027\u3068\u547c\u3070\u308c\u3066\u3044\u307e\u3059\u3002");
        DJ.printS(3, "QuantumTeleportation(1)", this);
        DJ._print("Code(1)\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3");
        DJ.print("Code(1-1)\u7e54\u59ebVega\u306f\u30e1\u30c3\u30bb\u30fc\u30b8\uff08\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b\uff09\u3092\u3001  \n\u3000\u5f66\u661fAltair\u306b\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u3067\u4f1d\u3048\u307e\u3059\u3002            \n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u305f\u3063\u305f\uff11\u500b\u3067\u3082\u7121\u9650\u306e\u72b6\u614b\u3092\u8868\u3059\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\n\u3000\u3042\u3089\u304b\u3058\u3081\u3082\u3064\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u5404\u3005\u3092\u53cc\u65b9\u304c\u6301\u3064\u3053\u3068\u306b\u3088\u308a\u3001\n\u3000\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u3001\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u518d\u73fe\u3057\u307e\u3059\u3002");
        DJ._print("Code(1-2)\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u3092\u5b9f\u73fe\u3059\u308b\u91cf\u5b50\u56de\u8def");
        DJ.print("\u30fb\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u91cf\u5b50\u56de\u8def\u306f\u3001         \n\u3000H\u30b2\u30fc\u30c8(Hadamard Gate)\u3068C-Not\u30b2\u30fc\u30c8(CX Gate)\u3001    \n\u3000X\u30b2\u30fc\u30c8\u3001Z\u30b2\u30fc\u30c8\u3001\u6e2c\u5b9a\u30b2\u30fc\u30c8M1\u3001M2\u3067\u69cb\u6210\u3055\u308c\u307e\u3059\u3002");
        DJ._print("               \u250c-\u2510\u250c-\u2510\u250c-\u2510\u250c-\u2510\u250c\u2500\u2510                        \n sQB = [s0 s1]'\u2524I\u251c\u2524I\u251c\u2524C\u251c\u2524H\u251c\u2524M1\u251d\u2501\u2501\u2501\u2501\u2513              \n               \u251c-\u2524\u251c-\u2524\u2502|\u2502\u251c-\u2524\u251c\u2500\u2524        \u2503              \n vQB = [0 1]'\u2500\u2524H\u251c\u2524C\u251c\u2524X\u251c\u2524I\u251c\u2524M2\u251d\u2501\u2513    \u2503              \n               \u251c-\u2524\u2502|\u2502\u251c-\u2524\u251c-\u2524\u2514\u2500\u2518\u250c\u2538\u2510\u250c\u2538\u2510            \n aQB = [0 1]'\u2500\u2524I\u251c\u2524X\u251c\u2524I\u251c\u2524I\u251c\u2500\u2500\u2500\u2524X \u251c\u2524Z \u251c [s0~ s1~]' \n               \u2514-\u2518\u2514-\u2518\u2514-\u2518\u2514-\u2518      \u2514\u2500\u2518\u2514\u2500\u2518            \n    \u91cf\u5b50\u72b6\u614b  P0   P1   P2   P3    P4   P5          P6           ");
        DJ._print("  sQB:\u7e54\u59eb\u304c\u5f66\u661f\u306b\u9001\u308a\u305f\u3044\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b \n      sQB = [s0 s1]' = s0[1 0]' + s1[0 1]' \n  vQB:\u7e54\u59eb\u306e\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff1a[1 0]'  \u3000\u3000   \n  aQB:\u5f66\u661f\u306e\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\uff1a[1 0]'         \n\u203b\u592a\u3044\u7dda\u306f\u53e4\u5178\u30d3\u30c3\u30c8\u306b\u3088\u308b\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u3092\u8868\u3057\u307e\u3059\u3002");
        DJ.printS(2, "QuantumTeleportation(2)", this);
        DJ.print("\uff08Code(2)P0:\u521d\u671f\u5024\u3092\u8a2d\u5b9a");
        DJ._print("\u30fb\u7e54\u59eb\u306f\u5f66\u661f\u306b\u4f1d\u3048\u305f\u3044\u91cf\u5b50\u72b6\u614b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068\u3001\n\u3000\u521d\u671f\u5024 [1 0]'\u306e\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3092\u7528\u610f\u3057\u307e\u3059\u3002\n\u3000\u5f66\u661f\u3082 \u521d\u671f\u5024[1 0]'\u306e\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        double pi = Math.PI;
        int sDeg = 30;
        double sRad = Math.cos(pi * (double)sDeg / 180.0);
        Complex s0PA = new Complex(sRad, 0.0);
        DJ.print_("s0PA", s0PA);
        Complex s1PA = QuBit.getOtherPA(s0PA);
        DJ.print(", s1PA", s1PA);
        DJ.print("QuBit sQB = new QuBit(s0PA, s1PA);");
        QuBit sQB = new QuBit(s0PA, s1PA);
        DJ.printF("sQB", sQB);
        QuBit _sQB = new QuBit(pi * (double)sDeg / 180.0);
        DJ.printF("_sQB", _sQB);
        QuBit vQB = new QuBit();
        DJ.printF("vQB", vQB);
        QuBit aQB = new QuBit("std0QuBit");
        DJ.printF("aQB", aQB);
        this.stepMode = true;
        DJ.printS(2, "QuantumTeleportation(3)", this);
        DJ.print("Code(3)\u91cf\u5b50\u3082\u3064\u308c\u72b6\u614b\u306e\u751f\u6210");
        DJ.print("  \u7e54\u59eb\u3068\u5f66\u661f\u306f\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3068aQB\u3092\u3082\u3064\u308c\u3055\u305b\u307e\u3059\u3002\n  \u91cf\u5b50\u3082\u3064\u308c\u72b6\u614b\u306e\u751f\u6210\u306bH\u30b2\u30fc\u30c8\uff08\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30b2\u30fc\u30c8\uff09\u3068\n  CX\u30b2\u30fc\u30c8\uff08\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebNOT\u30b2\u30fc\u30c8\uff09\u3092\u4f7f\u3044\u307e\u3059\u3002");
        DJ._print("Code(3-1)\u2460H\u30b2\u30fc\u30c8\uff08\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30b2\u30fc\u30c8\uff09");
        QuGate hGate = new QuGate("H_GATE");
        DJ.printF("hGate", hGate);
        DJ._print("Code(3-1)\u2461P1:\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3092H\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hV = hGate.apply(vQB);");
        QuBit hvQB = hGate.apply(vQB);
        DJ.printF("hvQB", hvQB);
        DJ.printS(1, "QuantumTeleportation(3-2)", this);
        DJ._print("Code(3-2)\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3068hvQB\u3092\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\n  \u91cf\u5b50\u30d3\u30c3\u30c8hvQB\u306bCX\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b\u305f\u3081\u3001\u91cf\u5b50\u30d3\u30c3\u30c8hvQB\u3068\n  \u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3068\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hv_aQB = hvQB.interactQuBit(aQB);");
        QuBit hv_aQB = hvQB.interactQuBit(aQB);
        DJ.printF("hv_aQB", hv_aQB);
        DJ.printS(2, "QuantumTeleportation(3-3)\u2460", this);
        DJ._print("Code(3-3)\u2460CX\u30b2\u30fc\u30c8\uff08\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebNOT\u30b2\u30fc\u30c8\uff09");
        int numOfBit = 2;
        int target = 1;
        int[] control = new int[]{0};
        QuGate cxGate = new QuGate("CX_GATE", numOfBit, target, control);
        DJ.printF("cxGate = ", cxGate);
        DJ.printS(1, "QuantumTeleportation(3-3)\u2461", this);
        DJ._print("Code(3-3)\u2461P2:\uff12\u91cf\u5b50\u30d3\u30c3\u30c8hv_aQB\u3092CX\u30b2\u30fc\u30c8\u306b\u9069\u7528");
        DJ.print("QuBit hv_aQB = cxGate.apply(hv_aQB);");
        QuBit cxHv_aQB = cxGate.apply(hv_aQB);
        DJ.printF("cxHv_aQB", cxHv_aQB);
        DJ._print("Code(3-3)\u2462\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
        boolean checked = cxHv_aQB.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        this.stepMode = true;
        DJ.printS(2, "QuantumTeleportation(4)", this);
        DJ.print("Code(4)\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068cx_hvaQB\u3092\u9006\u30d9\u30eb\u56de\u8def\u306b\u9069\u7528");
        DJ._print("  \u7e54\u59eb\u306f\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068cx_hvaQB\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u3001\n  CX\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3066\u3082\u3064\u308c\u3092\u89e3\u6d88\u3055\u305b\u307e\u3059\u3002");
        DJ._print("Code(4-1)\u91cf\u5b50\u30d3\u30c3\u30c8cxHv_aQBB\u3092CX\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3059\u308b\u305f\u3081\u3001\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        QuBit s_v_aQB = sQB.interactQuBit(cxHv_aQB);
        DJ.printF("s_v_aQB", s_v_aQB);
        DJ.printS(1, "QuantumTeleportation(4-2)\u2460", this);
        DJ._print("Code(4-2)\u2460CX\u30b2\u30fc\u30c8\u3092\uff13\u91cf\u5b50\u30b2\u30fc\u30c8\u306b\u62e1\u5f35");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ._print("\u30fbI\u30b2\u30fc\u30c8\u3092CX\u30b2\u30fc\u30c8\u306b\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30b2\u30fc\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        DJ.print("QuGate cx_iGate = cxGate.interactQuGate(iGate);");
        QuGate cx_iGate = cxGate.interactQuGate(iGate);
        DJ.printF("cx_iGaet", cx_iGate);
        DJ.printS(1, "QuantumTeleportation(4-2)\u2461", this);
        DJ._print("Code(4-2)\u2461P3:\u91cf\u5b50\u30d3\u30c3\u30c8s_v_aQB\u3092CX_I\u30b2\u30fc\u30c8\u306b\u9069\u7528");
        QuBit cXsvaQB = cx_iGate.apply(s_v_aQB);
        DJ.printF("cXsvaQB = ", cXsvaQB);
        DJ._print("Code(4-2)\u2462\uff13\u91cf\u5b50\u30d3\u30c3\u30c8cXsvaQB\u306e\u9077\u79fb\u78ba\u7387");
        double[][] cXsvaTransProb = cXsvaQB.getTransProb();
        DJ.printF("cXsvaTransProb", cXsvaTransProb);
        DJ.printS(2, "QuantumTeleportation(4-3)\u2460", this);
        DJ._print("Code(4-3)\u2460\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u5358\u4f4d\u30b2\u30fc\u30c8\u3092\u751f\u6210");
        int numOfQuBit = 2;
        DJ.print("QuGate i_iGate = new QuGate(numOfQuBit); // numOfQuBit=2");
        QuGate i_iGate = new QuGate(numOfQuBit);
        DJ.printF("i_iGate", i_iGate);
        DJ._print("Code(4-3)\u2461H\u30b2\u30fc\u30c8\u3092\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\n  H\u30b2\u30fc\u30c8\u306bI_I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        DJ.print("QuGate h_i_iGate = hGate.interactQuGate(i_iGate);");
        QuGate h_i_iGate = hGate.interactQuGate(i_iGate);
        DJ.printF("h_i_iGate", h_i_iGate);
        DJ.printS(1, "QuantumTeleportation(4-3)\u2462", this);
        DJ._print("Code(4-3)\u2462P4:\u91cf\u5b50\u30d3\u30c3\u30c8cxIsvaQB\u3092H_I_I\u30b2\u30fc\u30c8\u306b\u9069\u7528");
        DJ.print("QuGate hcXsvaQB = h_i_iGate.apply(cxsvaQB)");
        QuBit hcXsvaQB = h_i_iGate.apply(cXsvaQB);
        DJ.printF("hcXsvaQB", hcXsvaQB);
        DJ._print("Code(4-3)\u2463\u91cf\u5b50\u30d3\u30c3\u30c8hcXsvaQB\u306e\u9077\u79fb\u78ba\u7387");
        double[][] hcXsvaTransProb = hcXsvaQB.getTransProb();
        DJ.printF("hcXsvaTransProb", hcXsvaTransProb);
        this.stepMode = true;
        DJ.printS(3, "QuantumTeleportation(5)", this);
        DJ.print("Code(5)\u91cf\u5b50\u72b6\u614b\u306e\u6e2c\u5b9a\u3068\u5fa9\u5143\n\u30fb\u7e54\u59eb\u306f\u81ea\u5206\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068vQB\u3092\u6e2c\u5b9a\u3057\u3001\n\u3000\u7d50\u679c\u3092\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u5f66\u661f\u306b\u9001\u308a\u307e\u3059\u3002");
        DJ.print("\u30fb\u5f66\u661f\u306f\u7e54\u59eb\u304b\u3089\u9001\u3089\u308c\u305f\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u306b\n  \u5f93\u3063\u3066\u81ea\u5206\u306e\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3092\u51e6\u7406\u3057\u3001\n  \u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u306e\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002");
        DJ._print("\u30fbH\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8hcXsvaQB\u306f   \n  \u91cf\u5b50\u56de\u8def\u306e\u91cf\u5b50\u72b6\u614bP4\u306b\u76f8\u5f53\u3057\u3001          \n  \u4ee5\u4e0b\u306e\u3088\u3046\u306b\uff14\u9805\u306b\u5206\u304b\u308c\u307e\u3059\u3002          \n\u3000\u5404\u9805\u306e\u6700\u521d\u306e\uff12\u500b\u306e\u7e54\u59eb\u306e2\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u3001 \n\u3000\u7e54\u59eb\u304c\u6e2c\u5b9a\u30b2\u30fc\u30c8M0\u3001M1\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u306f\u3001\n  \u5404\u9805\uff081/2)^2=1/4\u3000\u306e\u78ba\u7387\u3067\u3001\u53e4\u5178\u30d3\u30c3\u30c8  \n\u300000\u300101\u300110\u300111\u306e\u3044\u305a\u308c\u304b\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.print("hcXsvaQB  \u250c \u2510  \u250c \u2510         \u250c \u2510     \u250c \u2510    \n   = 1/2 (\u25021\u2502\u24e7\u25021\u2502\u24e7 (\u221a3/2\u25021\u2502+ 1/2\u25020\u2502)   \n          \u25020\u2502  \u25020\u2502         \u25020\u2502     \u25021\u2502    \n          \u2514 \u2518  \u2514 \u2518         \u2514 \u2518     \u2514 \u2518    \n          \u250c \u2510  \u250c \u2510        \u250c \u2510       \u250c \u2510   \n        + \u25021\u2502\u24e7\u25020\u2502\u24e7 ( 1/2\u25021\u2502+ \u221a3/2\u25020\u2502)  \n          \u25020\u2502  \u25021\u2502        \u25020\u2502       \u25021\u2502   \n          \u2514 \u2518  \u2514 \u2518        \u2514 \u2518       \u2514 \u2518   \n          \u250c \u2510  \u250c \u2510         \u250c \u2510     \u250c \u2510    \n        + \u25020\u2502\u24e7\u25021\u2502\u24e7 (\u221a3/2\u25021\u2502- 1/2\u25020\u2502)   \n          \u25021\u2502  \u25020\u2502         \u25020\u2502     \u25021\u2502    \n          \u2514 \u2518  \u2514 \u2518         \u2514 \u2518     \u2514 \u2518    \n          \u250c \u2510  \u250c \u2510        \u250c \u2510       \u250c \u2510   \n        + \u25020\u2502\u24e7\u25020\u2502\u24e7 (-1/2\u25021\u2502+ \u221a3/2\u25020\u2502)) \n          \u25021\u2502  \u25021\u2502        \u25020\u2502       \u25021\u2502   \n          \u2514 \u2518  \u2514 \u2518        \u2514 \u2518       \u2514 \u2518   ");
        DJ.printS(1, "QuantumTeleportation(5-0)", this);
        DJ._print("Code(5-0)\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u30fb\u5404\u9805\u306e\uff13\u500b\u76ee\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306b      \n  \u5bfe\u5fdc\u3057\u3066\u3044\u307e\u3059\u3002\u7e54\u59eb\u304c\u6e2c\u5b9a\u3059\u308b\u3068\u540c\u6642\u306b            \n\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082\u9077\u79fb\u3057\u3001\u78ba\u5b9a\u3057\u307e\u3059\u3002            \n\u30fb\u5168\u4f53\u304c1/2\u3067\u62ec\u3089\u308c\u3066\u3044\u308b\u306e\u306f\u3001\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e   \n  \u78ba\u7387\uff08\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u306e\u548c\uff09\u3092\uff11\u306b\u3059\u308b\u305f\u3081\u3067\u3059\u3002    \n\u3000\u4f8b\u3048\u3070\u7b2c\uff11\u9805\u3067\u306f\u3001                                \n    (\u221a3/2)^2 + (1/2)^2 = 3/4 + 1/4 = 1 \u3068\u306a\u308a\u307e\u3059\u3002");
        DJ._print("\u30fb\u5404\u9805\u306e\uff13\u500b\u76ee\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u53d6\u308a\u51fa\u3057\u3001\n\u3000\u5168\u4f53\u30921/2\u3067\u62ec\u308b\u305f\u3081\u3001\uff12\u500d\u3057\u307e\u3059\u3002");
        CompVec probAmpVec = hcXsvaQB.copyProbAmpVec();
        probAmpVec.product(2.0);
        QuBit[] aQBArray = new QuBit[4];
        for (int i = 0; i < 4; ++i) {
            aQBArray[i] = new QuBit(probAmpVec.getComp(i * 2), probAmpVec.getComp(i * 2 + 1));
            String term = Integer.toBinaryString(i);
            if (i < 2) {
                term = "0" + term;
            }
            DJ.printF("aQBArray[" + term + "] = ", aQBArray[i]);
        }
        DJ.printS(2, "QuantumTeleportation(5-1)", this);
        DJ._print("Code(5-1)\uff11\u9805\u76ee\u306e\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c00\u306e\u5834\u5408\n  \u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u7e54\u59eb\u304c\u4f1d\u3048\u305f\u3044\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\n\u3000\u91cf\u5b50\u72b6\u614bsQB\u306b\u4e00\u81f4\u3057\u307e\u3059\u3002     \n                                \n    sQB = [s0 s1]'              \n        = s0[1 0]' + s1[0 1]'   \n        = [0.86603+0i  0.5+0i]' \n        = [\u221a3/2  1/2]'         \n                                \n\u3000\u5f93\u3063\u3066\u3001\u5f66\u661f\u306f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5fa9\u5143\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        DJ._print("\u3000\u3057\u304b\u3057\u3001\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c\uff12\u9805\u76ee\u4ee5\u964d\u306e \n  01\u300110\u300111\u306e\u5834\u5408\u306b\u306f\u3001\u5f66\u661f\u306f\u4ee5\u4e0b\u306e\u3088\u3046\u306b\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002");
        DJ.printS(1, "QuantumTeleportation(5-2)", this);
        DJ._print("Code(5-2)\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c01\u306e\u5834\u5408");
        DJ.print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\n  \u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        QuGate xGate = new QuGate("X_GATE");
        DJ.printF("xGate", xGate);
        DJ._printF("aQBArray[01] = ", aQBArray[1]);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b01]);");
        QuBit _aQB = xGate.apply(aQBArray[1]);
        DJ.printF("_aQB", _aQB);
        DJ.printS(1, "QuantumTeleportation(5-3)", this);
        DJ._print("Code(5-3)\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c10\u306e\u5834\u5408");
        DJ.print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\n  \u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        QuGate zGate = new QuGate("Z_GATE");
        DJ.printF("zGate", zGate);
        DJ.printF("aQBArray[10] = ", aQBArray[2]);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = zGate.apply(aQBArray[0b10]);");
        _aQB = zGate.apply(aQBArray[2]);
        DJ.printF("_aQB", _aQB);
        DJ.printS(1, "QuantumTeleportation(5-4)", this);
        DJ._print("(5-4)\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c11\u306e\u5834\u5408");
        DJ._print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u3001Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\n  \u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        DJ.printF("aQBArray[11] = ", aQBArray[3]);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b11]);");
        _aQB = xGate.apply(aQBArray[3]);
        DJ.printF("_aQB", _aQB);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = zGate.apply(_aQB);");
        _aQB = zGate.apply(_aQB);
        DJ.printF("_aQB", _aQB);
        DJ._print("\u30fb\u4ee5\u4e0a\u306b\u3088\u308a\u3001\u7e54\u59eb\u304c\u9001\u4fe1\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u304c\n  \u3082\u3064\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u5bfe\u3092\u7528\u3044\u305f\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306b\u3088\u308a\n  \u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u306b\u518d\u73fe\u3055\u308c\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u307e\u3057\u305f\u3002");
        this.stepMode = true;
        DJ._print("");
        DJ._print("\u30fb\u4ee5\u4e0a\u3067\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u7d42\u308f\u308a\u3067\u3059\u3002");
        DJ.printS(2, "QuantumTeleportation", this);
        DJ._print("\u91cf\u5b50\u8a08\u7b97\u306e\u5b8c\u4e86");
        DJ.print("QuantumTeleportation.quantumTeleportation() =================");
    }
}

