/*
 * Decompiled with CFR 0.152.
 */
package task.qu.aug;

import quan.QuBasis;
import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class BellsIneqOld
extends Task {
    int dataNum = 1000;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Open-loop Control", 6, this.patternData1, "Clos-loop Control");
        this.bellsInequality();
    }

    public void bellsInequality() {
        DJ._print("BellsInequality.bellsInequality() ========================");
        DJ.print("\u25a0\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\uff1aBell's Inequality");
        DJ.print("\u30fb\u5c40\u6240\u5b9f\u5728\u8ad6");
        DJ.print("\u30fb\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f");
        DJ.print("\u30fbCHSH\u4e0d\u7b49\u5f0f");
        DJ.print("https://github.com/Qiskit/textbook/blob/main/translations/ja/ch-demos/chsh.ipynb");
        this.stepMode = true;
        DJ.printS(3, "BellsInequality\uff08\uff10\uff09", this);
        DJ.print("Bell's Inequality\uff1a");
        DJ.print("\uff08\uff11\uff09\u30d9\u30eb\u306e\u5b9f\u9a13\u306b\u3088\u308a\u3001\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306f\u7834\u3089\u308c\u308b\u3002");
        DJ._print("\u30fb\u7e54\u59ebVega\u306e\u3068\u5f66\u661fAltair\u306f\u3082\u3064\u308c\u305f2\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\n\u3000\uff13\u500b\u306e\u57fa\u5e95(b0, b1, b2)\u304b\u3089\uff12\u500b\u3092\u9078\u3093\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u5148\u306b\u7e54\u59eb\u304c\u6e2c\u5b9a\u3057\u3001\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u5f8c\u304b\u3089\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000b0 = (0:b0_0, 1:b0_1) \u03b8 = 0\u03c0,  \u03c0/2  =  0,  90deg \n  b1 = (0:b1_0, 1:b1_1) \u03b8 = \u03c0/3, 5\u03c0/6 = 60, 150deg \n  b2 = (0:b2_0, 1:b2_1) \u03b8 = \u03c0/6, 2\u03c0/3 = 30, 120deg \n\u3000\n\u30fb\u5c40\u6240\u5b58\u5728\u8ad6\uff08\u5c40\u6240\u6027\u3068\u5b58\u5728\u6027\uff09\u3092\u4eee\u5b9a\u3059\u308b\u3068\u6b21\u306e\u4e0d\u7b49\u5f0f\u304c\u6210\u7acb\u3057\u307e\u3059\u3002\n\u3000P(b0_0, b1_1) <= P(b0_0, b2_1) + P(b2_0, b1_1)\u2026Bell\u306e\u4e0d\u7b49\u5f0f\n\u3000\u3053\u3053\u3067\u3001P()\u306f\u767a\u751f\u78ba\u7387\u3092\u8868\u3057\u307e\u3059\u3002\n\u3000P(b0_0, b1_1)\u306f\u7e54\u59eb\u304cb0\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3001\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1\n\u3000P(b0_0, b2_1)\u306f\u7e54\u59eb\u304cb0\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3001\u5f66\u661f\u304cb2\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1\n\u3000P(b2_0, b1_1)\u306f\u7e54\u59eb\u304cb2\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3001\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1");
        DJ.print("\u30fb\u5c40\u6240\u5b58\u5728\u8ad6\u3067\u306f\u7d50\u679c\u306f\u6e2c\u5b9a\u3059\u308b\u524d\u304b\u3089\u5b9f\u5728\u3057\u3001\u53cc\u65b9\u306e\u6e2c\u5b9a\u7d50\u679c\u306f\n\u3000\u4e92\u3044\u306b\u4ed6\u65b9\u306b\u306f\u5f71\u97ff\u3057\u306a\u3044\uff08\u76f8\u5bfe\u8ad6\u7684\u306b\u5149\u306e\u65e9\u3055\u4ee5\u4e0a\u306e\u901f\u3055\u3067\u306f\u60c5\u5831\u306f\n\u3000\u4f1d\u308f\u3089\u306a\u3044\uff09\u3068\u8003\u3048\u308b\u306e\u3067\u3001\u78ba\u7387\u306f\u4ee5\u4e0b\u306e\u96c6\u5408\u306b\u7f6e\u304d\u63db\u3048\u3089\u308c\u307e\u3059\u3002\u3000\u30d9\u30f3\u56f3\uff08Venn Diagram\uff09\u306f\u5168\u3066\u306e\u8981\u7d20\uff08b0,b1,b2\u306e\u7d50\u679c0,1\uff09\u3092\u542b\u307f\u307e\u3059\u3002");
        DJ.print("\u3000\u5de6\u8fba\u3000\u3000\u3000P(b0_0, b1_1)\u306f\u96c6\u5408(b0_0,b1_1,b2_0)+(b0_0,b1_1,b2_1)\u3001\n\u3000\u53f3\u8fba\u7b2c\uff11\u9805P(b0_0, b2_1)\u306f\u96c6\u5408(b0_0,b1_0,b2_1)+(b0_0,b1_1,b2_1)\u3001\n\u3000\u53f3\u8fba\u7b2c\uff12\u9805P(b2_0, b1_1)\u306f\u96c6\u5408(b0_0,b1_1,b2_0)+(b0_1,b1_1,b2_0)\u3001\n\u3000\u3067\u3059\u306e\u3067\u3001\u5de6\u8fba\u306e\uff12\u500b\u306e\u96c6\u5408\u306f\u5168\u3066\u53f3\u8fba\u306b\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u3000\u5f93\u3063\u3066\u3001Bell\u306e\u4e0d\u7b49\u5f0f\u304c\u6210\u7acb\u3057\u307e\u3059\u3002");
        DJ._print("\u30fb\u30d9\u30eb\u306e\u5b9f\u9a13\u56de\u8def\u306fH\u30b2\u30fc\u30c8(Hadamard Gate)\u3068\u3001\n\u3000C-Not\u30b2\u30fc\u30c8(CX Gate)\u3067\u69cb\u6210\u3055\u308c\u307e\u3059\u3002\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\uff10\u3092M0\u3067\u6e2c\u5b9a\u3059\u308b\u3068\u3001\u305d\u306e\u7d50\u679c\u304c\u91cf\u5b50\u30d3\u30c3\u30c8\uff11\u306b\u53cd\u6620\u3055\u308c\u307e\u3059\u3002\n            \u250c-\u2510  \u250c-\u2510  \u250c- \u2510  \u3000\u3000\u3000  \u250c--\u2510  \nQB0 = |0> --\u2502H\u2502--\u2502C\u2502--\u2502M0\u2502--\uff3c\u3000\u3000  \u2502I \u2502  \n            \u2502 \u2502  \u2502 \u2502  \u2502  \u2502  \u3000\uff3c\u3000  \u2502  \u2502  \nQB1 = |0> --\u2502I\u2502--\u2502X\u2502--\u2502I \u2502--\u3000\u3000\uff3c--\u2502M1\u2502  \n            \u2514-\u2518  \u2514-\u2518  \u2514--\u2518 \u3000\u3000\u3000   \u2514--\u2518  ");
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff11\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff11\uff09\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("\u30fb\u4e8c\u91cf\u5b50\u30d3\u30c3\u30c8inQuBit = |00>\u3092\u751f\u6210\u3059\u308b\u5834\u5408\u3002");
        int numOfQuBit = 2;
        QuBit inQuBit = QuBit.unitQuBit(numOfQuBit, 0);
        DJ.printF("inQuBit", inQuBit);
        DJ.print("\u30fb\u4e8c\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8QB0 = QB1 = |0>\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\nQB00 = |00>\u3092\u751f\u6210\u3059\u308b\u5834\u5408\u3002");
        QuBit QB0 = new QuBit();
        DJ.printF("QB0", QB0);
        QuBit QB1 = new QuBit();
        DJ.printF("QB1", QB1);
        DJ.print("\u30fbQB0\u3068QB1\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8|00>\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit QB00 = QB0.interactQuBit(QB1);
        DJ.printF("QB00", QB00);
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff12\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff12\uff09\u91cf\u5b50\u56de\u8def\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ._print("\u2460H\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("H\u30b2\u30fc\u30c8\uff08Hadamard\u30b2\u30fc\u30c8\uff09\n          \u250c      \u2510 \n H = 1/\u221a2\u2502 1   1\u2502 \n          \u2502 1  -1\u2502 \n          \u2514      \u2518 ");
        DJ.print(" QuGate hadamardGate = new QuGate(QuGate.H_GATE)");
        QuGate hadamardGate = new QuGate("H_GATE");
        DJ.printF("hadamardGate", hadamardGate);
        DJ.print("I\u30b2\u30fc\u30c8\uff08\u6052\u7b49\u30b2\u30fc\u30c8\uff09\n     \u250c      \u2510 \n I = \u2502 1   0\u2502 \n     \u2502 0   1\u2502 \n     \u2514      \u2518 ");
        DJ.print(" QuGate iGate = new QuGate(QuGate.I_GATE)");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ._print("\u30fbH\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("HI\u30b2\u30fc\u30c8:H\u24e7I \n             \u250c     \u2510 \n H\u24e7I = 1/\u221a2\u2502 I  I\u2502 \n             \u2502 I -I\u2502 \n             \u2514     \u2518 ");
        QuGate hiGate = hadamardGate.interactQuGate(iGate);
        DJ.printF("hiGate", hiGate);
        DJ._print("\u2461CX\u30b2\u30fc\u30c8\uff08C-Not\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210\u3057\u307e\u3059\u3002\n      \u250c              \u2510 \n CX = \u2502 1   0   0   0\u2502 \n      \u2502 0   1   0   0\u2502 \n      \u2502 0   0   0   1\u2502 \n      \u2502 0   0   1   0\u2502 \n      \u2514              \u2518 ");
        DJ._print("\u30fbCX\u30b2\u30fc\u30c8\u306e\u751f\u6210\u306b\u306f\u3001\u91cf\u5b50\u30d3\u30c3\u30c8\u6570\u3001\u304a\u3088\u3073\n\u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        DJ.print(" QuGate cxGate = new QuGate( QuGate.CX_GATE, numOfBits, target, controlArray)");
        int numOfBits = 2;
        int target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray = new int[]{0};
        DJ.print(", controlArray", controlArray);
        QuGate cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.printF("cxGate", cxGate);
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff13\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff13\uff09\u9806\u756a\u306b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u91cf\u5b50\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3059\u308b\u3002");
        DJ._print("\u2460\u91cf\u5b50\u30d3\u30c3\u30c8QB00\u3092\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u306b\u9069\u7528\u3059\u308b\u3002");
        DJ.print("H\u24e7I*[1 0 0 0]'");
        DJ.print("QuBit hi00Bit = hiGate.apply(QB00);");
        QuBit hi00Bit = hiGate.apply(QB00);
        DJ.printF("hi00Bit", hi00Bit);
        DJ._print("\u2461\u91cf\u5b50\u30d3\u30c3\u30c8hi00Bit\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cxGate\u306b\u9069\u7528\u3059\u308b\u3002");
        DJ.print("CX*HI*[1 0 0 0]'");
        DJ.print("QuBit cxhi00Bit = cxGate.apply(hi00Bit);");
        QuBit cxhi00Bit = cxGate.apply(hi00Bit);
        DJ.printF("cxhi00Bit", cxhi00Bit);
        DJ._print("\u2462\u591a\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a\u3059\u308b\u3002");
        boolean checked = cxhi00Bit.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff14\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff14\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5de6\u8fbaP(b0_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002\n\u3000\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6a19\u6e96\u57fa\u5e95\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u6a19\u6e96\u57fa\u5e95\u3092\u751f\u6210\u3059\u308b\u3002");
        QuBasis std2QuBasis = new QuBasis(numOfQuBit);
        DJ.printF("stdQuBasis", std2QuBasis);
        DJ._print("\u2461\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6a19\u6e96\u57fa\u5e95\u3067\u6e2c\u5b9a\u3059\u308b\u3002");
        CompVec changedQuBit = cxhi00Bit.basisChang(std2QuBasis);
        DJ.printF("changedQuBit", changedQuBit);
        DJ._print("\u91cd\u306a\u308a\u5408\u3063\u305f\u72b6\u614b\u306e\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8|00>\u3068|11>\u306f\u3001\n(1/\u221a2)^2=1/2\u306e\u78ba\u7387\u3067\u3069\u3061\u3089\u304b\u306e\u57fa\u5e95\u306b\u9077\u79fb\u3057\u3001\n\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u306f\u89e3\u6d88\u3055\u308c\u308b\u3002");
        QuBit selectedQuBit = std2QuBasis.measurement(cxhi00Bit);
        DJ.printF("selectedQuBit", selectedQuBit);
        DJ._print("\u2462\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6a19\u6e96\u57fa\u5e95\u3067\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\u5404\u57fa\u5e95\u306e\u9078\u629e\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        int tryalNo = 2;
        int[] count = std2QuBasis.countQuBasis(cxhi00Bit, tryalNo);
        DJ.print("count = ", count);
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u57fa\u5e95");
        QuBit[] selectedQBArray = std2QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u53e4\u5178\u30d3\u30c3\u30c8\uff1a\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u30010,1,2,3");
        int[] clBitArray = std2QuBasis.getClassicBit();
        DJ.print("clBitArray = ", clBitArray);
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff15\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff15\uff09\u9077\u79fb\u3057\u305f\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u306e\u57fa\u5e95\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.print("\u3000\u7e54\u59eb\u304c\u6a19\u6e96\u57fa\u5e95\u3067\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6e2c\u5b9a\u3057\u305f\u3053\u3068\u306b\u3088\u308a\u3001\n\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082\u9077\u79fb\u3057\u3001\u3082\u3064\u308c\u72b6\u614b\u306f\u89e3\u6d88\u3055\u308c\u307e\u3059\u3002\n\u3000\u5f66\u661f\u306f60\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3067\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u246060\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3092\u751f\u6210\u3059\u308b\u3002");
        DJ._print("\u30fb\u56de\u8ee2\u89d2\u3092\u5ea6\u3067\u6307\u5b9a\u3059\u308b\u5834\u5408");
        QuBasis ang60QuBasis = new QuBasis(60L);
        DJ.printF("ang60QuBasis[deg]", ang60QuBasis);
        DJ._print("\u30fb\u56de\u8ee2\u89d2\u3092\u30e9\u30b8\u30a2\u30f3\u3067\u6307\u5b9a\u3059\u308b\u5834\u5408");
        ang60QuBasis = new QuBasis(1.0471975511965976);
        DJ.printF("ang60QuBasis[rad]", ang60QuBasis);
        DJ._print("\u30fb\u56de\u8ee2\u884c\u5217\u3092\u6c42\u3081\u3066\u3001\u57fa\u5e95\u3092\u5f97\u308b\u5834\u5408");
        DJ.print("\u30fb\u89d2\u5ea6\u309260 degree\uff08\u03c0/3 radian\uff09\u56de\u8ee2\u3055\u305b\u308b\u884c\u5217r60Mat");
        CompMat r60Mat = QuBasis.rotate(1.0471975511965976, 0.0, 0.0);
        DJ.printF("r60Mat", r60Mat);
        DJ.print("\u30fb60\u5ea6\u306e\u56de\u8ee2\u884c\u5217r60Mat\u3067\u57fa\u5e95\u3092\u5f97\u308b");
        QuBasis r60Basis = new QuBasis(r60Mat);
        DJ.printF("r60Basis", r60Basis);
        DJ._print("\u246160\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95ang60QuBasis\u3067\u3001|0>\u3068|1>\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6e2c\u5b9a\u3059\u308b\u3002");
        changedQuBit = QB0.basisChang(ang60QuBasis);
        DJ.printF("changedQuBit", changedQuBit);
        DJ._print("\u2462\u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092\u57fa\u5e95ang60QuBasis\u3067\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\n\u5404\u57fa\u5e95\u306e\u9078\u629e\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        tryalNo = 2;
        count = ang60QuBasis.countQuBasis(QB0, tryalNo);
        DJ.print("count = ", count);
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u57fa\u5e95");
        selectedQBArray = ang60QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u53e4\u5178\u30d3\u30c3\u30c8\uff1a\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u30010,1");
        clBitArray = ang60QuBasis.getClassicBit();
        DJ.print("clBitArray = ", clBitArray);
        DJ._print("\u4ee5\u4e0a\u306b\u3088\u308a\u3001P(b0_0, b1_1)\u306f\u3001\u307e\u305a\uff08\uff11\uff0d\uff14\uff09\u2461\u3088\u308a\u3001\n\u7e54\u59eb\u304cb0\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3068\u306a\u308b\u306e\u306f(1/\u221a2)^2=1/2=0.5\u3001\n\u3055\u3089\u306b\u3001\uff08\uff11\uff0d\uff15\uff09\u2462\u3088\u308a\u3001\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1\u3068\u306a\u308b\u306e\u306f\u3001\n(\u221a3/2)^2=3/4=0.75\u306a\u306e\u3067\u3001P=(1/2)*(3/4)=3/8=0.375\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff16\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff16\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u306e1\u9805\u3081P(b0_0, b2_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("\u3000\u7e54\u59eb\u304c\u6a19\u6e96\u57fa\u5e95\u3067\u6e2c\u5b9a\u3057\u3001\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u3001\n\u3000\u5f66\u661f\u306f30\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3067\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u246030\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("\u30fb\u56de\u8ee2\u89d2\u3092\u5ea6\u3067\u6307\u5b9a\u3059\u308b\u5834\u5408");
        QuBasis ang30QuBasis = new QuBasis(30L);
        DJ.printF("ang30QuBasis[deg]", ang30QuBasis);
        DJ._print("\u246130\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95ang30QuBasis\u3067\u3001|0>\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6e2c\u5b9a\u3059\u308b\u3002");
        changedQuBit = QB0.basisChang(ang30QuBasis);
        DJ.printF("changedQuBit", changedQuBit);
        DJ._print("\u2462\u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092\u57fa\u5e95ang30QuBasis\u3067\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\u5404\u57fa\u5e95\u306e\u9078\u629e\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        tryalNo = 2;
        count = ang30QuBasis.countQuBasis(QB0, tryalNo);
        DJ.print("count = ", count);
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u57fa\u5e95");
        selectedQBArray = ang30QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u53e4\u5178\u30d3\u30c3\u30c8\uff1a\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u30010,1");
        clBitArray = ang30QuBasis.getClassicBit();
        DJ.print("clBitArray = ", clBitArray);
        DJ._print("\u4ee5\u4e0a\u306b\u3088\u308a\u3001P(b0_0, b1_1)\u306f\u3001\u307e\u305a\uff08\uff11\uff0d\uff14\uff09\u2461\u3088\u308a\u3001\n\u7e54\u59eb\u304cb0\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3068\u306a\u308b\u306e\u306f(1/\u221a2)^2=1/2=0.5\u3001\n\u3055\u3089\u306b\u3001\uff08\uff11\uff0d\uff16\uff09\u2462\u3088\u308a\u3001\u5f66\u661f\u304cb2\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1\u3068\u306a\u308b\u306e\u306f\u3001\n(-1/2)^2=1/4=0.25\u306a\u306e\u3067\u3001P=(1/2)*(1/4)=1/8=0.125\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.printS(2, "BellsInequality\uff08\uff11\uff0d\uff17\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff17\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u306e\uff12\u9805\u3081P(b2_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("\u3000\u7e54\u59eb\u304c30\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3067\u6e2c\u5b9a\u3057\u3001\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u3001\n\u3000\u5f66\u661f\u306f60\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3067\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u246030\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95\u3092\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3059\u308b\u3002");
        DJ.printF("ang30QuBasis[deg]", ang30QuBasis);
        QuBasis ang30_30QuBasis = ang30QuBasis.interactQuBasis(ang30QuBasis);
        DJ.printF("ang30_30QuBasis", ang30_30QuBasis);
        changedQuBit = cxhi00Bit.basisChang(ang30_30QuBasis);
        DJ.printF("changedQuBit", changedQuBit);
        DJ._print("\u2460\u91cf\u5b50\u30d3\u30c3\u30c8cxhi00Bit\u3092\u57fa\u5e95ang30_30QuBasis\u3067\u6e2c\u5b9a\u3059\u308b\u3068\u3001\n\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8quBit0\u3068\u7b2c\uff13\u91cf\u5b50\u30d3\u30c3\u30c8quBit3\u306b\u9077\u79fb\u3059\u308b\u3002\n\u3053\u306e\u3068\u304d\u306e\u9077\u79fb\u78ba\u7387\u306f( 1/\u221a2)^2=1/2\u3067\u3059\u3002");
        int basisIndex = 0;
        QuBit quBit0 = ang30_30QuBasis.getBasisQuBit(basisIndex);
        DJ.printF("quBit0", quBit0);
        DJ._print("\u30fb\u591a\u91cf\u5b50\u30d3\u30c3\u30c8quBit0\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
        checked = quBit0.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        basisIndex = 3;
        QuBit quBit1 = ang30_30QuBasis.getBasisQuBit(basisIndex);
        DJ.printF("quBit1", quBit1);
        DJ._print("\u30fb\u591a\u91cf\u5b50\u30d3\u30c3\u30c8quBit1\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
        checked = quBit1.entangleCheck();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\u2461\u5f66\u661f\u306f60\u5ea6\u56de\u8ee2\u3057\u305f\u57fa\u5e95ang60QuBasis\u3067\u3001\nang30_30QuBasis\u306e\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\n\u7b2c\uff10\u91cf\u5b50\u30d3\u30c3\u30c8quBit0_0\u3092\u6e2c\u5b9a\u3059\u308b\u3002");
        Complex pa1 = new Complex(0.5, 0.0);
        Complex pa0 = QuBit.getOtherPA(pa1);
        QuBit quBit0_0 = new QuBit(pa0, pa1);
        DJ.printF("quBit0_0", quBit0_0);
        DJ.printF("ang60QuBasis[rad]", ang60QuBasis);
        changedQuBit = quBit0_0.basisChang(ang60QuBasis);
        DJ.printF("changedQuBit", changedQuBit);
        DJ._print("\u2462\u91cf\u5b50\u30d3\u30c3\u30c8quBit0_0\u3092\u57fa\u5e95ang60QuBasis\u3067\u8907\u6570\u56de\u6e2c\u5b9a\u3057\u3001\n\u5404\u57fa\u5e95\u306e\u9078\u629e\u56de\u6570\u3068\u53e4\u5178\u30d3\u30c3\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        tryalNo = 100;
        count = ang60QuBasis.countQuBasis(quBit0_0, tryalNo);
        DJ.print("count = ", count);
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u57fa\u5e95");
        selectedQBArray = ang60QuBasis.getSelectedQuBits();
        DJ.print(QuBit.toFormat("selectedQBArray", selectedQBArray));
        DJ._print("\u9078\u629e\u3055\u308c\u305f\u53e4\u5178\u30d3\u30c3\u30c8\uff1a\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u306a\u306e\u3067\u30010,1");
        clBitArray = ang60QuBasis.getClassicBit();
        DJ.print("clBitArray = ", clBitArray);
        DJ._print("\u4ee5\u4e0a\u306b\u3088\u308a\u3001P(b2_0, b1_1)\u306f\u3001\u307e\u305a\uff08\uff11\uff0d\uff17\uff09\u2460\u3088\u308a\u3001\n\u7e54\u59eb\u304cb2\u3067\u6e2c\u5b9a\u3057\u7d50\u679c0\u3068\u306a\u308b\u306e\u306f(1/\u221a2)^2=1/2=0.5\u3001\n\u3055\u3089\u306b\u3001\uff08\uff11\uff0d\uff17\uff09\u2461\u3088\u308a\u3001\u5f66\u661f\u304cb1\u3067\u6e2c\u5b9a\u3057\u7d50\u679c\u304c1\u3068\u306a\u308b\u306e\u306f\u3001\n(-1/2)^2=1/4=0.25\u306a\u306e\u3067\u3001P=(1/2)*(1/4)=1/8=0.125\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ._print("\u3088\u3063\u3066\u3001P(b0_0, b1_1)=3/8, P(b0_0, b2_1)=P(b2_0, b1_1=1/8\n\u3068\u306a\u308a\u3001\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u3001\nP(b0_0, b1_1) <= P(b0_0, b2_1) + P(b2_0, b1_1\u306f\u7834\u3089\u308c\u307e\u3059\u3002");
        DJ.printS(3, "BellsInequality\uff08\uff12\uff09", this);
        DJ.print("\uff08\uff12\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u7834\u308c\u3092\u30b0\u30e9\u30d5\u3067\u53ef\u8996\u5316\u3059\u308b\u3002");
        DJ._print("\u30fb\u7e54\u59ebVega\u306e\u3068\u5f66\u661fAltair\u306f\u3082\u3064\u308c\u305f2\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\n\u3000\uff13\u500b\u306e\u57fa\u5e95(b0, b1, b2)\u304b\u3089\uff12\u500b\u3092\u9078\u3093\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u5148\u306b\u7e54\u59eb\u304c\u6e2c\u5b9a\u3057\u3001\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u304c\u5f8c\u304b\u3089\u6e2c\u5b9a\u3057\u307e\u3059\u3002\n\u3000\uff13\u500b\u306e\u57fa\u5e95\u3092\u89d2\u5ea6\u03b8\u3092\u5143\u306b\u5b9a\u7fa9\u3057\u3001\u03b8\u3092\uff10\uff5e\u03c0\u307e\u3067\u5909\u5316\u3055\u305b\u307e\u3059\u3002\n\u3000b0 = (0:b0_0, 1:b0_1) = (0\u03b8, 0\u03b8+\u03c0/2) \u4f8b\uff1a 0,  90deg \n  b1 = (0:b1_0, 1:b1_1) = (2\u03b8, 2\u03b8+\u03c0/2) \u4f8b\uff1a60, 150deg \n  b2 = (0:b2_0, 1:b2_1) = (1\u03b8, 1\u03b8+\u03c0/2) \u4f8b\uff1a30, 120deg \n");
        DJ.printL(2);
        DJ.print("\uff08\uff12\uff0d\uff11\uff09\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u751f\u6210\u3057\u307e\u3059");
        DJ.print("  int numOfQuBit = 2; // \u91cf\u5b50\u30d3\u30c3\u30c8\u6570");
        DJ.print("  QuBit inQuBit = QuBit.unitQuBit(numOfQuBit, 0);");
        DJ.printF("inQuBit", inQuBit);
        DJ.printL(2);
        DJ.print("\uff08\uff12\uff0d\uff12\uff09\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("\u2460H\u30b2\u30fc\u30c8\uff08Hadamard\u30b2\u30fc\u30c8\uff09\n          \u250c      \u2510 \n H = 1/\u221a2\u2502 1   1\u2502 \n          \u2502 1  -1\u2502 \n          \u2514      \u2518 ");
        DJ.print("  QuGate hadamardGate = new QuGate(QuGate.H_GATE)");
        DJ.printF("hadamardGate", hadamardGate);
        DJ.print("\u2461I\u30b2\u30fc\u30c8\uff08\u6052\u7b49\u30b2\u30fc\u30c8\uff09\n     \u250c      \u2510 \n I = \u2502 1   0\u2502 \n     \u2502 0   1\u2502 \n     \u2514      \u2518 ");
        DJ.print(" QuGate iGate = new QuGate(QuGate.I_GATE)");
        DJ.printF("iGate", iGate);
        DJ._print("\u2462H\u30b2\u30fc\u30c8\u3068I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("  HI\u30b2\u30fc\u30c8:H\u24e7I \n             \u250c     \u2510 \n H\u24e7I = 1/\u221a2\u2502 I  I\u2502 \n             \u2502 I -I\u2502 \n             \u2514     \u2518 ");
        DJ.print("  QuGate hiGate = hadamardGate.interactQuGate(iGate);");
        DJ.printF("hiGate", hiGate);
        DJ._print("\u2463CX\u30b2\u30fc\u30c8\uff08C-Not\u30b2\u30fc\u30c8\uff09\u3092\u751f\u6210\u3057\u307e\u3059\u3002\n      \u250c              \u2510 \n CX = \u2502 1   0   0   0\u2502 \n      \u2502 0   1   0   0\u2502 \n      \u2502 0   0   0   1\u2502 \n      \u2502 0   0   1   0\u2502 \n      \u2514              \u2518 ");
        DJ.print("  CX\u30b2\u30fc\u30c8\u306e\u751f\u6210\u306b\u306f\u3001\u91cf\u5b50\u30d3\u30c3\u30c8\u6570\u3001\u304a\u3088\u3073\n\u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("  int numOfBits = 2; // \u91cf\u5b50\u30d3\u30c3\u30c8\u6570");
        DJ._print("  int target = 1; // \u30bf\u30fc\u30b2\u30c3\u30c8\u91cf\u5b50\u30d3\u30c3\u30c8");
        DJ._print("  int[] controlArray = {0}; // \u5236\u5fa1\u91cf\u5b50\u30d3\u30c3\u30c8\u914d\u5217");
        DJ._print("  QuGate cxGate = new QuGate( QuGate.CX_GATE, numOfBits, target, controlArray)");
        DJ.printF("cxGate", cxGate);
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff13\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff13\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u91cf\u5b50\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\u91cf\u5b50\u30d3\u30c3\u30c8QB00\u3092\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("H\u24e7I*[1 0 0 0]'");
        DJ.print("QuBit hi00Bit = hiGate.apply(QB00);");
        DJ.printF("hi00Bit", hi00Bit);
        DJ._print("\u2461\u91cf\u5b50\u30d3\u30c3\u30c8hi00Bit\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cxGate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("CX*HI*[1 0 0 0]'");
        DJ.print("QuBit cxhi00Bit = cxGate.apply(hi00Bit);");
        DJ.printF("cxhi00Bit", cxhi00Bit);
        DJ._print("\u2462\u591a\u91cf\u5b50\u30d3\u30c3\u30c8cxhi00Bit\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a\u3059\u308b\u3002");
        DJ.print("boolean checked = cxhi00Bit.entangleCheck();");
        checked = cxhi00Bit.entangleCheck();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff14\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff14\uff09\u6e2c\u5b9a\u7528\u306e\uff13\u7a2e\u985e\u306e\u57fa\u5e95\u3092\u6c42\u3081\u307e\u3059\u3002");
        double theta = 0.5235987755982988;
        DJ._print("\u2460\u57fa\u5e95b0\u3092\u751f\u6210\u3059\u308b\u3002");
        numOfQuBit = 2;
        QuBasis b0 = new QuBasis(numOfQuBit);
        DJ.printF("b0", b0);
        DJ._print("\u2461\u57fa\u5e95b1\u3092\u751f\u6210\u3057\u307e\u3059\u3002\uff08\u56de\u8ee2\u89d2\u30922\u03b8\u3067\u6307\u5b9a\uff09");
        QuBasis theta2QuBasis = new QuBasis(theta * 2.0);
        DJ.printF("theta2QuBasis", theta2QuBasis);
        DJ.print("\u3000\u540c\u3058\u57fa\u5e95\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("  QuBasis b1 = theta2QuBasis.interactQuBasis(theta2QuBasis)");
        QuBasis b1 = theta2QuBasis.interactQuBasis(theta2QuBasis);
        DJ.printF("b1", b1);
        DJ._print("\u2462\u57fa\u5e95b2\u3092\u751f\u6210\u3057\u307e\u3059\u3002\uff08\u56de\u8ee2\u89d2\u3092\u03b8\u3067\u6307\u5b9a\uff09");
        QuBasis theta1QuBasis = new QuBasis(theta);
        DJ.printF("theta1QuBasis", theta1QuBasis);
        DJ.print("\u3000\u57fa\u5e95theta1QuBasis\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u57fa\u5e95\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("  QuBasis b2 = theta1QuBasis.interactQuBasis(theta1QuBasis)");
        QuBasis b2 = theta1QuBasis.interactQuBasis(theta1QuBasis);
        DJ.printF("b2", b2);
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff15\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff15\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5de6\u8fbaP(b0_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("\u2460\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u6a19\u6e96\u57fa\u5e95\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002\u3002");
        DJ.print("CompVec b0QuBit = cxhi00Bit.basisChang(b0);");
        CompVec b0CompVec = cxhi00Bit.basisChang(b0);
        DJ.printF("b0CompVec", b0CompVec);
        DJ._print("\u91cd\u306a\u308a\u5408\u3063\u305f\u72b6\u614b\u306e\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8|00>\u3068|11>\u306f\u3001\n(1/\u221a2)^2=1/2\u306e\u78ba\u7387\u3067\u3069\u3061\u3089\u304b\u306e\u57fa\u5e95\u306b\u9077\u79fb\u3057\u3001\n\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u306f\u89e3\u6d88\u3055\u308c\u308b\u3002");
        DJ._print("QuBit selectedQuBit = std2QuBasis.measurement(cxhi00Bit);");
        DJ.printF("selectedQuBit", selectedQuBit);
        DJ._print("QuBit QB0 = new QuBit();");
        DJ.printF("QB0", QB0);
        DJ._print("uBit QB1 = new QuBit();");
        DJ.printF("QB1", QB1);
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff16\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff16\uff09\u7e54\u59eb\u306e\u6e2c\u5b9a\u306b\u3088\u308a\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306fQB0\u306b\u9077\u79fb\u3057\u3001\n\u3000\u3082\u3064\u308c\u3066\u3044\u305f\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082QB0\u306b\u9077\u79fb\u3057\u307e\u3059\u3002\n\u3000\u3082\u3064\u308c\u304c\u89e3\u6d88\u3055\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u306f\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\u57fa\u5e95b1(theta2QuBasis)\u3067\u3001\u91cf\u5b50\u30d3\u30c3\u30c8QB0\u3092\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.printF("theta2QuBasis", theta2QuBasis);
        CompVec b01CompVec = QB0.basisChang(theta2QuBasis);
        DJ.printF("b01CompVec", b01CompVec);
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff17\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff17\uff09\u7e54\u59eb\u306e\u6e2c\u5b9a\u306b\u3088\u308a\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306fQB0\u306b\u9077\u79fb\u3057\u3001\n\u3000\u3082\u3064\u308c\u3066\u3044\u305f\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082QB0\u306b\u9077\u79fb\u3057\u307e\u3059\u3002\n\u3000\u3082\u3064\u308c\u304c\u89e3\u6d88\u3055\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u306f\u57fa\u5e95b2\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\u57fa\u5e95b2(theta1QuBasis)\u3067\u3001\u91cf\u5b50\u30d3\u30c3\u30c8QB0\u3092\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.printF("theta1QuBasis", theta1QuBasis);
        CompVec b02CompVec = QB0.basisChang(theta1QuBasis);
        DJ.printF("b02CompVec", b02CompVec);
        DJ.printS(2, "BellsInequality\uff08\uff12\uff0d\uff18\uff09", this);
        DJ.print("\uff08\uff12\uff0d\uff18\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u306e\uff12\u9805P(b2_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        DJ.print("\u3000\u7e54\u59eb\u304c\u91cf\u5b50\u30d3\u30c3\u30c8cxhi00Bit\u3092\u57fa\u5e95b2\u3067\u6e2c\u5b9a\u3057\u3001\u3001\n\u3000\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5f66\u661f\u306f\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\u7e54\u59eb\u304c\u91cf\u5b50\u30d3\u30c3\u30c8cxhi00Bit\u3092\u57fa\u5e95b2\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.printF("cxhi00Bit", cxhi00Bit);
        DJ.printF("b2", b2);
        CompVec b2CompVec = cxhi00Bit.basisChang(b2);
        DJ.printF("b2CompVec", b2CompVec);
        DJ._print("\u3000\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95b2_0QuBit\u3068\n\u3000\u7b2c\uff13\u57fa\u5e95b2_3QuBit\u306b\u9077\u79fb\u3057\u307e\u3059\u3002\n\u3000\u3053\u306e\u3068\u304d\u306e\u9077\u79fb\u78ba\u7387\u306f( 1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u2461\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u3092\n\u3000\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u3000\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u306f\u3082\u3064\u308c\u3066\u3044\u306a\u3044\u306e\u3067\u3001\n\u3000\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u76f8\u4e92\u4f5c\u7528\uff08\u30c6\u30f3\u30bd\u30eb\u7a4d\uff09\u306b\u5206\u89e3\u3067\u304d\u307e\u3059\u3002");
        basisIndex = 0;
        QuBit b2_0QuBit = b2.getBasisQuBit(basisIndex);
        DJ.printF("b2_0QuBit", b2_0QuBit);
        DJ._print("\u30fb\u591a\u91cf\u5b50\u30d3\u30c3\u30c8quBit0\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
        DJ._print("boolean checked = quBit0.entangleCheck();");
        checked = b2_0QuBit.entangleCheck();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u3092\u5358\u72ec\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u5206\u89e3\u3057\u307e\u3059\u3002");
        int paIndex = 0;
        double b2_0 = b2_0QuBit.getProbAmp(paIndex).getReal();
        Complex b2_0Pa0 = new Complex(Math.sqrt(b2_0), 0.0);
        Complex b2_0Pa1 = QuBit.getOtherPA(pa0);
        QuBit b2_QuBit = new QuBit(b2_0Pa0, b2_0Pa1);
        DJ.printF("b2_QuBit", b2_QuBit);
        DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8b2_QuBit\u3092\u57fa\u5e95b1\uff08theta2QuBasis\uff09\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.printF("theta2QuBasis", theta2QuBasis);
        CompVec b21CompVec = b2_QuBit.basisChang(theta2QuBasis);
        DJ.printF("b21_CompVec", b21CompVec);
        DJ.printS(3, "BellsInequality\uff08\uff13\uff09", this);
        DJ.print("\uff08\uff13\uff09\u03b8\u3092\u5909\u5316\u3055\u305b\u3066\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5404\u9805\u3092\u6c42\u3081\u307e\u3059\u3002");
        this.stepMode = true;
        int delta = 30;
        int iMax = 180 / delta + 1;
        DJ._print("\uff08\uff13\uff0d\uff11\uff09\u6e2c\u5b9a\u5bfe\u8c61\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ._print("\u2460\u91cf\u5b50\u30d3\u30c3\u30c8QB00\u3092\u91cf\u5b50\u30b2\u30fc\u30c8hiGate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hi00Bit = hiGate.apply(QB00);");
        hi00Bit = hiGate.apply(QB00);
        DJ.printF("hi00Bit", hi00Bit);
        DJ._print("\u2461\u91cf\u5b50\u30d3\u30c3\u30c8hi00Bit\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cxGate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit targetQuBit = cxGate.apply(hi00Bit);");
        QuBit targetQuBit = cxGate.apply(hi00Bit);
        DJ.printF("targetQuBit", targetQuBit);
        DJ._print("\uff08\uff13\uff0d\uff12\uff09\u57fa\u5e95b0\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        DJ.print("int numOfQuBit = 2; // \u91cf\u5b50\u30d3\u30c3\u30c8\u6570");
        numOfQuBit = 2;
        DJ.print("QuBasis b0_b0QuBasis = new QuBasis(numOfQuBit); // \u57fa\u5e95b0_b0");
        QuBasis b0_b0QuBasis = new QuBasis(numOfQuBit);
        DJ.printF("b0_b0QuBasis", b0_b0QuBasis);
        DJ.print("\u3000\u7e54\u59eb\u304c\u5bfe\u8c61\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u57fa\u5e95b0_b0\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        DJ.print("CompVec b0_b0CompVec = targetQuBit.basisChang(b0_b0QuBasis);");
        CompVec b0_b0CompVec = targetQuBit.basisChang(b0_b0QuBasis);
        DJ.printF("b0_b0CompVec", b0_b0CompVec);
        DJ.print("\u3000\u57fa\u5e95b0_b0\u306e\u7b2c\uff10,\uff11\u9805\u3001\u306b\u9077\u79fb\u3059\u308b\u78ba\u7387\u306f\u5171\u306b(1/\u221a2)^2=1/2\u3067\u3059\u3002");
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u304c\u89e3\u6d88\u3055\u308c\u3001\u9077\u79fb\u3057\u305f\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8|00>\u3068|11>\u306e\n|00>\u304b\u3089\uff12\u500b\u306e\u5358\u72ec\u306e\u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092\u53d6\u308a\u51fa\u3059\u3002\n\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u4e00\u65b9\u3092\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3059\u308b\u3002");
        QuBit b00QuBit = new QuBit();
        DJ.printF("b00QuBit", b00QuBit);
        DJ._print("\uff08\uff13\uff0d\uff13\uff09\u7e70\u308a\u8fd4\u3057\u8a08\u7b97\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        for (int i = 0; i < iMax; ++i) {
            DJ._print_("######## \u7e70\u308a\u8fd4\u3057\uff1ai=", i);
            int angle = i * delta;
            DJ.print_(", angle[deg]=", angle);
            theta = Math.PI * (double)angle / 180.0;
            DJ.printF_(", theta[rad]=", theta);
            DJ.print(" ########");
            DJ._print("\u30fb\u57fa\u5e95b1\u3092\u751f\u6210\u3057\u307e\u3059\u3002\uff08\u56de\u8ee2\u89d2\u30922\u03b8\u3067\u6307\u5b9a\uff09");
            QuBasis b1QuBasis = new QuBasis(theta * 2.0);
            DJ.printF("b1QuBasis", b1QuBasis);
            DJ.print("  QuBasis b1_b1QuBasis = b1QuBasis.interactQuBasis(b1QuBasis)");
            QuBasis b1_b1QuBasis = b1QuBasis.interactQuBasis(b1QuBasis);
            DJ.printF("b1_b1QuBasis", b1_b1QuBasis);
            DJ._print("\u30fb\u57fa\u5e95b2\u3092\u751f\u6210\u3057\u307e\u3059\u3002\uff08\u56de\u8ee2\u89d2\u3092\u03b8\u3067\u6307\u5b9a\uff09");
            QuBasis b2QuBasis = new QuBasis(theta);
            DJ.printF("b2QuBasis", b2QuBasis);
            DJ.print("  QuBasis b2_b2QuBasis = b2QuBasis.interactQuBasis(b2QuBasis)");
            QuBasis b2_b2QuBasis = b2QuBasis.interactQuBasis(b2QuBasis);
            DJ.printF("b2_b2QuBasis", b2_b2QuBasis);
            DJ._print("\u30fb\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5de6\u8fbaP(b0_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
            DJ.print("\u3000\u5f66\u661f\u304c\u91cf\u5b50\u30d3\u30c3\u30c8b00QuBit\u3092\u57fa\u5e95b1QuBasis\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
            CompVec b0b1CompVec = b00QuBit.basisChang(b1QuBasis);
            DJ.printF("b0b1CompVec", b0b1CompVec);
            DJ.print("\u3000\u7b2c\uff12\u78ba\u7387\u632f\u5e45\u3088\u308a\u78ba\u7387\u306f(-\u221a3/2)^2 = 3/4");
            DJ.print("\u3000\u3088\u3063\u3066\u3001\u5de6\u8fbaP(b0_0, b1_1) = 1/2 * 3/4 = 3/8");
            DJ._print("\u30fb\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff11\u9805P(b0_0, b2_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
            DJ.print("\u3000\u5f66\u661f\u304c\u91cf\u5b50\u30d3\u30c3\u30c8b00QuBit\u3092\u57fa\u5e95b2QuBasis\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
            CompVec b0b2CompVec = b00QuBit.basisChang(b2QuBasis);
            DJ.printF("b0b2CompVec", b0b2CompVec);
            DJ.print("\u3000\u7b2c\uff12\u78ba\u7387\u632f\u5e45\u3088\u308a\u78ba\u7387\u306f(-1/2)^2 = 1/4");
            DJ.print("\u3000\u3088\u3063\u3066\u3001\u53f3\u8fba\u7b2c\uff11\u9805P(b0_0, b2_1) = 1/2 * 1/4 = 1/8");
            DJ._print("\u30fb\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff11\u9805P(b2_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
            DJ._print("\u2460\u7e54\u59eb\u304c\u91cf\u5b50\u30d3\u30c3\u30c8targetQuBit\u3092\u57fa\u5e95b2_b2QuBasis\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
            DJ.printF("targetQuBit", targetQuBit);
            DJ.printF("b2_b2QuBasis", b2_b2QuBasis);
            CompVec b2_b2CompVec = targetQuBit.basisChang(b2_b2QuBasis);
            DJ.printF("b2_b2CompVec", b2_b2CompVec);
            DJ._print("\u3000\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95b2_0QuBit\u3068\n\u3000\u7b2c\uff13\u57fa\u5e95b2_3QuBit\u306b\u9077\u79fb\u3057\u307e\u3059\u3002\n\u3000\u3053\u306e\u3068\u304d\u306e\u9077\u79fb\u78ba\u7387\u306f( 1/\u221a2)^2=1/2\u3067\u3059\u3002");
            DJ._print("\u2461\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u3092\n\u3000\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
            DJ._print("\u3000\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u306f\u3082\u3064\u308c\u3066\u3044\u306a\u3044\u306e\u3067\u3001\n\u3000\uff12\u500b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u76f8\u4e92\u4f5c\u7528\uff08\u30c6\u30f3\u30bd\u30eb\u7a4d\uff09\u306b\u5206\u89e3\u3067\u304d\u307e\u3059\u3002");
            basisIndex = 0;
            DJ._print("  QuBit b2_0QuBit = b2_b2CompVec.getBasisQuBit(basisIndex);");
            b2_0QuBit = b2_b2QuBasis.getBasisQuBit(basisIndex);
            DJ.printF("b2_0QuBit", b2_0QuBit);
            DJ._print("\u30fb\u591a\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a");
            DJ.print("boolean checked = b2_0QuBit.entangleCheck();");
            checked = b2_0QuBit.entangleCheck();
            DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
            DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u3092\u5358\u72ec\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u5206\u89e3\u3057\u307e\u3059\u3002");
            Complex b2_0Comp = b2_0QuBit.getProbAmp(0);
            double b2_0Pa0Real = b2_0Comp.getReal();
            Complex b2_0Pa0Comp = new Complex(Math.sqrt(b2_0Pa0Real), 0.0);
            Complex b2_0Pa1Comp = QuBit.getOtherPA(b2_0Pa0Comp);
            QuBit b2QuBit = new QuBit(b2_0Pa0Comp, b2_0Pa1Comp);
            DJ.printF("b2QuBit", b2QuBit);
            DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8b2QuBit\u3092\u57fa\u5e95b1\uff08b1QuBasis\uff09\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
            DJ.printF("b1QuBasis", b1QuBasis);
            CompVec b2b1CompVec = b2QuBit.basisChang(b1QuBasis);
            DJ.printF("b2b1CompVec", b2b1CompVec);
            DJ._print("\u30fb\u6e2c\u5b9a\u7d50\u679c\u3092\u307e\u3068\u3081\u307e\u3059\u3002");
            DJ.print_("\u3000i=", i);
            DJ.print_(", angle[deg]=", angle);
            DJ.printF(", theta[rad]=", theta);
            double b0_0Pa = b0_b0CompVec.getComp(0).getReal();
            double b0_0Prob = b0_0Pa * b0_0Pa;
            double b0b1Pa = b0b1CompVec.getComp(1).getReal();
            double b0_1Prob = b0b1Pa * b0b1Pa;
            double b0b1Prob = b0_0Prob * b0_1Prob;
            DJ.printF("\u30fb\u5de6\u8fba\u78ba\u7387 P(b0_0, b1_1)=", b0b1Prob);
            double b0b2Pa = b0b2CompVec.getComp(1).getReal();
            double b0_2Prob = b0b2Pa * b0b2Pa;
            double b0b2Prob = b0_0Prob * b0_2Prob;
            DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff11\u9805\u78ba\u7387 P(b0_0, b2_1)=", b0b2Prob);
            double b2_0Pa = b2_b2CompVec.getComp(0).getReal();
            double b2_0Prob = b2_0Pa * b2_0Pa;
            double b2b1Pa = b2b1CompVec.getComp(1).getReal();
            double b1_1Prob = b2b1Pa * b2b1Pa;
            double b2b1Prob = b2_0Prob * b1_1Prob;
            DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff11\u9805\u78ba\u7387 P(b2_0, b1_1)=", b2b1Prob);
            DJ.printF("\u30fb\u53f3\u8fba\u306e\u5408\u8a08 =", b0b2Prob + b2b1Prob);
            DJ.printS(3, "BellsInequality", this);
        }
        DJ._print("##### \u7e70\u308a\u8fd4\u3057\u8a08\u7b97\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f #####");
        DJ.printL(2);
        DJ._print("\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5b8c\u4e86");
        DJ.print("BellsInequality.bellInequality() ===========================");
    }
}

