/*
 * Decompiled with CFR 0.152.
 */
package task.qu.aug;

import java.util.ArrayList;
import quan.QuBasis;
import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompVec;
import util.comp.Complex;

public class QuTeleport
extends Task {
    int epoch = 6;
    int interval = 1;
    int dataNum = 200;
    int delta = 30;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Quantum Teleportation", 6, this.patternData1, "Quantum Teleportation");
        this.stepMode = true;
        this.quantumTeleportation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quantumTeleportation() {
        int _f;
        DJ._print("QuantumTeleportation.quantumTeleportation() ==================");
        DJ.print("\u25a0\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\uff1aQuantum Teleportation");
        DJ.print("\u3000\u91cf\u5b50\u72b6\u614b\u3092\u8ee2\u9001\u3059\u308b\u6280\u8853");
        DJ.print("\uff08\uff11\uff09\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3");
        DJ.print("\uff08\uff12\uff09\u516c\u958b\u9375\u6697\u53f7\u901a\u4fe1\u306e\u30d7\u30ed\u30b0\u30e9\u30e0");
        DJ.print("\uff08\uff13\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f");
        DJ.print("\uff08\uff14\uff09\u6e2c\u5b9a\u7528\u57fa\u5e95\u89d2\u5ea6\u03b8\u3092\u5909\u5316\u3055\u305b\u3066\u3001\u78ba\u7387\u3092\u30b0\u30e9\u30d5\u8868\u793a");
        DJ._print("\u30fb\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306f\u91cf\u5b50\u3082\u3064\u308c (Quantum entanglement)\u3068\n\u3000\u53e4\u5178\u7684\u306a\u60c5\u5831\u4f1d\u9054\u624b\u6bb5\u3092\u8907\u5408\u7684\u306b\u5229\u7528\u3057\u3066\u884c\u308f\u308c\u307e\u3059\u3002");
        DJ._print("\u30fb\u91cf\u5b50\u3082\u3064\u308c\u306e\u95a2\u4fc2\u306b\u3042\u308b2\u3064\u306e\u7c92\u5b50\u306e\u3046\u3061\u4e00\u65b9\u306e\u72b6\u614b\u3092\u89b3\u6e2c\u3059\u308b\u3068\n\u3000\u89b3\u6e2c\u3068\u540c\u6642\u306b\u96e2\u308c\u305f\u4f4d\u7f6e\u306b\u3042\u308b\u3082\u3046\u4e00\u65b9\u306e\u7c92\u5b50\u306e\u72b6\u614b\u304c\u78ba\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u72b6\u614b\u306e\u78ba\u5b9a\u306f\u3082\u3064\u308c\u305f\u91cf\u5b50\u304c\u3069\u3093\u306a\u306b\u96e2\u308c\u3066\u3044\u3066\u3082\u77ac\u6642\u306b\u4f1d\u308f\u308b\u3053\u3068\u304c\u3001\n\u3000\u5b9f\u9a13\u306b\u3088\u308a\u8a3c\u660e\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5149\u306e\u901f\u3055\u3092\u8d85\u8d8a\u3057\u3066\u3044\u308b\u3053\u306e\u73fe\u8c61\u306f\u3001\n\u3000\u76f8\u5bfe\u8ad6\u7684\u306a\u5c40\u6240\u6027\u3092\u7834\u308b\u305f\u3081\u3001\u91cf\u5b50\u529b\u5b66\u306b\u304a\u3051\u308b\u975e\u5c40\u6240\u6027\u3068\u547c\u3070\u308c\u3066\u3044\u307e\u3059\u3002");
        DJ._print("\u30fb\u30bf\u30b9\u30af\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print("\u3000\u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570\uff1aepoch = ", this.epoch);
        DJ.print("\u3000\u7d4c\u904e\u8868\u793a\u9593\u9694\uff1ainterval = ", this.interval);
        DJ.print("\u3000\u5b66\u7fd2\u30c7\u30fc\u30bf\u6570\uff1adataNum = ", this.dataNum);
        DJ.print("\u30fb\u91cf\u5b50\u8a08\u7b97\u306e\u30d1\u30e9\u30e1\u30fc\u30bf");
        DJ.print("\u3000\u57fa\u5e95\u89d2\u5ea6\u306e\u5897\u5206\uff08\u5ea6\uff09\uff1adelta = ", this.delta);
        DJ.printS(3, "QuantumTeleportation\uff08\uff11\uff09", this);
        DJ._print("\uff08\uff11\uff09\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3");
        DJ._print("\u30fb\u7e54\u59ebVega\u306f\u30e1\u30c3\u30bb\u30fc\u30b8\uff08\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b\uff09\u3092\u3001\u3000\u5f66\u661fAltair\u306b\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u3067\u9001\u308a\u307e\u3059\u3002\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u305f\u3063\u305f\uff11\u500b\u3067\u3082\u7121\u9650\u306e\u72b6\u614b\u3092\u8868\u3059\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\n\u3000\u3042\u3089\u304b\u3058\u3081\u3082\u3064\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u5404\u3005\u3092\u53cc\u65b9\u304c\u6301\u3064\u3053\u3068\u306b\u3088\u308a\u3001\n\u3000\uff14\u72b6\u614b\u3057\u304b\u8868\u305b\u306a\u3044\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u3001\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u9001\u4fe1\u3067\u304d\u307e\u3059\u3002");
        DJ._print("\uff08\uff11\uff0d\uff11\uff09\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u3092\u5b9f\u73fe\u3059\u308b\u91cf\u5b50\u56de\u8def");
        DJ._print("\u30fb\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306fH\u30b2\u30fc\u30c8(Hadamard Gate)\u3068\u3001\n\u3000C-Not\u30b2\u30fc\u30c8(CX Gate)\u3001X\u30b2\u30fc\u30c8\u3001Z\u30b2\u30fc\u30c8\u3001                \n\u3000\u304a\u3088\u3073\u3001\u6e2c\u5b9a\u30b2\u30fc\u30c8M1\u3001M2\u3067\u69cb\u6210\u3055\u308c\u307e\u3059\u3002                \n\u3000                                                        \n  sQB:\u7e54\u59eb\u304c\u5f66\u661f\u306b\u9001\u308a\u305f\u3044\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b                \n      |S> = s0PA|0> + s1PA|1>  = s0PA[1 0]' + s1PA[0 1]'  \n  vQB:\u7e54\u59eb\u306e\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8  |0> = [1 0]'                  \n  aQB:\u5f66\u661f\u306e\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8  |0> = [1 0]'                  ");
        DJ._print("           \u250c-\u2510\u250c-\u2510  \u250c-\u2510\u250c-\u2510  \u250c\u2500\u2510                 \nsQB = |S>\u2500\u2524I\u251c\u2524I\u251c\u2500\u2524C\u251c\u2524H\u251c\u2500\u2524M1\u251d\u2501\u2501\u2501\u2501\u2513       \n           \u251c-\u2524\u251c-\u2524  \u2502|\u2502\u251c-\u2524  \u251c\u2500\u2524        \u2503       \nvQB = |0>\u2500\u2524H\u251c\u2524C\u251c\u2500\u2524X\u251c\u2524I\u251c\u2500\u2524M2\u251d\u2501\u2513    \u2503       \n           \u251c-\u2524\u2502|\u2502  \u251c-\u2524\u251c-\u2524  \u2514\u2500\u2518\u250c\u2538\u2510\u250c\u2538\u2510     \naQB = |0>\u2500\u2524I\u251c\u2524X\u251c\u2500\u2524I\u251c\u2524I\u251c\u2500\u2500\u2500\u2500\u2524X \u251c\u2524Z \u251c\u2500   \n           \u2514-\u2518\u2514-\u2518  \u2514-\u2518\u2514-\u2518        \u2514\u2500\u2518\u2514\u2500\u2518     \n\u3000       P0    P1    P2    P3    P4     P5                \n\u3000                                                        \n\u3000\u203b\u592a\u3044\u7dda\u306f\u53e4\u5178\u30d3\u30c3\u30c8\u306b\u3088\u308b\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u3092\u8868\u3057\u307e\u3059\u3002      ");
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff12\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff12\uff09P0:\u521d\u671f\u5024\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        DJ._print("\u30fb\u7e54\u59eb\u306f\u5f66\u661f\u306b\u9001\u308a\u305f\u3044\u91cf\u5b50\u72b6\u614b\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068\u3001\n\u3000\u521d\u671f\u5024|0>\u306e\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3092\u7528\u610f\u3057\u307e\u3059\u3002\n\u3000\u5f66\u661f\u3082\u91cf\u5b50\u72b6\u614b\u3092\u53d7\u4fe1\u3059\u308b\u305f\u3081\u521d\u671f\u5024|0>\u306e\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        double pi = Math.PI;
        int sDeg = 30;
        double sRad = Math.cos(pi * (double)sDeg / 180.0);
        Complex s0PA = new Complex(sRad, 0.0);
        DJ.print_("s0PA", s0PA);
        Complex s1PA = QuBit.getOtherPA(s0PA);
        DJ.print(", s1PA", s1PA);
        DJ.print("QuBit sQB = new QuBit(s0PA, s1PA);");
        QuBit sQB = new QuBit(s0PA, s1PA);
        DJ.printF("sQB", sQB);
        QuBit vQB = new QuBit();
        DJ.printF("vQB", vQB);
        QuBit aQB = new QuBit("std0QuBit");
        DJ.printF("aQB", aQB);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff13\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff13\uff09\u7e54\u59eb\u3068\u5f66\u661f\u306f\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3068aQB\u3092\u3082\u3064\u308c\u3055\u305b\u307e\u3059\u3002");
        DJ.print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u3082\u3064\u308c\u3055\u305b\u308b\u305f\u3081\u306bH\u30b2\u30fc\u30c8\uff08\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30b2\u30fc\u30c8\uff09\u3068\n\u3000CX\u30b2\u30fc\u30c8\uff08\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebNOT\u30b2\u30fc\u30c8\uff09\u3092\u4f7f\u3044\u307e\u3059\u3002");
        DJ._print("\u2460H\u30b2\u30fc\u30c8\uff08\u30a2\u30c0\u30de\u30fc\u30eb\u30fb\u30b2\u30fc\u30c8\uff09");
        QuGate hGate = new QuGate("H_GATE");
        DJ.printF("hGate", hGate);
        DJ._print("\u2461P1:\u91cf\u5b50\u30d3\u30c3\u30c8vQB\u3092H\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hV = hGate.apply(vQB);");
        QuBit hvQB = hGate.apply(vQB);
        DJ.printF("hvQB", hvQB);
        DJ._print("\u2462\u91cf\u5b50\u30d3\u30c3\u30c8hvQB\u306bCX\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b\u305f\u3081\u3001\u91cf\u5b50\u30d3\u30c3\u30c8hvQB\u3068\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3068\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hv_aQB = hvQB.interactQuBit(aQB);");
        QuBit hv_aQB = hvQB.interactQuBit(aQB);
        DJ.printF("hv_aQB", hv_aQB);
        DJ._print("\u2463CX\u30b2\u30fc\u30c8\uff08\u30b3\u30f3\u30c8\u30ed\u30fc\u30ebNOT\u30b2\u30fc\u30c8\uff09");
        int numOfBit = 2;
        int target = 1;
        int[] control = new int[]{0};
        QuGate cxGate = new QuGate("CX_GATE", numOfBit, target, control);
        DJ.printF("cxGate = ", cxGate);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff13\uff09\u2464", this);
        DJ._print("\u2464P2:\uff12\u91cf\u5b50\u30d3\u30c3\u30c8hv_aQB\u3092CX\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit hv_aQB = cxGate.apply(hv_aQB);");
        QuBit cxHv_aQB = cxGate.apply(hv_aQB);
        DJ.printF("cxHv_aQB", cxHv_aQB);
        DJ._print("\u2465\u591a\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a\u3057\u307e\u3059\u3002");
        boolean checked = cxHv_aQB.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff14\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff14\uff09\u7e54\u59eb\u306f\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068cx_hvaQB\u3092\u9006\u30d9\u30eb\u56de\u8def\u306b\u9069\u7528");
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068cx_hvaQB\u3092CX\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3082\u3064\u308c\u3092\u89e3\u6d88\u3055\u305b\u307e\u3059\u3002");
        DJ._print("\u2460\u91cf\u5b50\u30d3\u30c3\u30c8cxHv_aQBB\u3092CX\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3059\u308b\u305f\u3081\u3001\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        QuBit s_v_aQB = sQB.interactQuBit(cxHv_aQB);
        DJ.printF("s_v_aQB", s_v_aQB);
        DJ._print("\u2461I\u30b2\u30fc\u30c8\u3092CX\u30b2\u30fc\u30c8\u306b\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30b2\u30fc\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        QuGate iGate = new QuGate("I_GATE");
        DJ.printF("iGate", iGate);
        DJ.print("QuGate cx_iGate = cxGate.interactQuGate(iGate);");
        QuGate cx_iGate = cxGate.interactQuGate(iGate);
        DJ.printF("cx_iGaet", cx_iGate);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff14\uff09\u2462", this);
        DJ._print("\u2462P3:\u91cf\u5b50\u30d3\u30c3\u30c8s_v_aQB\u3092CX_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        QuBit cXsvaQB = cx_iGate.apply(s_v_aQB);
        DJ.printF("cXsvaQB = ", cXsvaQB);
        DJ._print("\u2463\u591a\u91cf\u5b50\u30d3\u30c3\u30c8cxIsvaQB\u306e\u3082\u3064\u308c\u72b6\u614b\u3092\u5224\u5b9a\u3057\u307e\u3059\u3002");
        checked = cXsvaQB.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\u2464\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u5358\u4f4d\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        int numOfQuBit = 2;
        DJ.print("QuGate i_iGate = new QuGate(numOfQuBit); // numOfQuBit=2");
        QuGate i_iGate = new QuGate(numOfQuBit);
        DJ.printF("i_iGate", i_iGate);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff14\uff09\u2465", this);
        DJ._print("\u2465H\u30b2\u30fc\u30c8\u306bI_I\u30b2\u30fc\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u3001\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u62e1\u5f35\u3057\u307e\u3059\u3002");
        DJ.print("QuGate h_i_iGate = hGate.interactQuGate(i_iGate);");
        QuGate h_i_iGate = hGate.interactQuGate(i_iGate);
        DJ.printF("h_i_iGate", h_i_iGate);
        DJ._print("\u2466P4:\u91cf\u5b50\u30d3\u30c3\u30c8cxIsvaQB\u3092H_I_I\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuGate hcXsvaQB = h_i_iGate.apply(cxsvaQB)");
        QuBit hcXsvaQB = h_i_iGate.apply(cXsvaQB);
        DJ.printF("hcXsvaQB", hcXsvaQB);
        DJ.printS(3, "QuantumTeleportation\uff08\uff11\uff0d\uff15\uff09", this);
        DJ.print("\uff08\uff11\uff0d\uff15\uff09\u7e54\u59eb\u306f\u81ea\u5206\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u3068vQB\u3092\u6e2c\u5b9a\u3057\u3001\n\u3000\u7d50\u679c\u3092\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u3067\u5f66\u661f\u306b\u9001\u308a\u307e\u3059\u3002");
        DJ.print("\u3000\u5f66\u661f\u306f\u7e54\u59eb\u304b\u3089\u9001\u3089\u308c\u305f\uff12\u500b\u306e\u53e4\u5178\u30d3\u30c3\u30c8\u306b\u5f93\u3063\u3066\u81ea\u5206\u306e\n\u3000\u91cf\u5b50\u30d3\u30c3\u30c8aQB\u3092\u51e6\u7406\u3057\u3001\u7e54\u59eb\u306e\u91cf\u5b50\u30d3\u30c3\u30c8sQB\u306e\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002");
        DJ._print("\u2460H\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8hcXsvaQB\u306f\u4ee5\u4e0b\u306e\u3088\u3046\u306b\u5909\u5f62\u3055\u308c\u3001\n\u3000\uff14\u9805\u306b\u5206\u304b\u308c\u307e\u3059\u3002\u5404\u9805\u306e\u6700\u521d\u306e\uff12\u500b\u306e\u7e54\u59eb\u306e2\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u3001\n\u3000\u6e2c\u5b9a\u30b2\u30fc\u30c8M0\u3001M1\u3067\u6e2c\u5b9a\u3057\u305f\u7d50\u679c\u306f\u3001\u5404\u3005\u78ba\u7387\uff081/2)^2=1/4\u3067\n\u300000\u300101\u300110\u300111\u306e\u3044\u305a\u308c\u304b\u306b\u306a\u308a\u307e\u3059\u3002");
        DJ.print("hcXsvaQB  \u250c \u2510  \u250c \u2510         \u250c \u2510     \u250c \u2510    \n   = 1/2 (\u25021\u2502\u24e7\u25021\u2502\u24e7 (\u221a3/2\u25021\u2502+ 1/2\u25020\u2502)   \n          \u25020\u2502  \u25020\u2502         \u25020\u2502     \u25021\u2502    \n          \u2514 \u2518  \u2514 \u2518         \u2514 \u2518     \u2514 \u2518    \n          \u250c \u2510  \u250c \u2510        \u250c \u2510       \u250c \u2510   \n        + \u25021\u2502\u24e7\u25020\u2502\u24e7 ( 1/2\u25021\u2502+ \u221a3/2\u25020\u2502)  \n          \u25020\u2502  \u25021\u2502        \u25020\u2502       \u25021\u2502   \n          \u2514 \u2518  \u2514 \u2518        \u2514 \u2518       \u2514 \u2518   \n          \u250c \u2510  \u250c \u2510         \u250c \u2510     \u250c \u2510    \n        + \u25020\u2502\u24e7\u25021\u2502\u24e7 (\u221a3/2\u25021\u2502- 1/2\u25020\u2502)   \n          \u25021\u2502  \u25020\u2502         \u25020\u2502     \u25021\u2502    \n          \u2514 \u2518  \u2514 \u2518         \u2514 \u2518     \u2514 \u2518    \n          \u250c \u2510  \u250c \u2510        \u250c \u2510       \u250c \u2510   \n        + \u25020\u2502\u24e7\u25020\u2502\u24e7 (-1/2\u25021\u2502+ \u221a3/2\u25020\u2502)) \n          \u25021\u2502  \u25021\u2502        \u25020\u2502       \u25021\u2502   \n          \u2514 \u2518  \u2514 \u2518        \u2514 \u2518       \u2514 \u2518   ");
        DJ._print("\u3000\u5404\u9805\u306e\uff13\u500b\u76ee\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u3059\u3002\n\u3000\u7e54\u59eb\u304c\u6e2c\u5b9a\u3059\u308b\u3068\u540c\u6642\u306b\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3082\u9077\u79fb\u3057\u3001\u78ba\u5b9a\u3057\u307e\u3059\u3002\n\u3000\u5168\u4f53\u304c1/2\u3067\u62ec\u3089\u308c\u3066\u3044\u308b\u306e\u306f\u3001\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u78ba\u7387\u3001\u3059\u306a\u308f\u3061\u3001\n\u3000\u78ba\u7387\u632f\u5e45\u306e\u81ea\u4e57\u306e\u548c\u304c\uff11\u306b\u306a\u308b\u3088\u3046\u306b\u3059\u308b\u305f\u3081\u3067\u3059\u3002\n\u3000\u4f8b\u3048\u3070\uff11\u9805\u76ee\u3067\u306f\u3001(\u221a3/2)^2 + (1/2)^2 = 3/4 + 1/4 = 1\u3068\u306a\u308a\u307e\u3059\u3002");
        DJ._print("\u3000\u5404\u9805\u306e\uff13\u500b\u76ee\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u53d6\u308a\u51fa\u3057\u3001\n\u3000\u5168\u4f53\u30921/2\u3067\u62ec\u308b\u305f\u3081\u3001\uff12\u500d\u3057\u307e\u3059\u3002");
        CompVec probAmpVec = hcXsvaQB.copyProbAmpVec();
        probAmpVec.product(2.0);
        QuBit[] aQBArray = new QuBit[4];
        for (int i = 0; i < 4; ++i) {
            aQBArray[i] = new QuBit(probAmpVec.getComp(i * 2), probAmpVec.getComp(i * 2 + 1));
            String term = Integer.toBinaryString(i);
            if (i < 2) {
                term = "0" + term;
            }
            DJ.printF("aQBArray[" + term + "] = ", aQBArray[i]);
        }
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff15\uff09\u2461", this);
        DJ._print("\u2461\uff11\u9805\u76ee\u306e\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c00\u306e\u5834\u5408\u306b\u306f\u3001\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u306f\n\u3000\u7e54\u59eb\u304c\u9001\u308a\u305f\u3044\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b|S>\u306b\u4e00\u81f4\u3057\u307e\u3059\u3002\n                                   \n    |S> = s0PA|0> + s1PA|1>        \n        = s0PA[1 0]' + s1PA[0 1]'  \n        = [0.86603+0i  0.5+0i]'    \n        = [\u221a3/2  1/2]'            \n                                   \n\u3000\u5f93\u3063\u3066\u3001\u5f66\u661f\u306f\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u5fa9\u5143\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        DJ._print("\u3000\u3057\u304b\u3057\u3001\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c\uff12\u9805\u76ee\u4ee5\u964d\u306e01\u300110\u300111\u306e\u5834\u5408\u306b\u306f\u3001\n\u3000\u5f66\u661f\u306f\u4ee5\u4e0b\u306e\u3088\u3046\u306b\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002");
        DJ._print("\u2461\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c01\u306e\u5834\u5408");
        DJ._print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        String term = "01";
        DJ.printF("aQBArray[" + term + "] = ", aQBArray[1]);
        QuGate xGate = new QuGate("X_GATE");
        DJ.printF("xGate", xGate);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b01]);");
        QuBit _aQB = xGate.apply(aQBArray[1]);
        DJ.printF("_aQB", _aQB);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff15\uff09\u2462", this);
        DJ._print("\u2462\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c10\u306e\u5834\u5408");
        DJ._print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        term = "10";
        DJ.printF("aQBArray[" + term + "] = ", aQBArray[2]);
        QuGate zGate = new QuGate("Z_GATE");
        DJ.printF("zGate", zGate);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = zGate.apply(aQBArray[0b10]);");
        _aQB = zGate.apply(aQBArray[2]);
        DJ.printF("_aQB", _aQB);
        DJ._print("\u2463\u7e54\u59eb\u306e\u6e2c\u5b9a\u7d50\u679c\u304c11\u306e\u5834\u5408");
        DJ._print("\u3000\u5f66\u661f\u306e\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u3001Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u3001\u72b6\u614b\u3092\u5fa9\u5143\u3057\u307e\u3059\u3002\n");
        term = "11";
        DJ.printF("aQBArray[" + term + "] = ", aQBArray[3]);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092X\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b11]);");
        _aQB = xGate.apply(aQBArray[3]);
        DJ._print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8\u3092Z\u30b2\u30fc\u30c8\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        DJ.print("QuBit _aQB = zGate.apply(_aQB);");
        _aQB = zGate.apply(_aQB);
        DJ.printF("_aQB", _aQB);
        this.stepMode = true;
        DJ._print("");
        DJ._print("\u30fb\u4ee5\u4e0a\u3067\u91cf\u5b50\u30c6\u30ec\u30dd\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u7d42\u308f\u308a\u3067\u3059\u3002");
        DJ.printS(3, "QuantumTeleportation", this);
        DJ._print("\uff08\uff12\uff09\u516c\u958b\u9375\u6697\u53f7\u901a\u4fe1\u306e\u30d7\u30ed\u30b0\u30e9\u30e0");
        DJ._print("\uff08\uff12\uff0d\uff11\uff09\u5f66\u661f\u306f\u7d20\u6570\u3092\u4f7f\u3063\u3066\u65bd\u9320\u9375\u3068\u958b\u9320\u9375\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        DJ.print("\u2460\uff12\u500b\u306e\u5927\u304d\u306a\u7d20\u6570p\u3068q\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        int p = 3;
        int q = 5;
        DJ.print_("p = ", p);
        DJ.print(", q = ", q);
        DJ._print("\u2461\u65bd\u9320\u9375 m = p * q \u3092\u6c42\u3081\u307e\u3059\u3002");
        int m = p * q;
        DJ.print("m = ", m);
        DJ._print("\u2462\u65bd\u9320\u9375\u306e\u4e0a\u9650 l = (p - 1)(q - 1) \u3092\u6c42\u3081\u307e\u3059\u3002");
        int l = (p - 1) * (q - 1);
        DJ.print("l = ", l);
        DJ._print("\u2463\u7d20\u6570\u30ea\u30b9\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        ArrayList<Integer> primeList = this.prime(m);
        DJ._printList("Primes:", primeList);
        DJ._print("\u2464\u65bd\u9320\u9375\uff08\u7d20\u6570\uff09f (< l) \u3092\u6c42\u3081\u307e\u3059\u3002");
        int f = 0;
        for (int i = 3; i < m && (_f = primeList.get(i).intValue()) < l; ++i) {
            f = _f;
        }
        DJ.print("f = ", f);
        DJ._print("\u2465\u958b\u9320\u9375 d \u3092\u6c42\u3081\u307e\u3059\u3002ed mod(l) = 1");
        int r = 0;
        int d = 0;
        int k = 0;
        for (k = 0; k < f; ++k) {
            r = (l * k + 1) % f;
            if (r != 0) continue;
            d = (l * k + 1) / f;
            break;
        }
        DJ.print_("k = ", k);
        DJ.print_(", d = ", d);
        DJ.print(", r = ", r);
        DJ._print("\uff08\uff11\uff0d\uff13\uff09\u7e54\u59eb\u306f\u5f66\u661f\u306e\u65bd\u9320\u9375\u3067\u60c5\u5831\u3092\u6697\u53f7\u5316\u3057\u3001\u5f66\u661f\u306b\u9001\u308a\u307e\u3059\u3002");
        DJ.print("\u2460\u9001\u4fe1\u3059\u308b\u30e1\u30c3\u30bb\u30fc\u30b8 message\uff08\u6574\u6570\u5024\uff09\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        int message = 3;
        DJ.print("message = ", message);
        DJ._print("\u2461\u65bd\u9320\u9375 m \u3068 f \u3092\u4f7f\u3063\u3066\u6697\u53f7\u5316 c \u3057\u307e\u3059\u3002 c = message^f mod(m) ");
        int pow_mf = (int)Math.pow(message, f);
        DJ.print_("message^f = ", pow_mf);
        int c = pow_mf % m;
        DJ.print(", c = ", c);
        DJ._print("\uff08\uff12\uff0d\uff12\uff09\u5f66\u661f\u306f\u958b\u9320\u9375\u3067\u7e54\u59eb\u304b\u3089\u9001\u3089\u308c\u305f\u60c5\u5831\u3092\u89e3\u8aad\u3057\u307e\u3059\u3002");
        DJ.print("\u3000\u65bd\u9320\u9375 m \u3068\u958b\u9320\u9375 d \u3067\u89e3\u8aad\u3057\u307e\u3059\u3002 decoded = c^d mod(m) ");
        int pow_cd = (int)Math.pow(c, d);
        DJ.print_("c^d = ", pow_cd);
        int decoded = pow_cd % m;
        DJ.print(", decoded = ", decoded);
        DJ._print("\u3000\u7e54\u59eb\u304b\u3089\u306e\u60c5\u5831\u306f\u89e3\u8aad\u3055\u308c\u307e\u3057\u305f\u3002message = decoded = ", decoded);
        DJ.printS(2, "QuantumTeleportation\uff08\uff12\uff0d\uff13\uff09", this);
        DJ._print("\uff08\uff12\uff0d\uff13\uff09\u516c\u958b\u9375\u6697\u53f7\u306e\u4f8b\u3068\u3057\u3066\u3001\u3088\u308a\u9577\u3044\u60c5\u5831\u3092\u6271\u3044\u307e\u3059\u3002");
        DJ._print("\u2460\uff12\u500b\u306e\u5927\u304d\u306a\u7d20\u6570p\u3068q\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        p = 5;
        q = 11;
        DJ.print_("p = ", p);
        DJ.print(", q = ", q);
        DJ._print("\u2461\u65bd\u9320\u9375 m = p * q \u3092\u6c42\u3081\u307e\u3059\u3002");
        m = p * q;
        DJ.print("m = ", m);
        DJ._print("\u2462\u65bd\u9320\u9375\u306e\u4e0a\u9650 l = (p - 1)(q - 1) \u3092\u6c42\u3081\u307e\u3059\u3002");
        l = (p - 1) * (q - 1);
        DJ.print("l = ", l);
        DJ._print("\u2463\u7d20\u6570\u30ea\u30b9\u30c8\u3092\u6c42\u3081\u307e\u3059\u3002");
        primeList = this.prime(m);
        DJ._printList("Primes:", primeList);
        DJ._print("\u2464\u65bd\u9320\u9375\uff08\u7d20\u6570\uff09f (< l) \u3092\u6c42\u3081\u307e\u3059\u3002");
        for (int i = 1; i < m && (_f = primeList.get(i).intValue()) >= l; ++i) {
            f = _f;
        }
        DJ.print("f = ", f);
        DJ._print("\u2465\u958b\u9320\u9375 d \u3092\u6c42\u3081\u307e\u3059\u3002fd mod(l) = 1");
        d = 0;
        for (k = 0; k < f; ++k) {
            r = (l * k + 1) % f;
            if (r != 0) continue;
            d = (l * k + 1) / f;
            break;
        }
        DJ.print_("k = ", k);
        DJ.print_(", d = ", d);
        DJ.print(", r = ", r);
        DJ._print("\u2466\u7e54\u59eb\u306f\u5f66\u661f\u306e\u65bd\u9320\u9375\u3067\u60c5\u5831\u3092\u6697\u53f7\u5316\u3057\u3001\u5f66\u661f\u306b\u9001\u308a\u307e\u3059\u3002");
        DJ.print("\u3000\u9001\u4fe1\u3059\u308b\u30e1\u30c3\u30bb\u30fc\u30b8 message\uff08\u6574\u6570\u5024\uff09\u3092\u7528\u610f\u3057\u307e\u3059\u3002");
        message = 8;
        DJ.print("message = ", message);
        DJ._print("\u2467\u65bd\u9320\u9375 m \u3068 f \u3092\u4f7f\u3063\u3066\u6697\u53f7\u5316 c \u3057\u307e\u3059\u3002 c = message^f mod(m) ");
        pow_mf = (int)Math.pow(message, f);
        if (this.checkPower(message, f, "message^f")) {
            return;
        }
        DJ.print_("message^f = ", pow_mf);
        c = pow_mf % m;
        DJ.print(", c = ", c);
        DJ._print("\u2468\u5f66\u661f\u306f\u958b\u9320\u9375\u3067\u7e54\u59eb\u304b\u3089\u9001\u3089\u308c\u305f\u60c5\u5831\u3092\u89e3\u8aad\u3057\u307e\u3059\u3002");
        DJ._print("\u3000\u65bd\u9320\u9375 m \u3068\u958b\u9320\u9375 d \u3067\u89e3\u8aad\u3057\u307e\u3059\u3002 decoded = c^d mod(m) ");
        pow_cd = (int)Math.pow(c, d);
        if (this.checkPower(c, d, "c^d")) {
            return;
        }
        DJ.print_("c^d = ", pow_cd);
        decoded = pow_cd % m;
        DJ.print(", decoded = ", decoded);
        DJ._print("\u3000\u7e54\u59eb\u304b\u3089\u306e\u60c5\u5831\u306f\u89e3\u8aad\u3055\u308c\u307e\u3057\u305f\u3002message = decoded = ", decoded);
        this.stepMode = true;
        DJ._print("");
        DJ._print("\u30fb\u4ee5\u4e0a\u3067\u516c\u958b\u9375\u6697\u53f7\u901a\u4fe1\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u7d42\u308f\u308a\u3067\u3059\u3002");
        DJ.printS(3, "QuantumTeleportation", this);
        DJ._print("\uff08\uff13\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u3000\u6e2c\u5b9a\u7528\u57fa\u5e95\u89d2\u5ea6\u03b8\u3092\uff10\u5ea6\u3001\uff13\uff10\u5ea6\u3001\uff16\uff10\u5ea6\u306b\u56fa\u5b9a\u3057\u305f\u5834\u5408");
        DJ.print("\uff08\uff13\uff0d\uff11\uff09\u5165\u529b\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit QB0 = new QuBit();
        QuBit QB1 = new QuBit();
        QuBit QB00 = QB0.interactQuBit(QB1);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff12\uff09", this);
        DJ.print("\uff08\uff13\uff0d\uff12\uff09\u91cf\u5b50\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuGate hadamardGate = new QuGate("H_GATE");
        QuGate hiGate = hadamardGate.interactQuGate(iGate);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff12\uff09\u2463", this);
        int numOfBits = 2;
        target = 1;
        int[] controlArray = new int[]{0};
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff13\uff09", this);
        DJ._print("\uff08\uff13\uff0d\uff13\uff09\u6e2c\u5b9a\u5bfe\u8c61\u306e\u91cf\u5b50\u30d3\u30c3\u30c8targetQuBit\u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        QuBit hi00Bit = hiGate.apply(QB00);
        QuBit targetQuBit = cxGate.apply(hi00Bit);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff14\uff09", this);
        DJ.print("\uff08\uff13\uff0d\uff14\uff09\u6e2c\u5b9a\u7528\u306e\uff13\u7a2e\u985e\u306e\u57fa\u5e95\u3092\u6c42\u3081\u307e\u3059\u3002");
        double theta = 0.5235987755982988;
        numOfQuBit = 2;
        QuBasis b0_b0QuBasis = new QuBasis(numOfQuBit);
        QuBasis b1QuBasis = new QuBasis(theta * 2.0);
        QuBasis b1_b1QuBasis = b1QuBasis.interactQuBasis(b1QuBasis);
        QuBasis b2QuBasis = new QuBasis(theta);
        QuBasis b2_b2QuBasis = b2QuBasis.interactQuBasis(b2QuBasis);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff15\uff09", this);
        DJ._print("\uff08\uff13\uff0d\uff15\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u5404\u9805\u3092\u6c42\u3081\u307e\u3059\u3002");
        CompVec b0_b0CompVec = targetQuBit.basisChang(b0_b0QuBasis);
        QuBit b00QuBit = new QuBit();
        CompVec b0b1CompVec = b00QuBit.basisChang(b1QuBasis);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff16\uff09", this);
        DJ._print("\uff08\uff13\uff0d\uff16\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff11\u9805P(b0_0, b2_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        CompVec b0b2CompVec = b00QuBit.basisChang(b2QuBasis);
        DJ.printS(2, "QuantumTeleportation\uff08\uff13\uff0d\uff17\uff09", this);
        DJ._print("\uff08\uff13\uff0d\uff17\uff09\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u306e\u53f3\u8fba\u7b2c\uff11\u9805P(b2_0, b1_1)\u3092\u6c42\u3081\u307e\u3059\u3002");
        CompVec b2_b2CompVec = targetQuBit.basisChang(b2_b2QuBasis);
        DJ.printS(2, "QuantumTeleportation", this);
        DJ._print("\u2461\u7e54\u59eb\u306e\u6e2c\u5b9a\u3067\u57fa\u5e95b2\u306e\u7b2c\uff10\u57fa\u5e95\u306b\u9077\u79fb\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8b2_0QuBit\u3092\n\u3000\u5f66\u661f\u304c\u57fa\u5e95b1\u3067\u6e2c\u5b9a\u3057\u307e\u3059\u3002");
        int basisIndex = 0;
        QuBit b2_0QuBit = b2_b2QuBasis.getBasisQuBit(basisIndex);
        Complex b2_0Comp = b2_0QuBit.getProbAmp(0);
        double b2_0Pa0Real = b2_0Comp.getReal();
        Complex b2_0Pa0Comp = new Complex(Math.sqrt(b2_0Pa0Real), 0.0);
        Complex b2_0Pa1Comp = QuBit.getOtherPA(b2_0Pa0Comp);
        QuBit b2QuBit = new QuBit(b2_0Pa0Comp, b2_0Pa1Comp);
        CompVec b2b1CompVec = b2QuBit.basisChang(b1QuBasis);
        DJ.printS(2, "QuantumTeleportation\uff08\uff11\uff0d\uff18\uff09", this);
        DJ._print("\uff08\uff11\uff0d\uff18\uff09\u6e2c\u5b9a\u7d50\u679c\u3092\u307e\u3068\u3081\u307e\u3059\u3002");
        double b0_0Pa = b0_b0CompVec.getComp(0).getReal();
        double b0_0Prob = b0_0Pa * b0_0Pa;
        double b0b1Pa = b0b1CompVec.getComp(1).getReal();
        double b0_1Prob = b0b1Pa * b0b1Pa;
        double b0b1Prob = b0_0Prob * b0_1Prob;
        DJ._printF("\u30fb\u5de6\u8fba\u78ba\u7387 P(b0_0, b1_1)=", b0b1Prob);
        double b0b2Pa = b0b2CompVec.getComp(1).getReal();
        double b0_2Prob = b0b2Pa * b0b2Pa;
        double b0b2Prob = b0_0Prob * b0_2Prob;
        DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff10\u9805\u78ba\u7387 P(b0_0, b2_1)=", b0b2Prob);
        double b2_0Pa = b2_b2CompVec.getComp(0).getReal();
        double b2_0Prob = b2_0Pa * b2_0Pa;
        double b2b1Pa = b2b1CompVec.getComp(1).getReal();
        double b1_1Prob = b2b1Pa * b2b1Pa;
        double b2b1Prob = b2_0Prob * b1_1Prob;
        DJ.printF("\u30fb\u53f3\u8fba\u7b2c\uff11\u9805\u78ba\u7387 P(b2_0, b1_1)=", b2b1Prob);
        this.patternViewer = this.patternViewerLauncher.getPatternViewer();
        DJ.printS(3, "QuantumTeleportation", this);
        DJ._print("\uff08\uff14\uff09\u6e2c\u5b9a\u7528\u57fa\u5e95\u89d2\u5ea6\u03b8\u3092\u5909\u5316\u3055\u305b\u3066\u3001\u78ba\u7387\u3092\u30b0\u30e9\u30d5\u8868\u793a\u3057\u307e\u3059");
        DJ._print("====== \u6e2c\u5b9a\u57fa\u5e95\u3092\u56de\u8ee2\u3055\u305b\u3066\u30d9\u30eb\u306e\u4e0d\u7b49\u5f0f\u3092\u6c42\u3081\u307e\u3059 ======");
        int iMax = 90 / this.delta + 1;
        if (this.epoch > iMax) {
            this.epoch = iMax;
        }
        DJ.print_("\u3000\u30a8\u30dd\u30c3\u30af\u306e\u56de\u6570\uff1aepoch = ", this.epoch);
        DJ.print_(",\u3000\u8a08\u7b97\u306e\u7e70\u308a\u8fd4\u3057\u56de\u6570\uff1aiMax = ", iMax);
        DJ.print(",\u3000\u7d4c\u904e\u8868\u793a\u9593\u9694\uff1ainterval = ", this.interval);
        this.stepMode = true;
        DJ.printS(1, "BellsInequality", this);
        for (int i = 0; i <= this.epoch; ++i) {
            this.startTime = System.nanoTime();
            this.intervalFlag = i % this.interval == this.interval - 1 | i == this.epoch;
            DJ.print_("===== \u89d2\u5ea6\u03b8\u3092\u5909\u3048\u3066\u8a08\u7b97\uff1ai=", i);
            int angle = i * this.delta;
            DJ.print_(", angle[deg]=", angle);
            theta = Math.PI * (double)angle / 180.0;
            DJ.printF_(", theta[rad]=", theta);
            DJ.print(" =====");
            b1QuBasis = new QuBasis(theta * 2.0);
            b1_b1QuBasis = b1QuBasis.interactQuBasis(b1QuBasis);
            b2QuBasis = new QuBasis(theta);
            b2_b2QuBasis = b2QuBasis.interactQuBasis(b2QuBasis);
            b0b1CompVec = b00QuBit.basisChang(b1QuBasis);
            b0b2CompVec = b00QuBit.basisChang(b2QuBasis);
            b2_b2CompVec = targetQuBit.basisChang(b2_b2QuBasis);
            basisIndex = 0;
            b2_0QuBit = b2_b2QuBasis.getBasisQuBit(basisIndex);
            b2_0Comp = b2_0QuBit.getProbAmp(0);
            b2_0Pa0Real = b2_0Comp.getReal();
            b2_0Pa0Comp = new Complex(Math.sqrt(b2_0Pa0Real), 0.0);
            b2_0Pa1Comp = QuBit.getOtherPA(b2_0Pa0Comp);
            b2QuBit = new QuBit(b2_0Pa0Comp, b2_0Pa1Comp);
            b2b1CompVec = b2QuBit.basisChang(b1QuBasis);
            b0_0Pa = b0_b0CompVec.getComp(0).getReal();
            b0_0Prob = b0_0Pa * b0_0Pa;
            b0b1Pa = b0b1CompVec.getComp(1).getReal();
            b0_1Prob = b0b1Pa * b0b1Pa;
            b0b1Prob = b0_0Prob * b0_1Prob;
            b0b2Pa = b0b2CompVec.getComp(1).getReal();
            b0_2Prob = b0b2Pa * b0b2Pa;
            b0b2Prob = b0_0Prob * b0_2Prob;
            b2_0Pa = b2_b2CompVec.getComp(0).getReal();
            b2_0Prob = b2_0Pa * b2_0Pa;
            b2b1Pa = b2b1CompVec.getComp(1).getReal();
            b1_1Prob = b2b1Pa * b2b1Pa;
            b2b1Prob = b2_0Prob * b1_1Prob;
            DJ.printF_("\u3000\u5de6\u8fba\u306e\u78ba\u7387 (", b0b1Prob);
            double b0b2_b2b1Prob = b0b2Prob + b2b1Prob;
            if (b0b1Prob > b0b2_b2b1Prob) {
                DJ.printF_(") > (", b0b2_b2b1Prob);
            } else {
                DJ.printF_(") <= (", b0b2_b2b1Prob);
            }
            DJ.printF(" \u53f3\u8fba\u306e\u78ba\u7387(", b0b2_b2b1Prob);
            this.patternData0[0][i] = theta;
            this.patternData0[1][i] = b0b1Prob;
            this.patternData0[2][i] = b0b2_b2b1Prob;
            this.patternData0[3][i] = 10.0;
            this.patternData0[4][i] = 10.0;
            this.patternData1[0][i] = theta;
            this.patternData1[1][i] = b0b1Prob;
            this.patternData1[2][i] = b0b2_b2b1Prob;
            this.patternData1[3][i] = b0b2Prob;
            this.patternData1[4][i] = b2b1Prob;
            this.endTime = System.nanoTime();
            double lapTime_ = (double)(this.endTime - this.startTime) / 1000000.0;
            if (lapTime_ > 0.0) {
                this.lapTime = lapTime_;
            }
            this.totalTime += this.lapTime;
            if (this.intervalFlag) {
                this.updatePattern();
                QuTeleport quTeleport = this;
                synchronized (quTeleport) {
                    try {
                        this.wait(100L);
                        if (this.pauseFlag) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DJ.print("***** ERROR ***** " + this.getClass().getName() + "\n Exception occur in wait(sleepTime):" + e.toString());
                    }
                }
            }
            if (this.abortFlag) {
                DJ._print("##### Abort action requested");
                this.epoch = i;
            }
            DJ.printS(0, "QuantumTeleportation", this);
        }
        DJ._print_("\u30fb\u7dcf\u5b9f\u884c\u6642\u9593\uff1a" + this.totalTime / 1000.0 + " [sec]");
        double aveTime = this.totalTime / (double)this.epoch;
        DJ.print(", \u5e73\u5747\u5b9f\u884c\u6642\u9593\uff1a" + aveTime + " [msec/epoch]");
        this.finishTime = System.currentTimeMillis();
        DJ.print_("\u30fb\u30bf\u30b9\u30af\u51e6\u7406\u6642\u9593\uff1a" + (double)(this.finishTime - this.beginTime) / 1000.0 + " [sec]");
        DJ.print(", \u30bf\u30b9\u30af\u7d42\u4e86\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
    }

    private ArrayList<Integer> prime(int upperLimit) {
        ArrayList<Integer> primeList = new ArrayList<Integer>();
        primeList.add(2);
        for (int i = 3; i <= upperLimit; i += 2) {
            boolean k = false;
            int j = 3;
            while ((double)j <= Math.sqrt(i)) {
                if (i % j == 0) {
                    k = true;
                    break;
                }
                j += 2;
            }
            if (k) continue;
            primeList.add(i);
        }
        return primeList;
    }

    private boolean checkPower(int a, int b, String name) {
        boolean errorFlag = false;
        if (Math.pow(a, b) > 2.147483647E9) {
            DJ.print("***** ERROR ***** ShorsAlgorithm.checkPower(int, int, String)\n  " + name + ": Power is too big.");
            errorFlag = true;
        }
        return errorFlag;
    }
}

