/*
 * Decompiled with CFR 0.152.
 */
package task.qu.aug;

import java.util.ArrayList;
import quan.QuBasis;
import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuantumPrime_51
extends Task {
    int dataNum = 1000;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Open-loop Control", 6, this.patternData1, "Clos-loop Control");
        this.quantumPrime_51();
    }

    public void quantumPrime_51() {
        DJ._print("QuantumPrime_51.quantumPrime_51() ========================");
        DJ._print("\u25a0\u91cf\u5b50\u8a08\u7b97\u306e\u958b\u59cb");
        DJ._print("");
        DJ.print("QuantumPrime_5\uff1a");
        DJ.print("(1)\u4ee3\u8868\u7684\u306a\u5358\u4e00\u91cf\u5b50\u30d3\u30c3\u30c8");
        DJ.print("(2)\u56de\u8ee2\u884c\u5217\u306b\u3088\u308b\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u56de\u8ee2");
        DJ.print("(3)H\u30b2\u30fc\u30c8\u3068CX\u30b2\u30fc\u30c8\u3067\u3082\u3064\u308c\u3001\u5224\u5b9a\u65b9\u6cd5");
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u6e2c\u5b9a\uff08\u57fa\u5e95\u306e\u5909\u63db\uff1a\u6a19\u6e96\u898f\u5b9a\u2192\u4efb\u610f\u306e\u57fa\u5e95\uff09");
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(1)\u4ee3\u8868\u7684\u306a\u5358\u4e00\u91cf\u5b50\u30d3\u30c3\u30c8");
        DJ._print("\u30fbzeroQuBit = |0> \u91cf\u5b50\u30d3\u30c3\u30c8 [1, 0]");
        QuBit zeroQuBit = new QuBit();
        DJ.print(zeroQuBit.toFormat("|0>"));
        DJ._print("\u30fboneQuBit = |1> \u91cf\u5b50\u30d3\u30c3\u30c8 [0, 1]");
        Complex comp0 = new Complex(0.0, 0.0);
        Complex comp1 = QuBit.getOtherPA(comp0);
        QuBit oneQuBit = new QuBit(comp0, comp1);
        DJ.print(oneQuBit.toFormat("|1>"));
        DJ._print("\u30fboneR2QuBit = 1/\u221a2(|0>-|1>) \u91cf\u5b50\u30d3\u30c3\u30c8 [1/\u221a2, -1/\u221a2]");
        double oneRt2 = 1.0 / Math.sqrt(2.0);
        Complex comp2 = new Complex(oneRt2, 0.0);
        Complex comp3 = new Complex(-oneRt2, 0.0);
        QuBit oneR2QuBit = new QuBit(comp2, comp3);
        DJ.print(oneR2QuBit.toFormat("1/\u221a2(|0>-|1>)"));
        DJ._print("\u30fbhalfQuBit = 1/2(|0>-\u221a3|1>) \u91cf\u5b50\u30d3\u30c3\u30c8 [1/2, -\u221a3/2]");
        Complex comp4 = new Complex(0.5, 0.0);
        Complex comp5 = QuBit.getOtherPA(comp4);
        comp5.mul(-1.0);
        QuBit halfQuBit = new QuBit(comp4, comp5);
        DJ.print(halfQuBit.toFormat("1/2(|0>-\u221a3|1>)"));
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(2)\u56de\u8ee2\u884c\u5217\u306b\u3088\u308b\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u56de\u8ee2");
        double pai = Math.PI;
        double theta = 0.0;
        double lamda = 0.0;
        double phi = 0.0;
        DJ._print("(2)-1 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0/4\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai / 4.0;
        DJ.print("theta = ", theta);
        Complex[][] r45Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r45Mat", r45Mat);
        Complex[] qbArray = zeroQuBit.copyProbArray();
        Complex[] resultQB = Complex.innerProduct(r45Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        CompVec resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("(2)-2 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0/3\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai / 3.0;
        DJ.print("theta = ", theta);
        Complex[][] r60Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r60Mat", r60Mat);
        qbArray = zeroQuBit.copyProbArray();
        resultQB = Complex.innerProduct(r60Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("(2)-3 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0/6\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai / 6.0;
        DJ.print("theta = ", theta);
        Complex[][] r30Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r30Mat", r30Mat);
        qbArray = zeroQuBit.copyProbArray();
        resultQB = Complex.innerProduct(r30Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("(2)-4 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0/2\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai / 2.0;
        DJ.print("theta = ", theta);
        Complex[][] r90Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r90Mat", r90Mat);
        qbArray = zeroQuBit.copyProbArray();
        resultQB = Complex.innerProduct(r90Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("(2)-5 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai;
        DJ.print("theta = ", theta);
        Complex[][] r180Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r180Mat", r180Mat);
        qbArray = zeroQuBit.copyProbArray();
        resultQB = Complex.innerProduct(r180Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("(2)-6 \u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092-\u03c0/9\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2");
        theta = -pai / 9.0;
        DJ.print("theta = ", theta);
        Complex[][] r20Mat = QuBasis.rotate2(theta, lamda, phi);
        DJ.printF("r20Mat", r20Mat);
        qbArray = zeroQuBit.copyProbArray();
        resultQB = Complex.innerProduct(r20Mat, qbArray);
        DJ.printF("resultQB", resultQB);
        resultVec = new CompVec(resultQB);
        DJ.printF("resultVec", resultVec);
        DJ._print("");
        DJ.print("// ----------------------------------------------------");
        DJ.print("(3)H\u30b2\u30fc\u30c8\u3068CX\u30b2\u30fc\u30c8\u3067\u3082\u3064\u308c\u3001\u5224\u5b9a\u65b9\u6cd5");
        DJ._print("(3)-1, H\u30b2\u30fc\u30c8\uff08\u30a2\u30c0\u30de\u30fc\u30eb\u30b2\u30fc\u30c8\uff09\u3068CX\u30b2\u30fc\u30c8\u3067\u3082\u3064\u308c\u3055\u305b\u308b");
        zeroQuBit = new QuBit();
        DJ.print("|0>", zeroQuBit);
        QuGate hadaGate = new QuGate("H_GATE");
        DJ.print(hadaGate.toFormat("hadaGate"));
        QuBit adaQu0 = hadaGate.apply(zeroQuBit);
        DJ.printF("H|0> = 1/\u221a2(|0>+|1>)", adaQu0);
        DJ._print("\u91cf\u5b50\u30d3\u30c3\u30c8|0>\u3092\u8ffd\u52a0\u3057\u3001H|0>\u3068\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u308b");
        ArrayList<QuBit> quBits = new ArrayList<QuBit>();
        quBits.add(adaQu0);
        quBits.add(zeroQuBit);
        QuBit interracted = QuBit.interactQuBit(quBits);
        DJ.printF("H|0>\u2a02|0>", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        boolean checked = interracted.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff10\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff11");
        int numOfBits = 2;
        int target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray0 = new int[]{0};
        DJ.print(", controlArray", controlArray0);
        QuGate cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray0);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u306bCH|0>\u2a02|0>\u3092\u9069\u7528\u3059\u308b");
        QuBit result = cxGate.apply(interracted);
        DJ.printF("cx(H|0>\u2a02|0>) = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("");
        DJ._print("(3)-2, \u3082\u3064\u308c\u3066\u3044\u306a\u3044\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u4f8b");
        ArrayList<QuBit> quBitList = new ArrayList<QuBit>();
        quBitList.add(oneR2QuBit);
        quBitList.add(halfQuBit);
        DJ._print("quBitList", QuBit.toString(quBitList));
        DJ._print("\u591a\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\u76f8\u4e92\u4f5c\u7528\u3059\u308b\u524d\uff09");
        QuBit multiQuBit = new QuBit(quBitList);
        DJ.printF("multiQuBit\uff08\u76f8\u4e92\u4f5c\u7528\u524d\uff09", multiQuBit);
        DJ._print("\u591a\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\u76f8\u4e92\u4f5c\u7528\u3057\u305f\u5f8c\uff09");
        QuBit interactedQBs = QuBit.interactQuBit(quBitList);
        DJ.printF("interactedQBs\uff08\u76f8\u4e92\u4f5c\u7528\u5f8c\uff09", interactedQBs);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a");
        checked = interactedQBs.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u8a73\u7d30\u8868\u793a\uff09");
        checked = interactedQBs.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(3)-3, \u3082\u3064\u308c\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u4f8b\u3000\u24cd\u24e7\u3289\u3000");
        DJ._print(" 1/2|0>\u2a02|0>");
        quBits.clear();
        quBits.add(zeroQuBit);
        quBits.add(zeroQuBit);
        QuBit _0thQB = QuBit.interactQuBit(quBits);
        _0thQB.product(0.5);
        DJ.printF("1/2|0>\u2a02|0>", _0thQB);
        DJ._print(" 1/2|0>\u2a02|1>");
        quBits.clear();
        quBits.add(zeroQuBit);
        quBits.add(oneQuBit);
        QuBit _1stQB = QuBit.interactQuBit(quBits);
        _1stQB.product(0.5);
        DJ.printF("1/2|0>\u2a02|1>", _1stQB);
        DJ._print(" 1/\u221a2|1>\u2a02|0>");
        quBits.clear();
        quBits.add(oneQuBit);
        quBits.add(zeroQuBit);
        QuBit _2ndQB = QuBit.interactQuBit(quBits);
        _2ndQB.product(Math.sqrt(2.0));
        DJ.printF("1/\u221a2|1>\u2a02|0>", _2ndQB);
        DJ._print(" 0|1>\u2a02|1>");
        quBits.clear();
        quBits.add(oneQuBit);
        quBits.add(zeroQuBit);
        QuBit _3rdQB = QuBit.interactQuBit(quBits);
        _3rdQB.product(0.0);
        DJ.printF("0|1>\u2a02|0>", _3rdQB);
        DJ._print(" 1/2|0>\u2a02|0> + 1/2|0>\u2a02|1> + 1/\u221a2|1>\u2a02|0> + 0|1>\u2a02|1>");
        quBits.clear();
        multiQuBit.setProbAmp(_0thQB.copyProbAmpVec());
        multiQuBit.sum(_1stQB);
        multiQuBit.sum(_2ndQB);
        multiQuBit.sum(_3rdQB);
        DJ.printF("multiQuBit", multiQuBit);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a");
        checked = multiQuBit.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(3)-4, \uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c");
        DJ._print("\u2460\u3000|0>\u3092-\u03c0/9\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m20degQuBit\u3092\u5f97\u308b");
        theta = -pai / 9.0;
        DJ.print("theta = ", theta);
        CompMat m20degMat = QuBasis.rotate(theta, lamda, phi);
        DJ.printF("m20degMat", m20degMat);
        QuBit m20degQuBit = m20degMat.innerProduct(zeroQuBit);
        DJ.printF("m20degQuBit", m20degQuBit);
        DJ._print("\u2461\u3000|0>\u3092-\u03c0/4\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m45degQuBit\u3092\u5f97\u308b");
        theta = -pai / 4.0;
        DJ.print("theta = ", theta);
        CompMat m45degMat = QuBasis.rotate(theta, lamda, phi);
        DJ.printF("m45degMat", m45degMat);
        QuBit m45degQuBit = m45degMat.innerProduct(zeroQuBit);
        DJ.printF("m45degQuBit", m45degQuBit);
        DJ._print("\u2462\u3000|0>\u3092-\u03c0/3\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m60degQuBit\u3092\u5f97\u308b");
        theta = -pai / 3.0;
        DJ.print("theta = ", theta);
        CompMat m60degMat = QuBasis.rotate(theta, lamda, phi);
        DJ.printF("m60degMat", m60degMat);
        QuBit m60degQuBit = m60degMat.innerProduct(zeroQuBit);
        DJ.printF("m60degQuBit", m60degQuBit);
        DJ._print("\u2463\u3000|0>\u3092-\u03c0/6\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m30degQuBit\u3092\u5f97\u308b");
        theta = -pai / 6.0;
        DJ.print("theta = ", theta);
        CompMat m30degMat = QuBasis.rotate(theta, lamda, phi);
        DJ.printF("m30degMat", m30degMat);
        QuBit m30degQuBit = m30degMat.innerProduct(zeroQuBit);
        DJ.printF("m30degQuBit", m30degQuBit);
        DJ._print("");
        DJ._print("(3)-5, \uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c");
        DJ._print(" \u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8");
        quBits.clear();
        quBits.add(m20degQuBit);
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        multiQuBit = QuBit.interactQuBit(quBits);
        DJ.printF("multiQuBit", multiQuBit);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a");
        checked = multiQuBit.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print(" \uff14\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u3082\u3064\u308c");
        quBits.add(m30degQuBit);
        multiQuBit = QuBit.interactQuBit(quBits);
        DJ.printF("multiQuBit", multiQuBit);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a");
        checked = multiQuBit.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(4) \u91cf\u5b50\u30b2\u30fc\u30c8\u306e\u8868\u793a");
        DJ._print("CX_GATE", cxGate.toString());
        DJ.print("CX_GATE", cxGate.toFormat());
        DJ.print(cxGate.toString("CX_GATE"));
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print(cxGate);
        DJ.printF(cxGate);
        DJ.print("CX_GATE", cxGate);
        DJ.printF("CX_GATE", cxGate);
        DJ._print("");
        DJ._print("hadaGate", hadaGate.toString());
        DJ.print("hadaGate", hadaGate.toFormat());
        DJ.print(hadaGate.toString("hadaGate"));
        DJ.print(hadaGate.toFormat("hadaGate"));
        DJ._print(hadaGate);
        DJ.printF(hadaGate);
        DJ.print("hadaGate", hadaGate);
        DJ.printF("hadaGate", hadaGate);
        DJ._print("");
        DJ._print("(5) CX-\u30b2\u30fc\u30c8\u3067\u78ba\u7387\u632f\u5e45\u3092\u53cd\u8ee2\u3055\u305b\u3001\u3082\u3064\u308c\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3059\u308b");
        DJ._print("(5)-1 \uff12\u91cf\u5b50\u30d3\u30c3\u30c8");
        quBits.clear();
        quBits.add(m20degQuBit);
        quBits.add(m60degQuBit);
        DJ.printF("quBits", new QuBit(quBits));
        interracted = QuBit.interactQuBit(quBits);
        DJ.printF("InteractQuBit", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = interracted.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff10\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff11");
        numOfBits = 2;
        target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray = new int[]{0};
        DJ.print(", controlArray", controlArray);
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b");
        result = cxGate.apply(interracted);
        DJ.printF("result = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(5)-2 \uff13\u91cf\u5b50\u30d3\u30c3\u30c8");
        quBits.clear();
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        quBits.add(m20degQuBit);
        DJ.printF("quBits", new QuBit(quBits));
        interracted = QuBit.interactQuBit(quBits);
        DJ.printF("InteractQuBit", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = interracted.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff10\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff12");
        numOfBits = 3;
        target = 2;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        controlArray[0] = 0;
        DJ.print(", controlArray", controlArray);
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b");
        result = cxGate.apply(interracted);
        DJ.printF("result = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(5)-3 \uff14\u91cf\u5b50\u30d3\u30c3\u30c8");
        quBits.clear();
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        quBits.add(m20degQuBit);
        quBits.add(m30degQuBit);
        DJ.printF("quBits", new QuBit(quBits));
        interracted = QuBit.interactQuBit(quBits);
        DJ.printF("InteractQuBit", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = interracted.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff10\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff12");
        numOfBits = 4;
        target = 3;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        controlArray[0] = 0;
        DJ.print(", controlArray", controlArray);
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b");
        result = cxGate.apply(interracted);
        DJ.printF("result = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(5)-4 \uff14\u91cf\u5b50\u30d3\u30c3\u30c8\u3001CX\u30b2\u30fc\u30c8\u306e\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u3068\u30bf\u30fc\u30b2\u30c3\u30c8\u3092\u5909\u66f4");
        quBits.clear();
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        quBits.add(m20degQuBit);
        quBits.add(m30degQuBit);
        DJ.printF("quBits", new QuBit(quBits));
        interracted = QuBit.interactQuBit(quBits);
        DJ.printF("InteractQuBit", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = interracted.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff12\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff10");
        numOfBits = 4;
        target = 0;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        controlArray[0] = 2;
        DJ.print(", controlArray", controlArray);
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b");
        result = cxGate.apply(interracted);
        DJ.printF("result = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(5)-5 \uff14\u91cf\u5b50\u30d3\u30c3\u30c8\u3001CX\u30b2\u30fc\u30c8\u306e\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u3092\u8907\u6570\u306b\u5909\u66f4");
        quBits.clear();
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        quBits.add(m20degQuBit);
        quBits.add(m30degQuBit);
        DJ.printF("quBits", new QuBit(quBits));
        interracted = QuBit.interactQuBit(quBits);
        DJ.printF("InteractQuBit", interracted);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = interracted.entangleCheck();
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u751f\u6210\u3001\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\uff1a\uff10\uff0c\uff12\u3001\u30bf\u30fc\u30b2\u30c3\u30c8\uff1a\uff11");
        numOfBits = 4;
        target = 1;
        DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
        int[] controlArray2 = new int[]{0, 2};
        DJ.print(", controlArray", controlArray2);
        cxGate = new QuGate("CX_GATE", numOfBits, target, controlArray2);
        DJ.print(cxGate.toFormat("CX_GATE"));
        DJ._print("\uff23\uff38\u30b2\u30fc\u30c8\u3092\u9069\u7528\u3059\u308b");
        result = cxGate.apply(interracted);
        DJ.printF("result = ", result);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = result.entangleDetails();
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ.print("\u3082\u3064\u308c\u72b6\u614b\uff1a", QuBit.entangleStatus(checked));
        DJ._print("");
        DJ._print("(6) \u3082\u3064\u308c\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3059\u308b\u30e1\u30bd\u30c3\u30c9\u306e\u30c1\u30a7\u30c3\u30af");
        QuBit f00QB = new QuBit(2, 0);
        DJ.printF("f00QB", f00QB);
        QuGate hGate = new QuGate("H_GATE");
        DJ._printF("hadaGate", hGate);
        QuGate iGate = new QuGate("I_GATE");
        DJ._printF("iGate", iGate);
        QuGate hiGate = hGate.interactQuGate(iGate);
        DJ._printF("hiGate", hiGate);
        QuBit hi_fQB = hiGate.apply(f00QB);
        DJ.printF("hi_fQB", hi_fQB);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = hi_fQB.entangleDetails();
        DJ._print("hi_fQB\u306e\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\uff08\uff12\uff0d\uff13\uff09\u2460\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306eCX\u30b2\u30fc\u30c8cx2Gate\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        DJ._print("\u30fbCX\u30b2\u30fc\u30c8\u306e\u91cf\u5b50\u56de\u8def\n            \u250c-\u2510    \nQB0 = fQB --\u2502C\u2502--  \n            \u2502 \u2502    \nQB1 = tQB --\u2502X\u2502--  \n            \u2514-\u2518    ");
        int numOfQuBit = 2;
        int[] targetArray = new int[]{1};
        controlArray = new int[]{0};
        QuGate cx2Gate = new QuGate("CX_GATE", numOfQuBit, targetArray, controlArray);
        DJ.printF("cx2Gate", cx2Gate);
        DJ.print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8hi_fQB\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cx2Gate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        QuBit cx_hiQB = cx2Gate.apply(hi_fQB);
        DJ.printF("cx_hiQB", cx_hiQB);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c\uff09");
        checked = cx_hiQB.entangleDetails();
        DJ.print("cx_hiQB\u306e\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\uff08\uff12\uff0d\uff14\uff09\u2460\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\u306eCX\u30b2\u30fc\u30c8cixGate\u3092\u691c\u8a3c\u3057\u307e\u3059\u3002");
        DJ._print("\u30fbCIX\u30b2\u30fc\u30c8\u306e\u91cf\u5b50\u56de\u8def\n              \u250c-\u2510  \u250c-\u2510  \nQB2   = |0> --\u2502H\u2502--\u2502C\u2502  \n              \u2502 \u2502  \u2502|\u2502  \nQB3   = |0> --\u2502I\u2502--\u2502|\u2502  \n              \u2502 \u2502  \u2502|\u2502  \nQB4   = |0> --\u2502I\u2502--\u2502X\u2502  \n              \u2514-\u2518  \u2514-\u2518  ");
        QuBit f000QB = new QuBit(3, 0);
        DJ.printF("f000QB", f000QB);
        QuGate hiiGate = hiGate.interactQuGate(iGate);
        DJ._printF("hiiGate", hiiGate);
        QuBit hii_f000QB = hiiGate.apply(f000QB);
        DJ.printF("hii_f000QB", hii_f000QB);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u308b\u524d\uff09");
        checked = hii_f000QB.entangleDetails();
        DJ._print("hii_f000QB\u306e\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("\u30fbCX\u30b2\u30fc\u30c8\u306e\u91cf\u5b50\u56de\u8def\n");
        numOfQuBit = 3;
        targetArray = new int[]{2};
        controlArray = new int[]{0};
        QuGate cixGate = new QuGate("CX_GATE", numOfQuBit, targetArray, controlArray);
        DJ.printF("cixGate", cixGate);
        DJ.print("\u3000\u91cf\u5b50\u30d3\u30c3\u30c8hii_f000QB\u3092\u91cf\u5b50\u30b2\u30fc\u30c8cixGate\u306b\u9069\u7528\u3057\u307e\u3059\u3002");
        QuBit cixhii_f000QB = cixGate.apply(hii_f000QB);
        DJ.printF("cixhii_f000QB", cixhii_f000QB);
        DJ._print("\u3082\u3064\u308c\u72b6\u614b\u306e\u5224\u5b9a\uff08\u3082\u3064\u308c\u305f\u5f8c?\uff09");
        checked = cixhii_f000QB.entangleDetails();
        DJ.print("cixhii_f000QB\u306e\u3082\u3064\u308c\u72b6\u614b\uff1a", Boolean.toString(checked));
        DJ._print("");
        DJ._print("");
        DJ._print("");
        DJ._print("\uff08\uff11\uff09\u30b7\u30e7\u30a2\u306e\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306e\u91cf\u5b50\u56de\u8def\n              \u250c-\u2510  \u250c-\u2510  \u250c-\u2510  \u250c-\u2510  \u250c-\u2510  \u250c-\u2500\u2500\u2500\u2510  \u250c-\u2510 \nQB0   = |0> --\u2502H\u2502--\u2502I\u2502--\u2502I\u2502--\u2502I\u2502--\u2502I\u2502--\u2502inv-QFT\u2502--\u2502M\u2502 \n              \u2502 \u2502  \u2502 \u2502  \u2502 \u2502  \u2502 \u2502  \u2502 \u2502  \u2502       \u2502  \u2502 \u2502 \nQB1   = |0> --\u2502H\u2502--\u2502I\u2502--\u2502I\u2502--\u2502C\u2502--\u2502C\u2502--\u2502       \u2502--\u2502M\u2502 \n              \u2502 \u2502  \u2502 \u2502  \u2502 \u2502  \u2502|\u2502  \u2502|\u2502  \u2502       \u2502  \u2502 \u2502 \nQB2   = |0> --\u2502H\u2502--\u2502C\u2502  \u2502C\u2502--\u2502|\u2502--\u2502|\u2502--\u2502       \u2502--\u2502M\u2502 \n              \u2514-\u2518  \u2502|\u2502  \u2502|\u2502  \u2502|\u2502  \u2502|\u2502  \u2502       \u2502  \u2514-\u2518 \nQB3   = |0> ---------\u2502|\u2502--\u2502|\u2502--\u2502|\u2502--\u2502*\u2502--\u2502       \u2502------- \n                     \u2502|\u2502  \u2502|\u2502  \u2502|\u2502  \u2502|\u2502  \u2502       \u2502        \nQB4   = |0> ---------\u2502X\u2502--\u2502|\u2502--\u2502*\u2502--\u2502|\u2502--\u2502       \u2502------- \n                     \u2502 \u2502  \u2502|\u2502  \u2502|\u2502  \u2502|\u2502  \u2502       \u2502        \nQB5   = |0> ---------\u2502I\u2502--\u2502X\u2502--\u2502|\u2502--\u2502*\u2502--\u2502       \u2502------- \n              \u250c-\u2510  \u2502 \u2502  \u2502 \u2502  \u2502|\u2502  \u2502 \u2502  \u2502       \u2502        \nQB6   = |0> --\u2502X\u2502--\u2502I\u2502--\u2502I\u2502--\u2502*\u2502--\u2502I\u2502--\u2502       \u2502------- \n              \u2514-\u2518  \u2514-\u2518  \u2514-\u2518  \u2514-\u2518  \u2514-\u2518  \u2514-\u2500\u2500\u2500\u2518        \nphase      ph0     ph1    ph2    ph3    ph4    ph5          ph6     ");
        DJ._print("");
        DJ._print("\u91cf\u5b50\u8a08\u7b97\u306e\u5b8c\u4e86");
        DJ.print("QuantumPrime_51.quantumPrime_51() ===========================");
    }
}

