/*
 * Decompiled with CFR 0.152.
 */
package task.qu.aug;

import java.util.ArrayList;
import quan.QuBasis;
import quan.QuBit;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompMat;
import util.comp.CompVec;
import util.comp.Complex;

public class QuantumPrime_6
extends Task {
    int dataNum = 1000;

    @Override
    public void runTask() {
        DJ._print("\u30fb\u30bf\u30b9\u30af\u958b\u59cb\u65e5\u6642\uff1a", TimeStamp.getTimeFormated());
        this.beginTime = System.currentTimeMillis();
        this.patternViewerFlag = true;
        this.patternData0 = new double[5][this.dataNum];
        this.patternData1 = new double[5][this.dataNum];
        this.patternViewerLauncher = DJ.pattern(6, this.patternData0, "Open-loop Control", 6, this.patternData1, "Clos-loop Control");
        this.quantumPrime_6();
    }

    public void quantumPrime_6() {
        int numOfPA;
        int i;
        DJ._print("QuantumPrime_6.quantumPrime_6() ========================");
        DJ._print("\u25a0\u91cf\u5b50\u8a08\u7b97\u306e\u958b\u59cb");
        DJ._print("");
        DJ.print("QuantumPrime_6\uff1a");
        DJ.print("(1)\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u57fa\u5e95");
        DJ.print("(2)\u57fa\u5e95\u306e\u5909\u63db");
        DJ.print("(3)\u5185\u7a4d\u3001\u30ce\u30eb\u30e0");
        DJ.print("(4)\u30b0\u30e9\u30e0\u30b7\u30e5\u30df\u30c3\u30c8\u306e\u76f4\u4ea4\u5316\u6cd5");
        DJ.print("(5)\u6b63\u898f\u76f4\u4ea4\u57fa\u5e95\u3092\u30c1\u30a7\u30c3\u30afcheckOrthonormal()");
        DJ.print("(6)NG\u3068\u306a\u308b\u4e8b\u4f8b\u306eV\u30d9\u30af\u30c8\u30eb\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("(7)\u884c\u5217\u5f0f\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("(8)\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\uff14\u6b21\u306e\u57fa\u5e95\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8\u3092\u76f8\u4e92\u4f5c\u7528\u3055\u305b\u308b\u524d\u5f8c\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("  private QuBit checkInteractQuBit(ArrayList<QuBit> quBits)");
        DJ.print("\u30fb\u6b63\u898f\u76f4\u4ea4\u57fa\u5e95\u306e\u30c1\u30a7\u30c3\u30af");
        DJ.print("  private void checkOrthonormal(Complex[][] originalArrys)");
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(1)\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u57fa\u5e95");
        int numOfQuBit = 1;
        DJ._print_("\u91cf\u5b50\u30d3\u30c3\u30c8\u6570", numOfQuBit);
        DJ.print("\u306e\u6a19\u6e96\u57fa\u5e95");
        QuBasis defaultQuBasis = new QuBasis(numOfQuBit);
        int order = defaultQuBasis.getOrder();
        DJ.print("order", order);
        for (i = 0; i < order; ++i) {
            DJ.print("defaultQuBasis(" + i + ") ", defaultQuBasis.getBasisVec(i));
        }
        DJ.print("defaultQuBasis", defaultQuBasis.toString());
        DJ.print(defaultQuBasis);
        numOfQuBit = 2;
        DJ._print_("\u91cf\u5b50\u30d3\u30c3\u30c8\u6570", numOfQuBit);
        DJ.print("\u306e\u6a19\u6e96\u57fa\u5e95");
        defaultQuBasis = new QuBasis(numOfQuBit);
        order = defaultQuBasis.getOrder();
        DJ.print("order", order);
        for (i = 0; i < order; ++i) {
            DJ.print("defaultQuBasis(" + i + ") ", defaultQuBasis.getBasisVec(i));
        }
        DJ.print("defaultQuBasis", defaultQuBasis.toFormat());
        DJ.printF(defaultQuBasis);
        numOfQuBit = 3;
        DJ._print_("\u91cf\u5b50\u30d3\u30c3\u30c8\u6570", numOfQuBit);
        DJ.print("\u306e\u6a19\u6e96\u57fa\u5e95");
        defaultQuBasis = new QuBasis(numOfQuBit);
        order = defaultQuBasis.getOrder();
        for (i = 0; i < defaultQuBasis.getOrder(); ++i) {
            DJ.print("defaultQuBasis(" + i + ") ", defaultQuBasis.getBasisVec(i));
        }
        DJ.print(defaultQuBasis.toString("defaultQuBasis"));
        DJ.print("defaultQuBasis", defaultQuBasis);
        numOfQuBit = 4;
        DJ._print_("\u91cf\u5b50\u30d3\u30c3\u30c8\u6570", numOfQuBit);
        DJ.print("\u306e\u6a19\u6e96\u57fa\u5e95");
        defaultQuBasis = new QuBasis(numOfQuBit);
        for (i = 0; i < defaultQuBasis.getOrder(); ++i) {
            DJ.print("defaultQuBasis(" + i + ") ", defaultQuBasis.getBasisVec(i));
        }
        DJ.print(defaultQuBasis.toFormat("defaultQuBasis"));
        DJ.printF("defaultQuBasis", defaultQuBasis);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(2)\u57fa\u5e95\u306e\u5909\u63db");
        DJ._print("\u30fb\u91cf\u5b50\u30d3\u30c3\u30c8|v> = 1/2|0>-\u221a3/2|1>\u3092 \u57fa\u5e95{[1/\u221a2, 1/\u221a2]T, [1/\u221a2, -1/\u221a2]T}\u3067\u8868\u3059");
        DJ._print("(2)-1.\u91cf\u5b50\u30d3\u30c3\u30c8|v> = 1/2|0>-\u221a3/2|1>\u3092\u5f97\u308b");
        Complex comp4 = new Complex(0.5, 0.0);
        Complex comp5 = QuBit.getOtherPA(comp4);
        comp5.mul(-1.0);
        QuBit halfQuBit = new QuBit(comp4, comp5);
        DJ.print(halfQuBit.toFormat("1/2[1 0]T - \u221a3/2[0 1]T"));
        DJ._print("(2)-2.\u57fa\u5e95{1/\u221a2(|0>+|1>), 1/\u221a2(-|0>+|1>)}\u3092\u5f97\u308b");
        double pai = Math.PI;
        double theta = pai / 4.0;
        double lamda = 0.0;
        double phi = 0.0;
        DJ.print("theta = ", theta);
        CompMat basisMat = QuBasis.rotate(theta, lamda, phi);
        QuBasis newBasis = new QuBasis(basisMat);
        DJ.printF("newBasis", newBasis);
        DJ._print("(2)-3.\u65b0\u57fa\u5e95\u3067\u306e\u78ba\u7387\u632f\u5e45\u3092\u5f97\u308b");
        QuBit newProbAmp = basisMat.innerProduct(halfQuBit);
        DJ.printF("newProbAmp", newProbAmp);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(3)\u5185\u7a4d\u3001\u30ce\u30eb\u30e0");
        DJ._print("(3)-1.\u5185\u7a4d\u3068\u30ce\u30eb\u30e0\u3001\uff11\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff12\u6b21\uff09");
        Complex[] target = halfQuBit.copyProbArray();
        DJ.print("target", target);
        Complex innPro = Complex.innerProduct(target);
        DJ.print("innPro", innPro);
        DJ.printF("innPro", innPro);
        Complex norm = Complex.norm(target);
        DJ.print("norm", norm);
        DJ.printF("norm", norm);
        DJ._print("(3)-2.\u5185\u7a4d\u3068\u30ce\u30eb\u30e0\u3001\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff14\u6b21\uff09");
        int length = 4;
        Complex[] dataArray = new Complex[length];
        for (int i2 = 0; i2 < length; ++i2) {
            double k = 0.1 + (double)i2 / 10.0;
            dataArray[i2] = new Complex(k, k + (double)i2 / 10.0);
        }
        DJ.print("dataArray", dataArray);
        DJ.printF("dataArray", dataArray);
        innPro = Complex.innerProduct(dataArray);
        DJ.print("innPro", innPro);
        DJ.printF("innPro", innPro);
        norm = Complex.norm(dataArray);
        DJ.print("norm", norm);
        DJ.printF("norm", norm);
        DJ._print("(3)-3.\u5185\u7a4d\u3068\u30ce\u30eb\u30e0\u3001\uff13\u91cf\u5b50\u30d3\u30c3\u30c8\uff08\uff18\u6b21\uff09");
        QuBit zeroQuBit = new QuBit();
        DJ._print("\u2460\u3000|0>\u3092-\u03c0/9\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m20degQuBit\u3092\u5f97\u308b");
        theta = -pai / 9.0;
        CompMat m20degMat = QuBasis.rotate(theta, lamda, phi);
        QuBit m20degQuBit = m20degMat.innerProduct(zeroQuBit);
        DJ.printF("m20degQuBit", m20degQuBit);
        DJ._print("\u2461\u3000|0>\u3092-\u03c0/6\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m30degQuBit\u3092\u5f97\u308b");
        theta = -pai / 6.0;
        DJ.print("theta = ", theta);
        CompMat m30degMat = QuBasis.rotate(theta, lamda, phi);
        DJ.printF("m30degMat", m30degMat);
        QuBit m30degQuBit = m30degMat.innerProduct(zeroQuBit);
        DJ.printF("m30degQuBit", m30degQuBit);
        DJ._print("\u2462\u3000|0>\u3092-\u03c0/4\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m45degQuBit\u3092\u5f97\u308b");
        theta = -pai / 4.0;
        CompMat m45degMat = QuBasis.rotate(theta, lamda, phi);
        QuBit m45degQuBit = m45degMat.innerProduct(zeroQuBit);
        DJ.printF("m45degQuBit", m45degQuBit);
        DJ._print("\u2463\u3000|0>\u3092-\u03c0/3\u30e9\u30b8\u30a2\u30f3\u56de\u8ee2\u3057\u305f\u91cf\u5b50\u30d3\u30c3\u30c8m60degQuBit\u3092\u5f97\u308b");
        theta = -pai / 3.0;
        CompMat m60degMat = QuBasis.rotate(theta, lamda, phi);
        QuBit m60degQuBit = m60degMat.innerProduct(zeroQuBit);
        DJ.printF("m60degQuBit", m60degQuBit);
        ArrayList<QuBit> quBits = new ArrayList<QuBit>();
        quBits.add(m20degQuBit);
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        DJ._print("\u76f8\u4e92\u4f5c\u7528\u524d");
        QuBit _quBits = new QuBit(quBits);
        DJ.printF("quBits", _quBits);
        target = _quBits.copyProbArray();
        innPro = Complex.innerProduct(target);
        DJ.print("innPro", innPro);
        DJ.printF("innPro", innPro);
        norm = Complex.norm(target);
        DJ.print("norm", norm);
        DJ.printF("norm", norm);
        DJ._print("\u76f8\u4e92\u4f5c\u7528\u5f8c");
        QuBit multiQuBit = QuBit.interactQuBit(quBits);
        DJ.printF("multiQuBit", multiQuBit);
        target = multiQuBit.copyProbArray();
        innPro = Complex.innerProduct(target);
        DJ.print("innPro", innPro);
        DJ.printF("innPro", innPro);
        norm = Complex.norm(target);
        DJ.print("norm", norm);
        DJ.printF("norm", norm);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(4)\u30b0\u30e9\u30e0\u30b7\u30e5\u30df\u30c3\u30c8\u306e\u76f4\u4ea4\u5316\u6cd5");
        DJ.print("(4)-1 \uff12\u6b21\u306e\u4f8b");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff11.OK");
        Complex[][] v2 = new Complex[2][2];
        v2[0][0] = new Complex(1.0, 0.0);
        v2[0][1] = new Complex(1.0, 0.0);
        v2[1][0] = new Complex(1.0, 0.0);
        v2[1][1] = new Complex(2.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v2);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff12.OK");
        v2[0][0] = new Complex(2.0, 0.0);
        v2[0][1] = new Complex(1.0, 0.0);
        v2[1][0] = new Complex(1.0, 0.0);
        v2[1][1] = new Complex(2.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v2);
        QuBasis u2 = QuBasis.gramSchmidt(v2);
        DJ._print("(4)-2 \uff13\u6b21\u306e\u4f8b");
        Complex[][] v3 = new Complex[3][3];
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff11.OK");
        v3[0][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[0][2] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(0.0, 0.0);
        v3[1][2] = new Complex(1.0, 0.0);
        v3[2][0] = new Complex(2.0, 0.0);
        v3[2][1] = new Complex(5.0, 0.0);
        v3[2][2] = new Complex(0.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff12.OK\u3000\uff08\uff11\uff0e\u306e\u8ee2\u7f6e\uff09");
        v3[0][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[0][2] = new Complex(2.0, 0.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(0.0, 0.0);
        v3[1][2] = new Complex(5.0, 0.0);
        v3[2][0] = new Complex(1.0, 0.0);
        v3[2][1] = new Complex(1.0, 0.0);
        v3[2][2] = new Complex(0.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff13.NG\u3000\uff08v\u30d9\u30af\u30c8\u30eb\u304c\u72ec\u7acb\u3067\u306f\u306a\u3044\uff09");
        v3[0][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[0][2] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(6.0, 0.0);
        v3[1][1] = new Complex(2.0, 0.0);
        v3[1][2] = new Complex(2.0, 0.0);
        v3[2][0] = new Complex(2.0, 0.0);
        v3[2][1] = new Complex(5.0, 0.0);
        v3[2][2] = new Complex(0.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff14.NG\u3000\uff08u\u30d9\u30af\u30c8\u30eb\u304c\u975e\u76f4\u4ea4\uff09");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[0][1] = new Complex(2.0, 0.0);
        v3[0][2] = new Complex(3.0, 0.0);
        v3[1][0] = new Complex(4.0, 0.0);
        v3[1][1] = new Complex(5.0, 0.0);
        v3[1][2] = new Complex(9.0, 0.0);
        v3[2][0] = new Complex(7.0, 0.0);
        v3[2][1] = new Complex(8.0, 0.0);
        v3[2][2] = new Complex(15.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff15.OK");
        v3[0][0] = new Complex(2.0, 0.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[2][0] = new Complex(0.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(2.0, 0.0);
        v3[2][1] = new Complex(0.0, 0.0);
        v3[0][2] = new Complex(1.0, 0.0);
        v3[1][2] = new Complex(1.0, 0.0);
        v3[2][2] = new Complex(2.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff16.OK");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[0][1] = new Complex(-1.0, 0.0);
        v3[0][2] = new Complex(0.0, 0.0);
        v3[1][0] = new Complex(2.0, 0.0);
        v3[1][1] = new Complex(-1.0, 0.0);
        v3[1][2] = new Complex(-2.0, 0.0);
        v3[2][0] = new Complex(1.0, 0.0);
        v3[2][1] = new Complex(-1.0, 0.0);
        v3[2][2] = new Complex(-2.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a\uff17.OK");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[0][1] = new Complex(0.0, 0.0);
        v3[0][2] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(-1.0, 0.0);
        v3[1][2] = new Complex(1.0, 0.0);
        v3[2][0] = new Complex(0.0, 0.0);
        v3[2][1] = new Complex(1.0, 0.0);
        v3[2][2] = new Complex(1.0, 0.0);
        CompMat v3Mat = new CompMat(v3);
        QuBasis v3QuBasis = new QuBasis(v3Mat);
        v3QuBasis.checkOrthonormal();
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(5)checkOrthonormal()\u3092QuBasis\u306e\u30e1\u30bd\u30c3\u30c9\u3068\u3057\u3066\u547c\u3073\u51fa\u3059");
        DJ._print("");
        DJ._print("\u4f8b\uff1a(5)-1. NG");
        v3Mat = new CompMat(3);
        v3Mat.setComp(0, 0, 1.0, 0.0);
        v3Mat.setComp(0, 1, 2.0, 0.0);
        v3Mat.setComp(0, 2, 3.0, 0.0);
        v3Mat.setComp(1, 0, 4.0, 0.0);
        v3Mat.setComp(1, 1, 5.0, 0.0);
        v3Mat.setComp(1, 2, 9.0, 0.0);
        v3Mat.setComp(2, 0, 7.0, 0.0);
        v3Mat.setComp(2, 1, 8.0, 0.0);
        v3Mat.setComp(2, 2, 15.0, 0.0);
        v3QuBasis = new QuBasis(v3Mat);
        v3QuBasis.checkOrthonormal();
        DJ._print("");
        DJ._print("\u4f8b\uff1a(5)-2. OK");
        v3Mat.setComp(0, 0, 3.0, 0.0);
        v3Mat.setComp(0, 1, 1.0, 0.0);
        v3Mat.setComp(0, 2, 2.0, 0.0);
        v3Mat.setComp(1, 0, 1.0, 0.0);
        v3Mat.setComp(1, 1, 0.0, 0.0);
        v3Mat.setComp(1, 2, 5.0, 0.0);
        v3Mat.setComp(2, 0, 1.0, 0.0);
        v3Mat.setComp(2, 1, 1.0, 0.0);
        v3Mat.setComp(2, 2, 0.0, 0.0);
        v3QuBasis.checkOrthonormal();
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(6)NG\u3068\u306a\u308b\u4e8b\u4f8b\u306eV\u30d9\u30af\u30c8\u30eb\u3092\u30c1\u30a7\u30c3\u30af");
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a7-1.NG (\u975e\u76f4\u4ea4)");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[0][1] = new Complex(2.0, 0.0);
        v3[0][2] = new Complex(3.0, 0.0);
        v3[1][0] = new Complex(4.0, 0.0);
        v3[1][1] = new Complex(5.0, 0.0);
        v3[1][2] = new Complex(9.0, 0.0);
        v3[2][0] = new Complex(7.0, 0.0);
        v3[2][1] = new Complex(8.0, 0.0);
        v3[2][2] = new Complex(15.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ._print("\u6b63\u898f\u76f4\u4ea4\u6027\u306e\u30c1\u30a7\u30c3\u30af\u3000\u4f8b\uff1a7-2.NG (7-1\u306e\u53cd\u8ee2\u3001\u975e\u76f4\u4ea4)");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(2.0, 0.0);
        v3[2][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(4.0, 0.0);
        v3[1][1] = new Complex(5.0, 0.0);
        v3[2][1] = new Complex(9.0, 0.0);
        v3[0][2] = new Complex(7.0, 0.0);
        v3[1][2] = new Complex(8.0, 0.0);
        v3[2][2] = new Complex(15.0, 0.0);
        QuantumPrime_6.checkOrthonormal(v3);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(7)\u884c\u5217\u5f0f\u3092\u30c1\u30a7\u30c3\u30af");
        DJ._print("\u8981\u7d20\u304c\u5358\u7d14\u306a\u4f8b");
        v2[0][0] = new Complex(1.0, 0.0);
        v2[0][1] = new Complex(2.0, 0.0);
        v2[1][0] = new Complex(3.0, 0.0);
        v2[1][1] = new Complex(4.0, 0.0);
        DJ._print("v2", v2);
        DJ.printF("v2", v2);
        Complex determinant = Complex.determinant(v2);
        DJ.print("|v2|", determinant);
        DJ.printF("|V2|", determinant);
        DJ._print("\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u4f8b");
        v2[0][0] = new Complex(0.93969, 0.0);
        v2[0][1] = new Complex(-0.34202, 0.0);
        v2[1][0] = new Complex(0.5, 0.0);
        v2[1][1] = new Complex(-0.86603, 0.0);
        DJ._print("v2", v2);
        DJ.printF("v2", v2);
        determinant = Complex.determinant(v2);
        DJ.print("|v2|", determinant);
        DJ.printF("|V2|", determinant);
        DJ._print("gramSchmidt\u3067\u6c42\u3081\u305f\u57fa\u5e95\u306e\u4f8b");
        DJ.print("u2", u2);
        DJ.printF("u2", u2);
        Complex[][] u = u2.getBasisMat().getMatrix();
        determinant = Complex.determinant(u);
        DJ.print("|u2|", determinant);
        DJ.printF("|u2|", determinant);
        DJ._print("\u8907\u7d20\u6570\u306e\u4f8b");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[0][2] = new Complex(0.0, 1.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(0.0, 1.0);
        v3[1][2] = new Complex(1.0, 0.0);
        v3[2][0] = new Complex(0.0, 1.0);
        v3[2][1] = new Complex(1.0, 0.0);
        v3[2][2] = new Complex(1.0, 0.0);
        DJ._print("v3", v3);
        DJ.printF("v3", v3);
        determinant = Complex.determinant(v3);
        DJ.print("|v3|", determinant);
        DJ.printF("|v3|", determinant);
        DJ._print("\u5bfe\u89d2\u8981\u7d20\u304c\u30bc\u30ed\u306e\u4f8b");
        v3[0][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(1.0, 0.0);
        v3[0][2] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(1.0, 0.0);
        v3[1][1] = new Complex(0.0, 0.0);
        v3[1][2] = new Complex(1.0, 0.0);
        v3[2][0] = new Complex(2.0, 0.0);
        v3[2][1] = new Complex(5.0, 0.0);
        v3[2][2] = new Complex(0.0, 0.0);
        DJ._print("v3", v3);
        DJ.printF("v3", v3);
        determinant = Complex.determinant(v3);
        DJ.print("|v3|", determinant);
        DJ.printF("|v3|", determinant);
        DJ._print("\u57fa\u5e95\u304c\u5f97\u3089\u308c\u306a\u304b\u3063\u305f\u4f8b");
        v3[0][0] = new Complex(1.0, 0.0);
        v3[1][0] = new Complex(2.0, 0.0);
        v3[2][0] = new Complex(3.0, 0.0);
        v3[0][1] = new Complex(4.0, 0.0);
        v3[1][1] = new Complex(5.0, 0.0);
        v3[2][1] = new Complex(9.0, 0.0);
        v3[0][2] = new Complex(7.0, 0.0);
        v3[1][2] = new Complex(8.0, 0.0);
        v3[2][2] = new Complex(15.0, 0.0);
        DJ._print("v3", v3);
        DJ.printF("v3", v3);
        determinant = Complex.determinant(v3);
        DJ.print("|v3|", determinant);
        DJ.printF("|v3|", determinant);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("(8)\uff12\u91cf\u5b50\u30d3\u30c3\u30c8\u3001\uff14\u6b21\u306e\u57fa\u5e95\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("\u56de\u8ee2\u3055\u305b\u305f\u91cf\u5b50\u30d3\u30c3\u30c8\u3067v\u30d9\u30af\u30c8\u30eb\u3092\u5f97\u308b");
        Complex[][] vArray = new Complex[4][4];
        Complex[][] uArray = new Complex[4][4];
        DJ._print("1. m20degQuBit\u24cd(m30degQuBit");
        quBits = new ArrayList();
        quBits.add(m20degQuBit);
        quBits.add(m30degQuBit);
        vArray[0][0] = quBits.get(0).copyProbAmp(0);
        vArray[0][1] = quBits.get(0).copyProbAmp(1);
        vArray[0][2] = quBits.get(1).copyProbAmp(0);
        vArray[0][3] = quBits.get(1).copyProbAmp(1);
        QuBit uQuBit = this.checkInteractQuBit(quBits);
        uArray[0][0] = uQuBit.getProbAmp(0);
        uArray[0][1] = uQuBit.getProbAmp(1);
        uArray[0][2] = uQuBit.getProbAmp(2);
        uArray[0][3] = uQuBit.getProbAmp(3);
        DJ._print("2. m30degQuBit\u24cd(m45degQuBit");
        quBits = new ArrayList();
        quBits.add(m30degQuBit);
        quBits.add(m45degQuBit);
        vArray[1][0] = quBits.get(0).copyProbAmp(0);
        vArray[1][1] = quBits.get(0).copyProbAmp(1);
        vArray[1][2] = quBits.get(1).copyProbAmp(0);
        vArray[1][3] = quBits.get(1).copyProbAmp(1);
        uQuBit = this.checkInteractQuBit(quBits);
        uArray[1][0] = uQuBit.getProbAmp(0);
        uArray[1][1] = uQuBit.getProbAmp(1);
        uArray[1][2] = uQuBit.getProbAmp(2);
        uArray[1][3] = uQuBit.getProbAmp(3);
        DJ._print("3. m45degQuBit\u24cd(m60degQuBit");
        quBits = new ArrayList();
        quBits.add(m45degQuBit);
        quBits.add(m60degQuBit);
        vArray[2][0] = quBits.get(0).copyProbAmp(0);
        vArray[2][1] = quBits.get(0).copyProbAmp(1);
        vArray[2][2] = quBits.get(1).copyProbAmp(0);
        vArray[2][3] = quBits.get(1).copyProbAmp(1);
        uQuBit = this.checkInteractQuBit(quBits);
        uArray[2][0] = uQuBit.getProbAmp(0);
        uArray[2][1] = uQuBit.getProbAmp(1);
        uArray[2][2] = uQuBit.getProbAmp(2);
        uArray[2][3] = uQuBit.getProbAmp(3);
        DJ._print("4. m60degQuBit\u24cd(m20degQuBit");
        quBits = new ArrayList();
        quBits.add(m60degQuBit);
        quBits.add(m20degQuBit);
        vArray[3][0] = quBits.get(0).copyProbAmp(0);
        vArray[3][1] = quBits.get(0).copyProbAmp(1);
        vArray[3][2] = quBits.get(1).copyProbAmp(0);
        vArray[3][3] = quBits.get(1).copyProbAmp(1);
        uQuBit = this.checkInteractQuBit(quBits);
        uArray[3][0] = uQuBit.getProbAmp(0);
        uArray[3][1] = uQuBit.getProbAmp(1);
        uArray[3][2] = uQuBit.getProbAmp(2);
        uArray[3][3] = uQuBit.getProbAmp(3);
        DJ.print("");
        DJ._print("(8)-1 Original QuBasis");
        QuBasis.checkOrthonormal(vArray);
        DJ.print("");
        DJ._print("(8)-2 Interacted QuBasis");
        QuBasis.checkOrthonormal(uArray);
        DJ._print("");
        DJ.print("// ---------------------------------------------------");
        DJ.print("\uff08X\uff09\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570\u304b\u3089\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u500b\u6570\u3092\u6c42\u3081\u308b");
        DJ._print("\uff08X\uff0d\uff11\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u500b\u65701\u3001\u78ba\u7387\u632f\u5e45\u306e\u500b\u65702");
        QuBit aQuBit = new QuBit(1);
        numOfQuBit = aQuBit.getNumOfQuBit();
        DJ.print("numOfQuBit = ", numOfQuBit);
        int numOfProbAmp = aQuBit.getProbAmpLength();
        DJ.print("numOfProbAmp = ", numOfProbAmp);
        QuBit _QuBit = new QuBit(numOfQuBit);
        DJ.printF("_QuBit", _QuBit);
        int iPALength = QuBit.calcNumOfProbAmp(_QuBit.getNumOfQuBit());
        DJ.print("iPALength = ", iPALength);
        numOfQuBit = QuBit.calcNumOfQuBit(iPALength);
        DJ.print("numOfQuBit = ", numOfQuBit);
        DJ._print("\uff08X\uff0d\uff12\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u500b\u65702\u3001\u78ba\u7387\u632f\u5e45\u306e\u500b\u65704");
        aQuBit = new QuBit(2);
        numOfQuBit = aQuBit.getNumOfQuBit();
        DJ.print("numOfQuBit = ", numOfQuBit);
        numOfProbAmp = aQuBit.getProbAmpLength();
        DJ.print("numOfProbAmp = ", numOfProbAmp);
        _QuBit = new QuBit(numOfQuBit);
        DJ.printF("_QuBit", _QuBit);
        iPALength = QuBit.calcNumOfProbAmp(_QuBit.getNumOfQuBit());
        DJ.print("iPALength = ", iPALength);
        numOfQuBit = QuBit.calcNumOfQuBit(iPALength);
        DJ.print("numOfQuBit = ", numOfQuBit);
        DJ._print("\uff08X\uff0d\uff13\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u500b\u65703\u3001\u78ba\u7387\u632f\u5e45\u306e\u500b\u65708");
        aQuBit = new QuBit(3);
        numOfQuBit = aQuBit.getNumOfQuBit();
        DJ.print("numOfQuBit = ", numOfQuBit);
        numOfProbAmp = aQuBit.getProbAmpLength();
        DJ.print("numOfProbAmp = ", numOfProbAmp);
        _QuBit = new QuBit(numOfQuBit);
        DJ.printF("_QuBit", _QuBit);
        iPALength = QuBit.calcNumOfProbAmp(_QuBit.getNumOfQuBit());
        DJ.print("iPALength = ", iPALength);
        numOfQuBit = QuBit.calcNumOfQuBit(iPALength);
        DJ.print("numOfQuBit = ", numOfQuBit);
        DJ._print("\uff08X\uff0d\uff14\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u500b\u65704\u3001\u78ba\u7387\u632f\u5e45\u306e\u500b\u657016");
        aQuBit = new QuBit(4);
        numOfQuBit = aQuBit.getNumOfQuBit();
        DJ.print("numOfQuBit = ", numOfQuBit);
        numOfProbAmp = aQuBit.getProbAmpLength();
        DJ.print("numOfProbAmp = ", numOfProbAmp);
        _QuBit = new QuBit(numOfQuBit);
        DJ.printF("_QuBit", _QuBit);
        iPALength = QuBit.calcNumOfProbAmp(_QuBit.getNumOfQuBit());
        DJ.print("iPALength = ", iPALength);
        numOfQuBit = QuBit.calcNumOfQuBit(iPALength);
        DJ.print("numOfQuBit = ", numOfQuBit);
        DJ._print("\uff08X\uff0d\uff15\uff09\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570\u304c\uff12\u306e\u3079\u304d\u4e57\u3067\u3042\u308b\u3053\u3068\u3092\u30c1\u30a7\u30c3\u30af");
        for (int numOfPA2 = 1; numOfPA2 < 35; ++numOfPA2) {
            DJ.print_("\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570" + numOfPA2 + "\u306f");
            boolean result = QuBit.checkPowerOfTwo(numOfPA2);
            if (result) {
                DJ.print("\uff12\u306e\u3079\u304d\u4e57\u3067\u3059\u3002");
                continue;
            }
            DJ.print("\uff12\u306e\u3079\u304d\u4e57\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        DJ._print("\uff08X\uff0d\uff16\uff09\u91cf\u5b50\u30d3\u30c3\u30c8\u306e\u751f\u6210\u6642\u306b\u3001\u4e0e\u3048\u3089\u308c\u305fprobAmpVec\u306e\n\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570\u304c\uff12\u306e\u3079\u304d\u4e57\u3067\u3042\u308b\u3053\u3068\u3092\u30c1\u30a7\u30c3\u30af");
        DJ.print("... +1 ...........");
        for (numOfPA = 1; numOfPA < 6; ++numOfPA) {
            DJ.print("\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570 = " + numOfPA);
            CompVec aCompVec = new CompVec(numOfPA);
            aQuBit = new QuBit(aCompVec);
        }
        DJ.print("... +2 ...........");
        for (numOfPA = 6; numOfPA < 19; numOfPA += 2) {
            DJ.print("\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570 = " + numOfPA);
            CompVec aCompVec = new CompVec(numOfPA);
            aQuBit = new QuBit(aCompVec);
        }
        DJ.print("... +4 ...........");
        for (numOfPA = 24; numOfPA < 73; numOfPA += 4) {
            DJ.print("\u78ba\u7387\u632f\u5e45\u306e\u500b\u6570 = " + numOfPA);
            CompVec aCompVec = new CompVec(numOfPA);
            aQuBit = new QuBit(aCompVec);
        }
        DJ._print("");
        DJ._print("\u91cf\u5b50\u8a08\u7b97\u306e\u5b8c\u4e86");
        DJ.print("QuantumPrime_6.quantumPrime_6() ===========================");
    }

    private QuBit checkInteractQuBit(ArrayList<QuBit> quBits) {
        DJ._print("\u76f8\u4e92\u4f5c\u7528\u524d");
        QuBit _quBits = new QuBit(quBits);
        DJ.printF("quBits", _quBits);
        Complex[] qbNotInteract = _quBits.copyProbArray();
        Complex innPro = Complex.innerProduct(qbNotInteract);
        DJ.print_("innPro", innPro);
        DJ.printF("  innPro", innPro);
        Complex norm = Complex.norm(qbNotInteract);
        DJ.print_("norm", norm);
        DJ.printF("  norm", norm);
        DJ._print("\u76f8\u4e92\u4f5c\u7528\u5f8c");
        QuBit multiQuBit = QuBit.interactQuBit(quBits);
        DJ.printF("multiQuBit", multiQuBit);
        Complex[] qbInteracted = multiQuBit.copyProbArray();
        innPro = Complex.innerProduct(qbInteracted);
        DJ.print_("innPro", innPro);
        DJ.printF("  innPro", innPro);
        norm = Complex.norm(qbInteracted);
        DJ.print_("norm", norm);
        DJ.printF("  norm", norm);
        return multiQuBit;
    }

    public static void checkOrthonormal(Complex[][] originalArrys) {
        Complex innPro;
        DJ.print("v", originalArrys);
        DJ.printF("v", originalArrys);
        DJ.print("\u884c\u5217\u5f0f|v|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        Complex determinant = Complex.determinant(originalArrys);
        DJ.print_("|v|", determinant);
        DJ.printF("  |v|", determinant);
        QuBasis orthonormalVec = QuBasis.gramSchmidt(originalArrys);
        DJ._print("u", orthonormalVec);
        DJ.printF("u", orthonormalVec);
        Complex[][] orthonormalArrays = orthonormalVec.getBasisMat().getMatrix();
        DJ.print("\u884c\u5217\u5f0f|u|\u304c\u30bc\u30ed\u306a\u3089\u3070\u30d9\u30af\u30c8\u30eb\u306f\u72ec\u7acb\u3067\u306f\u306a\u3044");
        determinant = Complex.determinant(orthonormalArrays);
        DJ.print_("|u|", determinant);
        DJ.printF("  |u|", determinant);
        DJ._print("\u884c\u306e\u5185\u7a4d\u30fb\u30ce\u30eb\u30e0\u304c\uff11\u306a\u3089\u3070\u305d\u306e\u57fa\u5e95\u306f\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u308b");
        int length = originalArrys.length;
        for (int i = 0; i < length; ++i) {
            DJ.print("" + i + "\u884c\u76ee\u306e\u5185\u7a4d\u3068\u30ce\u30eb\u30e0");
            Complex[] u = orthonormalArrays[i];
            innPro = Complex.innerProduct(u);
            DJ.print_("innPro(u[" + i + "])", innPro);
            DJ.printF("  innPro(u[" + i + "])", innPro);
            Complex norm = Complex.norm(u);
            DJ.print_("norm(u[" + i + "])", norm);
            DJ.printF("  norm(u[" + i + "])", norm);
        }
        DJ._print("\u884c\u3068\u884c\u306e\u5185\u7a4d\u304c\u30bc\u30ed\u306a\u3089\u3070\uff12\u3064\u306e\u57fa\u5e95\u306f\u76f4\u4ea4\u3057\u3066\u3044\u308b");
        for (int i = 0; i < length; ++i) {
            Complex[] u_i = orthonormalArrays[i];
            for (int k = i + 1; k < length; ++k) {
                DJ.print_("" + i + "\u884c\u76ee\u3068" + k + "\u884c\u76ee\u306e\u5185\u7a4d");
                Complex[] u_k = orthonormalArrays[k];
                innPro = Complex.innerProduct(u_i, u_k);
                DJ.print_(" ", innPro);
                DJ.printF("  ", innPro);
            }
        }
    }
}

