/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.LogEditor;

public class Normal {
    private double average = 0.0;
    private double stdDev = 1.0;

    public double average(double[][] original) {
        double average_;
        double sum = 0.0;
        int row = original.length;
        int col = original[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                sum += original[i][j];
            }
        }
        int elementNumber = row * col;
        if (elementNumber <= 0) {
            LogEditor.print("***** ERROR ***** Normal.avarage(): ");
            LogEditor.print("Element number of array <= 0.");
            average_ = Double.NaN;
        } else {
            average_ = sum / (double)elementNumber;
        }
        return average_;
    }

    public double stdDev(double[][] original) {
        double stdDev_;
        double average_ = this.average(original);
        double sum = 0.0;
        int row = original.length;
        int col = original[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                double diff = original[i][j] - average_;
                sum += diff * diff;
            }
        }
        int elementNumber = row * col;
        if (elementNumber <= 0) {
            LogEditor.print("***** ERROR ***** Normal.avarage(): ");
            LogEditor.print("Element number of array <= 0.");
            stdDev_ = Double.NaN;
        } else {
            stdDev_ = Math.sqrt(sum / (double)elementNumber);
        }
        return stdDev_;
    }

    public double[][] normalize(double[][] original) {
        this.average = this.average(original);
        this.stdDev = this.stdDev(original);
        if (this.stdDev <= Double.MIN_VALUE) {
            LogEditor.print("***** ERROR ***** DJ.normalize(): ");
            LogEditor.print("Standard Deviation is neary Zero.");
            return null;
        }
        int row = original.length;
        int col = original[0].length;
        double[][] normalizedArray = new double[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                normalizedArray[i][j] = (original[i][j] - this.average) / this.stdDev;
            }
        }
        return normalizedArray;
    }

    public double reverse(double normalizedValue) {
        double originalValue = normalizedValue * this.stdDev + this.average;
        return originalValue;
    }

    public double[][] reverse(double[][] normalizedArray) {
        int row = normalizedArray.length;
        int col = normalizedArray[0].length;
        double[][] originalArray = new double[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                originalArray[i][j] = normalizedArray[i][j] * this.stdDev + this.average;
            }
        }
        return originalArray;
    }
}

