/*
 * Decompiled with CFR 0.152.
 */
package util.comp;

import java.util.Random;
import quan.QuBit;
import util.DJ;
import util.comp.CompVec;
import util.comp.Complex;

public class CompMat {
    public static long RANDOM_SEED = 314L;
    private Complex[][] complexMatrix;

    public CompMat() {
    }

    public CompMat(int row, int col) {
        this.complexMatrix = new Complex[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j] = new Complex();
            }
        }
    }

    public CompMat(int order) {
        this.complexMatrix = new Complex[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                this.complexMatrix[i][j] = new Complex(0.0, 0.0);
            }
            this.complexMatrix[i][i] = new Complex(1.0, 0.0);
        }
    }

    public CompMat(int order, Complex element) {
        this.complexMatrix = new Complex[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                this.complexMatrix[i][j] = element.copyComplex();
            }
        }
    }

    public CompMat(Complex[] dataArray) {
        int length = dataArray.length;
        int order = (int)Math.sqrt(length);
        this.complexMatrix = new Complex[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                this.complexMatrix[i][j] = dataArray[i * order + j];
            }
        }
    }

    public CompMat(Complex[][] dataMat) {
        this.complexMatrix = dataMat;
    }

    public CompMat(QuBit[] quBitArray) {
        int length = quBitArray.length;
        this.complexMatrix = new Complex[length][length];
        for (int i = 0; i < length; ++i) {
            QuBit aQuBit = quBitArray[i];
            for (int j = 0; j < length; ++j) {
                this.complexMatrix[j][i] = aQuBit.getProbAmp(j);
            }
        }
    }

    public CompMat(int row, int col, long randomSeed) {
        Random random = new Random(randomSeed);
        random = new Random(randomSeed);
        this.complexMatrix = new Complex[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j] = new Complex(random.nextDouble(), 0.0);
            }
        }
    }

    public double getReal(int row, int col) {
        return this.complexMatrix[row][col].getReal();
    }

    public void setReal(int row, int col, double real) {
        this.complexMatrix[row][col].setReal(real);
    }

    public double getImag(int row, int col) {
        return this.complexMatrix[row][col].getImag();
    }

    public void setImag(int row, int col, double imag) {
        this.complexMatrix[row][col].setImag(imag);
    }

    public Complex getComp(int row, int col) {
        return this.complexMatrix[row][col];
    }

    public Complex copyComp(int row, int col) {
        return this.complexMatrix[row][col].copyComplex();
    }

    public void setComp(int row, int col, double real, double imag) {
        this.complexMatrix[row][col].setComplex(real, imag);
    }

    public void setComp(int row, int col, Complex element) {
        this.complexMatrix[row][col].setComplex(element);
    }

    public CompVec getRow(int rowNumber) {
        CompVec row = new CompVec(this.complexMatrix[rowNumber]);
        return row;
    }

    public CompVec copyColumn(int colNumber) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompVec resultVec = new CompVec(row);
        for (int i = 0; i < row; ++i) {
            Complex aComp = this.complexMatrix[i][colNumber];
            resultVec.setComp(i, aComp.getReal(), aComp.getImag());
        }
        return resultVec;
    }

    public Complex[][] getMatrix() {
        return this.complexMatrix;
    }

    public CompMat copyCompMat() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _compMat = new CompMat(row, col);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                _compMat.setComp(i, j, this.complexMatrix[i][j]);
            }
        }
        return _compMat;
    }

    public Complex[][] copyMatrix() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _compMat = new CompMat(row, col);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                _compMat.setComp(i, j, this.complexMatrix[i][j]);
            }
        }
        return _compMat.complexMatrix;
    }

    public void setArray(Complex[][] complexMatrix) {
        int row = complexMatrix.length;
        int col = complexMatrix[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j].setComplex(complexMatrix[i][j]);
            }
        }
    }

    public int rowNumber() {
        return this.complexMatrix.length;
    }

    public int colNumber() {
        return this.complexMatrix[0].length;
    }

    public void product(double real) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j].mul(real);
            }
        }
    }

    public void product(Complex comp) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j].mul(comp);
            }
        }
    }

    public void product(CompMat operand) {
        int row = this.complexMatrix.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of row (=" + row + ") is less than one.");
            return;
        }
        int col = this.complexMatrix[0].length;
        if (col < 1) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of col (=" + col + ") is less than one.");
            return;
        }
        int operandRow = operand.rowNumber();
        if (operandRow != row) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of row is not same.\n target matrix row is " + row + ", \n operand matrix length is " + operandRow + ".");
            return;
        }
        int operandCol = operand.colNumber();
        if (operandCol != col) {
            DJ.print("***** ERROR ***** CompMat.product(CompMat)\n Number of col is not same.\n target matrix col is " + col + ", \n operand matrix length is " + operandCol + ".");
            return;
        }
        Complex[][] operandMatrix = operand.getMatrix();
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.complexMatrix[i][j].mul(operandMatrix[i][j]);
            }
        }
    }

    public CompMat conjugate() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        CompMat _conjugate = new CompMat(col, row);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                _conjugate.setComp(j, i, this.complexMatrix[i][j].Conjugate());
            }
        }
        return _conjugate;
    }

    public CompVec innerProduct(CompVec operand) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int operandlength = operand.length();
        if (row != operandlength) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompMat)\n Element numbers are not same. target row number is " + row + ",  operand length is " + operandlength + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        CompVec _innerProduct = new CompVec(col);
        for (int i = 0; i < col; ++i) {
            for (int k = 0; k < row; ++k) {
                Complex conj = _conjugate.copyComp(i, k);
                conj.mul(operand.getComp(k));
                _innerProduct.getComp(i).add(conj);
            }
        }
        return _innerProduct;
    }

    public CompMat innerProduct(CompMat operand) {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int operandRow = operand.rowNumber();
        int operandCol = operand.colNumber();
        if (row != operandRow) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompMat)\n Element numbers are not same. target row number is " + row + ",  operand row number is " + operandRow + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        CompMat _innerProduct = new CompMat(col, operandCol);
        for (int i = 0; i < col; ++i) {
            for (int j = 0; j < operandCol; ++j) {
                for (int k = 0; k < row; ++k) {
                    Complex conj = _conjugate.copyComp(i, k);
                    conj.mul(operand.getComp(k, j));
                    _innerProduct.getComp(i, j).add(conj);
                }
            }
        }
        return _innerProduct;
    }

    public QuBit innerProduct(QuBit operand) {
        int operandLength;
        int row = this.complexMatrix.length;
        if (row < 1) {
            DJ.print("***** ERROR ***** CompMat.innerProduct(QuBit operand)\n target row number is less than one.");
            return null;
        }
        int col = this.complexMatrix[0].length;
        if (col % 2 != 0) {
            DJ.print("***** ERROR ***** CompMat.innerProduct(QuBit operand)\n target column number is (" + col + ") is not even number.");
        }
        if (row != (operandLength = operand.getProbAmpLength())) {
            DJ.print("***** ERROR ***** Complex.innerProduct(QuBit operand)\n Element numbers are not same.\n target row number is " + row + ", \n operand length is " + operandLength + ".");
            return null;
        }
        CompMat _conjugate = this.conjugate();
        QuBit resultQB = new QuBit(col / 2);
        CompVec _innerProduct = resultQB.getProbAmp();
        for (int i = 0; i < col; ++i) {
            for (int k = 0; k < operandLength; ++k) {
                Complex conj = _conjugate.copyComp(i, k);
                conj.mul(operand.getProbAmp(k));
                _innerProduct.getComp(i).add(conj);
            }
        }
        return resultQB;
    }

    public boolean equals(CompMat cm) {
        if (this == cm) {
            return true;
        }
        int thisRow = this.rowNumber();
        if (thisRow != cm.rowNumber()) {
            return false;
        }
        int thisCol = this.colNumber();
        if (thisCol != cm.colNumber()) {
            return false;
        }
        for (int i = 0; i < thisRow; ++i) {
            for (int j = 0; j < thisCol; ++j) {
                Complex thisComp = this.complexMatrix[i][j];
                if (thisComp.equals(cm.complexMatrix[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            space.append(" ");
        }
        return space.toString();
    }

    public String toString() {
        int index;
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < row; ++i) {
            sb.append("[");
            for (int j = 0; j < col; ++j) {
                sb.append(this.complexMatrix[i][j].toString());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat() {
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        int[] maxWide = new int[col];
        for (int j = 0; j < col; ++j) {
            maxWide[j] = 5;
        }
        String[][] buf = new String[row][col];
        int[][] wides = new int[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                String text = this.complexMatrix[i][j].toFormat();
                if (this.complexMatrix[i][j].getReal() >= 0.0) {
                    buf[i][j] = " " + text;
                    wides[i][j] = text.length() + 1;
                } else {
                    buf[i][j] = text;
                    wides[i][j] = text.length();
                }
                if (wides[i][j] <= maxWide[j]) continue;
                maxWide[j] = wides[i][j];
            }
        }
        StringBuilder sb = new StringBuilder("F\n");
        String filler = "  ";
        int gap = filler.length();
        int spaces = maxWide[0];
        for (int j = 1; j < col; ++j) {
            spaces = spaces + gap + maxWide[j];
        }
        sb.append("\u250c").append(this.getSpace(spaces)).append("\u2510\n");
        for (int i = 0; i < row; ++i) {
            sb.append("\u2502");
            for (int j = 0; j < col; ++j) {
                sb.append(buf[i][j]);
                sb.append(this.getSpace(maxWide[j] - wides[i][j])).append(filler);
            }
            int index = sb.length();
            sb.replace(index - gap, index, "\u2502\n");
        }
        sb.append("\u2514").append(this.getSpace(spaces)).append("\u2518\n");
        return sb.toString();
    }

    public String toString(String label) {
        int index;
        int row = this.complexMatrix.length;
        int col = this.complexMatrix[0].length;
        StringBuilder sb = new StringBuilder(label + ":\n[");
        for (int i = 0; i < row; ++i) {
            sb.append("[");
            for (int j = 0; j < col; ++j) {
                sb.append(this.complexMatrix[i][j].toString());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return label + ":" + str;
    }

    public static String toString(Complex[][] complexArray) {
        int index;
        int row = complexArray.length;
        int col = complexArray[0].length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < row; ++i) {
            sb.append("[");
            for (int j = 0; j < col; ++j) {
                sb.append(complexArray[i][j].toString());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder("F\n[");
        for (int i = 0; i < colLength; ++i) {
            sb.append("[");
            for (int j = 0; j < order; ++j) {
                sb.append(complexArray[i][j].toFormat());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(label + ":\n[");
        for (int i = 0; i < colLength; ++i) {
            sb.append("[");
            for (int j = 0; j < order; ++j) {
                sb.append(complexArray[i][j].toString());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[][] complexArray) {
        int index;
        int colLength = complexArray.length;
        int order = complexArray[0].length;
        StringBuilder sb = new StringBuilder(label + ":F\n[");
        for (int i = 0; i < colLength; ++i) {
            sb.append("[");
            for (int j = 0; j < order; ++j) {
                sb.append(complexArray[i][j].toFormat());
                sb.append("  ");
            }
            index = sb.length();
            sb.replace(index - 2, index, "]\n");
        }
        index = sb.length();
        sb.replace(index - 1, index, "]");
        return sb.toString();
    }
}

