/*
 * Decompiled with CFR 0.152.
 */
package util.comp;

import java.util.ArrayList;
import quan.QuBit;
import util.DJ;
import util.comp.CompMat;
import util.comp.Complex;

public class CompVec {
    public static final boolean H_VEC = false;
    public static final boolean V_VEC = true;
    private Complex[] complexArray;

    public CompVec() {
    }

    public CompVec(int length) {
        this.complexArray = new Complex[length];
        for (int i = 0; i < length; ++i) {
            this.complexArray[i] = new Complex();
        }
    }

    public CompVec(int length, double real, double image) {
        this.complexArray = new Complex[length];
        for (int i = 0; i < length; ++i) {
            this.complexArray[i] = new Complex(real, image);
        }
    }

    public CompVec(int length, Complex complex) {
        this.complexArray = new Complex[length];
        for (int i = 0; i < length; ++i) {
            this.complexArray[i] = complex.copyComplex();
        }
    }

    public CompVec(int length, int index) {
        this.complexArray = Complex.complexArray(length);
        this.complexArray[index].setComplex(1.0, 0.0);
    }

    public CompVec(double[] dataArray) {
        int dataLength = dataArray.length;
        if (dataLength % 2 != 0) {
            DJ.print("***** ERROR ***** CompVec.CompVec(double[] dataArray)\n Number of data (" + dataLength + ") is not even number.");
        }
        int compLength = dataLength / 2;
        this.complexArray = new Complex[compLength];
        for (int i = 0; i < compLength; ++i) {
            int i2 = i * 2;
            this.complexArray[i] = new Complex(dataArray[i2], dataArray[i2 + 1]);
        }
    }

    public CompVec(Complex[] complexArray) {
        int compLength = complexArray.length;
        this.complexArray = new Complex[compLength];
        for (int i = 0; i < compLength; ++i) {
            this.complexArray[i] = complexArray[i].copyComplex();
        }
    }

    public CompVec(ArrayList<QuBit> quBitList) {
        int qbListLength = quBitList.size();
        int compLength = qbListLength * 2;
        this.complexArray = new Complex[compLength];
        for (int i = 0; i < qbListLength; ++i) {
            QuBit quBit = quBitList.get(i);
            this.complexArray[i * 2] = quBit.copyProbAmp(0);
            this.complexArray[i * 2 + 1] = quBit.copyProbAmp(1);
        }
    }

    public double getReal(int index) {
        return this.complexArray[index].getReal();
    }

    public void setReal(int index, double real) {
        this.complexArray[index].setReal(real);
    }

    public double getImag(int index) {
        return this.complexArray[index].getImag();
    }

    public void setImag(int index, Double imag) {
        this.complexArray[index].setImag(imag);
    }

    public Complex getComp(int index) {
        return this.complexArray[index];
    }

    public Complex copyComp(int index) {
        return this.complexArray[index].copyComplex();
    }

    public void setComp(int index, Complex complex) {
        this.complexArray[index].setComplex(complex);
    }

    public void setComp(int index, double real, double imag) {
        this.complexArray[index].setComplex(real, imag);
    }

    public Complex[] getArray() {
        return this.complexArray;
    }

    public CompVec copyCompVec() {
        int length = this.complexArray.length;
        CompVec _compVec = new CompVec(length);
        for (int i = 0; i < length; ++i) {
            _compVec.setComp(i, this.complexArray[i]);
        }
        return _compVec;
    }

    public Complex[] copyArray() {
        int length = this.complexArray.length;
        CompVec _compVec = new CompVec(length);
        for (int i = 0; i < length; ++i) {
            _compVec.setComp(i, this.complexArray[i]);
        }
        return _compVec.complexArray;
    }

    public void setArray(Complex[] operandArray) {
        this.complexArray = operandArray;
    }

    public void copyArray(Complex[] operandArray) {
        int length = this.complexArray.length;
        int operandLength = operandArray.length;
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.product(vector)\n Array length are not same.\n target array length is " + length + ", \n operand array length is " + operandLength + ".");
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.complexArray[i].setComplex(operandArray[i]);
        }
    }

    public int length() {
        return this.complexArray.length;
    }

    public void sum(CompVec operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.sum(CompVec)\n target vector length (=" + length + ") is less than one.");
            return;
        }
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.sum(vector)\n Vecter length are not same.\n target vector length is " + length + ", \n operand vecter length is " + operandLength + ".");
            return;
        }
        Complex[] operandArray = operand.getArray();
        for (int i = 0; i < length; ++i) {
            this.complexArray[i].add(operandArray[i]);
        }
    }

    public void product(double real) {
        int length = this.complexArray.length;
        for (int i = 0; i < length; ++i) {
            this.complexArray[i].mul(real);
        }
    }

    public void product(Complex comp) {
        int length = this.complexArray.length;
        for (int i = 0; i < length; ++i) {
            this.complexArray[i].mul(comp);
        }
    }

    public void product(CompVec operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.product(CompVec)\n target vector length (=" + length + ") is less than one.");
            return;
        }
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** CompVec.product(vector)\n Vecter length are not same.\n target vector length is " + length + ", \n operand vecter length is " + operandLength + ".");
            return;
        }
        Complex[] operandArray = operand.getArray();
        for (int i = 0; i < length; ++i) {
            this.complexArray[i].mul(operandArray[i]);
        }
    }

    public CompVec Conjugate() {
        int length = this.complexArray.length;
        CompVec _conjugate = new CompVec(length);
        for (int i = 0; i < length; ++i) {
            _conjugate.setComp(i, this.complexArray[i].Conjugate());
        }
        return _conjugate;
    }

    public Complex innerProduct(CompVec operand) {
        int length = this.complexArray.length;
        int operandLength = operand.length();
        if (length != operandLength) {
            DJ.print("***** ERROR ***** Complex.innerProduct(CompVec)\n vecter length are not same. target vecter length is " + length + ",  operand length is " + operandLength + ".");
            return null;
        }
        CompVec _conjugate = this.Conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        for (int i = 0; i < operandLength; ++i) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(operand.getComp(i));
            _innerProduct.add(conj);
        }
        return _innerProduct;
    }

    public Complex innerProduct() {
        int length = this.complexArray.length;
        CompVec _conjugate = this.Conjugate();
        Complex _innerProduct = new Complex(0.0, 0.0);
        for (int i = 0; i < length; ++i) {
            Complex conj = _conjugate.getComp(i);
            conj.mul(this.getComp(i));
            _innerProduct.add(conj);
        }
        return _innerProduct;
    }

    public CompVec innerProduct(CompMat operand) {
        int length = this.complexArray.length;
        if (length < 1) {
            DJ.print("***** ERROR ***** CompVec.innerProduct(CompMat)\n target vector length (=" + length + ") is less than one.");
            return null;
        }
        CompVec conjuVec = this.Conjugate();
        int row = operand.rowNumber();
        if (length != row) {
            DJ.print("***** ERROR ***** CompVec.innerProduct(CompMat)\n Vecter length is not equal to row number of Matrix.\n target vector length is " + length + ", \n operand Matrix row number is " + row + ".");
            return null;
        }
        int col = operand.colNumber();
        CompVec resultVec = new CompVec(col);
        Complex[] resultArray = resultVec.complexArray;
        for (int j = 0; j < col; ++j) {
            CompVec aCompVec = operand.copyColumn(j);
            for (int k = 0; k < length; ++k) {
                Complex aComplex = conjuVec.copyComp(k);
                aComplex.mul(operand.getComp(k, j));
                resultVec.getComp(j).add(aComplex);
            }
        }
        return resultVec;
    }

    public boolean equals(CompVec cv) {
        if (this == cv) {
            return true;
        }
        int thisLength = this.length();
        if (thisLength != cv.length()) {
            return false;
        }
        for (int i = 0; i < thisLength; ++i) {
            Complex thisComp = this.complexArray[i];
            if (thisComp.equals(cv.complexArray[i])) continue;
            return false;
        }
        return true;
    }

    private String getSpace(int size) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            space.append(" ");
        }
        return space.toString();
    }

    public String toString() {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < order; ++i) {
            sb.append(this.complexArray[i].toString());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toFormat() {
        int order = this.complexArray.length;
        int maxWide = 5;
        String[] buf = new String[order];
        int[] wides = new int[order];
        for (int i = 0; i < order; ++i) {
            int tempWide;
            String text = this.complexArray[i].toFormat();
            if (this.complexArray[i].getReal() >= 0.0) {
                buf[i] = " " + text;
                tempWide = text.length() + 1;
            } else {
                buf[i] = text;
                tempWide = text.length();
            }
            wides[i] = tempWide;
            if (tempWide <= maxWide) continue;
            maxWide = tempWide;
        }
        StringBuilder sb = new StringBuilder("F \n");
        sb.append("\u250c").append(this.getSpace(maxWide)).append("\u2510\n");
        for (int i = 0; i < order; ++i) {
            sb.append("\u2502");
            sb.append(buf[i]);
            sb.append(this.getSpace(maxWide - wides[i]));
            sb.append("\u2502");
            sb.append("\n");
        }
        sb.append("\u2514").append(this.getSpace(maxWide)).append("\u2518");
        return sb.toString();
    }

    public String toFormat(boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder("F \n[") : new StringBuilder("F [");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toString(String label) {
        int order = this.complexArray.length;
        StringBuilder sb = new StringBuilder(label + ":[");
        for (int i = 0; i < order; ++i) {
            sb.append(this.complexArray[i].toString());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public String toString(String label, boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(label + ":\n[") : new StringBuilder(label + ":[");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public String toFormat(String label) {
        String str = this.toFormat();
        return label + ":" + str;
    }

    public String toFormat(String label, boolean orient) {
        int order = this.complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(label + ":F\n[") : new StringBuilder(label + ":F [");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(this.complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public static String toString(Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < length; ++i) {
            sb.append(complexArray[i].toString());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder("F[");
        for (int i = 0; i < order; ++i) {
            sb.append(complexArray[i].toFormat());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder("F \n[") : new StringBuilder("F [");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray) {
        int order = complexArray.length;
        StringBuilder sb = new StringBuilder(label + ":[");
        for (int i = 0; i < order; ++i) {
            sb.append(complexArray[i].toString());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toString(String label, Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(label + ":\n[") : new StringBuilder(label + ":[");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toString());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray) {
        int length = complexArray.length;
        StringBuilder sb = new StringBuilder(label + ":F [");
        for (int i = 0; i < length; ++i) {
            sb.append(complexArray[i].toFormat());
            sb.append("  ");
        }
        int index = sb.length();
        sb.replace(index - 2, index, "]");
        return sb.toString();
    }

    public static String toFormat(String label, Complex[] complexArray, boolean orient) {
        int order = complexArray.length;
        StringBuilder sb = orient ? new StringBuilder(label + ":F\n[") : new StringBuilder(label + ":F [");
        for (int i = 0; i < order; ++i) {
            if (orient) {
                sb.append("[");
            }
            sb.append(complexArray[i].toFormat());
            if (orient) {
                sb.append("]\n");
                continue;
            }
            sb.append("  ");
        }
        int index = sb.length();
        if (orient) {
            sb.replace(index - 1, index, "]");
        } else {
            sb.replace(index - 2, index, "]");
        }
        return sb.toString();
    }
}

