/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import view.Box;
import view.Dim;
import view.Dot;
import view.Pict;
import view.Quad;
import view.Rect;
import view.Tetra;

public class PatternSub {
    private static final int MAX_COLOR = 11;
    public static final int RED = 0;
    public static final int YELLOW = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    public static final int PURPLE = 4;
    public static final int PINK = 5;
    public static final int ORANGE = 6;
    public static final int DARK_GREEN = 7;
    public static final int LIGHT_GREEN = 8;
    public static final int DARK_BLUE = 9;
    public static final int BLACK = 10;
    private static Color[] colorPalet;
    public static final Color CARBON;
    public static final Color UMBER;
    public static final Color BEIGE;
    public static final Color BROWN;
    private Box screen;
    public String axisNameX = "x_axis";
    public String axisNameY = "y_axis";
    public int framSpace = 5;
    public int frameDouble = this.framSpace * 2;
    Pict axesSpace = new Pict(40, 10, 10, 25);
    public int axisSpace = 5;
    public int axisTwice = this.axisSpace * 2;
    public int axisNumX = 6;
    public int axisNumY = 6;
    public float step;
    Tetra axes = Tetra.tetra();
    Rect aide;
    Rect board;
    private Quad param;

    PatternSub() {
        this.axes.setTetra(-1.5f, 1.5f, -1.2f, 1.2f);
        this.step = 0.5f;
    }

    public void updateParameter() {
        float xMag = (float)this.board.w / (this.axes.r - this.axes.l);
        float xShift = -this.axes.l * xMag + (float)this.board.x;
        float yMag = -((float)this.board.h) / (this.axes.t - this.axes.b);
        float yShift = -this.axes.b * yMag + (float)(this.board.y + this.board.h);
        this.param = Quad.quad(xMag, xShift, yMag, yShift);
    }

    Dot getDot(Dim vol) {
        int e = (int)(vol.x * this.param.m + this.param.n);
        int f = (int)(vol.y * this.param.s + this.param.t);
        return Dot.dot(e, f);
    }

    private static void setColorPalet() {
        colorPalet = new Color[11];
        float aHue = 0.0f;
        float aMag = 0.9f;
        float aDim = 0.9f;
        for (int i = 0; i < 11; ++i) {
            aHue = 2.0f * (float)i / 11.0f;
            if (aHue > 1.0f) {
                aHue -= 1.0f;
                aMag = 0.6f;
                aDim = 0.8f;
            }
            if (i == 5) {
                aMag = 0.6f;
            }
            if (i == 13) {
                aMag = 0.3f;
            }
            PatternSub.colorPalet[i] = Color.getHSBColor(aHue, aMag, aDim);
        }
        PatternSub.colorPalet[10] = Color.getHSBColor(0.0f, 0.0f, 0.0f);
    }

    public Color getPaletColor(int id) {
        return colorPalet[id];
    }

    public void prepareScreen(Graphics g, Dimension size) {
        this.screen = Box.box(size.height, size.width);
        g.setColor(Color.getHSBColor(0.14f, 0.1f, 0.95f));
        g.fillRect(0, 0, this.screen.w, this.screen.h);
    }

    public void setAxesSpace(int l, int r, int t, int b) {
        this.axesSpace.l = l;
        this.axesSpace.r = r;
        this.axesSpace.t = t;
        this.axesSpace.b = b;
    }

    public void drawFrame(Graphics g) {
        int j;
        this.aide = Rect.rect(this.framSpace, this.framSpace, this.screen.w - this.frameDouble, this.screen.h - this.frameDouble);
        this.board = Rect.rect(this.aide.x + this.axesSpace.l, this.aide.y + this.axesSpace.t, this.aide.w - this.axesSpace.l - this.axesSpace.r, this.aide.h - this.axesSpace.t - this.axesSpace.b);
        this.updateParameter();
        float sX = this.axes.l;
        float sY = 0.0f;
        float eX = this.axes.r;
        float eY = sY;
        Dot dotS = this.getDot(Dim.dim(sX, sY));
        Dot dotE = this.getDot(Dim.dim(eX, eY));
        g.setColor(BEIGE);
        g.drawLine(dotS.e - this.axisSpace, dotS.f, dotE.e, dotE.f);
        g.setColor(BROWN);
        Object[] objectArray = new Object[1];
        float axis = 0.0f;
        objectArray[0] = Float.valueOf(0.0f);
        g.drawString(String.format("%.1f", objectArray), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        g.setColor(BROWN);
        dotS = this.getDot(Dim.dim(this.axes.l, this.axes.t));
        Object[] objectArray2 = new Object[1];
        axis = this.axes.t;
        objectArray2[0] = Float.valueOf(axis);
        g.drawString(String.format("%.1f", objectArray2), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        dotS = this.getDot(Dim.dim(this.axes.l, this.axes.b));
        Object[] objectArray3 = new Object[1];
        axis = this.axes.b;
        objectArray3[0] = Float.valueOf(axis);
        g.drawString(String.format("%.1f", objectArray3), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        for (j = 1; j < this.axisNumY / 2; ++j) {
            sX = this.axes.l;
            sY = this.step * (float)j;
            eX = this.axes.r;
            eY = sY;
            dotS = this.getDot(Dim.dim(sX, sY));
            dotE = this.getDot(Dim.dim(eX, eY));
            g.setColor(BEIGE);
            g.drawLine(dotS.e - this.axisSpace, dotS.f, dotE.e, dotE.f);
            g.setColor(BROWN);
            Object[] objectArray4 = new Object[1];
            axis = this.step * (float)j;
            objectArray4[0] = Float.valueOf(axis);
            g.drawString(String.format("%.1f", objectArray4), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
            dotS = this.getDot(Dim.dim(sX, -sY));
            dotE = this.getDot(Dim.dim(eX, -eY));
            g.setColor(BEIGE);
            g.drawLine(dotS.e - this.axisSpace, dotS.f, dotE.e, dotE.f);
            g.setColor(BROWN);
            Object[] objectArray5 = new Object[1];
            axis = -this.step * (float)j;
            objectArray5[0] = Float.valueOf(axis);
            g.drawString(String.format("%.1f", objectArray5), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        }
        for (j = 1; j < this.axisNumX; ++j) {
            sX = this.axes.l + (this.axes.r - this.axes.l) * (float)j / (float)this.axisNumX;
            sY = this.axes.t;
            eX = sX;
            eY = this.axes.b;
            dotS = this.getDot(Dim.dim(sX, sY));
            dotE = this.getDot(Dim.dim(eX, eY));
            g.setColor(BEIGE);
            g.drawLine(dotS.e, dotS.f, dotE.e, dotE.f + this.axisSpace);
            axis = this.axes.l * (float)(this.axisNumX - j) * 2.0f / (float)this.axisNumX + this.axes.r;
            g.setColor(BROWN);
            g.drawString(String.format("%.1f", Float.valueOf(axis)), dotS.e, dotE.f + this.axesSpace.b - this.axisTwice);
        }
        g.setColor(BROWN);
        dotE = this.getDot(Dim.dim(this.axes.l, this.axes.b));
        g.drawString(String.format("%.1f", Float.valueOf(this.axes.l)), dotE.e, dotE.f + this.axesSpace.b - this.axisTwice);
        dotE = this.getDot(Dim.dim(this.axes.r, this.axes.b));
        g.drawString(String.format("%.1f", Float.valueOf(this.axes.r)), dotE.e - this.axisTwice, dotE.f + this.axesSpace.b - this.axisTwice);
        g.setColor(UMBER);
        g.drawRect(this.board.x, this.board.y, this.board.w, this.board.h);
        g.setColor(CARBON);
        g.drawString(this.axisNameX, this.board.x + this.board.w / 2 - 33, this.board.y + this.board.h + this.axesSpace.b);
        g.drawString(this.axisNameY, this.board.x - this.axesSpace.l, this.board.y + this.board.h / 2 + this.axisSpace * 4);
    }

    public void drawServoFrame(Graphics g) {
        int j;
        this.aide = Rect.rect(this.framSpace, this.framSpace, this.screen.w - this.frameDouble, this.screen.h - this.frameDouble);
        this.board = Rect.rect(this.aide.x + this.axesSpace.l, this.aide.y + this.axesSpace.t, this.aide.w - this.axesSpace.l - this.axesSpace.r, this.aide.h - this.axesSpace.t - this.axesSpace.b);
        this.axes.setTetra(-0.2f, 1.2f, -0.2f, 1.5f);
        this.step = 0.5f;
        this.updateParameter();
        float sX = this.axes.l;
        float sY = 0.0f;
        float eX = this.axes.r;
        float eY = sY;
        Dot dotS = this.getDot(Dim.dim(sX, sY));
        Dot dotE = this.getDot(Dim.dim(eX, eY));
        g.setColor(BEIGE);
        g.drawLine(dotS.e - this.axisSpace, dotS.f, dotE.e, dotE.f);
        g.setColor(BROWN);
        Object[] objectArray = new Object[1];
        float axis = 0.0f;
        objectArray[0] = Float.valueOf(0.0f);
        g.drawString(String.format("%.1f", objectArray), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        g.setColor(BROWN);
        dotS = this.getDot(Dim.dim(this.axes.l, this.axes.t));
        Object[] objectArray2 = new Object[1];
        axis = this.axes.t;
        objectArray2[0] = Float.valueOf(axis);
        g.drawString(String.format("%.1f", objectArray2), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        dotS = this.getDot(Dim.dim(this.axes.l, this.axes.b));
        Object[] objectArray3 = new Object[1];
        axis = this.axes.b;
        objectArray3[0] = Float.valueOf(axis);
        g.drawString(String.format("%.1f", objectArray3), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        for (j = 1; j < this.axisNumY / 2; ++j) {
            sX = this.axes.l;
            sY = this.step * (float)j;
            eX = this.axes.r;
            eY = sY;
            dotS = this.getDot(Dim.dim(sX, sY));
            dotE = this.getDot(Dim.dim(eX, eY));
            g.setColor(BEIGE);
            g.drawLine(dotS.e - this.axisSpace, dotS.f, dotE.e, dotE.f);
            g.setColor(BROWN);
            Object[] objectArray4 = new Object[1];
            axis = this.step * (float)j;
            objectArray4[0] = Float.valueOf(axis);
            g.drawString(String.format("%.1f", objectArray4), dotS.e - this.axesSpace.l + this.axisTwice, dotS.f + this.axisSpace);
        }
        for (j = 0; j < this.axisNumX / 2; ++j) {
            sX = this.step * (float)j;
            sY = this.axes.t;
            eX = sX;
            eY = this.axes.b;
            dotS = this.getDot(Dim.dim(sX, sY));
            dotE = this.getDot(Dim.dim(eX, eY));
            g.setColor(BEIGE);
            g.drawLine(dotS.e, dotS.f, dotE.e, dotE.f + this.axisSpace);
            axis = this.step * (float)j;
            g.setColor(BROWN);
            g.drawString(String.format("%.1f", Float.valueOf(axis)), dotS.e, dotE.f + this.axesSpace.b - this.axisTwice);
        }
        g.setColor(BROWN);
        dotE = this.getDot(Dim.dim(this.axes.l, this.axes.b));
        g.drawString(String.format("%.1f", Float.valueOf(this.axes.l)), dotE.e, dotE.f + this.axesSpace.b - this.axisTwice);
        dotE = this.getDot(Dim.dim(this.axes.r, this.axes.b));
        g.drawString(String.format("%.1f", Float.valueOf(this.axes.r)), dotE.e - this.axisTwice, dotE.f + this.axesSpace.b - this.axisTwice);
        g.setColor(UMBER);
        g.drawRect(this.board.x, this.board.y, this.board.w, this.board.h);
        g.setColor(CARBON);
        g.drawString(this.axisNameX, this.board.x + this.board.w / 2 - 33, this.board.y + this.board.h + this.axesSpace.b);
        g.drawString(this.axisNameY, this.board.x - this.axesSpace.l, this.board.y + this.board.h / 2 + this.axisSpace * 2);
    }

    public void drawServo(Graphics g, float[][][] matrix) {
        int col = matrix[0][0].length;
        float criteria = 0.99f;
        for (int m = 0; m < matrix.length; ++m) {
            for (int i = 0; i < col; ++i) {
                float x = matrix[m][0][i];
                float y = matrix[m][1][i];
                float t = matrix[m][2][i];
                Dim yVol = Dim.dim(x, y);
                Dim tVol = Dim.dim(x, t);
                Dot yDot = this.getDot(yVol);
                Dot tDot = this.getDot(tVol);
                this.drawSmallDot(g, tDot, 10 - m % 5);
                this.drawSmallCross(g, yDot, m % 5);
            }
        }
    }

    public void drawTuner(Graphics g, float[][][] matrix) {
        int col = matrix[0][0].length;
        int row = matrix[0].length;
        float t = 0.0f;
        for (int m = 0; m < matrix.length; ++m) {
            for (int i = 0; i < col; ++i) {
                float x = matrix[m][0][i];
                float y = matrix[m][1][i];
                float r = matrix[m][2][i];
                if (row <= 3) continue;
                t = matrix[m][3][i];
                Dim yVol = Dim.dim(x, y);
                Dim rVol = Dim.dim(x, r);
                Dim tVol = Dim.dim(x, t);
                Dot yDot = this.getDot(yVol);
                Dot rDot = this.getDot(rVol);
                Dot tDot = this.getDot(tVol);
                if (row > 3) {
                    this.drawSmallDot(g, tDot, 10);
                }
                this.drawSmallDot(g, yDot, 9);
                float e = Math.abs(r - t);
                if ((double)e < 0.001) {
                    this.drawSmallDiamond(g, rDot, 2);
                } else {
                    this.drawSmallCross(g, rDot, 0);
                }
                if (row <= 4) continue;
                float z = 0.0f;
                Dim zvol = Dim.dim(x, z);
                Dot zDot = this.getDot(zvol);
                for (int k = 4; k < row; ++k) {
                    z = matrix[m][k][i];
                    zvol = Dim.dim(x, z);
                    zDot = this.getDot(zvol);
                    if (k < 7) {
                        this.drawDot(g, zDot, 3);
                        continue;
                    }
                    this.drawDot(g, zDot, 5);
                }
            }
        }
    }

    public void drawSpray(Graphics g, float[][][] matrix) {
        int col = matrix[0][0].length;
        int row = matrix[0].length;
        for (int i = 0; i < col; ++i) {
            float x = matrix[0][0][i];
            float y = matrix[0][1][i];
            float t = matrix[0][2][i];
            Dim yVol = Dim.dim(x, y);
            Dim tVol = Dim.dim(x, t);
            Dot yDot = this.getDot(yVol);
            Dot tDot = this.getDot(tVol);
            this.drawDot(g, tDot, 9);
            float e = Math.abs(y - t);
            if ((double)e < 0.05) {
                this.drawDiamond(g, yDot, 2);
            } else {
                this.drawCross(g, yDot, 0);
            }
            for (int m = 0; m < matrix.length; ++m) {
                if (row <= 4) continue;
                float z = 0.0f;
                Dim zvol = Dim.dim(x, z);
                Dot zDot = this.getDot(zvol);
                for (int k = 4; k < row; ++k) {
                    z = matrix[m][k][i];
                    zvol = Dim.dim(x, z);
                    zDot = this.getDot(zvol);
                    if (k < 7) {
                        this.drawDot(g, zDot, 3);
                        continue;
                    }
                    this.drawDot(g, zDot, 5);
                }
            }
        }
    }

    public void drawLogic(Graphics g, float[][][] matrix) {
        int col = matrix[0][0].length;
        float criteria = 0.99f;
        for (int i = 0; i < col; ++i) {
            float x0 = matrix[0][0][i];
            float x1 = matrix[0][1][i];
            float y = matrix[0][2][i];
            float t = matrix[0][3][i];
            Dim xPos = Dim.dim(x0, x1);
            Dot yDot = this.getDot(xPos);
            if (t > criteria && y > criteria || t < criteria && y < criteria) {
                this.drawDiamond(g, yDot, 2);
                continue;
            }
            this.drawBigCross(g, yDot, 0);
        }
    }

    public void drawGroup(Graphics g, float[][][] matrix) {
        int lng = matrix.length;
        int row = matrix[0].length;
        int col = matrix[0][0].length;
        block8: for (int i = 0; i < col; ++i) {
            float x0 = matrix[0][0][i];
            float y0 = matrix[0][1][i];
            float y = matrix[0][2][i];
            float t = matrix[0][3][i];
            Dim tVol = Dim.dim(y0, t);
            Dot y0Dot = this.getDot(Dim.dim(x0 / 2.0f, y0 / 2.0f));
            Dot tDot = this.getDot(tVol);
            if ((double)y > 0.7) {
                switch ((int)t) {
                    case 0: {
                        this.drawBigCross(g, y0Dot, 2);
                        break;
                    }
                    case 1: {
                        this.drawDiamond(g, y0Dot, 2);
                        break;
                    }
                    default: {
                        this.drawGreek(g, y0Dot, 2);
                        break;
                    }
                }
                continue;
            }
            switch ((int)t) {
                case 0: {
                    this.drawBigCross(g, y0Dot, 0);
                    continue block8;
                }
                case 1: {
                    this.drawDiamond(g, y0Dot, 0);
                    continue block8;
                }
                default: {
                    this.drawGreek(g, y0Dot, 0);
                }
            }
        }
    }

    public void drawJudge(Graphics g, float[][][] matrix) {
        int lng = matrix.length;
        int row = matrix[0].length;
        int col = matrix[0][0].length;
        for (int i = 0; i < lng; ++i) {
            for (int j = 0; j < row; ++j) {
                float y = matrix[i][j][0];
                float t = matrix[i][j][1];
                float yVal = y * 2.0f - 1.0f;
                float xVal = (float)j / 5.0f - 0.9f;
                Dot yDot = this.getDot(Dim.dim(xVal, yVal));
                if (t > 0.5f) {
                    if (y > 0.5f) {
                        this.drawDiamond(g, yDot, 2);
                        continue;
                    }
                    this.drawDiamond(g, yDot, 0);
                    continue;
                }
                if (y < 0.5f) {
                    this.drawBigCross(g, yDot, 2);
                    continue;
                }
                this.drawBigCross(g, yDot, 0);
            }
        }
    }

    private void drawDot(Graphics g, Dot dot, int color) {
        boolean mg = true;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x, y, x, y);
    }

    private void drawSmallDot(Graphics g, Dot dot, int color) {
        int mg = 1;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y, x + mg, y);
        g.drawLine(x, y + mg, x, y - mg);
    }

    private void drawSmallCross(Graphics g, Dot dot, int color) {
        int mg = 1;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y - mg, x + mg, y + mg);
        g.drawLine(x - mg, y + mg, x + mg, y - mg);
    }

    private void drawCross(Graphics g, Dot dot, int color) {
        int mg = 2;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y - mg, x + mg, y + mg);
        g.drawLine(x - mg, y + mg, x + mg, y - mg);
    }

    private void drawBigCross(Graphics g, Dot dot, int color) {
        int mg = 4;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y - mg, x + mg, y + mg);
        g.drawLine(x - mg, y + mg, x + mg, y - mg);
    }

    private void drawGreek(Graphics g, Dot dot, int color) {
        int mg = 4;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y, x + mg, y);
        g.drawLine(x, y + mg, x, y - mg);
    }

    private void drawSmallDiamond(Graphics g, Dot dot, int color) {
        int mg = 2;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y, x, y + mg);
        g.drawLine(x - mg, y, x, y - mg);
        g.drawLine(x, y + mg, x + mg, y);
        g.drawLine(x, y - mg, x + mg, y);
    }

    private void drawDiamond(Graphics g, Dot dot, int color) {
        int mg = 4;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y, x, y + mg);
        g.drawLine(x - mg, y, x, y - mg);
        g.drawLine(x, y + mg, x + mg, y);
        g.drawLine(x, y - mg, x + mg, y);
    }

    private void drawSquare(Graphics g, Dot dot, int color) {
        int mg = 3;
        g.setColor(colorPalet[color]);
        int x = dot.e;
        int y = dot.f;
        g.drawLine(x - mg, y + mg, x + mg, y + mg);
        g.drawLine(x - mg, y - mg, x + mg, y - mg);
        g.drawLine(x - mg, y + mg, x - mg, y - mg);
        g.drawLine(x + mg, y + mg, x + mg, y - mg);
    }

    static {
        PatternSub.setColorPalet();
        CARBON = Color.getHSBColor(0.0f, 1.0f, 0.0f);
        UMBER = Color.getHSBColor(0.113f, 1.0f, 1.0f);
        BEIGE = Color.getHSBColor(0.13f, 0.3f, 0.9f);
        BROWN = Color.getHSBColor(0.13f, 0.5f, 0.4f);
    }
}

