/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import util.DJ;
import util.TimeStamp;
import view.Box;
import view.Num;
import view.PatternSub;
import view.PropertyViewer;
import view.Viewer;

public class PatternViewer
extends Viewer {
    public static final String BOUNDS_NAME = "patternBounds";
    public static final int PATTERN_PLAIN = 0;
    public static final int PATTERN_CHECK = 1;
    public static final int PATTERN_SPRAY = 2;
    public static final int PATTERN_LOGIC = 3;
    public static final int PATTERN_GROUP = 4;
    public static final int PATTERN_JUDGE = 5;
    public static final int PATTERN_TUNER = 6;
    public static final int PATTERN_SERVO = 7;
    PatternDrawer drawer0;
    PatternDrawer drawer1;
    private JButton cardButton;
    private JPanel controlPanel;
    private JPanel imageCard;
    private JPanel mainPanel;
    private CardLayout cardLayout;
    private JButton valueButton;
    private JPanel verifyCard;

    public PatternViewer(int patternType0, double[][] patternData0, String patternComment0) {
        this.initComponents();
        this.initialize();
        this.drawer0 = new PatternDrawer(patternType0, patternData0);
        this.drawer0.setPage_Comment(0, patternComment0);
        this.verifyCard.add((Component)this.drawer0, "Center");
        this.drawer1 = new PatternDrawer(0, patternData0);
        this.drawer1.setPage_Comment(1, patternComment0);
        this.imageCard.add((Component)this.drawer1, "Center");
    }

    public PatternViewer(int patternType0, double[][] patternData0, String patternComment0, int patternType1, double[][] patternData1, String patternComment1) {
        this.initComponents();
        this.initialize();
        this.drawer0 = new PatternDrawer(patternType0, patternData0);
        this.drawer1 = new PatternDrawer(patternType1, patternData1);
        this.drawer0.setPage_Comment(0, patternComment0);
        this.drawer1.setPage_Comment(1, patternComment1);
        this.verifyCard.add((Component)this.drawer0, "Center");
        this.imageCard.add((Component)this.drawer1, "Center");
    }

    public PatternViewer(int patternType0, double[][][] patternData0, String patternComment0, int patternType1, double[][] patternData1, String patternComment1) {
        this.initComponents();
        this.initialize();
        this.drawer0 = new PatternDrawer(patternType0, patternData0);
        this.drawer1 = new PatternDrawer(patternType1, patternData1);
        this.drawer0.setPage_Comment(0, patternComment0);
        this.drawer1.setPage_Comment(1, patternComment1);
        this.verifyCard.add((Component)this.drawer0, "Center");
        this.imageCard.add((Component)this.drawer1, "Center");
    }

    public PatternViewer(int patternType0, double[][][] patternData0, String patternComment0, int patternType1, double[][][] patternData1, String patternComment1) {
        this.initComponents();
        this.initialize();
        this.drawer0 = new PatternDrawer(patternType0, patternData0);
        this.drawer1 = new PatternDrawer(patternType1, patternData1);
        this.drawer0.setPage_Comment(0, patternComment0);
        this.drawer1.setPage_Comment(1, patternComment1);
        this.verifyCard.add((Component)this.drawer0, "Center");
        this.imageCard.add((Component)this.drawer1, "Center");
    }

    public final void setBounds() {
        PropertyViewer propertyViewer = DJ.getPropertyViewer();
        Rectangle rect = propertyViewer.getBoundsValue(BOUNDS_NAME);
        if (rect != null) {
            this.setBounds(rect);
        } else {
            this.setBounds(610, 410, 400, 400);
        }
    }

    public void setTitle(String title0, String title1) {
        if (this.drawer0 != null) {
            this.drawer0.setPage_Comment(0, title0);
        }
        if (this.drawer1 != null) {
            this.drawer1.setPage_Comment(1, title1);
        }
    }

    public void updatePattern(double[][] data) {
        this.drawer0.setMatrix(data);
    }

    public void updatePattern(double[][] data0, double[][] data1) {
        this.drawer0.setMatrix(data0);
        this.drawer1.setMatrix(data1);
    }

    public void updatePattern(double[][][] data0, double[][] data1) {
        this.drawer0.setMatrix(data0);
        this.drawer1.setMatrix(data1);
    }

    public void updatePattern(double[][][] data0, double[][][] data1) {
        this.drawer0.setMatrix(data0);
        this.drawer1.setMatrix(data1);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.verifyCard = new JPanel();
        this.imageCard = new JPanel();
        this.controlPanel = new JPanel();
        this.valueButton = new JButton();
        this.cardButton = new JButton();
        this.setTitle("DaiJa : Pattern viewer");
        this.setFocusable(false);
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setLayout(null);
        this.cardLayout = new CardLayout();
        this.mainPanel.setLayout(this.cardLayout);
        this.verifyCard.setLayout(new BorderLayout());
        this.mainPanel.add(this.verifyCard);
        this.verifyCard.setBounds(0, 0, 400, 350);
        this.imageCard.setLayout(new BorderLayout());
        this.mainPanel.add(this.imageCard);
        this.imageCard.setBounds(0, 0, 400, 350);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setPreferredSize(new Dimension(400, 24));
        this.controlPanel.setRequestFocusEnabled(false);
        this.valueButton.setText("Value");
        this.valueButton.setPreferredSize(new Dimension(72, 18));
        this.cardButton.setText("Next Page");
        this.cardButton.setPreferredSize(new Dimension(84, 18));
        this.cardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternViewer.this.cardButtonActionPerformed(evt);
            }
        });
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.valueButton, -2, -1, -2).addGap(87, 87, 87).addComponent(this.cardButton, -2, 95, -2).addContainerGap(136, Short.MAX_VALUE)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueButton, -2, -1, -2).addComponent(this.cardButton, -2, -1, -2)).addGap(0, 2, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void cardButtonActionPerformed(ActionEvent evt) {
        this.cardLayout.next(this.mainPanel);
    }

    private void initialize() {
        PatternViewer_button_actionAdapter buttonAdapter = new PatternViewer_button_actionAdapter(this);
        this.valueButton.addActionListener(buttonAdapter);
        this.setBounds();
    }

    void button_actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "Value": {
                this.drawer0.writeValueFlag = !this.drawer0.writeValueFlag;
                this.drawer0.repaint();
                this.drawer1.writeValueFlag = !this.drawer1.writeValueFlag;
                this.drawer1.repaint();
                break;
            }
        }
    }

    public class PatternDrawer
    extends Canvas {
        int patternType;
        double[][] patternData2;
        double[][][] patternData3;
        float[][] matrix2;
        float[][][] matrix3;
        boolean writeValueFlag = false;
        PatternSub ps;
        int page;
        String comment = "Pattern Name";

        PatternDrawer(int patternType, double[][] patternData) {
            this.patternType = patternType;
            this.ps = new PatternSub();
            this.ps.getPaletColor(0);
        }

        PatternDrawer(int patternType, double[][][] patternData) {
            this.patternType = patternType;
            this.ps = new PatternSub();
            this.ps.getPaletColor(0);
        }

        void setPage(int page) {
            this.page = page;
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        void setPage_Comment(int page, String comment) {
            this.page = page;
            this.comment = comment;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            this.ps.prepareScreen(g, size);
            if (this.patternData2 == null && this.patternData3 == null) {
                return;
            }
            this.drawPage(g);
            this.drawComment(g);
            this.drawDate(g);
            switch (this.patternType) {
                case 1: {
                    this.checkered(g);
                    break;
                }
                case 2: {
                    this.spray(g);
                    break;
                }
                case 3: {
                    this.logic(g);
                    break;
                }
                case 4: {
                    this.group(g);
                    break;
                }
                case 5: {
                    this.judge(g);
                    break;
                }
                case 6: {
                    this.tuner(g);
                    break;
                }
                case 7: {
                    this.servo(g);
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.writeValueFlag) {
                this.drawText(g);
            }
        }

        void servo(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawServoFrame(g);
            this.ps.drawServo(g, this.matrix3);
        }

        void tuner(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawServoFrame(g);
            this.ps.drawTuner(g, this.matrix3);
        }

        void judge(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawFrame(g);
            this.ps.drawJudge(g, this.matrix3);
        }

        void group(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawFrame(g);
            this.ps.drawGroup(g, this.matrix3);
        }

        void logic(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawFrame(g);
            this.ps.drawLogic(g, this.matrix3);
        }

        void spray(Graphics g) {
            this.makeMatrix();
            this.ps.setAxesSpace(40, 10, 10, 25);
            this.ps.drawFrame(g);
            this.ps.drawSpray(g, this.matrix3);
        }

        void checkered(Graphics g) {
            this.getEmptyMatrix();
            this.scaleMatrix();
            this.ps.framSpace = 30;
            Dimension size = this.getSize();
            Box board = Box.box(size.height - this.ps.framSpace, size.width - this.ps.framSpace);
            int nPat = this.matrix3.length;
            if (nPat < 2) {
                nPat = 2;
            }
            int xFill = this.ps.framSpace / 2;
            int yFill = this.ps.framSpace / 2;
            if (this.matrix3.length == 1) {
                yFill = 140;
            } else if (this.matrix3.length >= 10) {
                xFill = 220;
                yFill = 10;
            }
            Num slot = Num.num(this.matrix3[0][0].length, this.matrix3[0].length);
            Box pane = Box.box(board.h / slot.r / nPat * 2 - 2, board.w / slot.c / nPat * 2 - 2);
            Box frame = Box.box(pane.h * slot.r * 2, pane.w * slot.c * 2);
            int frameTop = this.ps.framSpace / 2 + 2;
            int frameBottom = board.h - frame.h - frameTop;
            int frameLeft = this.ps.framSpace / 2;
            int frameRight = board.w - frame.w - frameLeft;
            for (int k = 0; k < this.matrix3.length; ++k) {
                int xShift = k % 2 * (frame.w / 2 + this.ps.framSpace / 3);
                int yShift = k / 2 * (frame.h / 2 + this.ps.framSpace / 3);
                for (int j = 0; j < slot.c; ++j) {
                    for (int i = 0; i < slot.r; ++i) {
                        int col = frameTop + pane.h * j + yShift;
                        int row = frameLeft + pane.w * i + xShift;
                        g.setColor(Color.getHSBColor(0.0f, 0.0f, 1.0f - this.matrix3[k][j][i]));
                        g.fillRect(row, col, pane.w, pane.h);
                    }
                }
            }
        }

        void drawPage(Graphics g) {
            g.setColor(Color.BLACK);
            g.drawString("P." + Integer.toString(this.page) + ",", 40, 15);
        }

        void drawComment(Graphics g) {
            g.setColor(Color.BLACK);
            g.drawString(this.comment, 70, 15);
        }

        void drawComment(Graphics g, String comment) {
            g.setColor(Color.BLACK);
            g.drawString(comment, 70, 15);
        }

        void drawDate(Graphics g) {
            g.setColor(Color.LIGHT_GRAY);
            g.drawString(TimeStamp.getTimeFormated(), 260, 15);
        }

        void drawText(Graphics g) {
            int lng = this.matrix3.length;
            int row = this.matrix3[0].length;
            int col = this.matrix3[0][0].length;
            g.setColor(Color.RED);
            for (int k = 0; k < lng; ++k) {
                int yShift = k * (16 * row + 20);
                for (int i = 0; i < row; ++i) {
                    for (int j = 0; j < col; ++j) {
                        int x = 50 + j * 90;
                        int y = 35 + i * 16 + yShift;
                        g.drawString(String.valueOf(this.matrix3[k][i][j]), x, y);
                    }
                }
            }
        }

        private void makeMatrix() {
            block10: {
                int col;
                int row;
                int lng;
                block9: {
                    int col2;
                    int row2;
                    if (this.matrix3 == null) {
                        if (this.patternData2 != null) {
                            row2 = this.patternData2.length;
                            col2 = this.patternData2[0].length;
                            this.matrix3 = new float[1][row2][col2];
                        } else if (this.patternData3 != null) {
                            lng = this.patternData3.length;
                            row = this.patternData3[0].length;
                            col = this.patternData3[0][0].length;
                            this.matrix3 = new float[lng][row][col];
                        }
                    }
                    if (this.patternData2 == null) break block9;
                    row2 = this.patternData2.length;
                    col2 = this.patternData2[0].length;
                    for (int i = 0; i < row2; ++i) {
                        for (int j = 0; j < col2; ++j) {
                            this.matrix3[0][i][j] = (float)this.patternData2[i][j];
                        }
                    }
                    break block10;
                }
                if (this.patternData3 == null) break block10;
                lng = this.patternData3.length;
                row = this.patternData3[0].length;
                col = this.patternData3[0][0].length;
                for (int k = 0; k < lng; ++k) {
                    for (int i = 0; i < row; ++i) {
                        for (int j = 0; j < col; ++j) {
                            this.matrix3[k][i][j] = (float)this.patternData3[k][i][j];
                        }
                    }
                }
            }
        }

        private void getEmptyMatrix() {
            if (this.matrix3 == null) {
                if (this.patternData2 != null) {
                    int row = this.patternData2.length;
                    int col = this.patternData2[0].length;
                    this.matrix2 = new float[row][col];
                    this.matrix3 = new float[1][row][col];
                } else if (this.patternData3 != null) {
                    int lng = this.patternData3.length;
                    int row = this.patternData3[0].length;
                    int col = this.patternData3[0][0].length;
                    this.matrix3 = new float[lng][row][col];
                }
            }
        }

        private void scaleMatrix() {
            if (this.patternData2 != null) {
                this.scaling(this.patternData2, this.matrix2);
                this.matrix3[0] = this.matrix2;
            } else if (this.patternData3 != null) {
                this.scaling(this.patternData3, this.matrix3);
            }
        }

        public void scaling(double[][] original, float[][] floatMatrix) {
            int row = original.length;
            int col = original[0].length;
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    float val;
                    floatMatrix[i][j] = val = (float)original[i][j];
                    if (val < min) {
                        min = val;
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
            }
            float diff = max - min;
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    floatMatrix[i][j] = (floatMatrix[i][j] - min) / diff;
                }
            }
        }

        public void scaling(double[][][] original, float[][][] floatMatrix) {
            int lng = original.length;
            int row = original[0].length;
            int col = original[0][0].length;
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (int k = 0; k < lng; ++k) {
                for (int i = 0; i < row; ++i) {
                    for (int j = 0; j < col; ++j) {
                        float val;
                        floatMatrix[k][i][j] = val = (float)original[k][i][j];
                        if (val < min) {
                            min = val;
                            continue;
                        }
                        if (!(val > max)) continue;
                        max = val;
                    }
                }
            }
            float diff = max - min;
            for (int k = 0; k < lng; ++k) {
                for (int i = 0; i < row; ++i) {
                    for (int j = 0; j < col; ++j) {
                        floatMatrix[k][i][j] = (floatMatrix[k][i][j] - min) / diff;
                    }
                }
            }
        }

        @Override
        public void update(Graphics g) {
            Dimension dim = this.getSize();
            Image offImage = this.createImage(dim.width, dim.height);
            Graphics offGraphics = offImage.getGraphics();
            if (offImage != null) {
                this.paint(offGraphics);
                g.drawImage(offImage, 0, 0, null);
            }
        }

        public void setMatrix(double[][] patternData) {
            this.patternData2 = patternData;
            this.repaint();
        }

        public void setMatrix(double[][][] patternData) {
            this.patternData3 = patternData;
            this.repaint();
        }
    }

    class PatternViewer_button_actionAdapter
    implements ActionListener {
        PatternViewer adaptee;

        PatternViewer_button_actionAdapter(PatternViewer adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.button_actionPerformed(e);
        }
    }
}

